/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.vcs.log.data.index.ProjectLevelConnectionManager;
import com.intellij.vcs.log.util.StorageId;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.sqlite.IntBinder;
import org.jetbrains.sqlite.ObjectBinder;
import org.jetbrains.sqlite.SqlStatementPool;
import org.jetbrains.sqlite.SqliteConnection;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010%\u001a\u00020\u000bH\u0002J\b\u0010&\u001a\u00020'H\u0016J\u0006\u0010(\u001a\u00020\u0000J-\u0010)\u001a\u0004\u0018\u0001H*\"\b\b\u0000\u0010**\u00020+2\u0014\u0010,\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u0001H*0-\u00a2\u0006\u0002\u0010.R\u0010\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013R\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001e0\u000f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0013\u00a8\u0006/"}, d2={"Lcom/intellij/vcs/log/data/index/ProjectLevelConnectionManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "logId", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "storageId", "Lcom/intellij/vcs/log/util/StorageId$File;", "(Lcom/intellij/vcs/log/util/StorageId$File;)V", "connection", "Lorg/jetbrains/sqlite/SqliteConnection;", "dbFile", "Ljava/nio/file/Path;", "insertCommitPool", "Lorg/jetbrains/sqlite/SqlStatementPool;", "Lorg/jetbrains/sqlite/ObjectBinder;", "insertMoreCommitPool", "getInsertMoreCommitPool", "()Lorg/jetbrains/sqlite/SqlStatementPool;", "insertPathPool", "isFresh", "", "()Z", "setFresh", "(Z)V", "selectCommitPool", "getSelectCommitPool", "selectCommitsForUserPool", "selectCommitterForCommitPool", "Lorg/jetbrains/sqlite/IntBinder;", "selectParent", "selectPathIdPool", "selectPathPool", "selectRename", "updateCommitPool", "getUpdateCommitPool", "connect", "dispose", "", "recreate", "runUnderReadonlyConnection", "R", "", "runnable", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nSqliteVcsLogStorageBackend.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqliteVcsLogStorageBackend.kt\ncom/intellij/vcs/log/data/index/ProjectLevelConnectionManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,824:1\n1#2:825\n*E\n"})
final class ProjectLevelConnectionManager
implements Disposable {
    @JvmField
    @NotNull
    public final StorageId.File storageId;
    @NotNull
    private final Path dbFile;
    @JvmField
    @NotNull
    public final SqliteConnection connection;
    private volatile boolean isFresh;
    @JvmField
    @NotNull
    public final SqlStatementPool<IntBinder> selectParent;
    @JvmField
    @NotNull
    public final SqlStatementPool<IntBinder> selectRename;
    @JvmField
    @NotNull
    public final SqlStatementPool<ObjectBinder> selectPathIdPool;
    @JvmField
    @NotNull
    public final SqlStatementPool<ObjectBinder> insertPathPool;
    @JvmField
    @NotNull
    public final SqlStatementPool<IntBinder> selectPathPool;
    @JvmField
    @NotNull
    public final SqlStatementPool<IntBinder> selectCommitterForCommitPool;
    @JvmField
    @NotNull
    public final SqlStatementPool<ObjectBinder> selectCommitsForUserPool;
    @JvmField
    @NotNull
    public final SqlStatementPool<ObjectBinder> insertCommitPool;
    @NotNull
    private final SqlStatementPool<ObjectBinder> selectCommitPool;
    @NotNull
    private final SqlStatementPool<ObjectBinder> insertMoreCommitPool;
    @NotNull
    private final SqlStatementPool<ObjectBinder> updateCommitPool;

    private ProjectLevelConnectionManager(StorageId.File storageId) {
        this.storageId = storageId;
        this.dbFile = this.storageId.getStoragePath();
        this.connection = this.connect();
        this.selectParent = this.connection.statementPool("select parent from parent where commitId = ?", selectParent.1.INSTANCE);
        this.selectRename = this.connection.statementPool("select rename from rename where parent = ? and child = ?", selectRename.1.INSTANCE);
        this.selectPathIdPool = this.connection.statementPool("select rowid from path where position = ? and relativePath = ?", selectPathIdPool.1.INSTANCE);
        this.insertPathPool = this.connection.statementPool("insert into path(position, relativePath) values (?, ?) returning rowid", insertPathPool.1.INSTANCE);
        this.selectPathPool = this.connection.statementPool("select position, relativePath from path where rowid = ?", selectPathPool.1.INSTANCE);
        this.selectCommitterForCommitPool = this.connection.statementPool("select name, email from user where commitId = ? and isCommitter = ?", selectCommitterForCommitPool.1.INSTANCE);
        this.selectCommitsForUserPool = this.connection.statementPool("select commitId from user where isCommitter = 0 and name = ? and email = ?", selectCommitsForUserPool.1.INSTANCE);
        this.insertCommitPool = this.connection.statementPool("insert into commit_hashes(position, hash) values(?, ?) returning rowid", insertCommitPool.1.INSTANCE);
        this.selectCommitPool = this.connection.statementPool("select rowid from commit_hashes where position = ? and hash = ?", selectCommitPool.1.INSTANCE);
        this.insertMoreCommitPool = this.connection.statementPool("insert into commit_hashes(position, hash, name, type) values(?, ?, ?, ?) returning rowid", insertMoreCommitPool.1.INSTANCE);
        this.updateCommitPool = this.connection.statementPool("update commit_hashes set name = ?, type = ? where position = ? and hash = ? returning rowid", updateCommitPool.1.INSTANCE);
    }

    public ProjectLevelConnectionManager(@NotNull Project project2, @NotNull String logId) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)logId, (String)"logId");
        String string2 = project2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        this(new StorageId.File(string2, logId, "vcs-log-v2-18", "db"));
    }

    public final boolean isFresh() {
        return this.isFresh;
    }

    public final void setFresh(boolean bl) {
        this.isFresh = bl;
    }

    @NotNull
    public final SqlStatementPool<ObjectBinder> getSelectCommitPool() {
        return this.selectCommitPool;
    }

    @NotNull
    public final SqlStatementPool<ObjectBinder> getInsertMoreCommitPool() {
        return this.insertMoreCommitPool;
    }

    @NotNull
    public final SqlStatementPool<ObjectBinder> getUpdateCommitPool() {
        return this.updateCommitPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final <R> R runUnderReadonlyConnection(@NotNull Function1<? super SqliteConnection, ? extends R> runnable) {
        Object object;
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        if (!Files.exists(this.dbFile, new LinkOption[0])) {
            return null;
        }
        AutoCloseable autoCloseable = new SqliteConnection(this.dbFile, true);
        Throwable throwable = null;
        try {
            SqliteConnection connection = (SqliteConnection)autoCloseable;
            boolean bl = false;
            object = runnable.invoke((Object)connection);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return (R)object;
    }

    private final SqliteConnection connect() {
        this.isFresh = !Files.exists(this.dbFile, new LinkOption[0]);
        SqliteConnection connection = new SqliteConnection(this.dbFile, false, 2, null);
        if (this.isFresh) {
            connection.execute("\n  begin transaction;\n  \n  create table log (\n    commitId integer primary key,\n    message text not null,\n    authorTime integer not null,\n    commitTime integer not null,\n    isCommitter integer not null\n  ) strict;\n  create virtual table fts_message_index using fts5(message, content='log', content_rowid='commitId', tokenize='trigram');\n  \n  create trigger log_ai after insert on log begin\n    insert into fts_message_index(rowid, message) values (new.commitId, new.message);\n  end;\n  create trigger log_ad after delete on log begin \n    insert into fts_message_index(fts_message_index, rowid, message) values ('delete', old.commitId, old.message);\n  end;\n  create trigger log_au after update on log begin\n    insert into fts_message_index(fts_message_index, rowid, message) values ('delete', old.commitId, old.message);\n    insert into fts_message_index(rowid, message) values (new.commitId, new.message);\n  end;\n  \n  -- one to many relation, so, commitId is not a primary key\n  create table parent (commitId integer not null, parent integer not null) strict;\n  create index parent_index on parent (commitId);\n  \n  create table rename (parent integer not null, child integer not null, rename integer not null) strict;\n  create index rename_index on rename (parent, child);\n  \n  create table user (commitId integer not null, isCommitter integer not null, name text not null, email text not null) strict;\n  create index user_index on user (name, email);\n  \n  create table path (relativePath text not null, position integer not null) strict;\n  create index path_index on path (position, relativePath);\n  create table path_change (commitId integer not null, pathId integer not null, kind integer not null) strict;\n  create index path_change_index on path_change(pathId);\n  \n  create table commit_hashes (hash text not null, position integer not null, name text null, type integer null) strict;\n  create unique index commit_hashes_index on commit_hashes (position, hash);\n  \n  commit transaction;\n");
        }
        return connection;
    }

    @NotNull
    public final ProjectLevelConnectionManager recreate() {
        this.connection.close();
        NioFiles.deleteRecursively((Path)this.dbFile);
        return new ProjectLevelConnectionManager(this.storageId);
    }

    public void dispose() {
        this.connection.interruptAndClose();
    }
}

