/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.impl.SingletonRefGroup;
import com.intellij.vcs.log.util.VcsLogUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BranchPopupBuilder {
    @NotNull
    protected final VcsLogDataPack myDataPack;
    @Nullable
    private final Collection<? extends VirtualFile> myVisibleRoots;
    @Nullable
    private final List<? extends List<String>> myRecentItems;

    protected BranchPopupBuilder(@NotNull VcsLogDataPack dataPack, @Nullable Collection<? extends VirtualFile> visibleRoots, @Nullable List<? extends List<String>> recentItems) {
        if (dataPack == null) {
            BranchPopupBuilder.$$$reportNull$$$0(0);
        }
        this.myDataPack = dataPack;
        this.myVisibleRoots = visibleRoots;
        this.myRecentItems = recentItems;
    }

    @NotNull
    protected abstract AnAction createAction(@NotNull @NlsActions.ActionText String var1, @NotNull Collection<? extends VcsRef> var2);

    protected void createRecentAction(@NotNull List<AnAction> actionGroup, @NotNull List<String> recentItem) {
        if (actionGroup == null) {
            BranchPopupBuilder.$$$reportNull$$$0(1);
        }
        if (recentItem == null) {
            BranchPopupBuilder.$$$reportNull$$$0(2);
        }
        assert (this.myRecentItems == null);
    }

    protected void createFavoritesAction(@NotNull List<AnAction> actionGroup, @NotNull List<String> favorites) {
        if (actionGroup == null) {
            BranchPopupBuilder.$$$reportNull$$$0(3);
        }
        if (favorites == null) {
            BranchPopupBuilder.$$$reportNull$$$0(4);
        }
    }

    @NotNull
    protected AnAction createCollapsedAction(@NotNull @NlsActions.ActionText String actionName, @NotNull Collection<? extends VcsRef> refs) {
        if (actionName == null) {
            BranchPopupBuilder.$$$reportNull$$$0(5);
        }
        if (refs == null) {
            BranchPopupBuilder.$$$reportNull$$$0(6);
        }
        AnAction anAction = this.createAction(actionName, refs);
        if (anAction == null) {
            BranchPopupBuilder.$$$reportNull$$$0(7);
        }
        return anAction;
    }

    public ActionGroup build() {
        return this.createActions(BranchPopupBuilder.prepareGroups(this.myDataPack, this.myVisibleRoots, this.myRecentItems));
    }

    private static Groups prepareGroups(@NotNull VcsLogDataPack dataPack, @Nullable Collection<? extends VirtualFile> visibleRoots, @Nullable List<? extends List<String>> recentItems) {
        if (dataPack == null) {
            BranchPopupBuilder.$$$reportNull$$$0(8);
        }
        Groups filteredGroups = new Groups();
        Collection<VcsRef> allRefs = dataPack.getRefs().getBranches();
        for (Map.Entry<VirtualFile, Set<VcsRef>> entry2 : VcsLogUtil.groupRefsByRoot(allRefs).entrySet()) {
            VirtualFile root = entry2.getKey();
            if (visibleRoots != null && !visibleRoots.contains(root)) continue;
            List<RefGroup> refGroups = dataPack.getLogProviders().get(root).getReferenceManager().groupForBranchFilter((Collection<? extends VcsRef>)entry2.getValue());
            BranchPopupBuilder.putActionsForReferences(dataPack, refGroups, filteredGroups);
        }
        if (recentItems != null) {
            filteredGroups.recentGroups.addAll(recentItems);
        }
        return filteredGroups;
    }

    @NotNull
    private DefaultActionGroup createActions(@NotNull Groups groups) {
        if (groups == null) {
            BranchPopupBuilder.$$$reportNull$$$0(9);
        }
        ArrayList<AnAction> actionGroup = new ArrayList<AnAction>();
        for (Map.Entry<String, Collection<VcsRef>> entry2 : groups.singletonGroups.entrySet()) {
            actionGroup.add(this.createAction(entry2.getKey(), entry2.getValue()));
        }
        if (!groups.recentGroups.isEmpty()) {
            ArrayList<AnAction> recents = new ArrayList<AnAction>();
            for (List<String> list2 : groups.recentGroups) {
                this.createRecentAction(recents, list2);
            }
            DefaultActionGroup defaultActionGroup = new DefaultActionGroup(VcsLogBundle.message("vcs.log.filter.recent", new Object[0]), recents);
            defaultActionGroup.setPopup(true);
            actionGroup.add((AnAction)defaultActionGroup);
        }
        if (groups.favoriteGroups.size() > 1) {
            this.createFavoritesAction(actionGroup, new ArrayList<String>(ContainerUtil.map2LinkedSet((Collection)ContainerUtil.flatten(groups.favoriteGroups.values()), ref -> ref.getName())));
        }
        for (Map.Entry<String, Collection<VcsRef>> entry3 : groups.favoriteGroups.entrySet()) {
            actionGroup.add(this.createAction(entry3.getKey(), entry3.getValue()));
        }
        for (Map.Entry<String, Object> entry4 : groups.expandedGroups.entrySet()) {
            actionGroup.add((AnAction)Separator.create((String)entry4.getKey()));
            for (Map.Entry entry5 : ((TreeMap)entry4.getValue()).entrySet()) {
                actionGroup.add(this.createAction((String)entry5.getKey(), (Collection)entry5.getValue()));
            }
        }
        actionGroup.add((AnAction)Separator.getInstance());
        for (Map.Entry<String, Object> entry6 : groups.collapsedGroups.entrySet()) {
            ArrayList<AnAction> arrayList = new ArrayList<AnAction>();
            for (Map.Entry entry7 : ((TreeMap)entry6.getValue()).entrySet()) {
                arrayList.add(this.createCollapsedAction((String)entry7.getKey(), (Collection)entry7.getValue()));
            }
            DefaultActionGroup defaultActionGroup = new DefaultActionGroup(entry6.getKey(), arrayList);
            defaultActionGroup.setPopup(true);
            actionGroup.add((AnAction)defaultActionGroup);
        }
        return new DefaultActionGroup(actionGroup);
    }

    private static void putActionsForReferences(@NotNull VcsLogDataPack pack, @NotNull List<? extends RefGroup> references, @NotNull Groups actions2) {
        if (pack == null) {
            BranchPopupBuilder.$$$reportNull$$$0(10);
        }
        if (references == null) {
            BranchPopupBuilder.$$$reportNull$$$0(11);
        }
        if (actions2 == null) {
            BranchPopupBuilder.$$$reportNull$$$0(12);
        }
        for (RefGroup refGroup : references) {
            if (refGroup instanceof SingletonRefGroup) {
                VcsRef ref = ((SingletonRefGroup)refGroup).getRef();
                if (BranchPopupBuilder.isFavorite(pack, ref)) {
                    BranchPopupBuilder.append(actions2.favoriteGroups, refGroup.getName(), ref);
                    continue;
                }
                BranchPopupBuilder.append(actions2.singletonGroups, refGroup.getName(), ref);
                continue;
            }
            TreeMap<String, TreeMap<String, Collection<VcsRef>>> groups = refGroup.isExpanded() ? actions2.expandedGroups : actions2.collapsedGroups;
            TreeMap groupActions = groups.computeIfAbsent(refGroup.getName(), key2 -> new TreeMap());
            for (VcsRef ref : refGroup.getRefs()) {
                if (BranchPopupBuilder.isFavorite(pack, ref)) {
                    BranchPopupBuilder.append(actions2.favoriteGroups, ref.getName(), ref);
                }
                BranchPopupBuilder.append(groupActions, ref.getName(), ref);
            }
        }
    }

    public static boolean isFavorite(@NotNull VcsLogDataPack pack, @NotNull VcsRef ref) {
        if (pack == null) {
            BranchPopupBuilder.$$$reportNull$$$0(13);
        }
        if (ref == null) {
            BranchPopupBuilder.$$$reportNull$$$0(14);
        }
        return pack.getLogProviders().get(ref.getRoot()).getReferenceManager().isFavorite(ref);
    }

    private static <T> void append(@NotNull TreeMap<String, Collection<T>> map2, @NotNull String key2, @NotNull T value2) {
        if (map2 == null) {
            BranchPopupBuilder.$$$reportNull$$$0(15);
        }
        if (key2 == null) {
            BranchPopupBuilder.$$$reportNull$$$0(16);
        }
        if (value2 == null) {
            BranchPopupBuilder.$$$reportNull$$$0(17);
        }
        BranchPopupBuilder.append(map2, key2, Collections.singleton(value2));
    }

    private static <T> void append(@NotNull TreeMap<String, Collection<T>> map2, @NotNull String key2, @NotNull Collection<? extends T> values2) {
        if (map2 == null) {
            BranchPopupBuilder.$$$reportNull$$$0(18);
        }
        if (key2 == null) {
            BranchPopupBuilder.$$$reportNull$$$0(19);
        }
        if (values2 == null) {
            BranchPopupBuilder.$$$reportNull$$$0(20);
        }
        map2.computeIfAbsent(key2, k -> new HashSet()).addAll(values2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPack";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recentItem";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "favorites";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/filter/BranchPopupBuilder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pack";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/filter/BranchPopupBuilder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createCollapsedAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createRecentAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFavoritesAction";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCollapsedAction";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prepareGroups";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createActions";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "putActionsForReferences";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isFavorite";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 7 -> new IllegalStateException(string2);
        };
    }

    private static class Groups {
        private final TreeMap<String, Collection<VcsRef>> favoriteGroups = new TreeMap();
        private final TreeMap<String, Collection<VcsRef>> singletonGroups = new TreeMap();
        private final List<List<String>> recentGroups = new ArrayList<List<String>>();
        private final TreeMap<String, TreeMap<String, Collection<VcsRef>>> expandedGroups = new TreeMap();
        private final TreeMap<String, TreeMap<String, Collection<VcsRef>>> collapsedGroups = new TreeMap();

        private Groups() {
        }
    }
}

