/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtilRt;
import com.intellij.vcs.log.VcsLogProvider;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u0007J\u001d\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b\u0015J\u0018\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u0018\u0010\u0017\u001a\u00020\u0018*\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\u00068FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/intellij/vcs/log/util/PersistentUtil;", "", "()V", "CORRUPTION_MARKER", "", "LOG_CACHE", "Ljava/nio/file/Path;", "corruptionMarkerFile", "getCorruptionMarkerFile$annotations", "getCorruptionMarkerFile", "()Ljava/nio/file/Path;", "calcLogId", "project", "Lcom/intellij/openapi/project/Project;", "logProviders", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/VcsLogProvider;", "getPersistenceLogCacheDir", "projectName", "logId", "getPersistenceLogCacheDir$intellij_platform_vcs_log_impl", "getProjectLogDataDirectoryName", "calcHash", "", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nPersistentUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PersistentUtil.kt\ncom/intellij/vcs/log/util/PersistentUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n1045#2:87\n*S KotlinDebug\n*F\n+ 1 PersistentUtil.kt\ncom/intellij/vcs/log/util/PersistentUtil\n*L\n34#1:87\n*E\n"})
public final class PersistentUtil {
    @NotNull
    public static final PersistentUtil INSTANCE = new PersistentUtil();
    @JvmField
    @NotNull
    public static final Path LOG_CACHE;
    @NonNls
    @NotNull
    private static final String CORRUPTION_MARKER = "corruption.marker";

    private PersistentUtil() {
    }

    @NotNull
    public static final Path getCorruptionMarkerFile() {
        Path path2 = LOG_CACHE.resolve(CORRUPTION_MARKER);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return path2;
    }

    @JvmStatic
    public static /* synthetic */ void getCorruptionMarkerFile$annotations() {
    }

    @JvmStatic
    @NotNull
    public static final String calcLogId(@NotNull Project project2, @NotNull Map<VirtualFile, ? extends VcsLogProvider> logProviders) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(logProviders, (String)"logProviders");
        return project2.getLocationHash() + "." + Integer.toHexString(INSTANCE.calcHash(logProviders));
    }

    private final int calcHash(Map<VirtualFile, ? extends VcsLogProvider> $this$calcHash) {
        Iterable $this$sortedBy$iv = $this$calcHash.keySet();
        boolean $i$f$sortedBy = false;
        List sortedRoots2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                VirtualFile it = (VirtualFile)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getPath());
                it = (VirtualFile)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getPath())));
            }
        });
        return CollectionsKt.joinToString$default((Iterable)sortedRoots2, (CharSequence)".", null, null, (int)0, null, (Function1)((Function1)new Function1<VirtualFile, CharSequence>($this$calcHash){
            final /* synthetic */ Map<VirtualFile, VcsLogProvider> $this_calcHash;
            {
                this.$this_calcHash = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull VirtualFile root) {
                Intrinsics.checkNotNullParameter((Object)root, (String)"root");
                return root.getPath() + "." + ((VcsLogProvider)MapsKt.getValue(this.$this_calcHash, (Object)root)).getSupportedVcs().getName();
            }
        }), (int)30, null).hashCode();
    }

    @JvmStatic
    @NotNull
    public static final Path getPersistenceLogCacheDir$intellij_platform_vcs_log_impl(@NotNull String projectName, @NotNull String logId) {
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        Intrinsics.checkNotNullParameter((Object)logId, (String)"logId");
        Path path2 = LOG_CACHE.resolve(PersistentUtil.getProjectLogDataDirectoryName(projectName, logId));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return path2;
    }

    @JvmStatic
    @NotNull
    public static final String getProjectLogDataDirectoryName(@NotNull String projectName, @NotNull String logId) {
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        Intrinsics.checkNotNullParameter((Object)logId, (String)"logId");
        String string2 = PathUtilRt.suggestFileName((String)(StringsKt.take((String)projectName, (int)7) + "." + logId), (boolean)false, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"suggestFileName(...)");
        return string2;
    }

    static {
        String[] stringArray = new String[]{"vcs-log"};
        Path path2 = Path.of(PathManager.getSystemPath(), stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
        LOG_CACHE = path2;
    }
}

