/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackBase;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.visible.EmptyVisibleGraph;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisiblePack
implements VcsLogDataPack,
UserDataHolder {
    @NotNull
    public static final VisiblePack EMPTY = new VisiblePack((DataPackBase)DataPack.EMPTY, (VisibleGraph)EmptyVisibleGraph.getInstance(), false, VcsLogFilterObject.EMPTY_COLLECTION){

        @Override
        public String toString() {
            return "EmptyVisiblePack";
        }
    };
    @NotNull
    public static final Key<Boolean> NO_GRAPH_INFORMATION = Key.create((String)"NO_GRAPH_INFORMATION");
    @NotNull
    private final DataPackBase myDataPack;
    @NotNull
    private final VisibleGraph<Integer> myVisibleGraph;
    private final boolean myCanRequestMore;
    @NotNull
    private final VcsLogFilterCollection myFilters;
    @NotNull
    private final Map<Key, Object> myAdditionalData;

    public VisiblePack(@NotNull DataPackBase dataPack, @NotNull VisibleGraph<Integer> graph, boolean canRequestMore, @NotNull VcsLogFilterCollection filters) {
        if (dataPack == null) {
            VisiblePack.$$$reportNull$$$0(0);
        }
        if (graph == null) {
            VisiblePack.$$$reportNull$$$0(1);
        }
        if (filters == null) {
            VisiblePack.$$$reportNull$$$0(2);
        }
        this(dataPack, graph, canRequestMore, filters, Collections.emptyMap());
    }

    public VisiblePack(@NotNull DataPackBase dataPack, @NotNull VisibleGraph<Integer> graph, boolean canRequestMore, @NotNull VcsLogFilterCollection filters, @NotNull Map<Key, Object> additionalData) {
        if (dataPack == null) {
            VisiblePack.$$$reportNull$$$0(3);
        }
        if (graph == null) {
            VisiblePack.$$$reportNull$$$0(4);
        }
        if (filters == null) {
            VisiblePack.$$$reportNull$$$0(5);
        }
        if (additionalData == null) {
            VisiblePack.$$$reportNull$$$0(6);
        }
        this.myAdditionalData = new ConcurrentHashMap<Key, Object>();
        this.myDataPack = dataPack;
        this.myVisibleGraph = graph;
        this.myCanRequestMore = canRequestMore;
        this.myFilters = filters;
        this.myAdditionalData.putAll(additionalData);
    }

    @NotNull
    public VisibleGraph<Integer> getVisibleGraph() {
        VisibleGraph<Integer> visibleGraph = this.myVisibleGraph;
        if (visibleGraph == null) {
            VisiblePack.$$$reportNull$$$0(7);
        }
        return visibleGraph;
    }

    @NotNull
    public DataPackBase getDataPack() {
        DataPackBase dataPackBase = this.myDataPack;
        if (dataPackBase == null) {
            VisiblePack.$$$reportNull$$$0(8);
        }
        return dataPackBase;
    }

    public boolean canRequestMore() {
        return this.myCanRequestMore;
    }

    @Override
    @NotNull
    public Map<VirtualFile, VcsLogProvider> getLogProviders() {
        Map<VirtualFile, VcsLogProvider> map2 = this.myDataPack.getLogProviders();
        if (map2 == null) {
            VisiblePack.$$$reportNull$$$0(9);
        }
        return map2;
    }

    @Override
    @NotNull
    public VcsLogRefs getRefs() {
        RefsModel refsModel = this.myDataPack.getRefsModel();
        if (refsModel == null) {
            VisiblePack.$$$reportNull$$$0(10);
        }
        return refsModel;
    }

    public boolean isFull() {
        return this.myDataPack.isFull();
    }

    @Override
    @NotNull
    public VcsLogFilterCollection getFilters() {
        VcsLogFilterCollection vcsLogFilterCollection = this.myFilters;
        if (vcsLogFilterCollection == null) {
            VisiblePack.$$$reportNull$$$0(11);
        }
        return vcsLogFilterCollection;
    }

    @Override
    public boolean isEmpty() {
        return this.getVisibleGraph().getVisibleCommitCount() == 0;
    }

    @Nullable
    public VirtualFile getRoot(int row2) {
        int head = this.getVisibleGraph().getRowInfo(row2).getOneOfHeads();
        return this.myDataPack.getRefsModel().rootAtHead(head);
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key2) {
        if (key2 == null) {
            VisiblePack.$$$reportNull$$$0(12);
        }
        return (T)this.myAdditionalData.get(key2);
    }

    public <T> void putUserData(@NotNull Key<T> key2, @Nullable T value2) {
        if (key2 == null) {
            VisiblePack.$$$reportNull$$$0(13);
        }
        this.myAdditionalData.put(key2, value2);
    }

    @NotNull
    public Map<Key, Object> getAdditionalData() {
        Map<Key, Object> map2 = this.myAdditionalData;
        if (map2 == null) {
            VisiblePack.$$$reportNull$$$0(14);
        }
        return map2;
    }

    @NonNls
    public String toString() {
        return "VisiblePack{size=" + this.getVisibleGraph().getVisibleCommitCount() + ", filters=" + this.myFilters + ", canRequestMore=" + this.myCanRequestMore + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 10, 11, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPack";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalData";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/visible/VisiblePack";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/visible/VisiblePack";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleGraph";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataPack";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogProviders";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefs";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilters";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 7, 8, 9, 10, 11, 14 -> new IllegalStateException(string2);
        };
    }

    public static class ErrorVisiblePack
    extends VisiblePack {
        @NotNull
        private final Throwable myError;

        public ErrorVisiblePack(@NotNull DataPackBase dataPack, @NotNull VcsLogFilterCollection filters, @NotNull Throwable error) {
            if (dataPack == null) {
                ErrorVisiblePack.$$$reportNull$$$0(0);
            }
            if (filters == null) {
                ErrorVisiblePack.$$$reportNull$$$0(1);
            }
            if (error == null) {
                ErrorVisiblePack.$$$reportNull$$$0(2);
            }
            super(dataPack, EmptyVisibleGraph.getInstance(), false, filters);
            this.myError = error;
        }

        @NotNull
        public Throwable getError() {
            Throwable throwable = this.myError;
            if (throwable == null) {
                ErrorVisiblePack.$$$reportNull$$$0(3);
            }
            return throwable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataPack";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filters";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "error";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/visible/VisiblePack$ErrorVisiblePack";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/visible/VisiblePack$ErrorVisiblePack";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getError";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 3 -> new IllegalStateException(string2);
            };
        }
    }
}

