/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols;

import com.intellij.model.Pointer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.webSymbols.WebSymbol;
import com.intellij.webSymbols.WebSymbolApiStatus;
import com.intellij.webSymbols.WebSymbolNameSegment;
import com.intellij.webSymbols.WebSymbolQualifiedKind;
import com.intellij.webSymbols.utils.WebSymbolUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001:\u0002DEB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bB+\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\n\"\u00020\u0003\u00a2\u0006\u0002\u0010\u000bB\u0082\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u000f\b\u0002\u0010\u000f\u001a\t\u0018\u00010\u0010\u00a2\u0006\u0002\b\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0006\u0012\u0010\b\u0002\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014\u0012\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u0012\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u0012\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u001bJ\r\u00103\u001a\u000204H\u0000\u00a2\u0006\u0002\b5JO\u00106\u001a\u00020\u00002\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u00172\n\b\u0002\u0010&\u001a\u0004\u0018\u00010\u00192\n\b\u0002\u0010+\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\fH\u0000\u00a2\u0006\u0004\b7\u00108J\f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00000:J\u0013\u0010;\u001a\u00070\u0010\u00a2\u0006\u0002\b\u00112\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010<\u001a\u00020\u0010H\u0016J\u0017\u0010=\u001a\u00020\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0000\u00a2\u0006\u0002\b>J\u0015\u0010?\u001a\u00020\u00002\u0006\u0010@\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\bAJ\u001d\u0010B\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\bCR\u0013\u0010\u001c\u001a\u0004\u0018\u00010\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0018\u0010\u000f\u001a\t\u0018\u00010\u0010\u00a2\u0006\u0002\b\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010#R\u0016\u0010$\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\"R\u0013\u0010&\u001a\u0004\u0018\u00010\u00198F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0013\u0010+\u001a\u0004\u0018\u00010\u00068F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\"R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148F\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\f\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102\u00a8\u0006F"}, d2={"Lcom/intellij/webSymbols/WebSymbolNameSegment;", "", "symbol", "Lcom/intellij/webSymbols/WebSymbol;", "(Lcom/intellij/webSymbols/WebSymbol;)V", "start", "", "end", "(IILcom/intellij/webSymbols/WebSymbol;)V", "symbols", "", "(II[Lcom/intellij/webSymbols/WebSymbol;)V", "", "problem", "Lcom/intellij/webSymbols/WebSymbolNameSegment$MatchProblem;", "displayName", "", "Lcom/intellij/openapi/util/NlsSafe;", "matchScore", "symbolKinds", "", "Lcom/intellij/webSymbols/WebSymbolQualifiedKind;", "explicitApiStatus", "Lcom/intellij/webSymbols/WebSymbolApiStatus;", "explicitPriority", "Lcom/intellij/webSymbols/WebSymbol$Priority;", "explicitProximity", "(IILjava/util/List;Lcom/intellij/webSymbols/WebSymbolNameSegment$MatchProblem;Ljava/lang/String;ILjava/util/Set;Lcom/intellij/webSymbols/WebSymbolApiStatus;Lcom/intellij/webSymbols/WebSymbol$Priority;Ljava/lang/Integer;)V", "apiStatus", "getApiStatus", "()Lcom/intellij/webSymbols/WebSymbolApiStatus;", "getDisplayName", "()Ljava/lang/String;", "getEnd", "()I", "Ljava/lang/Integer;", "forcedSymbolKinds", "getMatchScore", "priority", "getPriority", "()Lcom/intellij/webSymbols/WebSymbol$Priority;", "getProblem", "()Lcom/intellij/webSymbols/WebSymbolNameSegment$MatchProblem;", "proximity", "getProximity", "()Ljava/lang/Integer;", "getStart", "getSymbolKinds", "()Ljava/util/Set;", "getSymbols", "()Ljava/util/List;", "canUnwrapSymbols", "", "canUnwrapSymbols$intellij_platform_webSymbols", "copy", "copy$intellij_platform_webSymbols", "(Lcom/intellij/webSymbols/WebSymbolApiStatus;Lcom/intellij/webSymbols/WebSymbol$Priority;Ljava/lang/Integer;Lcom/intellij/webSymbols/WebSymbolNameSegment$MatchProblem;Ljava/util/List;)Lcom/intellij/webSymbols/WebSymbolNameSegment;", "createPointer", "Lcom/intellij/model/Pointer;", "getName", "toString", "withDisplayName", "withDisplayName$intellij_platform_webSymbols", "withOffset", "offset", "withOffset$intellij_platform_webSymbols", "withRange", "withRange$intellij_platform_webSymbols", "MatchProblem", "NameSegmentPointer", "intellij.platform.webSymbols"})
public final class WebSymbolNameSegment {
    private final int start;
    private final int end;
    @NotNull
    private final List<WebSymbol> symbols;
    @Nullable
    private final MatchProblem problem;
    @Nullable
    private final String displayName;
    private final int matchScore;
    @Nullable
    private final WebSymbolApiStatus explicitApiStatus;
    @Nullable
    private final WebSymbol.Priority explicitPriority;
    @Nullable
    private final Integer explicitProximity;
    @Nullable
    private final Set<WebSymbolQualifiedKind> forcedSymbolKinds;

    public WebSymbolNameSegment(int start2, int end, @NotNull List<? extends WebSymbol> symbols, @Nullable MatchProblem problem2, @Nullable String displayName, int matchScore, @Nullable Set<WebSymbolQualifiedKind> symbolKinds2, @Nullable WebSymbolApiStatus explicitApiStatus, @Nullable WebSymbol.Priority explicitPriority, @Nullable Integer explicitProximity) {
        boolean bl;
        Intrinsics.checkNotNullParameter(symbols, (String)"symbols");
        this.start = start2;
        this.end = end;
        this.symbols = symbols;
        this.problem = problem2;
        this.displayName = displayName;
        this.matchScore = matchScore;
        this.explicitApiStatus = explicitApiStatus;
        this.explicitPriority = explicitPriority;
        this.explicitProximity = explicitProximity;
        boolean bl2 = bl = this.start <= this.end;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.forcedSymbolKinds = symbolKinds2;
    }

    public /* synthetic */ WebSymbolNameSegment(int n, int n2, List list2, MatchProblem matchProblem2, String string2, int n3, Set set, WebSymbolApiStatus webSymbolApiStatus, WebSymbol.Priority priority2, Integer n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n5 & 8) != 0) {
            matchProblem2 = null;
        }
        if ((n5 & 0x10) != 0) {
            string2 = null;
        }
        if ((n5 & 0x20) != 0) {
            n3 = n2 - n;
        }
        if ((n5 & 0x40) != 0) {
            set = null;
        }
        if ((n5 & 0x80) != 0) {
            webSymbolApiStatus = null;
        }
        if ((n5 & 0x100) != 0) {
            priority2 = null;
        }
        if ((n5 & 0x200) != 0) {
            n4 = null;
        }
        this(n, n2, list2, matchProblem2, string2, n3, set, webSymbolApiStatus, priority2, n4);
    }

    public final int getStart() {
        return this.start;
    }

    public final int getEnd() {
        return this.end;
    }

    @NotNull
    public final List<WebSymbol> getSymbols() {
        return this.symbols;
    }

    @Nullable
    public final MatchProblem getProblem() {
        return this.problem;
    }

    @Nullable
    public final String getDisplayName() {
        return this.displayName;
    }

    public final int getMatchScore() {
        return this.matchScore;
    }

    public WebSymbolNameSegment(@NotNull WebSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        this(0, symbol.getName().length(), CollectionsKt.listOf((Object)symbol), null, null, 0, null, null, null, null, 1016, null);
    }

    public WebSymbolNameSegment(int start2, int end, @NotNull WebSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        this(start2, end, CollectionsKt.listOf((Object)symbol), null, null, 0, null, null, null, null, 1016, null);
    }

    public WebSymbolNameSegment(int start2, int end, WebSymbol ... symbols) {
        Intrinsics.checkNotNullParameter((Object)symbols, (String)"symbols");
        this(start2, end, ArraysKt.toList((Object[])symbols), null, null, 0, null, null, null, null, 1016, null);
    }

    @Nullable
    public final WebSymbolApiStatus getApiStatus() {
        return this.explicitApiStatus;
    }

    @Nullable
    public final WebSymbol.Priority getPriority() {
        WebSymbol.Priority priority2 = this.explicitPriority;
        if (priority2 == null) {
            priority2 = (WebSymbol.Priority)((Object)SequencesKt.maxOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.symbols), (Function1)priority.1.INSTANCE)));
        }
        return priority2;
    }

    @Nullable
    public final Integer getProximity() {
        Integer n = this.explicitProximity;
        if (n == null) {
            n = (Integer)SequencesKt.maxOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.symbols), (Function1)proximity.1.INSTANCE));
        }
        return n;
    }

    @NotNull
    public final Set<WebSymbolQualifiedKind> getSymbolKinds() {
        Set set = this.forcedSymbolKinds;
        if (set == null) {
            set = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.symbols), (Function1)symbolKinds.1.INSTANCE));
        }
        return set;
    }

    @NotNull
    public final String getName(@NotNull WebSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        String string2 = WebSymbolUtils.getMatchedNameOrName(symbol).substring(this.start, this.end);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return string2;
    }

    @NotNull
    public final WebSymbolNameSegment withOffset$intellij_platform_webSymbols(int offset) {
        return new WebSymbolNameSegment(this.start + offset, this.end + offset, this.symbols, this.problem, this.displayName, this.matchScore, this.forcedSymbolKinds, this.explicitApiStatus, this.explicitPriority, this.explicitProximity);
    }

    @NotNull
    public final WebSymbolNameSegment withDisplayName$intellij_platform_webSymbols(@Nullable String displayName) {
        String string2 = this.displayName;
        if (string2 == null) {
            string2 = displayName;
        }
        return new WebSymbolNameSegment(this.start, this.end, this.symbols, this.problem, string2, this.matchScore, this.forcedSymbolKinds, this.explicitApiStatus, this.explicitPriority, this.explicitProximity);
    }

    @NotNull
    public final WebSymbolNameSegment withRange$intellij_platform_webSymbols(int start2, int end) {
        return new WebSymbolNameSegment(start2, end, this.symbols, this.problem, this.displayName, this.matchScore, this.forcedSymbolKinds, this.explicitApiStatus, this.explicitPriority, this.explicitProximity);
    }

    @NotNull
    public final WebSymbolNameSegment copy$intellij_platform_webSymbols(@Nullable WebSymbolApiStatus apiStatus2, @Nullable WebSymbol.Priority priority2, @Nullable Integer proximity2, @Nullable MatchProblem problem2, @NotNull List<? extends WebSymbol> symbols) {
        Integer n;
        WebSymbol.Priority priority3;
        WebSymbolApiStatus webSymbolApiStatus;
        Intrinsics.checkNotNullParameter(symbols, (String)"symbols");
        List list2 = CollectionsKt.plus((Collection)this.symbols, (Iterable)symbols);
        MatchProblem matchProblem2 = problem2;
        if (matchProblem2 == null) {
            matchProblem2 = this.problem;
        }
        if ((webSymbolApiStatus = apiStatus2) == null) {
            webSymbolApiStatus = this.explicitApiStatus;
        }
        if ((priority3 = priority2) == null) {
            priority3 = this.explicitPriority;
        }
        if ((n = proximity2) == null) {
            n = this.explicitProximity;
        }
        return new WebSymbolNameSegment(this.start, this.end, list2, matchProblem2, this.displayName, this.matchScore, this.forcedSymbolKinds, webSymbolApiStatus, priority3, n);
    }

    public static /* synthetic */ WebSymbolNameSegment copy$intellij_platform_webSymbols$default(WebSymbolNameSegment webSymbolNameSegment, WebSymbolApiStatus webSymbolApiStatus, WebSymbol.Priority priority2, Integer n, MatchProblem matchProblem2, List list2, int n2, Object object) {
        if ((n2 & 1) != 0) {
            webSymbolApiStatus = null;
        }
        if ((n2 & 2) != 0) {
            priority2 = null;
        }
        if ((n2 & 4) != 0) {
            n = null;
        }
        if ((n2 & 8) != 0) {
            matchProblem2 = null;
        }
        if ((n2 & 0x10) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return webSymbolNameSegment.copy$intellij_platform_webSymbols(webSymbolApiStatus, priority2, n, matchProblem2, list2);
    }

    public final boolean canUnwrapSymbols$intellij_platform_webSymbols() {
        return this.explicitApiStatus == null && this.problem == null && this.displayName == null && this.matchScore == this.end - this.start && this.explicitPriority == null && this.explicitProximity == null && !((Collection)this.symbols).isEmpty();
    }

    @NotNull
    public final Pointer<WebSymbolNameSegment> createPointer() {
        return new NameSegmentPointer(this);
    }

    @NotNull
    public String toString() {
        return "<" + this.start + ":" + this.end + (String)(this.problem != null ? ":" + this.problem : "") + "-" + this.symbols.size() + "cs>";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/webSymbols/WebSymbolNameSegment$MatchProblem;", "", "(Ljava/lang/String;I)V", "MISSING_REQUIRED_PART", "UNKNOWN_SYMBOL", "DUPLICATE", "intellij.platform.webSymbols"})
    public static final class MatchProblem
    extends Enum<MatchProblem> {
        public static final /* enum */ MatchProblem MISSING_REQUIRED_PART = new MatchProblem();
        public static final /* enum */ MatchProblem UNKNOWN_SYMBOL = new MatchProblem();
        public static final /* enum */ MatchProblem DUPLICATE = new MatchProblem();
        private static final /* synthetic */ MatchProblem[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static MatchProblem[] values() {
            return (MatchProblem[])$VALUES.clone();
        }

        public static MatchProblem valueOf(String value2) {
            return Enum.valueOf(MatchProblem.class, value2);
        }

        @NotNull
        public static EnumEntries<MatchProblem> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = matchProblemArray = new MatchProblem[]{MatchProblem.MISSING_REQUIRED_PART, MatchProblem.UNKNOWN_SYMBOL, MatchProblem.DUPLICATE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0002H\u0016R\u0017\u0010\u0005\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\u00078\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u00010\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/webSymbols/WebSymbolNameSegment$NameSegmentPointer;", "Lcom/intellij/model/Pointer;", "Lcom/intellij/webSymbols/WebSymbolNameSegment;", "nameSegment", "(Lcom/intellij/webSymbols/WebSymbolNameSegment;)V", "displayName", "", "Lcom/intellij/openapi/util/NlsSafe;", "end", "", "explicitApiStatus", "Lcom/intellij/webSymbols/WebSymbolApiStatus;", "explicitPriority", "Lcom/intellij/webSymbols/WebSymbol$Priority;", "explicitProximity", "Ljava/lang/Integer;", "matchScore", "problem", "Lcom/intellij/webSymbols/WebSymbolNameSegment$MatchProblem;", "start", "symbols", "", "Lcom/intellij/webSymbols/WebSymbol;", "types", "", "Lcom/intellij/webSymbols/WebSymbolQualifiedKind;", "dereference", "intellij.platform.webSymbols"})
    @SourceDebugExtension(value={"SMAP\nWebSymbolNameSegment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSymbolNameSegment.kt\ncom/intellij/webSymbols/WebSymbolNameSegment$NameSegmentPointer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,118:1\n1549#2:119\n1620#2,3:120\n1549#2:123\n1620#2,3:124\n1726#2,3:128\n1#3:127\n*S KotlinDebug\n*F\n+ 1 WebSymbolNameSegment.kt\ncom/intellij/webSymbols/WebSymbolNameSegment$NameSegmentPointer\n*L\n96#1:119\n96#1:120,3\n109#1:123\n109#1:124,3\n110#1:128,3\n*E\n"})
    private static final class NameSegmentPointer
    implements Pointer<WebSymbolNameSegment> {
        private final int start;
        private final int end;
        @NotNull
        private final List<Pointer<? extends WebSymbol>> symbols;
        @Nullable
        private final MatchProblem problem;
        @NlsSafe
        @Nullable
        private final String displayName;
        private final int matchScore;
        @NotNull
        private final Set<WebSymbolQualifiedKind> types;
        @Nullable
        private final WebSymbolApiStatus explicitApiStatus;
        @Nullable
        private final WebSymbol.Priority explicitPriority;
        @Nullable
        private final Integer explicitProximity;

        /*
         * WARNING - void declaration
         */
        public NameSegmentPointer(@NotNull WebSymbolNameSegment nameSegment) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)nameSegment, (String)"nameSegment");
            this.start = nameSegment.getStart();
            this.end = nameSegment.getEnd();
            Iterable iterable = nameSegment.getSymbols();
            NameSegmentPointer nameSegmentPointer = this;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                WebSymbol webSymbol = (WebSymbol)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.createPointer());
            }
            nameSegmentPointer.symbols = (List)destination$iv$iv;
            this.problem = nameSegment.getProblem();
            this.displayName = nameSegment.getDisplayName();
            this.matchScore = nameSegment.getMatchScore();
            this.types = nameSegment.getSymbolKinds();
            this.explicitApiStatus = nameSegment.explicitApiStatus;
            this.explicitPriority = nameSegment.explicitPriority;
            this.explicitProximity = nameSegment.explicitProximity;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public WebSymbolNameSegment dereference() {
            WebSymbolNameSegment webSymbolNameSegment;
            List list2;
            boolean bl;
            List it;
            List list3;
            block6: {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = this.symbols;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    Pointer pointer = (Pointer)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add((WebSymbol)it2.dereference());
                }
                it = list3 = (List)destination$iv$iv;
                boolean bl3 = false;
                Iterable $this$all$iv = it;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        WebSymbol symbol = (WebSymbol)element$iv;
                        boolean bl4 = false;
                        if (symbol != null) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
            }
            List list4 = list2 = bl ? list3 : null;
            if (list2 != null) {
                it = list2;
                boolean bl5 = false;
                webSymbolNameSegment = new WebSymbolNameSegment(this.start, this.end, it, this.problem, this.displayName, this.matchScore, this.types, this.explicitApiStatus, this.explicitPriority, this.explicitProximity);
            } else {
                webSymbolNameSegment = null;
            }
            return webSymbolNameSegment;
        }
    }
}

