/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.customElements.json;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.intellij.webSymbols.customElements.json.CustomElementsMember;
import com.intellij.webSymbols.customElements.json.Deprecated;
import com.intellij.webSymbols.customElements.json.MemberBase;
import com.intellij.webSymbols.customElements.json.Reference;
import com.intellij.webSymbols.customElements.json.SourceReference;
import com.intellij.webSymbols.customElements.json.Type;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"default", "deprecated", "description", "inheritedFrom", "name", "privacy", "readonly", "source", "static", "summary", "type"})
public class ClassField
extends MemberBase
implements CustomElementsMember {
    @JsonProperty(value="default")
    private String _default;
    @JsonProperty(value="deprecated")
    @JsonPropertyDescription(value="Whether the property is deprecated.\nIf the value is a string, it's the reason for the deprecation.")
    private Deprecated deprecated;
    @JsonProperty(value="description")
    @JsonPropertyDescription(value="A markdown description of the field.")
    private String description;
    @JsonProperty(value="inheritedFrom")
    @JsonPropertyDescription(value="A reference to an export of a module.\n\nAll references are required to be publically accessible, so the canonical\nrepresentation of a reference is the export it's available from.\n\n`package` should generally refer to an npm package name. If `package` is\nundefined then the reference is local to this package. If `module` is\nundefined the reference is local to the containing module.\n\nReferences to global symbols like `Array`, `HTMLElement`, or `Event` should\nuse a `package` name of `\"global:\"`.")
    private Reference inheritedFrom;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="privacy")
    private Privacy privacy;
    @JsonProperty(value="readonly")
    @JsonPropertyDescription(value="Whether the property is read-only.")
    private Boolean readonly;
    @JsonProperty(value="source")
    @JsonPropertyDescription(value="A reference to the source of a declaration or member.")
    private SourceReference source;
    @JsonProperty(value="static")
    private Boolean _static;
    @JsonProperty(value="summary")
    @JsonPropertyDescription(value="A markdown summary suitable for display in a listing.")
    private String summary;
    @JsonProperty(value="type")
    private Type type;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty(value="default")
    public String getDefault() {
        return this._default;
    }

    @JsonProperty(value="default")
    public void setDefault(String _default) {
        this._default = _default;
    }

    @Override
    @JsonProperty(value="deprecated")
    public Deprecated getDeprecated() {
        return this.deprecated;
    }

    @JsonProperty(value="deprecated")
    public void setDeprecated(Deprecated deprecated) {
        this.deprecated = deprecated;
    }

    @Override
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description2) {
        this.description = description2;
    }

    @Override
    @JsonProperty(value="inheritedFrom")
    public Reference getInheritedFrom() {
        return this.inheritedFrom;
    }

    @JsonProperty(value="inheritedFrom")
    public void setInheritedFrom(Reference inheritedFrom) {
        this.inheritedFrom = inheritedFrom;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @Override
    @JsonProperty(value="privacy")
    public Privacy getPrivacy() {
        return this.privacy;
    }

    @JsonProperty(value="privacy")
    public void setPrivacy(Privacy privacy) {
        this.privacy = privacy;
    }

    @JsonProperty(value="readonly")
    public Boolean getReadonly() {
        return this.readonly;
    }

    @JsonProperty(value="readonly")
    public void setReadonly(Boolean readonly2) {
        this.readonly = readonly2;
    }

    @Override
    @JsonProperty(value="source")
    public SourceReference getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    public void setSource(SourceReference source2) {
        this.source = source2;
    }

    @Override
    @JsonProperty(value="static")
    public Boolean getStatic() {
        return this._static;
    }

    @JsonProperty(value="static")
    public void setStatic(Boolean _static) {
        this._static = _static;
    }

    @Override
    @JsonProperty(value="summary")
    public String getSummary() {
        return this.summary;
    }

    @JsonProperty(value="summary")
    public void setSummary(String summary2) {
        this.summary = summary2;
    }

    @Override
    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(Type type2) {
        this.type = type2;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value2) {
        this.additionalProperties.put(name, value2);
    }

    public static enum Privacy {
        PRIVATE("private"),
        PROTECTED("protected"),
        PUBLIC("public");

        private final String value;
        private static final Map<String, Privacy> CONSTANTS;

        private Privacy(String value2) {
            this.value = value2;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Privacy fromValue(String value2) {
            Privacy constant = CONSTANTS.get(value2);
            if (constant == null) {
                throw new IllegalArgumentException(value2);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Privacy>();
            for (Privacy c : Privacy.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

