/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.customElements.json;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.intellij.webSymbols.customElements.json.Deprecated;
import com.intellij.webSymbols.customElements.json.ExportBase;
import com.intellij.webSymbols.customElements.json.Reference;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"declaration", "deprecated", "name"})
public class CustomElementExport
extends ExportBase {
    @JsonProperty(value="declaration")
    @JsonPropertyDescription(value="A reference to an export of a module.\n\nAll references are required to be publically accessible, so the canonical\nrepresentation of a reference is the export it's available from.\n\n`package` should generally refer to an npm package name. If `package` is\nundefined then the reference is local to this package. If `module` is\nundefined the reference is local to the containing module.\n\nReferences to global symbols like `Array`, `HTMLElement`, or `Event` should\nuse a `package` name of `\"global:\"`.")
    private Reference declaration;
    @JsonProperty(value="deprecated")
    @JsonPropertyDescription(value="Whether the custom-element export is deprecated.\nFor example, a future version will not register the custom element in this file.\nIf the value is a string, it's the reason for the deprecation.")
    private Deprecated deprecated;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="The tag name of the custom element.")
    private String name;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty(value="declaration")
    public Reference getDeclaration() {
        return this.declaration;
    }

    @JsonProperty(value="declaration")
    public void setDeclaration(Reference declaration) {
        this.declaration = declaration;
    }

    @JsonProperty(value="deprecated")
    public Deprecated getDeprecated() {
        return this.deprecated;
    }

    @JsonProperty(value="deprecated")
    public void setDeprecated(Deprecated deprecated) {
        this.deprecated = deprecated;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value2) {
        this.additionalProperties.put(name, value2);
    }
}

