/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.customElements.json;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.intellij.webSymbols.customElements.json.SourceReference;
import com.intellij.webSymbols.customElements.json.TypeReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"references", "source", "text"})
public class Type {
    @JsonProperty(value="references")
    @JsonPropertyDescription(value="An array of references to the types in the type string.\n\nThese references have optional indices into the type string so that tools\ncan understand the references in the type string independently of the type\nsystem and syntax. For example, a documentation viewer could display the\ntype `Array<FooElement | BarElement>` with cross-references to `FooElement`\nand `BarElement` without understanding arrays, generics, or union types.")
    private List<TypeReference> references = new ArrayList<TypeReference>();
    @JsonProperty(value="source")
    @JsonPropertyDescription(value="A reference to the source of a declaration or member.")
    private SourceReference source;
    @JsonProperty(value="text")
    @JsonPropertyDescription(value="The full string representation of the type, in whatever type syntax is\nused, such as JSDoc, Closure, or TypeScript.")
    private String text;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty(value="references")
    public List<TypeReference> getReferences() {
        return this.references;
    }

    @JsonProperty(value="references")
    public void setReferences(List<TypeReference> references) {
        this.references = references;
    }

    @JsonProperty(value="source")
    public SourceReference getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    public void setSource(SourceReference source2) {
        this.source = source2;
    }

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    @JsonProperty(value="text")
    public void setText(String text2) {
        this.text = text2;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value2) {
        this.additionalProperties.put(name, value2);
    }
}

