/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class UriOrFile {
    private UriOrFile() {
    }

    public static String toUri(String string2) {
        if (!UriOrFile.hasScheme(string2)) {
            try {
                return UriOrFile.fileToUri(string2);
            }
            catch (MalformedURLException malformedURLException) {
            }
        }
        return string2;
    }

    private static boolean hasScheme(String string2) {
        int n = string2.length();
        if (n == 0) {
            return false;
        }
        if (!UriOrFile.isAlpha(string2.charAt(0))) {
            return false;
        }
        int n2 = 1;
        while (n2 < n) {
            char c = string2.charAt(n2);
            switch (c) {
                case ':': {
                    return n2 != 1;
                }
                case '+': 
                case '-': {
                    break;
                }
                default: {
                    if (UriOrFile.isAlnum(c)) break;
                    return false;
                }
            }
            ++n2;
        }
        return false;
    }

    private static boolean isAlpha(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z';
    }

    private static boolean isAlnum(char c) {
        return UriOrFile.isAlpha(c) || '0' <= c && c <= '9';
    }

    public static String fileToUri(String string2) throws MalformedURLException {
        return UriOrFile.fileToUri(new File(string2));
    }

    public static String fileToUri(File file) throws MalformedURLException {
        String string2 = file.getAbsolutePath().replace(File.separatorChar, '/');
        if (string2.length() > 0 && string2.charAt(0) != '/') {
            string2 = '/' + string2;
        }
        return new URL("file", "", string2).toString();
    }

    public static String uriToUriOrFile(String string2) {
        if (!string2.startsWith("file:")) {
            return string2;
        }
        string2 = string2.substring(5);
        int n = 0;
        while (n < string2.length() && string2.charAt(n) == '/') {
            ++n;
        }
        File file = new File(string2.substring(n).replace('/', File.separatorChar));
        if (file.isAbsolute()) {
            return file.toString();
        }
        return string2.replace('/', File.separatorChar);
    }

    public static void main(String[] stringArray) {
        System.err.println(UriOrFile.uriToUriOrFile(stringArray[0]));
    }
}

