/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.map.AbstractInputCheckedMapDecorator;

public class PredicatedMap
extends AbstractInputCheckedMapDecorator
implements Serializable {
    private static final long serialVersionUID = 7412622456128415156L;
    protected final Predicate keyPredicate;
    protected final Predicate valuePredicate;

    public static Map decorate(Map map2, Predicate keyPredicate, Predicate valuePredicate) {
        return new PredicatedMap(map2, keyPredicate, valuePredicate);
    }

    protected PredicatedMap(Map map2, Predicate keyPredicate, Predicate valuePredicate) {
        super(map2);
        this.keyPredicate = keyPredicate;
        this.valuePredicate = valuePredicate;
        Iterator it = map2.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry2 = it.next();
            Object key2 = entry2.getKey();
            Object value2 = entry2.getValue();
            this.validate(key2, value2);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.map);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.map = (Map)in.readObject();
    }

    protected void validate(Object key2, Object value2) {
        if (this.keyPredicate != null && !this.keyPredicate.evaluate(key2)) {
            throw new IllegalArgumentException("Cannot add key - Predicate rejected it");
        }
        if (this.valuePredicate != null && !this.valuePredicate.evaluate(value2)) {
            throw new IllegalArgumentException("Cannot add value - Predicate rejected it");
        }
    }

    protected Object checkSetValue(Object value2) {
        if (!this.valuePredicate.evaluate(value2)) {
            throw new IllegalArgumentException("Cannot set value - Predicate rejected it");
        }
        return value2;
    }

    protected boolean isSetValueChecking() {
        return this.valuePredicate != null;
    }

    public Object put(Object key2, Object value2) {
        this.validate(key2, value2);
        return this.map.put(key2, value2);
    }

    public void putAll(Map mapToCopy) {
        Iterator it = mapToCopy.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry2 = it.next();
            Object key2 = entry2.getKey();
            Object value2 = entry2.getValue();
            this.validate(key2, value2);
        }
        this.map.putAll(mapToCopy);
    }
}

