/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact.parser;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.xml.psi.XmlPsiBundle;
import org.intellij.plugins.relaxNG.RelaxngBundle;
import org.intellij.plugins.relaxNG.compact.RncElementTypes;
import org.intellij.plugins.relaxNG.compact.RncTokenTypes;
import org.intellij.plugins.relaxNG.compact.parser.AbstractParsing;

public abstract class DeclarationParsing
extends AbstractParsing {
    public DeclarationParsing(PsiBuilder builder2) {
        super(builder2);
    }

    protected void parseTopLevel() {
        while (!this.myBuilder.eof() && LA_DECL.contains(this.currentToken())) {
            this.parseDecl(this.myBuilder);
        }
        if (LA_GRAMMAR_CONTENT.contains(this.currentToken())) {
            PsiBuilder.Marker marker = this.myBuilder.mark();
            this.parseGrammarContents();
            marker.done(RncElementTypes.GRAMMAR_PATTERN);
        } else if (this.currentToken() == RncTokenTypes.KEYWORD_GRAMMAR) {
            this.parsePattern();
        } else {
            PsiBuilder.Marker marker = this.myBuilder.mark();
            while (!this.myBuilder.eof() && this.parsePattern()) {
            }
            marker.done(RncElementTypes.GRAMMAR_PATTERN);
        }
    }

    protected abstract boolean parsePattern();

    protected void parseGrammarContents() {
        while (LA_GRAMMAR_CONTENT.contains(this.currentToken())) {
            this.parseGrammarContent(true);
        }
    }

    private void parseIncludeContents() {
        while (LA_INCLUDE_CONTENT.contains(this.currentToken())) {
            this.parseGrammarContent(false);
        }
    }

    private void parseGrammarContent(boolean allowInclude) {
        IElementType t = this.currentToken();
        if (t == RncTokenTypes.KEYWORD_START) {
            this.parseStart();
        } else if (t == RncTokenTypes.KEYWORD_DIV) {
            this.parseDiv();
        } else if (allowInclude && t == RncTokenTypes.KEYWORD_INCLUDE) {
            this.parseInclude();
        } else if (RncTokenTypes.IDENTIFIERS.contains(t)) {
            this.parseDefine();
        } else {
            this.error(XmlPsiBundle.message("xml.parsing.unexpected.token", new Object[0]));
            this.advance();
        }
    }

    private void parseDefine() {
        PsiBuilder.Marker marker = this.begin();
        this.match(ASSIGN_METHOD, RelaxngBundle.message("relaxng.parse.error.equals-orequals-or-andequals-expected", new Object[0]));
        if (!this.parsePattern()) {
            this.error(RelaxngBundle.message("relaxng.parse.error.pattern-expected", new Object[0]));
        }
        marker.done(RncElementTypes.DEFINE);
    }

    private void parseInclude() {
        PsiBuilder.Marker marker = this.begin();
        this.parseAnyUriLiteral();
        this.parseInherit();
        if (this.matches(RncTokenTypes.LBRACE)) {
            this.parseIncludeContents();
            this.match(RncTokenTypes.RBRACE, RelaxngBundle.message("relaxng.parse.error.rbrace-expected", new Object[0]));
        }
        marker.done(RncElementTypes.INCLUDE);
    }

    protected final void parseAnyUriLiteral() {
        this.match(RncTokenTypes.LITERAL, RelaxngBundle.message("relaxng.parse.error.uri-literal-expected", new Object[0]));
    }

    protected final void parseInherit() {
        if (this.matches(RncTokenTypes.KEYWORD_INHERIT)) {
            this.match(RncTokenTypes.EQ, RelaxngBundle.message("relaxng.parse.error.equals-expected", new Object[0]));
            this.match(RncTokenTypes.IDENTIFIER_OR_KEYWORD, RelaxngBundle.message("relaxng.parse.error.identifier-expected", new Object[0]));
        }
    }

    private void parseDiv() {
        PsiBuilder.Marker marker = this.begin();
        this.parseBracedGrammarContents();
        marker.done(RncElementTypes.DIV);
    }

    private void parseStart() {
        PsiBuilder.Marker marker = this.begin();
        this.match(ASSIGN_METHOD, RelaxngBundle.message("relaxng.parse.error.equals-orequals-or-andequals-expected", new Object[0]));
        if (!this.parsePattern()) {
            this.error(RelaxngBundle.message("relaxng.parse.error.pattern-expected", new Object[0]));
        }
        marker.done(RncElementTypes.START);
    }

    protected void parseBracedGrammarContents() {
        this.match(RncTokenTypes.LBRACE, RelaxngBundle.message("relaxng.parse.error.lbrace-expected", new Object[0]));
        this.parseGrammarContents();
        this.match(RncTokenTypes.RBRACE, RelaxngBundle.message("relaxng.parse.error.rbrace-expected", new Object[0]));
    }

    protected void parseDecl(PsiBuilder builder2) {
        IElementType t = builder2.getTokenType();
        if (t == RncTokenTypes.KEYWORD_NAMESPACE) {
            this.parseNamespaceDecl(false);
        } else if (t == RncTokenTypes.KEYWORD_DEFAULT) {
            this.parseNamespaceDecl(true);
        } else if (t == RncTokenTypes.KEYWORD_DATATYPES) {
            this.parseDataTypesDecl();
        }
    }

    private void parseDataTypesDecl() {
        PsiBuilder.Marker marker = this.begin();
        this.match(RncTokenTypes.IDENTIFIER_OR_KEYWORD, RelaxngBundle.message("relaxng.parse.error.identifier-expected", new Object[0]));
        this.match(RncTokenTypes.EQ, RelaxngBundle.message("relaxng.parse.error.equals-expected", new Object[0]));
        this.parseNsUriLiteral();
        marker.done(RncElementTypes.DATATYPES_DECL);
    }

    private void parseNamespaceDecl(boolean isDefault) {
        PsiBuilder.Marker marker = this.begin();
        if (isDefault) {
            this.match(RncTokenTypes.KEYWORD_NAMESPACE, RelaxngBundle.message("relaxng.parse.error.namespace-expected", new Object[0]));
            this.matches(RncTokenTypes.IDENTIFIER_OR_KEYWORD);
        } else {
            this.match(RncTokenTypes.IDENTIFIER_OR_KEYWORD, RelaxngBundle.message("relaxng.parse.error.identifier-expected", new Object[0]));
        }
        this.match(RncTokenTypes.EQ, RelaxngBundle.message("relaxng.parse.error.equals-expected", new Object[0]));
        this.parseNsUriLiteral();
        marker.done(RncElementTypes.NS_DECL);
    }

    private void parseNsUriLiteral() {
        this.match(NS_URI_LITERAL, RelaxngBundle.message("relaxng.parse.error.namespace-uri-or-inherit-expected", new Object[0]));
    }
}

