/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalUtil;
import org.jetbrains.plugins.terminal.exp.BlockTerminalSession;
import org.jetbrains.plugins.terminal.exp.ShellCommandOutputScraper;
import org.jetbrains.plugins.terminal.exp.StyledCommandOutput;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/terminal/exp/ShellCommandEndMarkerListener;", "", "session", "Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSession;", "onFound", "Lkotlin/Function0;", "", "(Lorg/jetbrains/plugins/terminal/exp/BlockTerminalSession;Lkotlin/jvm/functions/Function0;)V", "disposable", "Lcom/intellij/openapi/Disposable;", "found", "Ljava/util/concurrent/atomic/AtomicBoolean;", "findCommandEndMarker", "", "intellij.terminal"})
public final class ShellCommandEndMarkerListener {
    @NotNull
    private final BlockTerminalSession session;
    @NotNull
    private final Function0<Unit> onFound;
    @NotNull
    private final Disposable disposable;
    @NotNull
    private final AtomicBoolean found;

    public ShellCommandEndMarkerListener(@NotNull BlockTerminalSession session2, @NotNull Function0<Unit> onFound) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter(onFound, (String)"onFound");
        this.session = session2;
        this.onFound = onFound;
        Disposable disposable = Disposer.newDisposable((Disposable)this.session, (String)ShellCommandEndMarkerListener.class.getSimpleName());
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.disposable = disposable;
        this.found = new AtomicBoolean(false);
        if (!this.findCommandEndMarker()) {
            TerminalUtil.addModelListener(this.session.getModel().getTextBuffer$intellij_terminal(), this.disposable, () -> ShellCommandEndMarkerListener._init_$lambda$0(this));
        }
    }

    private final boolean findCommandEndMarker() {
        StyledCommandOutput output = ShellCommandOutputScraper.Companion.scrapeOutput(this.session);
        if (output.getCommandEndMarkerFound() && this.found.compareAndSet(false, true)) {
            Disposer.dispose((Disposable)this.disposable);
            this.onFound.invoke();
            return true;
        }
        return false;
    }

    private static final void _init_$lambda$0(ShellCommandEndMarkerListener this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.findCommandEndMarker();
    }
}

