/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.AllHighlightingsSnapshot;
import org.jetbrains.plugins.terminal.exp.CommandBlock;
import org.jetbrains.plugins.terminal.exp.CommandBlockInfo;
import org.jetbrains.plugins.terminal.exp.HighlightingInfo;
import org.jetbrains.plugins.terminal.exp.PromptRenderingInfo;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0014\u0018\u00002\u00020\u0001:\u0001FB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00152\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\b\u0010\u001b\u001a\u00020\u0017H\u0007J\u001c\u0010\u001c\u001a\u00020\t2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0007J\u0018\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020$H\u0007J\u0018\u0010%\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020$H\u0002J\u0015\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\tH\u0001\u00a2\u0006\u0002\b(J\u0010\u0010)\u001a\u00020$2\u0006\u0010\"\u001a\u00020\tH\u0002J\u0018\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00132\u0006\u0010-\u001a\u00020$H\u0002J\u0018\u0010.\u001a\u00020+2\u0006\u0010/\u001a\u00020+2\u0006\u00100\u001a\u00020+H\u0002J\b\u00101\u001a\u0004\u0018\u00010\tJ\u0010\u00102\u001a\u0002032\u0006\u0010\"\u001a\u00020\tH\u0007J\u0012\u00104\u001a\u0004\u0018\u00010\n2\u0006\u0010\"\u001a\u00020\tH\u0007J\u0006\u00105\u001a\u00020+J\u000e\u00106\u001a\u00020\t2\u0006\u00107\u001a\u00020+J\u0010\u00108\u001a\u0004\u0018\u00010\t2\u0006\u00109\u001a\u00020+J\u0018\u0010:\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\"\u001a\u00020\tH\u0007J\r\u0010;\u001a\u00020\u0006H\u0001\u00a2\u0006\u0002\b<J\u000e\u0010=\u001a\u00020+2\u0006\u0010\"\u001a\u00020\tJ\b\u0010>\u001a\u0004\u0018\u00010\tJ\b\u0010?\u001a\u00020+H\u0002J\u001e\u0010@\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0007J\u0010\u0010A\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\tH\u0007J\u0018\u0010B\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\t2\u0006\u0010C\u001a\u00020\nH\u0007J\b\u0010D\u001a\u00020\u0017H\u0007J\u0010\u0010E\u001a\u00020\u00172\u0006\u0010/\u001a\u00020+H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalOutputModel;", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "(Lcom/intellij/openapi/editor/ex/EditorEx;)V", "allHighlightingsSnapshot", "Lorg/jetbrains/plugins/terminal/exp/AllHighlightingsSnapshot;", "blockInfos", "", "Lorg/jetbrains/plugins/terminal/exp/CommandBlock;", "Lorg/jetbrains/plugins/terminal/exp/CommandBlockInfo;", "blocks", "", "document", "Lcom/intellij/openapi/editor/Document;", "getEditor", "()Lcom/intellij/openapi/editor/ex/EditorEx;", "highlightings", "", "Lorg/jetbrains/plugins/terminal/exp/HighlightingInfo;", "listeners", "Lorg/jetbrains/plugins/terminal/exp/TerminalOutputModel$TerminalOutputListener;", "addListener", "", "listener", "disposable", "Lcom/intellij/openapi/Disposable;", "clearBlocks", "createBlock", "command", "", "prompt", "Lorg/jetbrains/plugins/terminal/exp/PromptRenderingInfo;", "deleteDocumentRange", "block", "deleteRange", "Lcom/intellij/openapi/util/TextRange;", "deleteDocumentRangeInHighlightings", "finalizeBlock", "activeBlock", "finalizeBlock$intellij_terminal", "findBlockRangeToDelete", "findIntersectionLength", "", "range1", "range2", "findTopBlockCountToRemove", "maxCapacity", "textLength", "getActiveBlock", "getBlockBounds", "Ljava/awt/Rectangle;", "getBlockInfo", "getBlocksSize", "getByIndex", "index", "getByOffset", "offset", "getHighlightings", "getHighlightingsSnapshot", "getHighlightingsSnapshot$intellij_terminal", "getIndexOfBlock", "getLastBlock", "getMaxCapacity", "putHighlightings", "removeBlock", "setBlockInfo", "info", "trimOutput", "trimTopBlock", "TerminalOutputListener", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalOutputModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalOutputModel.kt\norg/jetbrains/plugins/terminal/exp/TerminalOutputModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,343:1\n1855#2,2:344\n1855#2,2:346\n1855#2,2:348\n1855#2,2:357\n1855#2,2:359\n350#2,7:361\n1603#2,9:368\n1855#2:377\n1856#2:379\n1612#2:380\n1#3:350\n1#3:378\n76#4:351\n96#4,5:352\n*S KotlinDebug\n*F\n+ 1 TerminalOutputModel.kt\norg/jetbrains/plugins/terminal/exp/TerminalOutputModel\n*L\n47#1:344,2\n55#1:346,2\n71#1:348,2\n167#1:357,2\n184#1:359,2\n203#1:361,7\n223#1:368,9\n223#1:377\n223#1:379\n223#1:380\n223#1:378\n147#1:351\n147#1:352,5\n*E\n"})
public final class TerminalOutputModel {
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final List<CommandBlock> blocks;
    @NotNull
    private final Map<CommandBlock, List<HighlightingInfo>> highlightings;
    @NotNull
    private final Map<CommandBlock, CommandBlockInfo> blockInfos;
    @Nullable
    private AllHighlightingsSnapshot allHighlightingsSnapshot;
    @NotNull
    private final Document document;
    @NotNull
    private final List<TerminalOutputListener> listeners;

    public TerminalOutputModel(@NotNull EditorEx editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
        List list = Collections.synchronizedList(new ArrayList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"synchronizedList(...)");
        this.blocks = list;
        this.highlightings = new LinkedHashMap();
        this.blockInfos = new HashMap();
        DocumentEx documentEx = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        this.document = (Document)documentEx;
        this.listeners = new CopyOnWriteArrayList();
    }

    @NotNull
    public final EditorEx getEditor() {
        return this.editor;
    }

    public final void addListener(@NotNull TerminalOutputListener listener, @Nullable Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.add(listener);
        if (disposable != null) {
            Disposer.register((Disposable)disposable, () -> TerminalOutputModel.addListener$lambda$0(this, listener));
        }
    }

    public static /* synthetic */ void addListener$default(TerminalOutputModel terminalOutputModel, TerminalOutputListener terminalOutputListener, Disposable disposable, int n, Object object) {
        if ((n & 2) != 0) {
            disposable = null;
        }
        terminalOutputModel.addListener(terminalOutputListener, disposable);
    }

    @RequiresEdt
    @NotNull
    public final CommandBlock createBlock(@Nullable String command, @Nullable PromptRenderingInfo prompt) {
        if (this.document.getTextLength() > 0) {
            this.document.insertString(this.document.getTextLength(), (CharSequence)"\n");
        }
        int startOffset = this.document.getTextLength();
        RangeMarker rangeMarker = this.document.createRangeMarker(startOffset, startOffset);
        Intrinsics.checkNotNullExpressionValue((Object)rangeMarker, (String)"createRangeMarker(...)");
        RangeMarker marker = rangeMarker;
        marker.setGreedyToRight(true);
        CommandBlock block2 = new CommandBlock(command, prompt, marker);
        this.blocks.add(block2);
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TerminalOutputListener it = (TerminalOutputListener)element$iv;
            boolean bl = false;
            it.blockCreated(block2);
        }
        return block2;
    }

    @RequiresEdt
    public final void finalizeBlock$intellij_terminal(@NotNull CommandBlock activeBlock) {
        Intrinsics.checkNotNullParameter((Object)activeBlock, (String)"activeBlock");
        activeBlock.getRange().setGreedyToRight(false);
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TerminalOutputListener it = (TerminalOutputListener)element$iv;
            boolean bl = false;
            it.blockFinalized(activeBlock);
        }
    }

    @RequiresEdt
    public final void removeBlock(@NotNull CommandBlock block2) {
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block");
        int startBlockInd = this.blocks.indexOf(block2);
        if (!(startBlockInd >= 0)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        TextRange rangeToDelete = this.findBlockRangeToDelete(block2);
        int n = this.blocks.size();
        for (int blockInd = startBlockInd + 1; blockInd < n; ++blockInd) {
            this.deleteDocumentRangeInHighlightings(this.blocks.get(blockInd), rangeToDelete);
        }
        this.blocks.remove(block2);
        this.highlightings.remove(block2);
        this.allHighlightingsSnapshot = null;
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TerminalOutputListener it = (TerminalOutputListener)element$iv;
            boolean bl = false;
            it.blockRemoved(block2);
        }
        this.document.deleteString(rangeToDelete.getStartOffset(), rangeToDelete.getEndOffset());
        block2.getRange().dispose();
    }

    private final TextRange findBlockRangeToDelete(CommandBlock block2) {
        TextRange textRange;
        TextRange blockRange = new TextRange(block2.getStartOffset(), block2.getEndOffset());
        if (blockRange.getStartOffset() > 0) {
            if (!(this.document.getCharsSequence().charAt(blockRange.getStartOffset() - 1) == '\n')) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            textRange = new TextRange(blockRange.getStartOffset() - 1, blockRange.getEndOffset());
        } else if (blockRange.getEndOffset() < this.document.getTextLength()) {
            if (!(this.document.getCharsSequence().charAt(blockRange.getEndOffset()) == '\n')) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            textRange = new TextRange(blockRange.getStartOffset(), blockRange.getEndOffset() + 1);
        } else {
            textRange = blockRange;
        }
        return textRange;
    }

    @RequiresEdt
    public final void clearBlocks() {
        List blocksCopy = CollectionsKt.reversed((Iterable)this.blocks);
        for (CommandBlock block2 : blocksCopy) {
            this.removeBlock(block2);
        }
        this.editor.getDocument().setText((CharSequence)"");
    }

    @Nullable
    public final CommandBlock getActiveBlock() {
        CommandBlock commandBlock;
        CommandBlock commandBlock2 = (CommandBlock)CollectionsKt.lastOrNull(this.blocks);
        if (commandBlock2 != null) {
            CommandBlock commandBlock3;
            CommandBlock it = commandBlock3 = commandBlock2;
            boolean bl = false;
            commandBlock = !it.isFinalized() ? commandBlock3 : null;
        } else {
            commandBlock = null;
        }
        return commandBlock;
    }

    @Nullable
    public final CommandBlock getLastBlock() {
        return (CommandBlock)CollectionsKt.lastOrNull(this.blocks);
    }

    @Nullable
    public final CommandBlock getByOffset(int offset) {
        Object v1;
        block1: {
            Iterable iterable = this.blocks;
            for (Object t : iterable) {
                CommandBlock it = (CommandBlock)t;
                boolean bl = false;
                int n = it.getStartOffset();
                boolean bl2 = offset <= it.getEndOffset() ? n <= offset : false;
                if (!bl2) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    @NotNull
    public final CommandBlock getByIndex(int index) {
        return this.blocks.get(index);
    }

    public final int getIndexOfBlock(@NotNull CommandBlock block2) {
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block");
        return this.blocks.indexOf(block2);
    }

    @RequiresEdt
    @NotNull
    public final Rectangle getBlockBounds(@NotNull CommandBlock block2) {
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block");
        int topY = this.editor.offsetToXY((int)block2.getStartOffset()).y - 8;
        int bottomY = this.editor.offsetToXY((int)block2.getEndOffset()).y + this.editor.getLineHeight() + 12;
        int width = this.editor.getScrollingModel().getVisibleArea().width - 7;
        return new Rectangle(0, topY, width, bottomY - topY);
    }

    public final int getBlocksSize() {
        return this.blocks.size();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    @NotNull
    public final AllHighlightingsSnapshot getHighlightingsSnapshot$intellij_terminal() {
        AllHighlightingsSnapshot snapshot = this.allHighlightingsSnapshot;
        if (snapshot == null) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            DocumentEx documentEx = this.editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
            Map<CommandBlock, List<HighlightingInfo>> map2 = this.highlightings;
            Document document = (Document)documentEx;
            boolean $i$f$flatMap = false;
            void var4_5 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator.next();
                boolean bl = false;
                Iterable list$iv$iv = (List)it.getValue();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List list = (List)destination$iv$iv;
            Document document2 = document;
            this.allHighlightingsSnapshot = snapshot = new AllHighlightingsSnapshot(document2, list);
        }
        return snapshot;
    }

    @RequiresEdt
    @Nullable
    public final List<HighlightingInfo> getHighlightings(@NotNull CommandBlock block2) {
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block");
        return this.highlightings.get(block2);
    }

    @RequiresEdt
    public final void putHighlightings(@NotNull CommandBlock block2, @NotNull List<HighlightingInfo> highlightings) {
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block");
        Intrinsics.checkNotNullParameter(highlightings, (String)"highlightings");
        this.highlightings.put(block2, highlightings);
        this.allHighlightingsSnapshot = null;
    }

    @RequiresEdt
    public final void setBlockInfo(@NotNull CommandBlock block2, @NotNull CommandBlockInfo info) {
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        this.blockInfos.put(block2, info);
        Iterable $this$forEach$iv = this.listeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TerminalOutputListener it = (TerminalOutputListener)element$iv;
            boolean bl = false;
            it.blockInfoUpdated(block2, info);
        }
    }

    @RequiresEdt
    @Nullable
    public final CommandBlockInfo getBlockInfo(@NotNull CommandBlock block2) {
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block");
        return this.blockInfos.get(block2);
    }

    @RequiresEdt
    public final void trimOutput() {
        int maxCapacity = this.getMaxCapacity();
        int textLength = this.document.getTextLength();
        if (textLength <= maxCapacity) {
            return;
        }
        int topBlockCountToRemove = this.findTopBlockCountToRemove(maxCapacity, textLength);
        List topBlocksToRemove = CollectionsKt.toList((Iterable)this.blocks.subList(0, topBlockCountToRemove));
        Iterable $this$forEach$iv = topBlocksToRemove;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CommandBlock it = (CommandBlock)element$iv;
            boolean bl = false;
            this.removeBlock(it);
        }
        this.trimTopBlock(maxCapacity);
    }

    private final void trimTopBlock(int maxCapacity) {
        int textLength = this.document.getTextLength();
        int textLengthToRemove = textLength - maxCapacity;
        if (textLengthToRemove <= 0) {
            return;
        }
        CommandBlock commandBlock = (CommandBlock)CollectionsKt.firstOrNull(this.blocks);
        if (commandBlock == null) {
            return;
        }
        CommandBlock block2 = commandBlock;
        int outputStartOffset = block2.getOutputStartOffset();
        int outputLengthToRemove = Math.min(block2.getEndOffset() - outputStartOffset, textLengthToRemove);
        this.deleteDocumentRange(block2, new TextRange(outputStartOffset, outputStartOffset + outputLengthToRemove));
    }

    private final int findTopBlockCountToRemove(int maxCapacity, int textLength) {
        int n;
        block2: {
            List<CommandBlock> $this$indexOfFirst$iv = this.blocks;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<CommandBlock> iterator = $this$indexOfFirst$iv.iterator();
            while (iterator.hasNext()) {
                CommandBlock item$iv;
                CommandBlock it = item$iv = iterator.next();
                boolean bl = false;
                if (it.getEndOffset() + maxCapacity > textLength) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        int firstRetainedBlockInd = n;
        return RangesKt.coerceAtLeast((int)firstRetainedBlockInd, (int)0);
    }

    @RequiresEdt
    public final void deleteDocumentRange(@NotNull CommandBlock block2, @NotNull TextRange deleteRange) {
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block");
        Intrinsics.checkNotNullParameter((Object)deleteRange, (String)"deleteRange");
        int startBlockInd = this.blocks.indexOf(block2);
        if (!(startBlockInd >= 0)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (!deleteRange.isEmpty()) {
            int n = this.blocks.size();
            for (int blockInd = startBlockInd; blockInd < n; ++blockInd) {
                this.deleteDocumentRangeInHighlightings(this.blocks.get(blockInd), deleteRange);
            }
            this.document.deleteString(deleteRange.getStartOffset(), deleteRange.getEndOffset());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void deleteDocumentRangeInHighlightings(CommandBlock block2, TextRange deleteRange) {
        void $this$mapNotNullTo$iv$iv;
        List list = this.getHighlightings(block2);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List highlightings = list;
        Iterable $this$mapNotNull$iv = highlightings;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            HighlightingInfo highlightingInfo;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            HighlightingInfo it = (HighlightingInfo)element$iv$iv;
            boolean bl2 = false;
            if (it.getEndOffset() <= deleteRange.getStartOffset()) {
                highlightingInfo = it;
            } else if (it.getStartOffset() >= deleteRange.getEndOffset()) {
                int newRangeStart = it.getStartOffset() - deleteRange.getLength();
                highlightingInfo = new HighlightingInfo(newRangeStart, newRangeStart + it.getLength(), it.getTextAttributesProvider());
            } else {
                int newRangeEnd;
                int intersectionLength = this.findIntersectionLength(it, deleteRange);
                if (!(intersectionLength > 0)) {
                    String string = "Check failed.";
                    throw new IllegalStateException(string.toString());
                }
                int newRangeStart = Math.min(it.getStartOffset(), deleteRange.getStartOffset());
                highlightingInfo = newRangeStart != (newRangeEnd = newRangeStart + it.getLength() - intersectionLength) ? new HighlightingInfo(newRangeStart, newRangeEnd, it.getTextAttributesProvider()) : null;
            }
            if (highlightingInfo == null) continue;
            HighlightingInfo it$iv$iv = highlightingInfo;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List updatedHighlightings = (List)destination$iv$iv;
        this.putHighlightings(block2, updatedHighlightings);
    }

    private final int findIntersectionLength(HighlightingInfo range1, TextRange range2) {
        int intersectionLength = Math.min(range1.getEndOffset(), range2.getEndOffset()) - Math.max(range1.getStartOffset(), range2.getStartOffset());
        return Math.max(intersectionLength, 0);
    }

    private final int getMaxCapacity() {
        return RangesKt.coerceIn((int)AdvancedSettings.Companion.getInt("new.terminal.output.capacity.kb"), (int)1, (int)10240) * 1024;
    }

    private static final void addListener$lambda$0(TerminalOutputModel this$0, TerminalOutputListener $listener) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        this$0.listeners.remove($listener);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000b\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalOutputModel$TerminalOutputListener;", "", "blockCreated", "", "block", "Lorg/jetbrains/plugins/terminal/exp/CommandBlock;", "blockFinalized", "blockInfoUpdated", "newInfo", "Lorg/jetbrains/plugins/terminal/exp/CommandBlockInfo;", "blockRemoved", "intellij.terminal"})
    public static interface TerminalOutputListener {
        default public void blockCreated(@NotNull CommandBlock block2) {
            Intrinsics.checkNotNullParameter((Object)block2, (String)"block");
        }

        default public void blockRemoved(@NotNull CommandBlock block2) {
            Intrinsics.checkNotNullParameter((Object)block2, (String)"block");
        }

        default public void blockFinalized(@NotNull CommandBlock block2) {
            Intrinsics.checkNotNullParameter((Object)block2, (String)"block");
        }

        default public void blockInfoUpdated(@NotNull CommandBlock block2, @NotNull CommandBlockInfo newInfo) {
            Intrinsics.checkNotNullParameter((Object)block2, (String)"block");
            Intrinsics.checkNotNullParameter((Object)newInfo, (String)"newInfo");
        }
    }
}

