/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.terminal.BlockTerminalColors;
import com.intellij.ui.JBColor;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.TerminalUi;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001aH\u0002J\u0012\u0010\u001d\u001a\u00020\u00142\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0012\u0010\u001e\u001a\u00020\u00142\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u000e\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0018J\u0012\u0010 \u001a\u00020!*\u00020\"2\u0006\u0010#\u001a\u00020$R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/plugins/terminal/exp/TerminalUi;", "", "()V", "alternateBufferLeftInset", "", "blockArc", "blockBottomInset", "blockLeftInset", "blockRightInset", "blockTopInset", "blocksGap", "commandToOutputInset", "cornerToBlockInset", "exitCodeRightInset", "exitCodeTextIconGap", "promptBottomInset", "promptToCommandInset", "promptTopInset", "searchComponentWidth", "createColorBoundToColorKey", "Lcom/intellij/ui/JBColor;", "colorKey", "Lcom/intellij/openapi/editor/colors/ColorKey;", "editor", "Lcom/intellij/openapi/editor/Editor;", "default", "Lkotlin/Function1;", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "Ljava/awt/Color;", "defaultBackground", "defaultForeground", "promptSeparatorColor", "useTerminalDefaultBackground", "", "Lcom/intellij/openapi/editor/ex/EditorEx;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "intellij.terminal"})
public final class TerminalUi {
    @NotNull
    public static final TerminalUi INSTANCE = new TerminalUi();
    public static final int blockTopInset = 8;
    public static final int blockBottomInset = 12;
    public static final int blockLeftInset = 12;
    public static final int blockRightInset = 12;
    public static final int cornerToBlockInset = 7;
    public static final int commandToOutputInset = 2;
    public static final int blockArc = 8;
    public static final int blocksGap = 6;
    public static final int exitCodeRightInset = 8;
    public static final int exitCodeTextIconGap = 4;
    public static final int promptTopInset = 11;
    public static final int promptBottomInset = 12;
    public static final int promptToCommandInset = 2;
    public static final int alternateBufferLeftInset = 4;
    public static final int searchComponentWidth = 500;

    private TerminalUi() {
    }

    @NotNull
    public final JBColor defaultBackground(@Nullable Editor editor) {
        return this.createColorBoundToColorKey(BlockTerminalColors.DEFAULT_BACKGROUND, editor, (Function1<? super EditorColorsScheme, ? extends Color>)((Function1)defaultBackground.1.INSTANCE));
    }

    public static /* synthetic */ JBColor defaultBackground$default(TerminalUi terminalUi, Editor editor, int n, Object object) {
        if ((n & 1) != 0) {
            editor = null;
        }
        return terminalUi.defaultBackground(editor);
    }

    @NotNull
    public final JBColor defaultForeground(@Nullable Editor editor) {
        return this.createColorBoundToColorKey(BlockTerminalColors.DEFAULT_FOREGROUND, editor, (Function1<? super EditorColorsScheme, ? extends Color>)((Function1)defaultForeground.1.INSTANCE));
    }

    public static /* synthetic */ JBColor defaultForeground$default(TerminalUi terminalUi, Editor editor, int n, Object object) {
        if ((n & 1) != 0) {
            editor = null;
        }
        return terminalUi.defaultForeground(editor);
    }

    private final JBColor createColorBoundToColorKey(ColorKey colorKey, Editor editor, Function1<? super EditorColorsScheme, ? extends Color> function1) {
        JBColor jBColor = JBColor.lazy(() -> TerminalUi.createColorBoundToColorKey$lambda$0(editor, colorKey, function1));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"lazy(...)");
        return jBColor;
    }

    static /* synthetic */ JBColor createColorBoundToColorKey$default(TerminalUi terminalUi, ColorKey colorKey, Editor editor, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            editor = null;
        }
        return terminalUi.createColorBoundToColorKey(colorKey, editor, (Function1<? super EditorColorsScheme, ? extends Color>)function1);
    }

    public final void useTerminalDefaultBackground(@NotNull EditorEx $this$useTerminalDefaultBackground, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)$this$useTerminalDefaultBackground, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        $this$useTerminalDefaultBackground.setBackgroundColor((Color)this.defaultBackground((Editor)$this$useTerminalDefaultBackground));
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect(parentDisposable);
        Topic topic = EditorColorsManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> TerminalUi.useTerminalDefaultBackground$lambda$1($this$useTerminalDefaultBackground, arg_0));
    }

    @NotNull
    public final Color promptSeparatorColor(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return (Color)this.createColorBoundToColorKey(BlockTerminalColors.PROMPT_SEPARATOR_COLOR, editor, (Function1<? super EditorColorsScheme, ? extends Color>)((Function1)promptSeparatorColor.1.INSTANCE));
    }

    private static final Color createColorBoundToColorKey$lambda$0(Editor $editor, ColorKey $colorKey, Function1 $default) {
        Intrinsics.checkNotNullParameter((Object)$colorKey, (String)"$colorKey");
        Intrinsics.checkNotNullParameter((Object)$default, (String)"$default");
        Editor editor = $editor;
        if (editor == null || (editor = editor.getColorsScheme()) == null) {
            editor = EditorColorsManager.getInstance().getGlobalScheme();
        }
        Editor editor2 = editor;
        Intrinsics.checkNotNull((Object)editor2);
        Editor colorsScheme = editor2;
        Color color = colorsScheme.getColor($colorKey);
        if (color == null) {
            color = (Color)$default.invoke((Object)colorsScheme);
        }
        return color;
    }

    private static final void useTerminalDefaultBackground$lambda$1(EditorEx $this_useTerminalDefaultBackground, EditorColorsScheme it) {
        Intrinsics.checkNotNullParameter((Object)$this_useTerminalDefaultBackground, (String)"$this_useTerminalDefaultBackground");
        $this_useTerminalDefaultBackground.setBackgroundColor((Color)INSTANCE.defaultBackground((Editor)$this_useTerminalDefaultBackground));
    }
}

