/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.exp.completion.powershell;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.DocumentUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalIcons;
import org.jetbrains.plugins.terminal.exp.BlockTerminalSession;
import org.jetbrains.plugins.terminal.exp.completion.ShellCommandExecutor;
import org.jetbrains.plugins.terminal.exp.completion.TerminalCompletionUtil;
import org.jetbrains.plugins.terminal.exp.completion.powershell.CompletionItem;
import org.jetbrains.plugins.terminal.exp.completion.powershell.CompletionResult;
import org.jetbrains.plugins.terminal.exp.completion.powershell.CompletionResultType;
import org.jetbrains.plugins.terminal.exp.completion.powershell.GetShellCompletionsCommand;
import org.jetbrains.plugins.terminal.util.ShellType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0002\u0015\u0016B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u0014\u0010\u0011\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u0014\u0010\u0012\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\f\u0010\u0013\u001a\u00020\u0014*\u00020\rH\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/terminal/exp/completion/powershell/PowerShellCompletionContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "fillCompletionVariants", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "getIconForItem", "Ljavax/swing/Icon;", "item", "Lorg/jetbrains/plugins/terminal/exp/completion/powershell/PowerShellCompletionContributor$CompletionItemInfo;", "insertFileSeparatorIfNeeded", "Lcom/intellij/codeInsight/lookup/LookupElementBuilder;", "itemInfo", "replacementStringAware", "surroundingQuotesAware", "toLookupElement", "Lcom/intellij/codeInsight/lookup/LookupElement;", "Companion", "CompletionItemInfo", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nPowerShellCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PowerShellCompletionContributor.kt\norg/jetbrains/plugins/terminal/exp/completion/powershell/PowerShellCompletionContributor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,189:1\n1549#2:190\n1620#2,3:191\n1549#2:194\n1620#2,3:195\n1549#2:198\n1620#2,3:199\n288#2,2:202\n11#3:204\n*S KotlinDebug\n*F\n+ 1 PowerShellCompletionContributor.kt\norg/jetbrains/plugins/terminal/exp/completion/powershell/PowerShellCompletionContributor\n*L\n66#1:190\n66#1:191,3\n72#1:194\n72#1:195,3\n78#1:198\n78#1:199,3\n126#1:202,2\n187#1:204\n*E\n"})
public final class PowerShellCompletionContributor
extends CompletionContributor
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        void $this$mapTo$iv$iv;
        Object item$iv$iv2;
        Pair pair;
        Object object;
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        BlockTerminalSession session2 = (BlockTerminalSession)parameters.getEditor().getUserData(BlockTerminalSession.Companion.getKEY());
        ShellCommandExecutor shellCommandExecutor = (ShellCommandExecutor)parameters.getEditor().getUserData(ShellCommandExecutor.Companion.getKEY());
        if (session2 == null || session2.getModel().isCommandRunning() || shellCommandExecutor == null || parameters.getCompletionType() != CompletionType.BASIC) {
            return;
        }
        result2.stopHere();
        if (session2.getShellIntegration().getShellType() != ShellType.POWERSHELL) {
            return;
        }
        String string = parameters.getEditor().getDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String command = string;
        int caretPosition = parameters.getEditor().getCaretModel().getOffset();
        CompletionResult completionResult2 = (CompletionResult)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super CompletionResult>, Object>(shellCommandExecutor, command, caretPosition, null){
            int label;
            final /* synthetic */ ShellCommandExecutor $shellCommandExecutor;
            final /* synthetic */ String $command;
            final /* synthetic */ int $caretPosition;
            {
                this.$shellCommandExecutor = $shellCommandExecutor;
                this.$command = $command;
                this.$caretPosition = $caretPosition;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$shellCommandExecutor.executeCommand(new GetShellCompletionsCommand(this.$command, this.$caretPosition), (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super CompletionResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        Object object2 = completionResult2;
        if (!(object2 != null && (object2 = ((CompletionResult)object2).getMatches()) != null ? !((Collection)object2).isEmpty() : false)) {
            return;
        }
        int replacementIndex = completionResult2.getReplacementIndex();
        int replacementLength = completionResult2.getReplacementLength();
        if (replacementIndex < 0 || replacementLength < 0 || replacementIndex + replacementLength > command.length()) {
            LOG.error(StringsKt.trimMargin$default((String)("Incorrect completion replacement indexes.\n        |Command: '" + command + "'\n        |CaretPosition: " + caretPosition + "\n        |Completion Result: " + completionResult2), null, (int)1, null));
            return;
        }
        int endIndex = Math.min(caretPosition, replacementIndex + replacementLength);
        String string2 = command.substring(replacementIndex, endIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String initialPrefix = string2;
        if (StringsKt.contains$default((CharSequence)initialPrefix, (char)File.separatorChar, (boolean)false, (int)2, null)) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv;
            shortenedPrefix = StringsKt.substringAfterLast$default((String)initialPrefix, (char)File.separatorChar, null, (int)2, null);
            Iterable iterable = completionResult2.getMatches();
            object = shortenedPrefix;
            boolean $i$f$map2 = false;
            void var16_19 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv2.iterator();
            while (iterator.hasNext()) {
                void it;
                CompletionItem completionItem = item$iv$iv = iterator.next();
                var27_32 = destination$iv$iv;
                boolean bl = false;
                String lookupString = StringsKt.substringAfterLast$default((String)StringsKt.removeSurrounding((String)StringsKt.removeSurrounding((String)it.getValue(), (CharSequence)"'"), (CharSequence)"\""), (char)File.separatorChar, null, (int)2, null);
                var27_32.add(new CompletionItemInfo(lookupString, it.getPresentableText(), it.getType(), replacementIndex, it.getValue()));
            }
            pair = TuplesKt.to((Object)object, (Object)((List)destination$iv$iv));
        } else {
            void $this$mapTo$iv$iv3;
            void $this$map$iv;
            shortenedPrefix = completionResult2.getMatches();
            object = initialPrefix;
            boolean $i$f$map = false;
            void $i$f$map2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv3) {
                void it;
                item$iv$iv = (CompletionItem)item$iv$iv2;
                var27_32 = destination$iv$iv;
                boolean bl = false;
                var27_32.add(new CompletionItemInfo(it.getValue(), it.getPresentableText(), it.getType(), replacementIndex, it.getValue()));
            }
            pair = TuplesKt.to((Object)object, (Object)((List)destination$iv$iv));
        }
        Pair pair2 = pair;
        String prefix = (String)pair2.component1();
        List completionItems = (List)pair2.component2();
        CompletionResultSet completionResultSet = result2.withPrefixMatcher((PrefixMatcher)new PlainPrefixMatcher(prefix));
        Intrinsics.checkNotNullExpressionValue((Object)completionResultSet, (String)"withPrefixMatcher(...)");
        CompletionResultSet resultSet = completionResultSet;
        Iterable $this$map$iv = completionItems;
        boolean $i$f$map = false;
        item$iv$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            void it;
            CompletionItemInfo completionItemInfo = (CompletionItemInfo)item$iv$iv3;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(this.toLookupElement((CompletionItemInfo)it));
        }
        List elements = (List)destination$iv$iv;
        resultSet.addAllElements((Iterable)elements);
    }

    private final LookupElement toLookupElement(CompletionItemInfo $this$toLookupElement) {
        Object text;
        Object object = $this$toLookupElement.getPresentableText();
        if (object == null) {
            object = text = $this$toLookupElement.getLookupString();
        }
        if ($this$toLookupElement.getType() == CompletionResultType.PROVIDER_CONTAINER && !StringsKt.endsWith$default((CharSequence)((CharSequence)text), (char)File.separatorChar, (boolean)false, (int)2, null)) {
            text = (String)text + File.separatorChar;
        }
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)$this$toLookupElement.getLookupString()).withPresentableText((String)text).withIcon(this.getIconForItem($this$toLookupElement));
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"withIcon(...)");
        return (LookupElement)this.insertFileSeparatorIfNeeded(this.surroundingQuotesAware(this.replacementStringAware(lookupElementBuilder, $this$toLookupElement), $this$toLookupElement), $this$toLookupElement);
    }

    private final Icon getIconForItem(CompletionItemInfo item) {
        Icon icon;
        switch (WhenMappings.$EnumSwitchMapping$0[item.getType().ordinal()]) {
            case 1: 
            case 2: {
                Icon icon2 = TerminalIcons.Command;
                icon = icon2;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Command");
                break;
            }
            case 3: {
                Icon icon3 = TerminalIcons.Option;
                icon = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Option");
                break;
            }
            case 4: {
                Icon icon4 = AllIcons.Nodes.Folder;
                icon = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Folder");
                break;
            }
            case 5: {
                icon = TerminalCompletionUtil.INSTANCE.getFileIcon(item.getLookupString());
                break;
            }
            default: {
                Icon icon5 = TerminalIcons.Other;
                icon = icon5;
                Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"Other");
            }
        }
        return icon;
    }

    private final LookupElementBuilder surroundingQuotesAware(LookupElementBuilder $this$surroundingQuotesAware, CompletionItemInfo itemInfo) {
        Object v0;
        block3: {
            String replacementString = itemInfo.getReplacementString();
            if (replacementString.length() < 2) {
                return $this$surroundingQuotesAware;
            }
            Object[] objectArray = new Character[]{Character.valueOf('\''), Character.valueOf('\"')};
            List delimiters = CollectionsKt.listOf((Object[])objectArray);
            Iterable $this$firstOrNull$iv = delimiters;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                char it = ((Character)element$iv).charValue();
                boolean bl = false;
                if (!(StringsKt.first((CharSequence)replacementString) == it && StringsKt.last((CharSequence)replacementString) == it)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Character c = v0;
        if (c == null) {
            return $this$surroundingQuotesAware;
        }
        char delimiter = c.charValue();
        LookupElementBuilder lookupElementBuilder = $this$surroundingQuotesAware.withInsertHandler((arg_0, arg_1) -> PowerShellCompletionContributor.surroundingQuotesAware$lambda$5($this$surroundingQuotesAware, delimiter, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"withInsertHandler(...)");
        return lookupElementBuilder;
    }

    private final LookupElementBuilder replacementStringAware(LookupElementBuilder $this$replacementStringAware, CompletionItemInfo itemInfo) {
        if (!Intrinsics.areEqual((Object)$this$replacementStringAware.getLookupString(), (Object)itemInfo.getReplacementString())) {
            LookupElementBuilder lookupElementBuilder = $this$replacementStringAware.withInsertHandler((arg_0, arg_1) -> PowerShellCompletionContributor.replacementStringAware$lambda$7($this$replacementStringAware, itemInfo, arg_0, arg_1));
            Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"withInsertHandler(...)");
            return lookupElementBuilder;
        }
        return $this$replacementStringAware;
    }

    private final LookupElementBuilder insertFileSeparatorIfNeeded(LookupElementBuilder $this$insertFileSeparatorIfNeeded, CompletionItemInfo itemInfo) {
        if (itemInfo.getType() == CompletionResultType.PROVIDER_CONTAINER) {
            LookupElementBuilder lookupElementBuilder = $this$insertFileSeparatorIfNeeded.withInsertHandler((arg_0, arg_1) -> PowerShellCompletionContributor.insertFileSeparatorIfNeeded$lambda$9($this$insertFileSeparatorIfNeeded, arg_0, arg_1));
            Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"withInsertHandler(...)");
            return lookupElementBuilder;
        }
        return $this$insertFileSeparatorIfNeeded;
    }

    private static final void surroundingQuotesAware$lambda$5$lambda$4(Document $document, int $endOffset) {
        Intrinsics.checkNotNullParameter((Object)$document, (String)"$document");
        $document.deleteString($endOffset, $endOffset + 1);
    }

    private static final void surroundingQuotesAware$lambda$5(LookupElementBuilder $this_surroundingQuotesAware, char $delimiter, InsertionContext context, LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)$this_surroundingQuotesAware, (String)"$this_surroundingQuotesAware");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        InsertHandler insertHandler = $this_surroundingQuotesAware.getInsertHandler();
        if (insertHandler != null) {
            insertHandler.handleInsert(context, item);
        }
        Document document = context.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int endOffset = context.getTailOffset();
        context.getEditor().getCaretModel().moveToOffset(endOffset - 1);
        if (endOffset < document2.getTextLength() && Intrinsics.areEqual((Object)document2.getText(TextRange.create((int)endOffset, (int)(endOffset + 1))), (Object)String.valueOf($delimiter))) {
            DocumentUtil.writeInRunUndoTransparentAction(() -> PowerShellCompletionContributor.surroundingQuotesAware$lambda$5$lambda$4(document2, endOffset));
        }
    }

    private static final void replacementStringAware$lambda$7$lambda$6(InsertionContext $context, CompletionItemInfo $itemInfo) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$itemInfo, (String)"$itemInfo");
        int endIndex = $context.getEditor().getCaretModel().getOffset();
        $context.getDocument().replaceString($itemInfo.getReplacementIndex(), endIndex, (CharSequence)$itemInfo.getReplacementString());
    }

    private static final void replacementStringAware$lambda$7(LookupElementBuilder $this_replacementStringAware, CompletionItemInfo $itemInfo, InsertionContext context, LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)$this_replacementStringAware, (String)"$this_replacementStringAware");
        Intrinsics.checkNotNullParameter((Object)$itemInfo, (String)"$itemInfo");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        InsertHandler insertHandler = $this_replacementStringAware.getInsertHandler();
        if (insertHandler != null) {
            insertHandler.handleInsert(context, item);
        }
        DocumentUtil.writeInRunUndoTransparentAction(() -> PowerShellCompletionContributor.replacementStringAware$lambda$7$lambda$6(context, $itemInfo));
    }

    private static final void insertFileSeparatorIfNeeded$lambda$9$lambda$8(InsertionContext $context) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        int offset = $context.getEditor().getCaretModel().getOffset();
        $context.getDocument().insertString(offset, (CharSequence)File.separator);
        $context.getEditor().getCaretModel().moveToOffset(offset + 1);
    }

    private static final void insertFileSeparatorIfNeeded$lambda$9(LookupElementBuilder $this_insertFileSeparatorIfNeeded, InsertionContext context, LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)$this_insertFileSeparatorIfNeeded, (String)"$this_insertFileSeparatorIfNeeded");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        InsertHandler insertHandler = $this_insertFileSeparatorIfNeeded.getInsertHandler();
        if (insertHandler != null) {
            insertHandler.handleInsert(context, item);
        }
        DocumentUtil.writeInRunUndoTransparentAction(() -> PowerShellCompletionContributor.insertFileSeparatorIfNeeded$lambda$9$lambda$8(context));
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PowerShellCompletionContributor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/terminal/exp/completion/powershell/PowerShellCompletionContributor$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J=\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\bH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/plugins/terminal/exp/completion/powershell/PowerShellCompletionContributor$CompletionItemInfo;", "", "lookupString", "", "presentableText", "type", "Lorg/jetbrains/plugins/terminal/exp/completion/powershell/CompletionResultType;", "replacementIndex", "", "replacementString", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/plugins/terminal/exp/completion/powershell/CompletionResultType;ILjava/lang/String;)V", "getLookupString", "()Ljava/lang/String;", "getPresentableText", "getReplacementIndex", "()I", "getReplacementString", "getType", "()Lorg/jetbrains/plugins/terminal/exp/completion/powershell/CompletionResultType;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "toString", "intellij.terminal"})
    private static final class CompletionItemInfo {
        @NotNull
        private final String lookupString;
        @Nullable
        private final String presentableText;
        @NotNull
        private final CompletionResultType type;
        private final int replacementIndex;
        @NotNull
        private final String replacementString;

        public CompletionItemInfo(@NotNull String lookupString, @Nullable String presentableText, @NotNull CompletionResultType type, int replacementIndex, @NotNull String replacementString) {
            Intrinsics.checkNotNullParameter((Object)lookupString, (String)"lookupString");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)replacementString, (String)"replacementString");
            this.lookupString = lookupString;
            this.presentableText = presentableText;
            this.type = type;
            this.replacementIndex = replacementIndex;
            this.replacementString = replacementString;
        }

        @NotNull
        public final String getLookupString() {
            return this.lookupString;
        }

        @Nullable
        public final String getPresentableText() {
            return this.presentableText;
        }

        @NotNull
        public final CompletionResultType getType() {
            return this.type;
        }

        public final int getReplacementIndex() {
            return this.replacementIndex;
        }

        @NotNull
        public final String getReplacementString() {
            return this.replacementString;
        }

        @NotNull
        public final String component1() {
            return this.lookupString;
        }

        @Nullable
        public final String component2() {
            return this.presentableText;
        }

        @NotNull
        public final CompletionResultType component3() {
            return this.type;
        }

        public final int component4() {
            return this.replacementIndex;
        }

        @NotNull
        public final String component5() {
            return this.replacementString;
        }

        @NotNull
        public final CompletionItemInfo copy(@NotNull String lookupString, @Nullable String presentableText, @NotNull CompletionResultType type, int replacementIndex, @NotNull String replacementString) {
            Intrinsics.checkNotNullParameter((Object)lookupString, (String)"lookupString");
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)replacementString, (String)"replacementString");
            return new CompletionItemInfo(lookupString, presentableText, type, replacementIndex, replacementString);
        }

        public static /* synthetic */ CompletionItemInfo copy$default(CompletionItemInfo completionItemInfo, String string, String string2, CompletionResultType completionResultType, int n, String string3, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = completionItemInfo.lookupString;
            }
            if ((n2 & 2) != 0) {
                string2 = completionItemInfo.presentableText;
            }
            if ((n2 & 4) != 0) {
                completionResultType = completionItemInfo.type;
            }
            if ((n2 & 8) != 0) {
                n = completionItemInfo.replacementIndex;
            }
            if ((n2 & 0x10) != 0) {
                string3 = completionItemInfo.replacementString;
            }
            return completionItemInfo.copy(string, string2, completionResultType, n, string3);
        }

        @NotNull
        public String toString() {
            return "CompletionItemInfo(lookupString=" + this.lookupString + ", presentableText=" + this.presentableText + ", type=" + this.type + ", replacementIndex=" + this.replacementIndex + ", replacementString=" + this.replacementString + ")";
        }

        public int hashCode() {
            int result2 = this.lookupString.hashCode();
            result2 = result2 * 31 + (this.presentableText == null ? 0 : this.presentableText.hashCode());
            result2 = result2 * 31 + this.type.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.replacementIndex);
            result2 = result2 * 31 + this.replacementString.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CompletionItemInfo)) {
                return false;
            }
            CompletionItemInfo completionItemInfo = (CompletionItemInfo)other;
            if (!Intrinsics.areEqual((Object)this.lookupString, (Object)completionItemInfo.lookupString)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.presentableText, (Object)completionItemInfo.presentableText)) {
                return false;
            }
            if (this.type != completionItemInfo.type) {
                return false;
            }
            if (this.replacementIndex != completionItemInfo.replacementIndex) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.replacementString, (Object)completionItemInfo.replacementString);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CompletionResultType.values().length];
            try {
                nArray[CompletionResultType.COMMAND.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompletionResultType.METHOD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompletionResultType.PARAMETER_NAME.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompletionResultType.PROVIDER_CONTAINER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompletionResultType.PROVIDER_ITEM.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

