/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.sh.powershell;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.exp.completion.TerminalShellSupport;
import org.jetbrains.plugins.terminal.sh.BaseShSupportKt;
import org.jetbrains.plugins.terminal.sh.powershell.PowerShellSupport$AliasDefinition$;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0006\u0018\u0000 \u00172\u00020\u0001:\u0002\u0016\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u001c\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u00122\u0006\u0010\u0013\u001a\u00020\rH\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0015\u001a\u00020\rH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/terminal/sh/powershell/PowerShellSupport;", "Lorg/jetbrains/plugins/terminal/exp/completion/TerminalShellSupport;", "()V", "lineContinuationChar", "", "getLineContinuationChar", "()C", "promptLanguage", "Lcom/intellij/lang/Language;", "getPromptLanguage", "()Lcom/intellij/lang/Language;", "getCommandTokens", "", "", "project", "Lcom/intellij/openapi/project/Project;", "command", "parseAliases", "", "aliasesDefinition", "parseCommandHistory", "history", "AliasDefinition", "Companion", "intellij.terminal.sh"})
@SourceDebugExtension(value={"SMAP\nPowerShellSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PowerShellSupport.kt\norg/jetbrains/plugins/terminal/sh/powershell/PowerShellSupport\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,73:1\n96#2:74\n1179#3,2:75\n1253#3,4:77\n11#4:81\n*S KotlinDebug\n*F\n+ 1 PowerShellSupport.kt\norg/jetbrains/plugins/terminal/sh/powershell/PowerShellSupport\n*L\n58#1:74\n64#1:75,2\n64#1:77,4\n71#1:81\n*E\n"})
public final class PowerShellSupport
implements TerminalShellSupport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final char lineContinuationChar = (char)96;
    @NotNull
    private static final Logger LOG;

    @Override
    @NotNull
    public Language getPromptLanguage() {
        PlainTextLanguage plainTextLanguage = PlainTextLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)plainTextLanguage, (String)"INSTANCE");
        return (Language)plainTextLanguage;
    }

    @Override
    public char getLineContinuationChar() {
        return this.lineContinuationChar;
    }

    @Override
    @Nullable
    public List<String> getCommandTokens(@NotNull Project project, @NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        return BaseShSupportKt.getShellCommandTokens(project, command);
    }

    @Override
    @NotNull
    public List<String> parseCommandHistory(@NotNull String history) {
        Intrinsics.checkNotNullParameter((Object)history, (String)"history");
        String string = StringUtil.convertLineSeparators((String)history, (String)"\n");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertLineSeparators(...)");
        String trimmedHistory = ((Object)StringsKt.trimEnd((CharSequence)string)).toString();
        if (StringsKt.isBlank((CharSequence)trimmedHistory)) {
            return CollectionsKt.emptyList();
        }
        String[] stringArray = new String[]{"\n"};
        List lines = StringsKt.split$default((CharSequence)trimmedHistory, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        List historyItems = new ArrayList();
        for (int ind = 0; ind < lines.size(); ++ind) {
            String line = (String)lines.get(ind);
            if (StringsKt.endsWith$default((String)line, (String)"`", (boolean)false, (int)2, null)) {
                StringBuilder builder = new StringBuilder(StringsKt.removeSuffix((String)line, (CharSequence)"`")).append("\n");
                ++ind;
                while (ind < lines.size() && StringsKt.endsWith$default((String)((String)lines.get(ind)), (String)"`", (boolean)false, (int)2, null)) {
                    builder.append(StringsKt.removeSuffix((String)((String)lines.get(ind)), (CharSequence)"`")).append("\n");
                    ++ind;
                }
                if (ind < lines.size()) {
                    builder.append((String)lines.get(ind));
                }
                String string2 = builder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                historyItems.add(string2);
                continue;
            }
            historyItems.add(line);
        }
        return historyItems;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<String, String> parseAliases(@NotNull String aliasesDefinition) {
        void $this$associateTo$iv$iv;
        Object this_$iv;
        Intrinsics.checkNotNullParameter((Object)aliasesDefinition, (String)"aliasesDefinition");
        try {
            this_$iv = (Json)Json.Default;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            this_$iv = (List)this_$iv.decodeFromString((DeserializationStrategy)new ArrayListSerializer(AliasDefinition.Companion.serializer()), aliasesDefinition);
        }
        catch (Throwable t) {
            LOG.error("Failed to parse aliases: '" + aliasesDefinition + "'", t);
            this_$iv = CollectionsKt.emptyList();
        }
        Object aliases2 = this_$iv;
        Iterable $this$associate$iv = (Iterable)aliases2;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            AliasDefinition it = (AliasDefinition)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getName(), (Object)it.getDefinition());
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PowerShellSupport.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Serializable
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0083\b\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001e\u001fB-\b\u0011\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tB\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001J&\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u00c1\u0001\u00a2\u0006\u0002\b\u001dR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006 "}, d2={"Lorg/jetbrains/plugins/terminal/sh/powershell/PowerShellSupport$AliasDefinition;", "", "seen1", "", "name", "", "definition", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "(Ljava/lang/String;Ljava/lang/String;)V", "getDefinition", "()Ljava/lang/String;", "getName", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_terminal_sh", "$serializer", "Companion", "intellij.terminal.sh"})
    private static final class AliasDefinition {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String name;
        @NotNull
        private final String definition;

        public AliasDefinition(@NotNull String name, @NotNull String definition) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
            this.name = name;
            this.definition = definition;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getDefinition() {
            return this.definition;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.definition;
        }

        @NotNull
        public final AliasDefinition copy(@NotNull String name, @NotNull String definition) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
            return new AliasDefinition(name, definition);
        }

        public static /* synthetic */ AliasDefinition copy$default(AliasDefinition aliasDefinition, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = aliasDefinition.name;
            }
            if ((n & 2) != 0) {
                string2 = aliasDefinition.definition;
            }
            return aliasDefinition.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "AliasDefinition(name=" + this.name + ", definition=" + this.definition + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + this.definition.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AliasDefinition)) {
                return false;
            }
            AliasDefinition aliasDefinition = (AliasDefinition)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)aliasDefinition.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.definition, (Object)aliasDefinition.definition);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_terminal_sh(AliasDefinition self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeStringElement(serialDesc, 0, self.name);
            output.encodeStringElement(serialDesc, 1, self.definition);
        }

        @Deprecated(message="This synthesized declaration should not be used directly", replaceWith=@ReplaceWith(expression="", imports={}), level=DeprecationLevel.HIDDEN)
        public /* synthetic */ AliasDefinition(int seen1, String name, String definition, SerializationConstructorMarker serializationConstructorMarker) {
            if (3 != (3 & seen1)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen1, (int)3, (SerialDescriptor)AliasDefinition$$serializer.INSTANCE.getDescriptor());
            }
            this.name = name;
            this.definition = definition;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/terminal/sh/powershell/PowerShellSupport$AliasDefinition$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lorg/jetbrains/plugins/terminal/sh/powershell/PowerShellSupport$AliasDefinition;", "intellij.terminal.sh"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<AliasDefinition> serializer() {
                return (KSerializer)AliasDefinition$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/terminal/sh/powershell/PowerShellSupport$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.terminal.sh"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

