/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.util.estimators;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003J\u0006\u0010\u0014\u001a\u00020\u0012J\u0006\u0010\u0015\u001a\u00020\u0003J\u0018\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J\u0018\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0003H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rd/platform/util/estimators/P2QuantileEstimator;", "", "p", "", "(D)V", "count", "", "isEmpty", "", "()Z", "n", "", "ns", "", "getP", "()D", "q", "addValue", "", "x", "clear", "getQuantile", "linear", "i", "d", "parabolic", "intellij.rd.platform"})
public final class P2QuantileEstimator {
    private final double p;
    @NotNull
    private final int[] n;
    @NotNull
    private final double[] ns;
    @NotNull
    private final double[] q;
    private int count;

    public P2QuantileEstimator(double p) {
        this.p = p;
        this.n = new int[5];
        this.ns = new double[5];
        this.q = new double[5];
    }

    public final double getP() {
        return this.p;
    }

    public final void addValue(double x) {
        if (this.count < 5) {
            int n = this.count;
            this.count = n + 1;
            this.q[n] = x;
            if (this.count == 5) {
                ArraysKt.sort((double[])this.q);
                for (int i2 = 0; i2 < 5; ++i2) {
                    this.n[i2] = i2;
                    this.ns[0] = 0.0;
                    this.ns[1] = (double)2 * this.p;
                    this.ns[2] = (double)4 * this.p;
                    this.ns[3] = (double)2 + (double)2 * this.p;
                    this.ns[4] = 4.0;
                }
            }
            return;
        }
        int k = 0;
        if (x < this.q[0]) {
            this.q[0] = x;
            k = 0;
        } else if (x < this.q[1]) {
            k = 0;
        } else if (x < this.q[2]) {
            k = 1;
        } else if (x < this.q[3]) {
            k = 2;
        } else if (x < this.q[4]) {
            k = 3;
        } else {
            this.q[4] = x;
            k = 3;
        }
        int i3 = k + 1;
        while (i3 < 5) {
            int[] nArray = this.n;
            int n = i3++;
            int n2 = nArray[n];
            nArray[n] = n2 + 1;
        }
        this.ns[1] = (double)this.count * this.p / (double)2;
        this.ns[2] = (double)this.count * this.p;
        this.ns[3] = (double)this.count * (1.0 + this.p) / (double)2;
        this.ns[4] = this.count;
        for (i3 = 1; i3 < 4; ++i3) {
            double d = this.ns[i3] - (double)this.n[i3];
            if (!(d >= 1.0 && this.n[i3 + 1] - this.n[i3] > 1) && (!(d <= -1.0) || this.n[i3 - 1] - this.n[i3] >= -1)) continue;
            int dInt = (int)Math.signum(d);
            double qs = this.parabolic(i3, dInt);
            this.q[i3] = this.q[i3 - 1] < qs && qs < this.q[i3 + 1] ? qs : this.linear(i3, dInt);
            int[] nArray = this.n;
            int n = i3;
            nArray[n] = nArray[n] + dInt;
        }
        int n = this.count;
        this.count = n + 1;
    }

    private final double parabolic(int i2, double d) {
        return this.q[i2] + d / (double)(this.n[i2 + 1] - this.n[i2 - 1]) * (((double)(this.n[i2] - this.n[i2 - 1]) + d) * (this.q[i2 + 1] - this.q[i2]) / (double)(this.n[i2 + 1] - this.n[i2]) + ((double)(this.n[i2 + 1] - this.n[i2]) - d) * (this.q[i2] - this.q[i2 - 1]) / (double)(this.n[i2] - this.n[i2 - 1]));
    }

    private final double linear(int i2, int d) {
        return this.q[i2] + (double)d * (this.q[i2 + d] - this.q[i2]) / (double)(this.n[i2 + d] - this.n[i2]);
    }

    public final double getQuantile() {
        if (this.count == 0) {
            throw new IllegalStateException("Sequence contains no elements");
        }
        if (this.count <= 5) {
            ArraysKt.sort((double[])this.q, (int)0, (int)this.count);
            int index = MathKt.roundToInt((double)((double)(this.count - 1) * this.p));
            return this.q[index];
        }
        return this.q[2];
    }

    public final void clear() {
        this.count = 0;
    }

    public final boolean isEmpty() {
        return this.count == 0;
    }
}

