/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.settings;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.core.module.status.StatusManager;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.core.settings.IvyVariableContainer;
import org.apache.ivy.plugins.circular.CircularDependencyStrategy;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.latest.LatestStrategy;
import org.apache.ivy.plugins.lock.LockStrategy;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.Configurator;
import org.apache.ivy.util.FileResolver;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.CredentialsStore;
import org.apache.ivy.util.url.URLHandlerRegistry;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlSettingsParser
extends DefaultHandler {
    private Configurator configurator;
    private List configuratorTags = Arrays.asList("resolvers", "namespaces", "parsers", "latest-strategies", "conflict-managers", "outputters", "version-matchers", "statuses", "circular-dependency-strategies", "triggers", "lock-strategies", "caches", "signers");
    private IvySettings ivy;
    private String defaultResolver;
    private String defaultCM;
    private String defaultLatest;
    private String defaultCacheManager;
    private String defaultCircular;
    private String defaultLock;
    private String currentConfiguratorTag;
    private URL settings;
    private boolean deprecatedMessagePrinted = false;

    public XmlSettingsParser(IvySettings ivySettings) {
        this.ivy = ivySettings;
    }

    public void parse(URL uRL) throws ParseException, IOException {
        this.configurator = new Configurator();
        this.configurator.setFileResolver(new FileResolver(){

            @Override
            public File resolveFile(String string, String string2) {
                return Checks.checkAbsolute(string, string2);
            }
        });
        Map map = this.ivy.getTypeDefs();
        for (String string : map.keySet()) {
            this.configurator.typeDef(string, (Class)map.get(string));
        }
        this.doParse(uRL);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doParse(URL serializable) throws IOException, ParseException {
        this.settings = serializable;
        InputStream inputStream = null;
        try {
            inputStream = URLHandlerRegistry.getDefault().openStream((URL)serializable);
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setSystemId(((URL)serializable).toExternalForm());
            SAXParserFactory.newInstance().newSAXParser().parse(((URL)serializable).toExternalForm(), (DefaultHandler)this);
            this.ivy.validate();
            if (inputStream == null) return;
        }
        catch (IOException iOException) {
            try {
                IOException iOException2 = iOException;
                throw iOException;
                catch (Exception exception) {
                    serializable = new ParseException("failed to load settings from " + serializable + ": " + exception.getMessage(), 0);
                    ((Throwable)serializable).initCause(exception);
                    throw serializable;
                }
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException3) {}
                throw throwable;
            }
        }
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private void parse(Configurator configurator, URL uRL) throws IOException, ParseException {
        this.configurator = configurator;
        this.doParse(uRL);
    }

    @Override
    public void startElement(String object, String string, String string2, Attributes attributes) throws SAXException {
        block19: {
            object = new HashMap();
            for (int i = 0; i < attributes.getLength(); ++i) {
                object.put(attributes.getQName(i), this.ivy.substitute(attributes.getValue(i)));
            }
            try {
                if ("ivyconf".equals(string2)) {
                    this.deprecatedMessagePrinted = true;
                    Message.deprecated("'ivyconf' element is deprecated, use 'ivysettings' instead (" + this.settings + ")");
                }
                if (this.configurator.getCurrent() != null) {
                    this.inConfiguratorStarted(string2, (Map)object);
                    break block19;
                }
                if ("classpath".equals(string2)) {
                    this.classpathStarted((Map)object);
                    break block19;
                }
                if ("typedef".equals(string2)) {
                    this.typedefStarted((Map)object);
                    break block19;
                }
                if ("property".equals(string2)) {
                    this.propertyStarted((Map)object);
                    break block19;
                }
                if ("properties".equals(string2)) {
                    this.propertiesStarted((Map)object);
                    break block19;
                }
                if ("include".equals(string2)) {
                    this.includeStarted((Map)object);
                    break block19;
                }
                if ("settings".equals(string2) || "conf".equals(string2)) {
                    this.settingsStarted(string2, (Map)object);
                    break block19;
                }
                if ("caches".equals(string2)) {
                    this.cachesStarted(string2, (Map)object);
                    break block19;
                }
                if ("version-matchers".equals(string2)) {
                    this.versionMatchersStarted(string2, (Map)object);
                    break block19;
                }
                if ("statuses".equals(string2)) {
                    this.statusesStarted(string2, (Map)object);
                    break block19;
                }
                if (this.configuratorTags.contains(string2)) {
                    this.anyConfiguratorStarted(string2);
                    break block19;
                }
                if ("macrodef".equals(string2)) {
                    this.macrodefStarted(string2, (Map)object);
                    break block19;
                }
                if ("module".equals(string2)) {
                    this.moduleStarted((Map)object);
                    break block19;
                }
                if ("credentials".equals(string2)) {
                    this.credentialsStarted((Map)object);
                }
                return;
            }
            catch (ParseException parseException) {
                object = new SAXException("problem in config file: " + parseException.getMessage(), parseException);
                ((Throwable)object).initCause(parseException);
                throw object;
            }
            catch (IOException iOException) {
                object = new SAXException("io problem while parsing config file: " + iOException.getMessage(), iOException);
                ((Throwable)object).initCause(iOException);
                throw object;
            }
        }
    }

    private void credentialsStarted(Map object) {
        String string = (String)object.remove("realm");
        String string2 = (String)object.remove("host");
        String string3 = (String)object.remove("username");
        object = (String)object.remove("passwd");
        CredentialsStore.INSTANCE.addCredentials(string, string2, string3, (String)object);
    }

    private void moduleStarted(Map map) {
        map.put("module", map.remove("name"));
        String string = (String)map.remove("resolver");
        String string2 = (String)map.remove("branch");
        String string3 = (String)map.remove("conflict-manager");
        String string4 = (String)map.remove("resolveMode");
        String string5 = (String)map.remove("matcher");
        string5 = string5 == null ? "exactOrRegexp" : string5;
        this.ivy.addModuleConfiguration(map, this.ivy.getMatcher(string5), string, string2, string3, string4);
    }

    private void macrodefStarted(String object, Map map) {
        this.currentConfiguratorTag = object;
        object = this.configurator.startMacroDef((String)map.get("name"));
        ((Configurator.MacroDef)object).addAttribute("name", null);
    }

    private void anyConfiguratorStarted(String string) {
        this.currentConfiguratorTag = string;
        this.configurator.setRoot(this.ivy);
    }

    private void statusesStarted(String object, Map object2) {
        this.currentConfiguratorTag = object;
        object = new StatusManager();
        if ((object2 = (String)object2.get("default")) != null) {
            ((StatusManager)object).setDefaultStatus((String)object2);
        }
        this.ivy.setStatusManager((StatusManager)object);
        this.configurator.setRoot(object);
    }

    private void versionMatchersStarted(String string, Map map) {
        this.anyConfiguratorStarted(string);
        if ("true".equals((String)map.get("usedefaults"))) {
            this.ivy.configureDefaultVersionMatcher();
        }
    }

    private void cachesStarted(String string, Map map) {
        this.anyConfiguratorStarted(string);
        this.defaultLock = (String)map.get("lockStrategy");
        this.defaultCacheManager = (String)map.get("default");
        string = (String)map.get("defaultCacheDir");
        if (string != null) {
            this.ivy.setDefaultCache(Checks.checkAbsolute(string, "defaultCacheDir"));
        }
        if ((string = (String)map.get("checkUpToDate")) != null) {
            Message.deprecated("'checkUpToDate' is deprecated, use the 'overwriteMode' on the 'ivy:retrieve' task instead (" + this.settings + ")");
            this.ivy.setCheckUpToDate(Boolean.valueOf(string));
        }
        if ((string = (String)map.get("resolutionCacheDir")) != null) {
            this.ivy.setDefaultResolutionCacheBasedir(string);
        }
        if ((string = (String)map.get("useOrigin")) != null) {
            this.ivy.setDefaultUseOrigin(Boolean.valueOf(string));
        }
        if ((string = (String)map.get("ivyPattern")) != null) {
            this.ivy.setDefaultCacheIvyPattern(string);
        }
        if ((string = (String)map.get("artifactPattern")) != null) {
            this.ivy.setDefaultCacheArtifactPattern(string);
        }
        if ((string = (String)map.get("repositoryCacheDir")) != null) {
            this.ivy.setDefaultRepositoryCacheBasedir(string);
        }
    }

    private void settingsStarted(String string, Map map) {
        if ("conf".equals(string) && !this.deprecatedMessagePrinted) {
            Message.deprecated("'conf' is deprecated, use 'settings' instead (" + this.settings + ")");
        }
        if ((string = (String)map.get("defaultCache")) != null) {
            Message.deprecated("'defaultCache' is deprecated, use 'caches[@defaultCacheDir]' instead (" + this.settings + ")");
            this.ivy.setDefaultCache(Checks.checkAbsolute(string, "defaultCache"));
        }
        if ((string = (String)map.get("defaultBranch")) != null) {
            this.ivy.setDefaultBranch(string);
        }
        if ((string = (String)map.get("defaultResolveMode")) != null) {
            this.ivy.setDefaultResolveMode(string);
        }
        if ((string = (String)map.get("validate")) != null) {
            this.ivy.setValidate(Boolean.valueOf(string));
        }
        if ((string = (String)map.get("checkUpToDate")) != null) {
            Message.deprecated("'checkUpToDate' is deprecated, use the 'overwriteMode' on the 'ivy:retrieve' task instead (" + this.settings + ")");
            this.ivy.setCheckUpToDate(Boolean.valueOf(string));
        }
        if ((string = (String)map.get("useRemoteConfig")) != null) {
            this.ivy.setUseRemoteConfig(Boolean.valueOf(string));
        }
        if ((string = (String)map.get("cacheIvyPattern")) != null) {
            Message.deprecated("'cacheIvyPattern' is deprecated, use 'caches[@ivyPattern]' instead (" + this.settings + ")");
            this.ivy.setDefaultCacheIvyPattern(string);
        }
        if ((string = (String)map.get("cacheArtifactPattern")) != null) {
            Message.deprecated("'cacheArtifactPattern' is deprecated, use 'caches[@artifactPattern]' instead (" + this.settings + ")");
            this.ivy.setDefaultCacheArtifactPattern(string);
        }
        this.defaultResolver = (String)map.get("defaultResolver");
        this.defaultCM = (String)map.get("defaultConflictManager");
        this.defaultLatest = (String)map.get("defaultLatestStrategy");
        this.defaultCircular = (String)map.get("circularDependencyStrategy");
        string = (String)map.get("httpRequestMethod");
        if ("head".equalsIgnoreCase(string)) {
            URLHandlerRegistry.getDefault().setRequestMethod(2);
            return;
        }
        if ("get".equalsIgnoreCase(string)) {
            URLHandlerRegistry.getDefault().setRequestMethod(1);
            return;
        }
        if (string != null && string.trim().length() > 0) {
            throw new IllegalArgumentException("Invalid httpRequestMethod specified, must be one of {'HEAD', 'GET'}");
        }
    }

    private void includeStarted(Map object) throws IOException, ParseException {
        IvyVariableContainer ivyVariableContainer = this.ivy.getVariableContainer();
        this.ivy.setVariableContainer(new IvyVariableContainerWrapper(ivyVariableContainer));
        try {
            Object object2 = (String)object.get("file");
            if (object2 == null) {
                object2 = (String)object.get("url");
                if (object2 == null) {
                    throw new IllegalArgumentException("bad include tag: specify file or url to include");
                }
                try {
                    object = new URL((String)object2);
                }
                catch (MalformedURLException malformedURLException) {
                    object = new URL(this.settings, (String)object2);
                }
                Message.verbose("including url: " + ((URL)object).toString());
                this.ivy.setSettingsVariables((URL)object);
            } else {
                object = this.urlFromFileAttribute((String)object2);
                Message.verbose("including file: " + object);
                if ("file".equals(((URL)object).getProtocol())) {
                    try {
                        object2 = new File(new URI(((URL)object).toExternalForm()));
                        this.ivy.setSettingsVariables(Checks.checkAbsolute((File)object2, "settings include path"));
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        this.ivy.setSettingsVariables(Checks.checkAbsolute(((URL)object).getPath(), "settings include path"));
                    }
                } else {
                    this.ivy.setSettingsVariables((URL)object);
                }
            }
            new XmlSettingsParser(this.ivy).parse(this.configurator, (URL)object);
            return;
        }
        finally {
            this.ivy.setVariableContainer(ivyVariableContainer);
        }
    }

    private URL urlFromFileAttribute(String string) throws IOException {
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string);
            if (file.isAbsolute()) {
                if (!file.exists()) {
                    throw new FileNotFoundException(file.getAbsolutePath());
                }
                return file.toURI().toURL();
            }
            if ("file".equals(this.settings.getProtocol())) {
                try {
                    file = new File(new URI(this.settings.toExternalForm()));
                    if (!file.exists()) {
                        throw new FileNotFoundException(file.getAbsolutePath());
                    }
                    return new File(file.getParentFile(), string).toURI().toURL();
                }
                catch (URISyntaxException uRISyntaxException) {
                    return new URL(this.settings, string);
                }
            }
            return new URL(this.settings, string);
        }
    }

    private void propertiesStarted(Map object) throws IOException {
        String string = (String)object.get("file");
        Object object2 = (String)object.get("environment");
        if (string != null) {
            boolean bl = (object = (String)object.get("override")) == null ? true : Boolean.valueOf((String)object);
            Message.verbose("loading properties: " + string);
            try {
                object2 = this.urlFromFileAttribute(string);
                this.ivy.loadProperties((URL)object2, bl);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Message.verbose("Unable to find property file: " + string);
                return;
            }
        } else {
            if (object2 != null) {
                this.ivy.getVariableContainer().setEnvironmentPrefix((String)object2);
                return;
            }
            throw new IllegalArgumentException("Didn't find a 'file' or 'environment' attribute on the 'properties' element");
        }
    }

    private void propertyStarted(Map object) {
        String string = (String)object.get("name");
        String string2 = (String)object.get("value");
        object = (String)object.get("override");
        if (string == null) {
            throw new IllegalArgumentException("missing attribute name on property tag");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("missing attribute value on property tag");
        }
        this.ivy.setVariable(string, string2, object == null ? true : Boolean.valueOf((String)object));
    }

    private void typedefStarted(Map object) {
        String string = (String)object.get("name");
        object = (String)object.get("classname");
        object = this.ivy.typeDef(string, (String)object);
        this.configurator.typeDef(string, (Class)object);
    }

    private void classpathStarted(Map object) throws IOException {
        String string = (String)object.get("url");
        if (string == null) {
            if ((object = (String)object.get("file")) == null) {
                throw new IllegalArgumentException("either url or file should be given for classpath element");
            }
            object = this.urlFromFileAttribute((String)object);
        } else {
            object = new URL(string);
        }
        this.ivy.addClasspathURL((URL)object);
    }

    private void inConfiguratorStarted(String string, Map map) {
        Object object;
        if ("macrodef".equals(this.currentConfiguratorTag) && this.configurator.getTypeDef(string) != null) {
            object = (String)map.get("name");
            if (object == null) {
                map.put("name", "@{name}");
            } else if (((String)object).indexOf("@{name}") != -1) {
                map.put("name", object);
            } else {
                map.put("name", "@{name}-" + (String)object);
            }
        }
        if (map.get("ref") != null) {
            if (map.size() != 1) {
                throw new IllegalArgumentException("ref attribute should be the only one ! found " + map.size() + " in " + string);
            }
            object = (String)map.get("ref");
            Object object2 = null;
            if ("resolvers".equals(this.currentConfiguratorTag) || "resolver".equals(string)) {
                object2 = this.ivy.getResolver((String)object);
                if (object2 == null) {
                    throw new IllegalArgumentException("unknown resolver " + (String)object + ": resolver should be defined before being referenced");
                }
            } else if ("latest-strategies".equals(this.currentConfiguratorTag)) {
                object2 = this.ivy.getLatestStrategy((String)object);
                if (object2 == null) {
                    throw new IllegalArgumentException("unknown latest strategy " + (String)object + ": latest strategy should be defined before being referenced");
                }
            } else if ("conflict-managers".equals(this.currentConfiguratorTag) && (object2 = this.ivy.getConflictManager((String)object)) == null) {
                throw new IllegalArgumentException("unknown conflict manager " + (String)object + ": conflict manager should be defined before being referenced");
            }
            if (object2 == null) {
                throw new IllegalArgumentException("bad reference " + (String)object);
            }
            this.configurator.addChild(string, object2);
            return;
        }
        this.configurator.startCreateChild(string);
        for (String string2 : map.keySet()) {
            this.configurator.setAttribute(string2, (String)map.get(string2));
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.configurator.getCurrent() != null) {
            if (this.configuratorTags.contains(string3) && this.configurator.getDepth() == 1) {
                this.configurator.clear();
                this.currentConfiguratorTag = null;
                return;
            }
            if ("macrodef".equals(string3) && this.configurator.getDepth() == 1) {
                this.configurator.endMacroDef();
                this.currentConfiguratorTag = null;
                return;
            }
            this.configurator.endCreateChild();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        Object object;
        if (this.defaultResolver != null) {
            this.ivy.setDefaultResolver(this.ivy.substitute(this.defaultResolver));
        }
        if (this.defaultCM != null) {
            object = this.ivy.getConflictManager(this.ivy.substitute(this.defaultCM));
            if (object == null) {
                throw new IllegalArgumentException("unknown conflict manager " + this.ivy.substitute(this.defaultCM));
            }
            this.ivy.setDefaultConflictManager((ConflictManager)object);
        }
        if (this.defaultLatest != null) {
            object = this.ivy.getLatestStrategy(this.ivy.substitute(this.defaultLatest));
            if (object == null) {
                throw new IllegalArgumentException("unknown latest strategy " + this.ivy.substitute(this.defaultLatest));
            }
            this.ivy.setDefaultLatestStrategy((LatestStrategy)object);
        }
        if (this.defaultCacheManager != null) {
            object = this.ivy.getRepositoryCacheManager(this.ivy.substitute(this.defaultCacheManager));
            if (object == null) {
                throw new IllegalArgumentException("unknown cache manager " + this.ivy.substitute(this.defaultCacheManager));
            }
            this.ivy.setDefaultRepositoryCacheManager((RepositoryCacheManager)object);
        }
        if (this.defaultCircular != null) {
            object = this.ivy.getCircularDependencyStrategy(this.ivy.substitute(this.defaultCircular));
            if (object == null) {
                throw new IllegalArgumentException("unknown circular dependency strategy " + this.ivy.substitute(this.defaultCircular));
            }
            this.ivy.setCircularDependencyStrategy((CircularDependencyStrategy)object);
        }
        if (this.defaultLock != null) {
            object = this.ivy.getLockStrategy(this.ivy.substitute(this.defaultLock));
            if (object == null) {
                throw new IllegalArgumentException("unknown lock strategy " + this.ivy.substitute(this.defaultLock));
            }
            this.ivy.setDefaultLockStrategy((LockStrategy)object);
        }
    }

    private static final class IvyVariableContainerWrapper
    implements IvyVariableContainer {
        private static final Collection SETTINGS_VARIABLES = Arrays.asList("ivy.settings.dir", "ivy.settings.url", "ivy.settings.file", "ivy.conf.dir", "ivy.conf.url", "ivy.conf.file");
        private final IvyVariableContainer variables;
        private Map localVariables = new HashMap();

        private IvyVariableContainerWrapper(IvyVariableContainer ivyVariableContainer) {
            this.variables = ivyVariableContainer;
        }

        @Override
        public final void setVariable(String string, String string2, boolean bl) {
            if (SETTINGS_VARIABLES.contains(string)) {
                if (!this.localVariables.containsKey(string) || bl) {
                    this.localVariables.put(string, string2);
                    return;
                }
            } else {
                this.variables.setVariable(string, string2, bl);
            }
        }

        @Override
        public final void setEnvironmentPrefix(String string) {
            this.variables.setEnvironmentPrefix(string);
        }

        @Override
        public final String getVariable(String string) {
            if (this.localVariables.containsKey(string)) {
                return (String)this.localVariables.get(string);
            }
            return this.variables.getVariable(string);
        }

        @Override
        public final Object clone() {
            throw new UnsupportedOperationException();
        }
    }
}

