/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.gotosource.truffle;

import java.util.HashMap;
import java.util.Map;
import org.graalvm.visualvm.gotosource.SourceHandle;
import org.graalvm.visualvm.gotosource.SourceHandleProvider;
import org.graalvm.visualvm.gotosource.SourcePathHandle;
import org.graalvm.visualvm.gotosource.SourcesRoot;
import org.graalvm.visualvm.gotosource.truffle.Bundle;
import org.graalvm.visualvm.gotosource.truffle.TruffleSourceHandle;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;

public final class TruffleSourceHandleProvider
extends SourceHandleProvider {
    private static final String[] JS_LANG_ID = new String[]{"js", "javascript"};
    private static final String[] RUBY_LANG_ID = new String[]{"ruby", "ruby"};
    private static final String[] R_LANG_ID = new String[]{"R", "r"};
    private static final String[] PYTHON_LANG_ID = new String[]{"python", "python"};
    private static final Map<String, String> SUPPORTED_LANGUAGES = new HashMap<String, String>();

    @Override
    public SourceHandle createHandle(String className, String methodName, String methodSignature, int line) {
        int langIdIdx = className.indexOf(46);
        String langId = langIdIdx == -1 ? className : className.substring(0, langIdIdx);
        String language = SUPPORTED_LANGUAGES.get(langId);
        if (language != null) {
            if (langIdIdx != -1) {
                ProfilerDialogs.displayError((String)Bundle.TruffleSourceHandleProvider_ObjectsNotSupported(language));
                return SourceHandle.EMPTY;
            }
            String fileLine = methodSignature.substring(2, methodSignature.length() - 4);
            String[] fileAndLine = fileLine.split(":");
            SourcePathHandle pathHandle = SourcesRoot.getPathHandle(fileAndLine[0]);
            return pathHandle == null ? null : new TruffleSourceHandle(language, className, methodName, methodSignature, Integer.parseInt(fileAndLine[1]), pathHandle);
        }
        return null;
    }

    static {
        SUPPORTED_LANGUAGES.put(JS_LANG_ID[0], JS_LANG_ID[1]);
        SUPPORTED_LANGUAGES.put(RUBY_LANG_ID[0], RUBY_LANG_ID[1]);
        SUPPORTED_LANGUAGES.put(R_LANG_ID[0], R_LANG_ID[1]);
        SUPPORTED_LANGUAGES.put(PYTHON_LANG_ID[0], PYTHON_LANG_ID[1]);
    }
}

