/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.json;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;

public class CryptoService {
    public static final int SIGNATURE_LENGTH = 32;
    private static final String DECRYPTION_KEY_GENERATION_ALGORITHM_NAME = "AES";
    private static final String DECRYPTION_CIPHER_NAME = "AES/CBC/PKCS5Padding";
    private static final String SIGNATURE_KEY_GENERATION_ALGORITHM_NAME = "HmacSHA256";
    private static final String SIGNATURE_MAC_ALGORITHM_NAME = "HmacSHA256";
    private static final IvParameterSpec NULL_IV = new IvParameterSpec(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});

    public SecretKey createEncryptionKey(byte[] keyBytes) {
        return new SecretKeySpec(keyBytes, DECRYPTION_KEY_GENERATION_ALGORITHM_NAME);
    }

    public SecretKey createSignatureKey(byte[] keyBytes) {
        return new SecretKeySpec(keyBytes, "HmacSHA256");
    }

    public byte[] decrypt(Key key, byte[] cipherText) throws GuacamoleException {
        try {
            Cipher cipher = Cipher.getInstance(DECRYPTION_CIPHER_NAME);
            cipher.init(2, key, NULL_IV);
            return cipher.doFinal(cipherText);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new GuacamoleServerException((Throwable)e);
        }
    }

    public byte[] sign(Key key, byte[] data) throws GuacamoleException {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(key);
            return mac.doFinal(data);
        }
        catch (IllegalStateException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new GuacamoleServerException((Throwable)e);
        }
    }
}

