ruleset (	// William McWorter

	Alien(n)	=> attr (delta, 360/11) X, n;
	X	=> [ attr (distance, distance*02^0.5) attr (distance, distance/02) -F X]f[ attr (distance, distance*02^0.5) attr (distance, distance/02) ---F X];
	F	=> ;
)

ruleset (
	// by Philippe Hurbain
	// Same as AmmanPolyColor, showing only the
	// pentagon/hexagon tiling

	Ammann_poly(n)	=> attr (delta, 360/10) X, n;
	X	=> attr (distance, distance*0.618034) +(36) [ -(9) attr (distance, distance*0.66) F]f[ +(196.5) attr (distance, distance*0.363) F][ +(180) Y] -(72) f[ +(180) X];
	X	=> [ -(144) attr (distance, distance*0.618034) f attr (distance, distance/0.618034) X] -(108) [ -(36) attr (distance, distance*0.509) F attr (distance, distance*01.18) -(30) F][X]f[ -(153) attr (distance, distance*0.66) F] -(72) [Y]f;
	Y	=> attr (distance, distance*0.618034) +(72) [X][ -(36) attr (distance, distance*0.509) F]f -(144) [ -(9) attr (distance, distance*0.66) F]f[ +(180) Y][ +(196.5) attr (distance, distance*0.363) F];
	Y	=> -(36) [Y]f -(144) f[ +(180) X];
	F	=> f;
)

ruleset (	// William McWorter

	Border(n)	=> attr (delta, 360/4) XYXYXYX+XYXYXYX+XYXYXYX+XYXYXYX, n;
	F	=> ;
	X	=> FX+FX+FXFY-FY-;
	Y	=> +FX+FXFY-FY-FY;
)

ruleset (	// William McWorter
	// Dekking's boundary of the Twindragon

	Boundary(n)	=> attr (delta, 360/4) O TU Z, n;
	F	=> ;
	O	=> F O+F-T;
	P	=> ++F--U+F-X;
	Q	=> -F+V++F--Q;
	R	=> -F+Z FS;
	S	=> F W;
	T	=> ++F--U;
	U	=> ++F--Y;
	V	=> F S;
	W	=> F O+F-P;
	X	=> ++F--Y+F-X;
	Y	=> -F+R++F--Q;
	Z	=> -F+Z FW;
)

ruleset (	// Adrian Mariano

	Bush(n)	=> attr (delta, 360/16) ++++F, n;
	F	=> FF-[-F+F+F]+[+F-F-F];
)

ruleset (	// William McWorter

	Cross(n)	=> attr (delta, 360/4) FX, n;
	F	=> ;
	X	=> FX+FX+FXFY-FY-;
	Y	=> +FX+FXFY-FY-FY;
)

ruleset (	// Dekking's Church
	// Advances in Math, Vol. 44, 1982, pp.78-104

	Dekking(n)	=> attr (delta, 360/4) WZYX, n;
	F	=> ;
	W	=> FW+F-XFW-F+Z;
	X	=> ++F--Y-F+Z++F--Y-F+Z;
	Y	=> ++F--Y+F-X;
	Z	=> FW+F-X;
)

ruleset (

	Dekking1(n)	=> attr (delta, 360/3) X+X+X, n;
	X	=> F Y+f X-F Y;
	Y	=> f X+F Y-f X;
	F	=> ;
	f	=> ;
)

ruleset (	// William McWorter

	Doublecrossmed(n)	=> attr (delta, 360/8) +X, n;
	X	=> X-F-Y-F-X+F+Y+F+X+F+Y-F-X-F-Y;
	Y	=> X+F+Y+F+X-F-Y-F-X-F-Y+F+X+F+Y;
)

ruleset (	// Adrian Mariano

	Doily(n)	=> attr (delta, 360/12) F--F--F--F--F--F, n;
	F	=> -F[--F--F]++F--F+;
)


ruleset (

	Doily_c(n)	=> attr (delta, 360/12) F--F--F--F--F--F, n;	// from Default.map
	F	=> -F[--F--F]++F--F+;
)

ruleset (

	Doily1(n)	=> attr (delta, 360/12) F--F--F--F--F--F, n;
	F	=> -F[--F--F]++F[++F--F]--F+;
)

ruleset (	// Adrian Mariano
	// from The Fractal Geometry of Nature by Mandelbrot

	Dragon(n)	=> attr (delta, 360/8) FX, n;
	F	=> ;
	Y	=> +FX--FY+;
	X	=> -FX++FY-;
)

ruleset (	// William McWorter

	Dragon_wm(n)	=> attr (delta, 360/4) X, n;
	F	=> ;
	X	=> FX+FY;	// Do first half, turn left 90 degrees, do second half
	Y	=> FX-FY;	// Trace first half (X) backwards; Y backwards is X,
	// left turn becomes right turn, and X backwards is Y
)

ruleset (	// William McWorter

	Dragon1(n)	=> attr (delta, 360/8) X, n;
	F	=> ;
	X	=> FX+ attr (distance, distance*0.500) FZ attr (distance, distance*02.00) +FY;
	Y	=> FX- attr (distance, distance*0.500) FZ attr (distance, distance*02.00) -FY;
	Z	=> FZ;
)

ruleset (	// William McWorter

	Dragon_alt(n)	=> attr (delta, 360/8) -X+[+++ attr (distance, distance*0.5) f W--- attr (distance, distance*02^0.5) F Z]+Y, n;
	F	=> ;
	f	=> ;
	X	=> F X+[+++ attr (distance, distance*0.5) f W--- attr (distance, distance*02^0.5) F Z]+F Y;
	Y	=> F X-[--- attr (distance, distance*0.5) f W+++ attr (distance, distance*02^0.5) F Z]-F Y;
	Z	=> F Z;
	W	=> f W;
)

ruleset (	// William McWorter

	Dragon_alt1(n)	=> attr (delta, 360/8) X, n;
	F	=> ;
	X	=> FX+ attr (distance, distance*0.500) FZ attr (distance, distance*02.00) +FY;
	Y	=> FX- attr (distance, distance*0.500) FZ attr (distance, distance*02.00) -FY;
	Z	=> FZ;
)

ruleset (	// William McWorter

	Dragon_curd(n)	=> attr (delta, 360/4) S U, n;
	F	=> ;
	f	=> ;
	S	=> F S+f-X;
	T	=> ++F--U+f-X;
	U	=> ++F--U-f+Z;
	V	=> F S-f+Z;
	W	=> f W+F-T;
	X	=> ++f--Y+F-T;
	Y	=> ++f--Y-F+V;
	Z	=> f W-F+V;
)

ruleset (	// William McWorter

	Dragonrnd(n)	=> attr (delta, 360/8) X, n;
	F	=> ;
	X	=> FX+ attr (distance, distance*0.500) FZ attr (distance, distance*02.00) +FY;
	Y	=> FX- attr (distance, distance*0.500) FZ attr (distance, distance*02.00) -FY;
	Z	=> FZ;
)

ruleset (	// William McWorter

	Dragon_med(n)	=> attr (delta, 360/8) -X+[+++ attr (distance, distance*0.5) f W--- attr (distance, distance*02^0.5) F Z]+Y, n;
	F	=> ;
	f	=> ;
	X	=> F X+[+++ attr (distance, distance*0.5) f W--- attr (distance, distance*02^0.5) F Z]+F Y;
	Y	=> F X-[--- attr (distance, distance*0.5) f W+++ attr (distance, distance*02^0.5) F Z]-F Y;
	Z	=> F Z;
	W	=> f W;
)

ruleset (	// Adrian Mariano, from the Algorithmic Beauty of Plants
	// FASS curve (3x3 tiles form macrotile), Figure 1.16a p.17
	Fass(n)	=> attr (delta, 360/8) -L, n;

	L	=> LF+RFR+FL-F-LFLFL-FRFR+;
	R	=> -LFLF+RFRFR+F+RF-LFL-FR;
)

ruleset (	// Adrian Mariano, from the Algorithmic Beauty of Plants
	// FASS curve (4x4 tiles form macrotile), Figure 1.16b p.17

	Fass1(n)	=> attr (delta, 360/4) -L, n;
	L	=> LFLF+RFR+FLFL-FRF-LFL-FR+F+RF-LFL-FRFRFR+;
	R	=> -LFLFLF+RFR+FL-F-LF+RFR+FLF+RFRF-LFL-FRFR;
)

ruleset (	// William McWorter

	Frac_rhombus_tile(n)	=> attr (delta, 360/12) F, n;
	F	=> [-F++f-]+F--f+;
	f	=> [-F++f-]+F--f+;
)

ruleset (	// William McWorter
	// made from Moore's spacefilling curve

	Frame(n)	=> attr (delta, 360/4) YXY-YXY-YXY-YXY, n;
	F	=> ;
	X	=> FX+FX+FXFYFX+FXFY-FY-FY-;
	Y	=> +FX+FX+FXFY-FYFXFY-FY-FY;
)

ruleset (
	// Allow turns of 90=360/4 degrees
	Grid(n)	=> attr (delta, 360/4) F, n;	// Birth string is the symbol f (see text below)
	F	=> F[+F][-F]F;	// Replacement string for f (see text below)
)

ruleset (	// William McWorter

	Grid1(n)	=> attr (delta, 360/4) X, n;
	X	=> Y;
	Y	=> F;
	F	=> F[+F][-F]F;
)

ruleset (	// William McWorter

	Grid_median(n)	=> attr (delta, 360/4) Z, n;
	Z	=> X;
	X	=> -[ attr (distance, distance/02) f+F+ attr (distance, distance*02) F+F+F+ attr (distance, distance/02) F]Y FW+[ attr (distance, distance/02) f+F+ attr (distance, distance*02) F+F+F+ attr (distance, distance/02) F]X FW;
	X	=> [ attr (distance, distance/02) f+F+ attr (distance, distance*02) F+F+F+ attr (distance, distance/02) F]X+F W[ attr (distance, distance/02) f+F+ attr (distance, distance*02) F+F+F+ attr (distance, distance/02) F]Y-;
	Y	=> +[ attr (distance, distance/02) f+F+ attr (distance, distance*02) F+F+F+ attr (distance, distance/02) F]X FW-[ attr (distance, distance/02) f+F+ attr (distance, distance*02) F+F+F+ attr (distance, distance/02) F]Y FW;
	Y	=> [ attr (distance, distance/02) f+F+ attr (distance, distance*02) F+F+F+ attr (distance, distance/02) F]Y-F W[ attr (distance, distance/02) f+F+ attr (distance, distance*02) F+F+F+ attr (distance, distance/02) F]X+;
	W	=> F W;
	F	=> ;
	f	=> ;
)

ruleset (
	// Turns are 60=360/6 degrees
	Hex(n)	=> attr (delta, 360/6) F, n;	// Birth string is f
	F	=> -F+F+f[+F+F]-;	// Replacement string for f 
	f	=> f f;	// Replacement string for g (see text below)
)

ruleset (

	Hex1(n)	=> attr (delta, 360/6) F, n;
	F	=> -F+F+F[+F+F+F]-;
)

ruleset (	// Ken Philip, from The Science of Fractal Images
	Hilbert(n)	=> attr (delta, 360/6) X, n;
	X	=> -YF+XFX+FY-;	// cup interior on left during trace
	Y	=> +XF-YFY-FX+;	// cup interior on right during trace

)

ruleset (
	Hilbert1(n)	=> attr (delta, 360/4) Z, n;
	Z	=> -Y F+X F X+F Y-;
	X	=> -YF+XFX+FY-;
	Y	=> +XF-YFY-FX+;

)

ruleset (

	Hiway(n)	=> attr (delta, 360/4) F X, n;
	X	=> F X+F Y;
	Y	=> F X-F Y;
	F	=> ;
)

ruleset (

	Hiway1(n)	=> attr (delta, 360/8) U, n;
	F	=> ;
	f	=> ;
	U	=> V;
	V	=> FX+[+++ attr (distance, distance*0.5) f W--- attr (distance, distance*02^0.5) F Z]+F Y;
	X	=> F X+[+++ attr (distance, distance*0.5) f W--- attr (distance, distance*02^0.5) F Z]+F Y;
	Y	=> F X-[--- attr (distance, distance*0.5) f W+++ attr (distance, distance*02^0.5) F Z]-F Y;
	Z	=> F Z;
	W	=> f W;
)

ruleset (	// William McWorter

	Hiwayint(n)	=> attr (delta, 360/4) S, n;
	F	=> ;
	S	=> X+F-T;
	T	=> ++F--U+F-T;
	U	=> Z-F+V;
	V	=> F S-F+V;
	W	=> F SW;
	X	=> X Y;
	Y	=> ++F--U Y;
	Z	=> Z W;
)

ruleset (
	// Smallest turn is 45=360/8 degrees
	Hiwaymed(n)	=> attr (delta, 360/8) -X, n;	// Turn whole thing 45 degrees so that all lines of X are horizontal or vertical
	X	=> X+F+Y;	// Do X, turn left, forward, turn left, do Y
	Y	=> X-F-Y;	// Do X backwards
)

ruleset (	// William McWorter

	Hiwaymed_x(n)	=> attr (delta, 360/4) S, n;
	F	=> ;
	S	=> F S+F-T;
	T	=> +F-U+F-T;
	U	=> ++F--V++F--W;
	V	=> ++F--V-F+X;
	W	=> -F+Y++F--W;
	X	=> -F+Y-F+X;
	Y	=> F SF Z;
	Z	=> +F-UF Z;
)

ruleset (	// William McWorter

	Isocepent(n)	=> attr (delta, 360/10) W, n;
	W	=> ++[- attr (distance, distance*01.618033989) F attr (distance, distance/01.618033989) ++++F]F X--[++ attr (distance, distance*01.618033989) F----F]F W--;
	W	=> [-- attr (distance, distance*01.618033989) F++++F]F Y++;
	X	=> -[+ attr (distance, distance*01.618033989) F attr (distance, distance/01.618033989) ----F]F Z++[-- attr (distance, distance*01.618033989) F++++F]F Y-;
	Y	=> --[+ attr (distance, distance*01.618033989) F attr (distance, distance/01.6180339898) ----F]F Z++[-- attr (distance, distance*01.618033989) F++++F]F Y++;
	Y	=> [++ attr (distance, distance*01.618033989) F----F]F W--;
	Z	=> +[- attr (distance, distance*01.618033989) F attr (distance, distance/01.618033989) ++++F]F X--[++ attr (distance, distance*01.618033989) F----F]F W+;
	F	=> ;
)

ruleset (	// William McWorter

	Isocepent1(n)	=> attr (delta, 360/10) S, n;
	S	=> W;
	W	=> ++[- attr (distance, distance*01.618033989) F attr (distance, distance/01.618033989) ++++F]F X--[++ attr (distance, distance*01.618033989) F----F]F W--;
	W	=> [-- attr (distance, distance*01.618033989) F++++F]F Y++;
	X	=> -[+ attr (distance, distance*01.618033989) F attr (distance, distance/01.618033989) ----F]F Z++[-- attr (distance, distance*01.618033989) F++++F]F Y-;
	Y	=> --[+ attr (distance, distance*01.618033989) F attr (distance, distance/01.6180339898) ----F]F Z++[-- attr (distance, distance*01.618033989) F++++F]F Y++;
	Y	=> [++ attr (distance, distance*01.618033989) F----F]F W--;
	Z	=> +[- attr (distance, distance*01.618033989) F attr (distance, distance/01.618033989) ++++F]F X--[++ attr (distance, distance*01.618033989) F----F]F W+;
	F	=> ;
)

ruleset (	// William McWorter

	Isocepent2(n)	=> attr (delta, 360/10) S, n;
	S	=> Z;
	W	=> ++[- attr (distance, distance*01.618033989) F attr (distance, distance/01.618033989) ++++F]F X--[++ attr (distance, distance*01.618033989) F----F]F W--;
	W	=> [-- attr (distance, distance*01.618033989) F++++F]F Y++;
	X	=> -[+ attr (distance, distance*01.618033989) F attr (distance, distance/01.618033989) ----F]F Z++[-- attr (distance, distance*01.618033989) F++++F]F Y-;
	Y	=> --[+ attr (distance, distance*01.618033989) F attr (distance, distance/01.6180339898) ----F]F Z++[-- attr (distance, distance*01.618033989) F++++F]F Y++;
	Y	=> [++ attr (distance, distance*01.618033989) F----F]F W--;
	Z	=> +[- attr (distance, distance*01.618033989) F attr (distance, distance/01.618033989) ++++F]F X--[++ attr (distance, distance*01.618033989) F----F]F W+;
	F	=> ;
)

ruleset (

	isocright(n)	=> attr (delta, 360/8) X, n;
	X	=> +Y-F-Y+;
	Y	=> -X+F+X-;
)

ruleset (	// Adrian Mariano

	Koch_curve(n)	=> attr (delta, 360/6) F, n;
	F	=> F+F--F+F;
)

ruleset (	// William McWorter
	// A 30-60-90 triangle dissects into three
	// congruent 30-60-90 triangles
	// This script traverses the centers of the congruent triangles

	Lace(n)	=> attr (delta, 360/12) W, n;
	W	=> +++X--F--ZF X+;
	X	=> ---W++F++YF W-;
	Y	=> +ZF X--F--Z+++;
	Z	=> -YF W++F++Y---;
)

ruleset (	// Adrian Mariano, from the Algorithmic Beauty of Plants
	// Compound leaf with alternating branches, Figure 5.12a p.130

	Leaf(n)	=> attr (delta, 360/8) A, n;
	A	=> F[+X]F B;
	B	=> F[-Y]F A;
	X	=> A;
	Y	=> B;
	F	=> attr (distance, distance*01.36) F attr (distance, distance/01.36);
)

ruleset (

	Leafy(n)	=> attr (delta, 360/50) +++++++++++++X, n;
	X	=> F[ attr (distance, distance*0.5) +++++++++X attr (distance, distance*0.5) F+++++++F--F|++++F------F];
	X	=> -F[ attr (distance, distance*0.4) -----------!X attr (distance, distance*0.5) F+++++++F--F|++++F------F];
	X	=> attr (distance, distance*0.6) X;
)

ruleset (

	Lawn_in_spring(n)	=> attr (delta, 360/16) X, n;
	X	=> [+++++F-F-F Z]f X++++f Y;
	Y	=> [+++++F-F-F Z]f X----f Y;
	Z	=> W;
	W	=> U;
	U	=> [ attr (distance, distance*0.3) [+++F]f++[+++F]f++[+++F]f++[+++F]f++[+++F]f++[+++F]f++[+++F]f++[+++F]f]Z;
	F	=> ;
	f	=> ;
)

ruleset (

	Maze(n)	=> attr (delta, 360/3) F+F+F, n;
	F	=> F+F F-F;
)

ruleset (

	Maze_fractal(n)	=> attr (delta, 360/3) X, n;
	X	=> F Y+F YF Y-F Y;
	Y	=> F X-F XF X+F X;
	F	=> ;
)

ruleset (	// William McWorter

	Moore(n)	=> attr (delta, 360/4) X, n;
	F	=> ;
	X	=> FX+FX+FXFYFX+FXFY-FY-FY-;
	Y	=> +FX+FX+FXFY-FYFXFY-FY-FY;
)

ruleset (	// Adrian Mariano
	// from The Fractal Geometry of Nature by Mandelbrot

	Peano(n)	=> attr (delta, 360/4) F, n;
	F	=> F-F+F+F+F-F-F-F+F;
)

ruleset (	// William McWorter

	Peanomed(n)	=> attr (delta, 360/8) -X, n;
	X	=> X+F+X-F-X-F-X-F-X+F+X+F+X+F+X-F-X;
)

ruleset (	// William McWorter

	Pentant(n)	=> attr (delta, 360/5) X-X-X-X-X, n;
	F	=> ;
	X	=> F X-F X-F X+F Y+F Y+F X-F X;
	Y	=> F Y+F Y-F X-F X-F Y+F Y+F Y;
)

ruleset (
	// Manual construction by Roger Penrose as a prelude to his development of
	// the famous Penrose tiles (the kites and darts) that tile the plane
	// only non-periodically.
	// Translated first to a "dragon curve" and finally to an L-system
	// by Joe Saverino.

	Penta_plexity(n)	=> attr (delta, 360/10) F++F++F++F++F, n;
	F	=> F++F++F|F-F++F;
)

ruleset (	// William McWorter

	Pentigree(n)	=> attr (delta, 360/5) F-F-F-F-F, n;
	F	=> F-F++F+F-F-F;
)

ruleset (

	Pentive(n)	=> attr (delta, 360/10) W, n;
	F	=> ;
	W	=> ++FX--FW--FY++;
	X	=> -FZ++FY-;
	Y	=> --FZ++FY++FW--;
	Z	=> +FX--FW+;
)

ruleset (

	Pentive1(n)	=> attr (delta, 360/10) X, n;
	F	=> ;
	f	=> ;
	X	=> ++F Z----F Y++F X;
	Y	=> +F W--f Z+;
	Z	=> --F X++++F W--F Z;
	W	=> -F Y++f X-;
)

ruleset (

	Pentive2(n)	=> attr (delta, 360/10) X, n;
	F	=> ;
	X	=> F Y++F Z----F W++;
	Y	=> +F W--F U+;
	Z	=> ++F V----F X++F Y;
	W	=> F U--F V++++F X--;
	U	=> -F X++F Y-;
	V	=> --F Z++++F W--F U;
)

ruleset (

	Pentive3(n)	=> attr (delta, 360/10) Q, n;
	F	=> ;
	P	=> --F R++++F S--F U;
	Q	=> F T++F R----F S++;
	R	=> ++F P----F Q++F T;
	S	=> F U--F P++++F Q--;
	T	=> +F U--F P+;
	U	=> -F Q++F T-;
)

ruleset (	// William McWorter *

	Penty(n)	=> attr (delta, 360/10) W, n;
	F	=> ;
	W	=> ++FX--FW--FY++;
	X	=> -FZ++FY-;
	Y	=> --FZ++FY++FW--;
	Z	=> +FX--FW+;
)

ruleset (	// William McWorter

	Pentl(n)	=> attr (delta, 360/5) F-F-F-F-F, n;
	F	=> F-F-F++F+F-F;
)

ruleset (	// Adrian Mariano, from the Algorithmic Beauty of Plants
	// Plant-like structure, figure 1.24d p.25

	Plant(n)	=> attr (delta, 360/18) X, n;
	X	=> F[+X]F[-X]+X;
	F	=> FF;
)

ruleset (

	Pre_lace(n)	=> attr (delta, 360/12) +++F W----F ZF W+, n;
	F	=> ;
	Y	=> +++F W----F ZF W+;
	X	=> +F ZF W----F Z+++;
	W	=> ---F Y++++F XF Y-;
	Z	=> -F XF Y++++F X---;
)

ruleset (

	Rhombus_tile(n)	=> attr (delta, 360/12) F, n;
	F	=> [-F++F-]+F--F+;
)

ruleset (	// William McWorter
	// Isoceles right triangle dissects into two congruent
	// isoceles right triangles

	Sierpinsk(n)	=> attr (delta, 360/8) L, n;
	L	=> +R-F-R+;
	R	=> -L+F+L-;
)

ruleset (	// William McWorter

	Sierpinski(n)	=> attr (delta, 360/8) L--F--L--F, n;
	L	=> +R-F-R+;
	R	=> -L+F+L-;
)

ruleset (

	Sierpinski1(n)	=> attr (delta, 360/8) Z, n;
	Z	=> X;
	X	=> +[- attr (distance, distance*0.5) f++ attr (distance, distance*02.414) f| attr (distance, distance*02^0.5) F--F--- attr (distance, distance*02^0.5) F]Y-F W-;
	X	=> [- attr (distance, distance*0.5) f++ attr (distance, distance*02.414) f| attr (distance, distance*02^0.5) F--F--- attr (distance, distance*02^0.5) F]Y+;
	Y	=> -[+ attr (distance, distance*0.5) f-- attr (distance, distance*02.414) f| attr (distance, distance*02^0.5) F++F+++ attr (distance, distance*02^0.5) F]X+F W+;
	Y	=> [+ attr (distance, distance*0.5) f-- attr (distance, distance*02.414) f| attr (distance, distance*02^0.5) F++F+++ attr (distance, distance*02^0.5) F]X-;
	W	=> F W;
	F	=> ;
	f	=> ;
)

ruleset (

	Sierpinski_carpet(n)	=> attr (delta, 360/4) F, n;
	F	=> F+F-F-F-f+F+F+F-F;
	f	=> f ff;
)

ruleset (
	// All turns are multiples of 60=360/6 degrees
	Snowflake(n)	=> attr (delta, 360/6) F--F--F, n;	// Draw clockwise a ring of three Snowflakes
	F	=> F+F--F+F;	// Forward, turn left, forward, turn left, turn left, ... , forward
)

ruleset (	// by Herb Savage
	// based on Martin Gardner's "Penrose Tiles to Trapdoor Ciphers"
	// This is an example of a "reptile"

	Sphinx(n)	=> attr (delta, 360/6) X, n;
	X	=> +FF-YFF+FF--FFF|X|F--YFFFYFFF|;
	Y	=> -FF+XFF-FF++FFF|Y|F++XFFFXFFF|;
	F	=> ff;
	f	=> ff;
)

ruleset (	// Adrian Mariano

	Square_gasket(n)	=> attr (delta, 360/4) X, n;
	X	=> +F XF+F XF+F XF+F XF;
	F	=> F F;
)

ruleset (
	// by Philippe Hurbain
	// Penrose's stars and pentagons, generated from
	// decomposition rules
	// u is the star, v is the boat, w is the thin rhombus
	// x, y and z are the pentagons

	Stars_pentas(n)	=> attr (delta, 360/10) U, n;
	U	=> attr (distance, distance*0.381966) [V]F[|Y][-U]++F|+[V]F[|Y]++F|+[V]F[|Y]++F|+;
	U	=> [V]F[|Y]++F|+[V]F[|Y]++F;
	V	=> attr (distance, distance*0.381966) [V]F[|Y]++F|+[V]F[|Y]-[U]F-F|+[V]F[|Y]++F;
	W	=> attr (distance, distance*0.381966) f++[U]F|+F-F|+[V]F[|Y];
	Y	=> attr (distance, distance*0.381966) [X][Y][W]F[|!Y]++F++[Y][W]F[|!Y]++F++[Z]F;
	X	=> attr (distance, distance*0.381966) f++f++[!X][!Z]F--[!Z]F--[!Z]F--[!Z]F--[!Z]F;
	Z	=> attr (distance, distance*0.381966) [Z][X]F++[Z]F++[W][Y]F[|!Y]++F++[Z]F;
	F	=> f;
)

ruleset (	// William McWorter
	// Strikethrough S

	Strike_s(n)	=> attr (delta, 360/4) UW, n;
	F	=> ;
	U	=> FU+F-V;
	V	=> ++F--W++F--Z;
	W	=> ++F--W-F+X;
	X	=> FUFY;
	Y	=> +F-VFY;
	Z	=> -F+X--F++Z;
)

ruleset (	// William McWorter
	// from Davis and Knuth. Journal of
	// Rec. Math. vol. 3, 1970, pages 61-81

	Terdragon(n)	=> attr (delta, 360/3) F, n;
	F	=> F+F-F;
)

ruleset (	// William McWorter
	// from Davis and Knuth. Journal of
	// Rec. Math. vol. 3, 1970, pages 61-81

	Terdragon_c(n)	=> attr (delta, 360/3) F+F-F, n;
	F	=> F+F-F;
)

ruleset (

	Terdragon1(n)	=> attr (delta, 360/3) X, n;
	X	=> Y;
	Y	=> F+F-F;
	F	=> F+F-F;
)

ruleset (	// William McWorter
	// median terdragon

	Terdragn_m(n)	=> attr (delta, 360/6) X, n;
	X	=> X+F+X-F-X;
)

ruleset (

	Three_tile(n)	=> attr (delta, 360/12) [U] attr (distance, distance*03^0.5) %, n;
	%	=> U;
	U	=> [+++ attr (distance, distance/03^0.5) F---- attr (distance, distance*02) F]F X;
	X	=> +++[--- attr (distance, distance/03^0.5) F++++ attr (distance, distance*02) F]F Y----[- attr (distance, distance*02) attr (distance, distance/03^0.5) F++++ attr (distance, distance/02) F]F Z[--- attr (distance, distance/03^0.5) F++++ attr (distance, distance*02) F]F Y+;
	Y	=> ---[+++ attr (distance, distance/03^0.5) F---- attr (distance, distance*02) F]F X++++[+ attr (distance, distance*02) attr (distance, distance/03^0.5) F---- attr (distance, distance/02) F]F W[+++ attr (distance, distance/03^0.5) F---- attr (distance, distance*02) F]F X-;
	Z	=> -[+ attr (distance, distance*02) attr (distance, distance/03^0.5) F---- attr (distance, distance/02) F]F W[+++ attr (distance, distance/03^0.5) F---- attr (distance, distance*02) F]F X++++[+ attr (distance, distance*02) attr (distance, distance/03^0.5) F---- attr (distance, distance/02) F]F W---;
	W	=> +[- attr (distance, distance*02) attr (distance, distance/03^0.5) F++++ attr (distance, distance/02) F]F Z[--- attr (distance, distance/03^0.5) F++++ attr (distance, distance*02) F]F Y----[- attr (distance, distance*02) attr (distance, distance/03^0.5) F++++ attr (distance, distance/02) F]F Z+++;
	F	=> ;
)

ruleset (

	Three_tile_med(n)	=> attr (delta, 360/12) U, n;
	U	=> [++++f+++++ attr (distance, distance*01.366) F+++ attr (distance, distance*03^0.5) F+++++ attr (distance, distance*02) attr (distance, distance/03^0.5) F]X;
	X	=> +++[----f----- attr (distance, distance*01.366) F--- attr (distance, distance*03^0.5) F----- attr (distance, distance*02) attr (distance, distance/03^0.5) F]Y--F P--;
	X	=> [--f+++++ attr (distance, distance*01.366) F+++ attr (distance, distance*03^0.5) F+++++ attr (distance, distance*02) attr (distance, distance/03^0.5) F]Z FP;
	X	=> [----f----- attr (distance, distance*01.366) F--- attr (distance, distance*03^0.5) F----- attr (distance, distance*02) attr (distance, distance/03^0.5) F]Y+;
	Y	=> ---[++++f+++++ attr (distance, distance*01.366) F+++ attr (distance, distance*03^0.5) F+++++ attr (distance, distance*02) attr (distance, distance/03^0.5) F]X++F P++;
	Y	=> [++f----- attr (distance, distance*01.366) F--- attr (distance, distance*03^0.5) F----- attr (distance, distance*02) attr (distance, distance/03^0.5) F]W FP;
	Y	=> [++++f+++++ attr (distance, distance*01.366) F+++ attr (distance, distance*03^0.5) F+++++ attr (distance, distance*02) attr (distance, distance/03^0.5) F]X-;
	Z	=> -[++f----- attr (distance, distance*01.366) F--- attr (distance, distance*03^0.5) F----- attr (distance, distance*02) attr (distance, distance/03^0.5) F]W FP;
	Z	=> [++++f+++++ attr (distance, distance*01.366) F+++ attr (distance, distance*03^0.5) F+++++ attr (distance, distance*02) attr (distance, distance/03^0.5) F]X++F P++;
	Z	=> [++f----- attr (distance, distance*01.366) F--- attr (distance, distance*03^0.5) F----- attr (distance, distance*02) attr (distance, distance/03^0.5) F]W---;
	W	=> +[--f+++++ attr (distance, distance*01.366) F+++ attr (distance, distance*03^0.5) F+++++ attr (distance, distance*02) attr (distance, distance/03^0.5) F]Z FP;
	W	=> [----f----- attr (distance, distance*01.366) F--- attr (distance, distance*03^0.5) F----- attr (distance, distance*02) attr (distance, distance/03^0.5) F]Y--F P--;
	W	=> [--f+++++ attr (distance, distance*01.366) F+++ attr (distance, distance*03^0.5) F+++++ attr (distance, distance*02) attr (distance, distance/03^0.5) F]Z+++;
	P	=> F P;
	F	=> ;
	f	=> ;
)

ruleset (

	Three_tile_med1(n)	=> attr (delta, 360/12) U---F P---V---F P, n;
	V	=> [++f----- attr (distance, distance*01.366) F--- attr (distance, distance*03^0.5) F----- attr (distance, distance*02) attr (distance, distance/03^0.5) F]W;
	U	=> [++++f+++++ attr (distance, distance*01.366) F+++ attr (distance, distance*03^0.5) F+++++ attr (distance, distance*02) attr (distance, distance/03^0.5) F]X;
	X	=> +++[----f----- attr (distance, distance*01.366) F--- attr (distance, distance*03^0.5) F----- attr (distance, distance*02) attr (distance, distance/03^0.5) F]Y--F P--;
	X	=> [--f+++++ attr (distance, distance*01.366) F+++ attr (distance, distance*03^0.5) F+++++ attr (distance, distance*02) attr (distance, distance/03^0.5) F]Z FP;
	X	=> [----f----- attr (distance, distance*01.366) F--- attr (distance, distance*03^0.5) F----- attr (distance, distance*02) attr (distance, distance/03^0.5) F]Y+;
	Y	=> ---[++++f+++++ attr (distance, distance*01.366) F+++ attr (distance, distance*03^0.5) F+++++ attr (distance, distance*02) attr (distance, distance/03^0.5) F]X++F P++;
	Y	=> [++f----- attr (distance, distance*01.366) F--- attr (distance, distance*03^0.5) F----- attr (distance, distance*02) attr (distance, distance/03^0.5) F]W FP;
	Y	=> [++++f+++++ attr (distance, distance*01.366) F+++ attr (distance, distance*03^0.5) F+++++ attr (distance, distance*02) attr (distance, distance/03^0.5) F]X-;
	Z	=> -[++f----- attr (distance, distance*01.366) F--- attr (distance, distance*03^0.5) F----- attr (distance, distance*02) attr (distance, distance/03^0.5) F]W FP;
	Z	=> [++++f+++++ attr (distance, distance*01.366) F+++ attr (distance, distance*03^0.5) F+++++ attr (distance, distance*02) attr (distance, distance/03^0.5) F]X++F P++;
	Z	=> [++f----- attr (distance, distance*01.366) F--- attr (distance, distance*03^0.5) F----- attr (distance, distance*02) attr (distance, distance/03^0.5) F]W---;
	W	=> +[--f+++++ attr (distance, distance*01.366) F+++ attr (distance, distance*03^0.5) F+++++ attr (distance, distance*02) attr (distance, distance/03^0.5) F]Z FP;
	W	=> [----f----- attr (distance, distance*01.366) F--- attr (distance, distance*03^0.5) F----- attr (distance, distance*02) attr (distance, distance/03^0.5) F]Y--F P--;
	W	=> [--f+++++ attr (distance, distance*01.366) F+++ attr (distance, distance*03^0.5) F+++++ attr (distance, distance*02) attr (distance, distance/03^0.5) F]Z+++;
	P	=> F P;
	F	=> ;
	f	=> ;
)

ruleset (

	Tiling(n)	=> attr (delta, 360/6) X, n;
	X	=> F-F-F+F+F X++F-F-F+F+F X--F-F-F+F+F X;
	F	=> ;
)

ruleset (

	Trigrid(n)	=> attr (delta, 360/3) F, n;
	F	=> F+F-F-F F+F+F-F;
)

ruleset (

	Trigrid1(n)	=> attr (delta, 360/6) X, n;
	X	=> F Y[+F Y][--F Y]F Y;
	Y	=> F X[++F X][-F X]F X;
	F	=> ;
)

ruleset (	// William McWorter

	Tripeanomed(n)	=> attr (delta, 360/6) X, n;
	X	=> X+F+X-F-X-F-X+F+X+F+X-F-X;
)

ruleset (	// William McWorter

	Tri_peano(n)	=> attr (delta, 360/3) F, n;
	F	=> F+F-F-F+F+F-F;
)

ruleset (

	Twin_dragon_curd(n)	=> attr (delta, 360/4) F X+F X, n;
	X	=> F X+f Y;
	Y	=> F X-f Y;
	F	=> ;
	f	=> ;
)

ruleset (

	Twin_dragon_curd1(n)	=> attr (delta, 360/4) F X+F X, n;
	X	=> F X+f Y;
	Y	=> f X-F Y;
	F	=> ;
	f	=> ;
)

ruleset (

	Two_tile(n)	=> attr (delta, 360/8) [Z] attr (distance, distance*02^0.5) A, n;
	A	=> Z;
	Z	=> [+ attr (distance, distance*02^0.5) attr (distance, distance/02) F--F]F X;
	X	=> +[- attr (distance, distance*02^0.5) attr (distance, distance/02) F++F]F Y--[- attr (distance, distance*02^0.5) attr (distance, distance/02) F++F]F Y+;
	Y	=> -[+ attr (distance, distance*02^0.5) attr (distance, distance/02) F--F]F X++[+ attr (distance, distance*02^0.5) attr (distance, distance/02) F--F]F X-;
	F	=> ;
)

ruleset (	// William McWorter

	Untitled(n)	=> attr (delta, 360/4) X, n;
	F	=> ;
	X	=> F X-F Y-F X+F Y+F X+F Y-F X-F Y+;
	Y	=> -F X+F Y+F X-F Y-F X-F Y+F X+F Y;
)

ruleset (	// William McWorter

	Untitledmed(n)	=> attr (delta, 360/8) +X, n;
	X	=> X-F-Y-F-X+F+Y+F+X+F+Y-F-X-F-Y;
	Y	=> X+F+Y+F+X-F-Y-F-X-F-Y+F+X+F+Y;
)

ruleset (

	Weed(n)	=> attr (delta, 360/50) +++++++++++++X, n;
	X	=> F[ attr (distance, distance*0.5) +++++++++X]-F[ attr (distance, distance*0.4) -----------!X]X;
)

ruleset (

	Weed1(n)	=> attr (delta, 360/50) +++++++++++++X, n;
	X	=> F[ attr (distance, distance*0.5) +++++++++X]-F[ attr (distance, distance*0.4) -----------!X] attr (distance, distance*0.6) X;
)

ruleset (	// by Morgan Savage
	// Try order 13 and color cycle in both 256 and 16 color modes

	Vertigo(n)	=> attr (delta, 360/46) X, n;
	X	=> XF+ attr (distance, distance*0.9997) X;
)

ruleset (	// by Herb Savage
	// based on Martin Gardner's "Penrose Tiles to Trapdoor Ciphers",
	// A spiral tiling by Heinz Voderberg

	Voderberg_tile(n)	=> attr (delta, 360/30) -(84.1) A -(96) attr (distance, distance*04.783386117) f attr (distance, distance/04.783386117) +(96) A, n;
	A	=> X -(12) X -(12) X -(12) X -(12) X -(12) X -(12) X -(12) X -(12) X -(12) X -(12) X -(12) X -(12) X -(12) X -(12) X -(12) Z;
	X	=> [F -(78) F -(46.37236) attr (distance, distance*03.393427) F attr (distance, distance/03.393427) +(46.37236) F -(114) [ -(168) X -(24) Y]F -(78) F -(46.37236) attr (distance, distance*03.393427) F attr (distance, distance/03.393427) +(46.37236) F +(78) F];
	Y	=> [F -(78) F -(46.37236) attr (distance, distance*03.393427) F attr (distance, distance/03.393427) +(46.37236) F +(78) F -(168) [ -(192) Y]F -(78) F -(46.37236) attr (distance, distance*03.393427) F attr (distance, distance/03.393427) +(46.37236) F];
	Z	=> [F -(78) F -(46.37236) attr (distance, distance*03.393427) F attr (distance, distance/03.393427) +(46.37236) F -(114) F -(78) F -(46.37236) attr (distance, distance*03.393427) F attr (distance, distance/03.393427) +(46.37236) F +(78) F];
)

ruleset (	// William McWorter

	Xmastree(n)	=> attr (delta, 360/10) P, n;
	F	=> ;
	P	=> --F R++++F S--F U;
	Q	=> F T++F R----F S++;
	R	=> ++F P----F Q++F T;
	S	=> F U--F P++++F Q--;
	T	=> +F U--F P+;
	U	=> -F Q++F T-;
)


ruleset (	// William McWorter

	Xmastree1(n)	=> attr (delta, 360/10) W, n;
	F	=> ;
	W	=> ++FX--FW--FY++;
	X	=> -FZ++FY-;
	Y	=> --FZ++FY++FW--;
	Z	=> +FX--FW+;
)


