.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/comp/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.TH "PG_EXEC_PREPARED" "" "17 September 2020" "" "PostgreSQL Tcl Interface Documentation"

.SH NAME
pg_exec_prepared \- send a request to execute a prepared SQL statement to the server

.SH SYNOPSIS

.nf
pg_exec_prepared \fIconn\fR \fIstatementName\fR [\fIargs\fR]
.fi
.SH "DESCRIPTION"
.PP
\fBpg_exec_prepared\fR submits a command to the
PostgreSQL server and returns a result.
.PP
\fBpg_exec_prepared\fR functions identically to
\fBpg_exec\fR, except that it operates using
statements prepared by the \fBPREPARE\fR SQL command.
.PP
Note that prepared statements are only support under PostgreSQL 7.4
and later.
.SH "ARGUMENTS"
.TP
\fB\fIconn\fB\fR
The handle of the connection on which to execute the command.
.TP
\fB\fIstatementName\fB\fR
The name of the prepared statement to execute.
.TP
\fB\fIargs\fB\fR
\fIargs\fR
consists of zero or more optional values that can be inserted,
unquoted, into the SQL statement using $-style substitution.
.SH "RETURN VALUE"
.PP
A result handle. See \fBpg_exec\fR for details.
.SH "EXAMPLE"
.PP

.nf
pg_exec $conn {prepare insert_people 
    (varchar, varchar, varchar, varchar, varchar, varchar) 
    as insert into people values ($1, $2, $3, $4, $5, $6);}

pg_exec_prepared $conn insert_people $email $name $address $city $state $zip
.fi
