/**
*
* Jquery Mapael - Dynamic maps jQuery plugin (based on raphael.js)
* Requires jQuery and raphael.js
*
* Map of Bretagne for Mapael
* Equirectangular projection
* 
* @author CCM Benchmark Group
* @source http://fr.m.wikipedia.org/wiki/Fichier:France_location_map-Departements.svg
*/
(function($) {
	$.extend(true, $.fn.mapael, 
		{
			maps :  {
				france_region_53 : {
					width : 172.88751,
					height : 94.71875,
					getCoords : function (lat, lon) {
						var xfactor = 45.48385;
						var xoffset = 220.22005;
						var x = (lon * xfactor) + xoffset;
						
						var yfactor = -65.97284;
						var yoffset = 3224.4354;
						var y = (lat * yfactor) + yoffset;
						return {x : x, y : y};
					},
					elems : {
					    "department-29" : "m 37.21,9.53 c -0.91,0.67 -1.9,1.21 -3,1.49 -0.68,0.41 -0.56,1.4 -0.99,2.01 -0.97,-1.5 -3.05,-0.87 -4.48,-0.59 -0.95,0.32 -1.89,0.92 -2.48,1.73 -0.06,0.5 0.86,0.64 0.9,0.89 -1.41,0.14 -3.26,-0.5 -4.33,0.71 -0.24,0.53 -1.05,0.13 -0.62,-0.4 0.29,-0.45 0.73,-1.21 -0.05,-1.45 -0.74,-0.54 -1.73,-0.92 -2.53,-0.27 -0.82,0.68 -1.88,0.87 -2.83,1.26 -0.32,0.45 1.05,0.73 0.19,0.85 -1.02,0.1 -2.02,0.23 -2.91,0.8 -0.94,0.09 -2.16,-1.19 -3.02,-0.16 -0.44,0.13 -0.8,0.47 -0.38,0.9 0.14,0.42 0.81,0.82 0.8,1.13 -0.91,0.41 -1.84,-0.12 -2.66,-0.45 -0.66,0.19 -0.66,1.49 -0.15,1.84 0.63,-0.12 1.11,1.45 0.31,0.99 -0.83,-1.37 -2.74,-1.16 -4.01,-0.63 -0.52,-0.03 -1.14,0.2 -1.1,0.78 -0.59,0.18 -1.48,-0.14 -1.67,0.74 -0.62,1.22 -2.2,2.65 -1.33,4.1 0.22,0.54 1.63,1.04 0.47,1.28 -1.12,0.55 -0.99,2.09 -1.33,3.11 0.27,0.92 1.22,1.78 1.1,2.76 -0.22,0.47 -0.97,0.54 -0.68,1.22 0.12,0.89 0.67,1.93 1.74,1.68 0.86,0.09 2.29,0.07 2.27,-1.11 0.4,-0.79 1.54,-0.22 2.16,-0.06 0.62,0.23 1.13,0.78 1.87,0.45 1.46,-0.42 2.81,-1.07 4.23,-1.62 2.07,-1.16 4.37,-1.69 6.63,-2.33 1.1,-0.34 2.16,-0.9 3.27,-1.17 -1.62,1.65 -4.15,1.85 -5.78,3.5 -0.96,0.38 -0.74,1.6 -1.18,2.36 0.33,0.57 1.09,-0.25 1.59,-0.25 0.44,-0.2 0.58,0 0.48,0.4 0.52,0.74 1.69,-0.08 1.89,-0.76 0.36,-0.49 1.26,-0.04 1.62,-0.64 0.23,0.9 0.82,0.45 1.27,-0.03 0.24,-0.17 0.95,-0.44 1.07,-0.19 -0.56,0.82 -1.63,1.25 -2.04,2.14 0.47,0.87 1.78,-0.11 2.34,0.68 0.39,0.38 1.25,0.45 1.5,0.14 0.04,1.05 1.5,0.49 1.96,0.9 -0.88,0.39 -2.03,0.08 -2.88,0.72 -0.26,0.27 -1.13,0.24 -1.11,-0.13 0.35,-0.76 -0.95,-0.58 -1.35,-0.48 -1.46,0.12 -2.83,1.19 -4.3,0.93 -0.52,-0.49 -1.03,-1.26 -1.91,-0.96 -0.84,0.01 -1.68,0.69 -2.5,0.48 -0.3,-0.42 -1.21,-0.79 -1.16,0.01 -0.65,-0.12 -1.31,-0.73 -0.96,-1.42 -0.06,-0.66 0.84,-1.32 0.44,-1.91 -1.17,-0.11 -2.31,1.15 -1.85,2.33 0.18,0.52 0.1,1.84 -0.73,1.46 -0.53,-0.5 -1.67,-0.32 -1.37,0.6 0.41,1.21 1.94,1.11 2.97,1 0.71,-0.05 0.75,0.8 0.24,1.12 -1.06,0.68 0.17,1.78 0.16,2.72 0.29,0.63 -0.39,1.2 -0.2,1.76 0.58,0.34 0.96,-0.37 1.18,-0.8 0.86,-0.88 1.37,-2.09 1.74,-3.22 1.14,-0.82 2.63,-0.2 3.66,0.51 0.61,0.32 1.58,0.06 1.77,0.95 0.63,0.83 2.01,-0.3 2.59,0.73 0.84,0.83 0.66,2.19 1.55,3.02 0.55,0.89 -0.1,1.99 -0.25,2.93 -0.11,0.66 -0.74,1.12 -1.35,0.68 -0.91,-0.18 -1.61,-1 -2.6,-0.62 -1.82,0.42 -3.71,0.66 -5.42,1.41 -0.82,0.03 -1.69,-0.07 -2.39,0.49 -0.82,0.36 -1.82,-0.1 -2.65,0.36 -1.12,0.33 -2.37,0.06 -3.41,0.66 -0.57,0.19 -1.85,-0.61 -1.54,0.43 0.3,0.55 -0.23,0.87 -0.42,1.29 0.56,0.73 1.76,0.71 2.61,0.91 1.24,-0.06 2.48,0.33 3.44,1.11 0.49,0.75 1.5,0.47 1.91,-0.22 0.37,-0.63 0.89,-0.16 1.2,0.23 0.88,0.4 1.74,0.84 2.45,1.55 2.79,2.16 4.63,5.4 5.46,8.76 0.34,0.82 -0.33,1.35 -0.93,1.7 -0.41,0.6 -0.23,1.86 0.72,1.72 1.28,0.03 2.52,0.28 3.77,0.49 1.79,-0.09 4.18,-0.1 5.03,-2.02 0.76,-0.85 -0.62,-0.61 -0.93,-1.09 -0.16,-0.66 -0.86,-1.32 -0.36,-2.02 0.09,-0.49 0.59,-0.49 0.73,-0.06 0.22,0.71 1.06,1.68 1.75,0.86 0.44,-0.22 1.08,-0.5 0.64,-1.11 -0.38,-0.81 -1.57,-1.89 -0.91,-2.73 0.39,1.24 1.13,2.47 2.18,3.22 0.61,0.15 1.48,-0.4 1.77,0.45 0.2,0.54 0.7,0.69 1.01,0.24 0.71,-0.44 1.36,0.62 2,0.06 0.47,-0.77 -0.24,-1.92 0.34,-2.6 1.04,-0.18 1.76,0.69 2.33,1.42 0.38,0.44 1.2,0.6 1.12,1.31 0.25,0.42 0.77,0.7 0.59,1.27 0.43,1.04 1.69,1.51 2.01,2.61 0.38,0.49 0.79,-0.37 1.26,-0.05 1.19,0.42 2.62,0.68 3.64,-0.27 0.47,-0.44 1.34,-0.57 1.48,0.23 0.58,0.85 1.67,1.03 2.6,0.94 1.42,0.97 3.25,0.59 4.82,1.15 1.05,-0.1 1.04,-1.53 1.24,-2.32 -0.04,-0.86 -1.19,-1.57 -0.6,-2.49 0.18,-0.4 0.95,-1.23 0.96,-0.3 0.24,0.79 1.39,1.22 1.91,0.42 0.43,-0.25 1.07,-0.29 1.05,-0.96 0,-0.46 -0.03,-1.04 0.59,-1.07 0.52,-0.3 1.73,0.11 1.61,-0.85 -0.03,-0.82 -0.75,-2.04 0.03,-2.69 0.91,-0.19 0.26,-1.07 0.06,-1.55 0.45,-0.64 -0.07,-1.82 -0.88,-1.71 -0.55,0.35 -1.1,0.66 -1.73,0.77 -0.3,0.21 -0.09,1.1 -0.65,0.59 -0.75,-0.43 -0.52,-1.81 -1.61,-1.78 -0.79,0.01 -1.16,-0.91 -1.97,-0.93 -1.01,-0.27 -2.01,0.28 -3.04,0.28 -0.81,0.35 -1.45,-0.37 -1.48,-1.14 -0.69,-1.01 -0.81,-2.24 -1.29,-3.34 -0.3,-0.57 -1.41,-0.55 -1.18,-1.4 0.25,-1.05 0.01,-1.81 -1.14,-1.45 -0.38,-0.33 -0.3,-1.22 0.14,-1.62 0.03,-0.55 0.45,-0.88 0.51,-1.41 0.88,-1.05 2.49,-0.61 3.49,-1.56 1.17,-0.66 2.5,-1.04 3.6,-1.78 0.49,-0.29 1.65,0.17 1.68,-0.62 -0.43,-0.37 -1.06,-0.57 -1.28,-1.19 -0.53,-0.61 -0.33,-1.44 0.27,-1.89 -0.02,-0.58 0.92,-0.47 0.76,-1.06 0.07,-0.54 0.47,-1.38 -0.33,-1.55 -0.37,-0.07 -1.1,-0.42 -0.74,-0.87 0.77,0.02 0.6,-0.89 0.07,-1.12 -0.29,-0.63 -0.3,-1.38 -0.55,-2.05 -0.11,-0.64 0.65,-1.51 0.02,-1.98 -0.64,-0.29 -1.65,-0.26 -2.12,-0.73 0.24,-1.17 0.21,-2.75 1.53,-3.3 1.16,-0.18 0.6,-0.9 -0.12,-1.31 -0.58,-0.28 -1.1,-0.64 -1.2,-1.35 -0.38,-1.33 1.26,-2.14 1.87,-3.1 0.95,-0.51 0.29,-1.24 -0.33,-1.64 -0.35,-0.35 -1.26,-0.16 -1.32,-0.72 0.69,-0.49 0.42,-1.61 -0.46,-1.65 -0.67,0.04 -1.54,-0.25 -1.5,-1.06 -0.64,-1.06 -1.04,-2.31 -1.02,-3.56 0.28,-0.54 1.4,-1.05 0.76,-1.72 -0.08,-0.37 -0.02,-1.18 -0.64,-0.86 -1.13,0.53 -2.31,-0.29 -3.24,-0.89 -0.74,-0.38 -1.56,-0.17 -2.29,-0.02 -0.66,-0.14 -1.39,-1.29 -1.88,-0.25 -0.29,0.2 -0.76,0.08 -0.86,0.59 -0.5,0.72 -0.1,1.62 -0.31,2.36 -0.75,0.65 -0.12,2.09 -0.48,2.71 -0.34,-1.11 -2.33,-0.97 -2.19,-2.3 0.34,-0.44 -0.05,-1.13 -0.58,-0.75 -0.64,0.27 -1.12,1.12 -1.68,1.28 0.38,-0.89 -0.49,-1.56 -0.62,-2.33 -0.16,-0.56 -0.46,-1.11 -0.24,-1.75 -0.01,-0.26 0.16,-0.97 -0.32,-0.9 z m -9.89,28.67 0,0.02 0,-0.02 z",
					    "department-22" : "m 77.62,0.14 c -1.39,0.92 -3.25,1.31 -4.29,2.65 0.01,0.98 -1.04,1.56 -1.5,2.19 0.48,-1.35 0.56,-2.92 0.2,-4.3 -0.68,-0.62 -1.33,0.55 -1.6,1.07 -0.24,0.5 -0.74,0.71 -1.23,0.64 -0.67,0.54 -1.76,-0.27 -2.49,0.36 -0.87,0.53 -2.1,0.46 -2.6,1.52 -0.45,0.49 -1.29,0.64 -1.87,0.47 0.24,-0.57 -0.07,-1.14 -0.7,-1.15 -0.65,-0.08 -0.96,-1.25 -1.63,-0.92 -0.42,0.64 -1.66,-0.34 -1.98,0.57 -0.36,0.14 -0.93,0.19 -0.73,0.77 0.26,0.62 -0.17,1.34 -0.88,1.17 -1.16,0.07 -1.34,1.97 -0.29,2.35 0.5,0.48 0.95,1.05 1.24,1.68 -0.69,0.27 -2.2,0.08 -2.04,1.23 -0.06,0.68 0.21,1.32 0.48,1.88 0.11,0.83 -1.02,1.34 -1.49,0.58 -0.38,-0.48 -1.26,-0.42 -1.27,0.27 -0.37,0.68 -1.51,0.94 -0.99,1.91 0.08,0.97 0.39,1.89 0.89,2.68 0.05,1.44 2.34,0.56 2.45,1.97 0.01,0.39 -0.5,1.12 0.18,1.16 0.76,0.01 1.16,0.97 1.82,1.11 -0.7,1.32 -2.32,2.16 -2.67,3.66 0.03,0.67 0.41,1.29 1.02,1.52 0.21,0.57 0.98,0.51 1.3,0.85 -0.73,0.81 -2.2,1.16 -2.19,2.51 0.02,0.54 -0.64,1.46 0.24,1.65 0.53,0.28 1.48,0.24 1.78,0.77 -0.1,0.92 -0.38,1.86 0.06,2.74 0.03,0.39 0.13,1.4 0.77,0.97 0.18,-0.29 1,-0.21 0.51,0.18 -0.27,0.46 -1.45,1.15 -0.66,1.67 0.35,0.27 1.18,0.47 0.76,1.05 -0.12,0.6 0.13,1.42 -0.64,1.61 -0.77,0.52 -1.09,1.6 -0.35,2.3 0.41,0.43 1.38,0.86 1.06,1.59 -0.52,0.07 -1.77,-0.39 -1.76,0.46 0.67,0.67 1.87,0.14 2.7,0.06 0.51,-0.19 1.03,-0.24 1.4,0.18 0.47,0.23 0.98,-0.13 1.24,-0.42 0.42,0.33 1.3,0.93 0.54,1.42 -0.56,0.61 0.64,1.44 1.14,0.82 0.89,-0.1 1.49,-0.89 2.41,-0.9 0.28,-0.25 0.65,-0.47 0.94,-0.07 0.28,0.66 0.91,0.92 1.58,0.9 0.52,0.19 0.9,0.91 1.55,0.5 0.61,-0.34 1.26,-0.21 1.89,-0.18 0.58,-0.33 0.94,-1.19 1.75,-0.92 0.72,-0.08 2.17,0.25 2.15,-0.86 -0.12,-0.88 0.29,-1.84 1.24,-1.99 0.92,-0.04 1.83,-0.27 2.74,0.02 0.54,0.1 1.03,0.37 1.46,0.66 0.27,0.8 0.61,2.26 1.7,2.14 0.73,-0.47 1.57,-0.62 2.42,-0.38 0.93,0.04 1.86,0.33 2.42,1.11 0.82,0.8 2.05,0.47 3.05,0.37 0.72,0.83 1.24,1.75 1.46,2.81 0.68,1.87 0.68,-1.29 1.68,-0.79 0.63,0 1.48,0.29 1.86,-0.35 0.51,-0.34 1.6,-1.17 1.95,-0.2 0.61,1.33 -0.08,2.72 -0.39,4.03 -0.29,1.24 1.43,2.34 2.31,1.3 0.82,-0.71 1.52,-1.63 2.57,-1.94 0.72,-0.53 -0.13,-1.59 0.77,-2.04 0.63,-0.72 1.63,-1.87 0.71,-2.77 -0.22,-0.19 -0.56,-0.77 -0.02,-0.72 0.74,0.01 1.5,-0.04 2.09,-0.5 0.6,-0.04 1.19,-0.2 1.68,-0.57 0.77,-0.13 1.88,0.05 2.07,0.92 0.54,0.72 1.43,1.3 1.37,2.31 0.17,0.86 0.85,0.32 1.13,-0.09 0.47,0.38 1.11,0.25 1.18,-0.43 0.41,-0.5 1.54,0.1 1.66,-0.77 0.35,-0.49 0.98,-0.38 1.45,-0.48 0.06,-0.68 0.98,-0.7 1.11,-1.37 0.33,-0.87 -0.09,-1.97 0.32,-2.75 0.47,-0.17 1.12,0.72 1.44,-0.01 2.1e-4,-0.97 -0.26,-2.32 0.88,-2.76 0.86,-0.46 1.85,-0.29 2.74,-0.16 0.58,-0.23 -0.01,-0.59 -0.08,-0.89 0.39,-0.55 1.43,-0.37 1.51,-1.21 0.38,-0.36 1.13,-0.96 1.46,-0.23 0.51,0.28 1.35,1.12 1.89,0.66 -0.05,-0.84 0.78,-1.19 1.52,-1.15 0.93,-0.54 0.61,-1.83 0.25,-2.63 0.17,-0.53 1.48,0.08 1.44,-0.79 -0.19,-0.6 -0.82,-1.12 -0.37,-1.79 0.31,-1.1 0.22,-2.35 -0.36,-3.32 -0.14,-0.67 0.15,-1.38 0.85,-1.55 0.54,-0.36 0.01,-0.92 0.14,-1.32 0.75,-0.41 0.72,-1.14 0.41,-1.8 0.45,-0.8 0.31,-1.85 -0.19,-2.56 0.17,-0.62 -0.5,-0.78 -0.77,-0.23 -0.41,0.46 -0.2,1.28 -0.96,1.44 -0.29,0.18 -1.1,1.1 -0.99,0.18 0.14,-0.5 0.35,-1.06 -0.11,-1.51 -0.37,-0.51 -0.84,-1.62 -1.62,-0.99 -0.45,0.14 -0.57,0.65 -0.73,0.93 -0.81,-0.12 -0.43,-1.15 -0.83,-1.59 -0.88,-0.28 -1.98,-0.11 -2.51,-1.07 -0.78,-0.58 -0.86,-2.15 -2.05,-2.07 -0.72,0.35 -0.82,1.18 -0.53,1.85 -0.08,0.44 -0.82,0.92 -0.92,0.19 -0.22,-1.13 -0.67,-0.28 -0.94,0.27 -0.44,0.5 -0.31,-0.57 -0.55,-0.79 0.01,-0.69 -0.52,-1.09 -0.98,-1.52 -0.44,-0.56 0.04,-1.7 -0.66,-2 -1.12,0.42 -1.97,1.37 -2.85,2.08 -0.76,-0.27 -0.39,-1.26 0.16,-1.56 0.4,-0.59 1.15,-1.47 0.81,-2.14 -0.52,-0.53 -1.52,-1.71 -1.55,-0.3 -0.79,0.85 -2.11,1.07 -2.99,1.87 -0.29,0.16 -0.98,0.87 -0.94,0.12 -0.39,-0.73 -1.49,-0.27 -2.16,-0.32 -0.39,-0.06 -1.38,0.3 -0.76,0.72 0.34,0.1 0.85,0.16 0.42,0.54 -0.93,1.17 -2.24,2.1 -3.74,2.31 -1.55,1.32 -2.62,3.25 -4.32,4.39 -0.51,-0.05 -1.42,-0.9 -1.65,-0.02 -0.14,0.51 0.11,1.32 -0.2,1.71 -0.7,-0.59 -1.45,-1.29 -1.91,-2.07 0.25,-0.58 0.43,-1.52 -0.38,-1.74 -1.36,-0.24 -2.02,-1.69 -3.33,-2.08 -0.84,-0.81 -0.35,-2.22 -0.66,-3.25 -0.14,-1.13 -1.33,-1.81 -2.24,-2.31 -0.97,-0.19 -0.78,-1.46 -1.63,-1.85 -0.62,-0.49 -1.54,-1.1 -1.61,-1.93 0.39,-0.78 0.21,-2.5 -1.03,-2.09 -0.92,0 -2.08,-0.19 -2.76,-0.79 -0.07,-0.42 -0.65,-0.34 -0.84,-0.53 0.24,-0.82 1.69,-0.73 1.4,-1.79 0.14,-1.23 -1.34,-0.62 -2.08,-0.72 -1.3,0.01 -1.08,1.66 -1.64,2.44 -0.39,0.65 -0.71,1.67 -1.39,1.95 -0.04,-0.84 0.61,-1.44 1.15,-1.98 0.26,-0.82 0.71,-1.61 0.76,-2.48 -0.51,-1.01 0.27,-2.33 -0.5,-3.27 l -0.14,0.02 z",
					    "department-56" : "m 78.94,44.19 c -0.1,7e-4 -0.21,0 -0.32,0.01 -0.92,0.04 -2.31,-0.07 -2.54,1.12 0.15,0.69 -0.1,1.78 -0.98,1.73 -0.55,-0.16 -0.93,0.39 -1.48,0.05 -0.7,-0.15 -1.37,0.5 -1.14,1.16 -0.69,0.02 -1.41,-0.72 -2.11,-0.2 -0.52,0.56 -1.31,0.29 -1.68,-0.28 -0.32,-0.37 -0.93,-0.33 -1.07,0.08 -0.56,0.11 -0.21,-0.85 -0.69,-1.03 -0.83,-0.41 -1.76,0.41 -2.53,0.67 -0.59,0.22 -1.33,1.06 -1.85,0.25 -1.14,-0.36 0.54,-1.24 -0.25,-1.82 -0.48,-0.42 -0.85,0.44 -1.41,0.09 -0.53,-0.26 -1.1,-0.52 -1.67,-0.19 -1,0.16 -2.12,0.24 -3.04,-0.17 -1.3,0.5 -2.66,0.86 -3.8,1.72 -0.57,0.38 -1.23,0.43 -1.85,0.44 -0.6,0.18 -0.86,0.76 -1.03,1.28 -0.31,0.39 -0.29,0.94 -0.66,1.31 -0.25,0.59 0.33,1.03 0.87,0.89 0.35,-0.01 0.8,0.19 0.47,0.6 -0.35,0.72 -0.19,1.69 0.68,1.94 1.02,0.65 0.7,2.12 1.38,3.04 0.45,0.56 0.32,1.97 1.32,1.8 1.06,-0.1 2.13,-0.39 3.18,-0.4 0.97,0.17 1.63,1.01 2.62,1.07 0.85,0.25 0.55,1.43 1.31,1.7 0.44,-0.04 0.25,-0.73 0.83,-0.64 0.66,-0.11 1.3,-0.94 1.83,-0.81 0.38,0.48 1.31,1.23 0.69,1.83 -0.01,0.53 0.76,1.42 0,1.74 -1.09,0.5 -0.15,1.79 -0.24,2.63 0.08,0.47 0.21,1.46 -0.55,0.96 -0.65,-0.51 -1.66,0.3 -1.58,1.07 -0.13,0.67 -0.68,0.88 -1.22,1.11 -0.56,0.79 -1.41,0.11 -1.91,-0.35 -0.45,-0.47 -1.13,-0.02 -0.88,0.59 0.02,0.9 1.25,1.51 0.6,2.44 -0.34,0.77 -0.48,1.78 0.28,2.35 0.93,1.3 1.35,3.41 3.11,3.83 1.1,-0.39 2.65,0.24 3.45,-0.79 0.43,-0.7 -0.56,-1.19 -0.84,-1.49 0.77,0.1 1.58,-0.05 2.05,-0.71 0.84,-0.73 1.75,-1.56 2.65,-2.11 -0.9,0.92 -0.87,2.68 -2.35,3.02 -0.42,0.28 -0.08,0.91 -0.58,1.22 -0.3,0.81 1.16,0.19 1.59,0.58 0.62,0.14 1.34,0.46 1.27,1.2 0.67,0.8 1.87,1.04 2.46,1.98 0.29,0.63 1.09,0.39 1.04,-0.29 -0.04,-0.7 0.75,-1.35 0.45,-2 0.64,-0.03 0.63,-1.13 1.44,-0.89 0.58,-0.55 0.01,-1.57 -0.42,-2.07 -0.41,-0.26 -0.6,-0.85 0.06,-0.51 0.52,0.37 1.23,0.52 1.57,-0.17 0.34,-0.06 0.05,0.78 0.07,1.01 -0.15,0.72 0.73,0.25 0.93,0.44 0.05,0.53 0.39,1.34 0.08,1.78 -0.97,0.26 -1.67,1.06 -2.69,1.19 -1.23,0.39 -1.22,2.05 -1.01,3.09 0.73,0.77 1.81,1.22 2.39,2.11 -0.63,1.41 -0.23,4.9 -0.1,5.8 0.14,0.87 1.19,1.11 1.91,0.93 0.29,-0.7 -0.9,-1.06 -0.98,-1.75 -0.22,-0.5 -0.15,-2.41 -0.2,-3.88 0.15,0.09 0.31,0.06 0.34,-0.23 -0.13,-0.46 0.3,-0.59 0.59,-0.26 0.26,0.26 1.16,0.62 0.53,0.95 -0.11,0.7 0.98,0.38 1.35,0.31 0.77,-0.24 1.61,-0.2 2.39,-0.34 0.11,-0.46 -0.42,-1.57 0.2,-1.75 0.32,0.63 0.19,1.76 0.94,2.06 0.57,-0.09 -0.17,-1.46 0.5,-0.73 0.65,0.58 0.97,1.51 1.96,1.61 0.77,0.05 0.03,-0.88 -0.19,-1.16 -0.72,-0.72 -0.97,-1.68 -0.69,-2.66 0.23,-0.87 -0.77,-1.67 -0.63,-2.37 0.49,0.54 0.97,1.33 1.56,1.64 -0.16,0.61 -0.34,1.93 0.68,1.8 0.63,-0.35 0.37,0.52 0.86,0.68 0.32,0.36 1.01,0.52 1.05,-0.17 0.05,-0.65 0.54,-0.55 0.98,-0.52 0.74,-0.21 0,-1.53 0.94,-1.33 0.9,-0.2 2.03,0.32 2.79,-0.26 0.33,-0.32 -0.43,-0.88 0.27,-0.69 0.6,-0.04 1.21,0.1 1.36,0.76 0.26,0.33 0.68,0.62 -0.02,0.4 -0.71,0.03 -0.08,0.78 0.29,0.84 0.47,0.15 1.31,0.94 1.67,0.34 0.04,-0.35 -0.52,-0.53 -0.01,-0.75 0.6,-0.35 0.27,-0.99 -0.06,-1.3 0.78,-0.21 0.93,1.07 0.93,1.62 -0.16,1.45 -1.81,2.19 -1.99,3.66 -0.29,0.83 -1.58,0.63 -2.13,0.28 -0.08,-0.81 -0.83,0.08 -1.16,-0.12 -0.19,-0.5 -0.69,-0.34 -0.73,0.11 -0.66,0.13 -1.71,0.29 -1.98,-0.54 -0.63,-0.44 -1.64,-0.58 -2.32,-0.23 -0.4,0.55 0.35,0.99 0.79,1.03 0.57,0.68 1.71,0.83 1.99,1.82 0.11,0.97 0.82,1.67 1.79,1.81 0.91,0.34 1.53,-0.66 2.43,-0.66 1.09,-0.42 2.21,-0.36 3.27,0.11 0.96,0.21 0.88,-1.05 1.06,-1.64 0.53,0.17 1.63,0.59 1.84,-0.16 -0.05,-0.35 -0.72,-0.87 -0.02,-0.8 0.7,0.18 1.46,-0.14 2.04,-0.32 -0.19,0.7 -1.07,0.81 -1.36,1.36 0.41,0.59 1.47,0.17 2.1,0.25 0.93,-0.04 1.83,-1.02 2.76,-0.35 0.87,0.38 1.82,0.59 2.65,1.14 0.84,0.52 1.74,0.12 2.59,-0.02 0.32,0.05 1.3,0.38 0.55,0.43 -1.5,0.15 -3,0.3 -4.55,0.32 -0.61,-0.09 -0.89,0.42 -0.66,0.94 0.2,0.73 -0.26,2.06 0.64,2.39 1.01,-0.25 1.03,-1.53 1.94,-1.93 0.28,-0.32 0.89,-0.56 0.8,0.08 0.22,0.84 1.3,0.8 1.91,0.44 0.69,-0.17 1.2,0.57 1.91,0.15 0.71,-0.02 0.96,-0.64 0.92,-1.26 0.26,-0.74 0.74,-1.43 0.76,-2.26 0.59,0.16 1.59,-0.14 2.01,0.36 -0.34,0.58 0.42,0.95 0.86,0.58 0.64,-0.25 1.56,-1.23 2.23,-0.63 -0.02,0.6 0.23,1.33 1,0.97 0.93,-0.36 0.02,-2.02 1.23,-2.16 0.83,-0.25 2.1,-0.23 1.72,-1.48 0.19,-1.17 -0.54,-2.52 0.4,-3.51 0.5,-0.71 0.2,-1.64 -0.44,-2.13 0.04,-0.59 -0.72,-0.87 -0.42,-1.48 0.23,-0.62 0.28,-1.53 -0.5,-1.73 -0.13,-0.86 -0.23,-1.79 -0.29,-2.65 0.58,-0.88 1.6,-1.18 2.61,-1.14 0.73,-0.14 0.13,-0.86 -0.4,-0.68 -0.36,-0.19 -0.42,-0.76 -0.96,-0.7 -0.34,-0.11 -1.17,0.06 -1.27,-0.31 0.49,-0.51 0.96,-1.03 1.7,-1.1 1.1,-0.47 0.56,-2.08 1.75,-2.44 0.56,-0.26 0.72,-0.98 0.18,-1.35 -0.15,-0.39 -0.34,-1.46 -0.89,-0.81 -0.47,0.35 -1.51,0.96 -1.79,0.11 0.26,-0.58 0.3,-1.21 -0.19,-1.67 -0.37,-0.94 0.4,-1.76 1.18,-2.13 0.52,-0.96 -0.7,-1.76 -0.85,-2.67 -0.63,-0.81 -1.21,-1.95 -2.25,-2.25 -0.71,0.21 -1.37,-0.02 -1.92,-0.47 -1.28,-0.75 -2.78,-0.36 -4.13,-0.2 -0.4,-0.59 0.47,-1.02 0.17,-1.63 0.23,-1 1.16,-1.75 1.93,-2.36 0.96,-0.28 2.64,0.3 3.02,-0.97 0.21,-0.53 -0.15,-1.13 -0.76,-0.88 -0.78,0.1 -1.95,0.12 -2.05,1.07 -0.62,0.22 -1.14,0.01 -0.89,-0.76 0.11,-1.3 -0.13,-2.71 -1.29,-3.49 -0.62,-0.68 -1.57,-0.25 -1.92,0.47 -0.46,0.16 -1.27,-0.25 -1.35,0.55 -0.4,0.31 -0.71,-0.59 -0.81,-0.89 -0.25,-1.06 -1.15,-1.8 -1.75,-2.65 -0.66,-0.45 -1.65,-0.48 -2.17,0.14 -0.48,0.1 -1.02,0.08 -1.4,0.4 -0.5,0.1 -1.93,-0.16 -1.61,0.75 0.95,0.82 0.04,2.07 -0.62,2.75 -0.63,0.49 -0.41,1.28 -0.6,1.92 -0.57,0.66 -1.53,0.69 -2.04,1.45 -0.57,0.61 -1.21,1.31 -2.14,1.19 -0.44,0.17 -0.95,0.5 -0.87,-0.29 -0.29,-0.29 -0.49,-0.63 -0.38,-1.12 0.09,-1.49 1.19,-3.03 0.43,-4.52 -0.67,-0.71 -1.56,0.4 -2.05,0.85 -0.63,0.25 -1.5,-0.43 -2.07,0.21 -0.4,0.39 -0.53,1.35 -1.12,1.42 -0.38,-1.04 -0.36,-2.3 -1.22,-3.14 -0.54,-1.14 -1.94,0.06 -2.83,-0.55 -0.84,-0.22 -1.04,-1.25 -1.96,-1.3 -1.13,-0.3 -2.43,-0.54 -3.44,0.19 -0.44,0.18 -1.02,0.11 -0.99,-0.45 -0.65,-0.4 -0.56,-1.37 -1.14,-1.82 -0.58,-0.43 -1.23,-0.62 -1.96,-0.61 z",
					    "department-35" : "m 134.51,11.19 c -1.01,0.48 -2.08,1.16 -3.2,0.58 -0.5,-0.27 -1,0.08 -0.89,0.62 -0.63,0.28 -1.8,-0.42 -2.1,0.39 0.18,0.91 -0.58,1.58 -1.42,1.67 -0.9,0.64 0.08,1.86 0.26,2.64 0.27,0.8 0.74,1.72 1.72,1.68 0.37,0.17 0.9,0.75 0.74,1.11 -0.34,-0.04 -1.06,-0.42 -0.95,0.24 0.02,0.86 1.14,1.18 0.88,2.11 0.24,0.95 0.95,-0.66 1.45,-0.89 0.41,0.21 0.6,1.14 0.86,1.62 0.42,0.57 0.08,1.14 -0.12,1.69 0.07,0.61 0.72,1.4 -0.24,1.62 -0.51,0.49 0.21,1.44 -0.6,1.74 -0.68,0.38 -0.84,1.35 -0.21,1.83 0.19,0.6 0.12,1.33 0.47,1.88 -0.74,0.65 -0.77,1.9 -0.06,2.57 0.29,0.9 -1.7,0.63 -1.26,1.66 0.15,0.78 0.11,1.68 -0.14,2.41 -0.52,0.3 -0.63,-0.67 -1.2,-0.29 -0.69,0.15 -0.56,1.56 -1.43,1.09 -0.67,-0.16 -1.23,-0.58 -1.73,-0.98 -0.71,-0.06 -0.78,0.71 -1.15,1.1 -0.26,0.4 -1.31,0.06 -1,0.76 0.38,0.36 -0.23,1.42 -0.66,0.81 -1.31,-0.71 -3.5,0.2 -3.17,1.9 0.15,0.47 0.35,1.26 -0.38,1.28 -0.41,0.05 -1.07,-0.7 -1.1,0.05 -0.21,0.93 0.23,2.41 -0.73,2.99 -0.78,0.11 0.16,0.96 -0.49,1.14 -0.48,0.07 -0.87,-0.55 -1.37,-0.12 -0.93,0.48 0.13,1.38 0.49,1.87 1.02,0.89 0.32,2.36 0.82,3.46 0.59,0.23 0.31,-0.76 0.87,-0.77 0.77,-0.24 1.83,-0.62 2.56,-0.14 0.49,0.94 -0.46,1.88 -1.41,1.84 -0.92,0.14 -2.07,-0.28 -2.54,0.81 -0.56,0.55 -1.06,1.24 -0.87,2.05 -0.18,0.3 -0.54,0.95 0.13,0.89 1.5,-0.49 3.11,-0.13 4.44,0.65 0.62,0.31 1.43,-0.32 1.84,0.46 0.76,0.82 1.7,1.56 1.95,2.72 0.37,0.58 1.08,1.24 0.54,1.96 -0.24,0.59 -1.09,0.54 -1.19,1.27 -0.26,0.82 0.75,1.44 0.36,2.27 -0.1,0.91 1.13,0.37 1.42,-0.05 0.29,-0.16 0.44,-1.12 0.86,-0.8 0.04,0.77 -0.13,1.73 0.72,2.14 -0.12,0.78 -0.82,1.18 -1.37,1.61 -0.29,0.6 -0.17,1.36 -0.86,1.74 -0.31,0.48 -1.43,0.31 -1.23,1.1 0.38,0.34 1.09,0.07 1.37,0.63 0.3,0.39 1.13,0.14 0.94,0.84 0.15,0.89 -1.17,0.31 -1.72,0.63 -0.49,0.22 -1.3,0.56 -1.22,1.19 0.68,0.72 -0.39,2.06 0.71,2.46 0.72,0.28 0.01,1.25 0.03,1.8 0.16,0.85 1.18,0.28 1.67,0.09 0.53,0.07 1.02,-0.16 1.06,-0.71 0.6,-0.68 1.76,-0.18 2.32,-1.02 0.4,-0.26 0.87,-1.11 1.34,-1.02 0.08,0.41 -0.03,1.52 0.72,1.18 0.84,-1.02 2.22,-1.22 3.44,-1.45 0.54,-0.36 1.01,-0.97 1.76,-0.73 1.38,0.05 2.76,0.81 4.1,0.14 0.62,-0.28 0.96,0.65 1.58,0.22 0.49,-0.46 1.05,-0.81 1.77,-0.63 1.23,0.11 2,-1.19 1.97,-2.28 0.13,-0.87 0.94,-1.16 1.6,-1.5 0.07,-0.51 0.5,-0.67 1,-0.74 1.01,-0.34 2.22,-0.17 2.96,-1.07 0.53,-0.6 1.99,0.11 1.94,-0.94 0.04,-0.5 -0.65,-1.06 -0.39,-1.48 1.32,-0.06 2.77,0.19 4.07,0.41 0.89,0.68 1.11,2.13 2.47,2.1 1.34,0.27 2.67,1 4.04,0.97 0.68,-0.66 -0.01,-1.9 0.84,-2.52 0.83,-0.6 0.36,-1.62 0.51,-2.41 0.57,-0.3 1.52,-0.7 1.03,-1.52 -0.36,-0.88 0.99,-1.03 0.86,-1.89 0.77,-1.21 0.34,-2.86 1.21,-4 0.62,-0.24 1.11,-0.68 1.44,-1.27 1.05,-0.54 2.31,0.55 3.39,-0.09 0.54,-0.35 1.37,-0.62 1.14,-1.46 -0.46,-1.13 -0.74,-2.45 -0.28,-3.63 -0.19,-0.74 -1.08,-1.11 -1.09,-1.97 -0.4,-1.47 -0.23,-3.14 -1.08,-4.44 -0.24,-1.09 -0.22,-2.28 -0.55,-3.34 0.22,-1.32 -0.93,-2.52 -0.5,-3.87 0.14,-1.61 1.8,-2.46 2.17,-3.93 -0.47,-1.08 -0.65,-2.36 -0.38,-3.53 -0.1,-1.11 -1.21,-1.82 -1.09,-3 -0.35,-0.87 0.78,-1.25 0.64,-2.11 -0.04,-0.7 -0.58,-1.26 -0.42,-2.02 0.04,-0.5 0.05,-1.39 -0.68,-1.29 -0.77,-0.32 -1.52,-0.95 -2.36,-0.47 -0.68,-0.11 -1.23,-0.86 -1.99,-0.67 -0.55,-0.33 -1.09,-0.78 -1.8,-0.65 -0.59,0.03 -1.22,-0.62 -1.69,0.05 -0.5,0.6 -0.19,1.78 -1.11,2.03 -0.51,0.41 -1.08,0.59 -1.66,0.84 -0.2,0.35 -0.39,0.48 -0.77,0.42 -0.41,0.29 -0.02,1 -0.6,1.2 -0.61,0.46 -1.34,1.05 -2.13,0.65 -0.82,10e-5 -1.91,-0.27 -1.87,-1.29 -0.5,-0.86 -2.16,-0.09 -2.44,-1.17 -0.25,-1.18 -1.01,-2.23 -1.62,-3.25 -0.47,-0.65 0.75,-1.77 -0.33,-2.19 -0.45,-0.57 1.7e-4,-1.58 -0.82,-1.97 -0.77,-0.34 -0.6,-1.29 -1.15,-1.76 -1.14,-0.3 -1.72,1.33 -2.85,1.35 -1.8,0.34 -3.66,0.45 -5.49,0.45 -0.45,0.62 -1.37,-0.04 -2.04,0.06 -0.93,0.01 -1.93,-0.21 -2.29,-1.19 -0.64,-0.88 -0.89,-2.26 -0.04,-3.09 0.89,-0.17 0.63,-1.89 0.06,-2.12 z"
					}
				}
			}
		}
	);
})(jQuery);