'''OpenGL extension AMD.gpu_shader_half_float

This module customises the behaviour of the 
OpenGL.raw.GL.AMD.gpu_shader_half_float to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension was developed based on the NV_gpu_shader5 extension to
	allow implementations supporting half float in shader and expose the
	feature without the additional requirements that are present in
	NV_gpu_shader5.
	
	The extension introduces the following features for all shader types:
	
	  * support for half float scalar, vector and matrix data types in shader;
	
	  * new built-in functions to pack and unpack half float types into a
	    32-bit integer vector;
	
	  * half float support for all existing single float built-in functions,
	    including angle functions, exponential functions, common functions,
	    geometric functions, matrix functions and etc.;
	
	This extension is designed to be a functional superset of the half-precision
	floating-point support from NV_gpu_shader5 and to keep source code compatible
	with that, thus the new procedures, functions, and tokens are identical to
	those found in that extension.
	

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/AMD/gpu_shader_half_float.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.AMD.gpu_shader_half_float import *
from OpenGL.raw.GL.AMD.gpu_shader_half_float import _EXTENSION_NAME

def glInitGpuShaderHalfFloatAMD():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION