/*
 * Decompiled with CFR 0.152.
 */
package jalview;

import jalview.AlignFrame;
import jalview.Alignment;
import jalview.ClustalxColourScheme;
import jalview.ColourAdapter;
import jalview.ColourScheme;
import jalview.ConsThread;
import jalview.DrawableSequence;
import jalview.ResidueColourScheme;
import jalview.SequenceGroup;
import jalview.TaylorColourScheme;
import java.applet.Applet;
import java.util.StringTokenizer;

public class AlignApplet
extends Applet {
    String input;
    String type;
    AlignFrame af;
    String fontSize = "10";
    String format = "MSF";
    int noGroups;
    String consString = "*";
    String local = "";
    ConsThread ct;
    String mailServer;
    String clustalServer;
    String srsServer;
    String database;

    public void init() {
        this.input = this.getParameter("input");
        this.type = this.getParameter("type");
        this.fontSize = this.getParameter("fontsize");
        this.mailServer = this.getParameter("mailServer");
        this.clustalServer = this.getParameter("clustalServer");
        this.srsServer = this.getParameter("srsServer");
        this.database = this.getParameter("database");
        this.local = this.getParameter("local");
        try {
            this.noGroups = Integer.valueOf(this.getParameter("groups"));
            System.out.println("Number of groups = " + this.noGroups);
        }
        catch (Exception exception) {}
        this.format = this.getParameter("format");
        if (this.format == null || this.format.equals("")) {
            this.format = "MSF";
        }
        this.format = this.format.toUpperCase();
        System.out.println("Format = " + this.format);
        this.consString = this.getParameter("Consensus");
        if (this.consString == null) {
            this.consString = "*";
        }
        this.componentInit();
    }

    public void componentInit() {
        this.makeFrame();
    }

    public void makeFrame() {
        try {
            int n;
            int n2;
            this.getParameter("numseqs");
            if (this.getParameter("numseqs") == null) {
                this.af = new AlignFrame(this, this.input, this.type, this.format);
            } else {
                n2 = Integer.valueOf(this.getParameter("numseqs"));
                n = 0;
                int n3 = 0;
                DrawableSequence[] drawableSequenceArray = new DrawableSequence[n2];
                while (n < n2) {
                    String string = this.getParameter("seq" + (n + 1));
                    if (string != null) {
                        String string2 = this.getParameter("id" + (n + 1));
                        if (string2 == null) {
                            string2 = "Seq_" + n;
                        }
                        drawableSequenceArray[n3] = new DrawableSequence(string2, string, 1, string.length());
                        ++n3;
                    } else {
                        System.out.println("Can't read sequence " + (n + 1));
                    }
                    ++n;
                }
                if (n3 > 0) {
                    this.af = new AlignFrame(this, drawableSequenceArray);
                } else {
                    System.out.println("No sequences found");
                    this.stop();
                }
            }
            this.af.setTitle("Jalview alignment editor");
            if (this.mailServer != null) {
                this.af.mp.server = !this.mailServer.equals("") ? this.mailServer : "";
            }
            if (this.srsServer != null && !this.srsServer.equals("")) {
                if (!this.srsServer.substring(this.srsServer.length() - 1).equals("/")) {
                    this.srsServer = String.valueOf(this.srsServer) + "/";
                }
                this.af.srsServer = this.srsServer;
                System.out.println("Srs server = " + this.af.srsServer);
            }
            if (this.database != null && !this.database.equals("")) {
                this.af.database = this.database;
                System.out.println("Srs database = " + this.af.database);
            }
            try {
                n2 = Integer.valueOf(this.fontSize);
                this.af.ap.seqPanel.seqCanvas.setFont(0, n2);
            }
            catch (Exception exception) {
                System.out.println("Exception in font size : " + exception);
                this.af.ap.seqPanel.seqCanvas.setFont(0, 10);
            }
            System.out.println("Consensus string " + this.consString);
            if (this.consString.equals("*")) {
                this.af.ap.selectAll(true);
            } else {
                int[] nArray = this.selectSeqs(this.consString);
                n = 0;
                this.af.ap.selectAll(false);
                while (n < nArray.length && nArray[n] != -1) {
                    this.af.ap.sel.addElement(this.af.ap.seqPanel.align.sequences[nArray[n]]);
                    ++n;
                }
            }
            this.af.status.setText("Calculating consensus...");
            this.af.ap.seqPanel.align.percentIdentity(this.af.ap.sel);
            this.af.ap.seqPanel.align.percentIdentity2();
            this.af.ap.seqPanel.align.findQuality();
            this.af.cons = this.af.ap.seqPanel.align.cons;
            this.af.status.setText("done");
            if (this.noGroups > 0) {
                int n4 = 0;
                while (n4 < this.noGroups) {
                    this.af.status.setText("Parsing group " + (n4 + 1));
                    String string = this.getParameter("group" + (n4 + 1));
                    System.out.println("Group = " + string);
                    this.parseGroup(this.af.ap.seqPanel.align, string);
                    ++n4;
                }
            } else {
                this.af.status.setText("Setting colour scheme...");
                ClustalxColourScheme clustalxColourScheme = new ClustalxColourScheme(this.af.ap.seqPanel.align.cons2, this.af.ap.seqPanel.align.size());
                this.af.ap.seqPanel.align.setColourScheme(clustalxColourScheme);
            }
            this.af.status.setText("done");
            this.af.updateFont();
            this.af.ap.selectAll(false);
            this.af.ap.idPanel.idCanvas.paintFlag = true;
            this.af.ap.idPanel.idCanvas.repaint();
            return;
        }
        catch (Exception exception) {
            System.out.println("Exception in applet : " + exception);
            return;
        }
    }

    public void parseGroup(Alignment alignment, String string) {
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        try {
            ColourScheme colourScheme;
            int[] nArray = this.selectSeqs(stringTokenizer.nextToken());
            String string2 = stringTokenizer.nextToken();
            bl = false;
            string2.toUpperCase();
            System.out.println(string2);
            if (string2.equals("SECONDARY")) {
                string2 = "Secondary structure";
            }
            if (string2.equals("ZAPPO")) {
                string2 = "Zappo";
            }
            if (string2.equals("TAYLOR")) {
                string2 = "Taylor";
            }
            if (string2.equals("HYDROPHOBIC")) {
                string2 = "Hydrophobic";
            }
            if (string2.equals("USERDEFINED")) {
                string2 = "User defined";
            }
            if (string2.equals("HELIX")) {
                string2 = "Helix";
            }
            if (string2.equals("STRAND")) {
                string2 = "Strand";
            }
            if (string2.equals("TURN")) {
                string2 = "Turn";
            }
            if (string2.equals("CLUSTALX")) {
                string2 = "Clustalx";
            }
            if ((colourScheme = ColourAdapter.get(string2)) == null) {
                colourScheme = new TaylorColourScheme();
            }
            System.out.println("Colour scheme = " + colourScheme);
            string2 = stringTokenizer.nextToken();
            string2 = string2.toUpperCase();
            if (string2.equals("TRUE")) {
                bl2 = true;
            } else if (string2.equals("FALSE")) {
                bl2 = false;
            }
            string2 = stringTokenizer.nextToken();
            string2 = string2.toUpperCase();
            if (string2.equals("TRUE")) {
                bl3 = true;
            } else if (string2.equals("FALSE")) {
                bl3 = false;
            }
            string2 = stringTokenizer.nextToken();
            string2 = string2.toUpperCase();
            if (string2.equals("TRUE")) {
                bl4 = true;
            } else if (string2.equals("FALSE")) {
                bl4 = false;
            }
            System.out.println("boxes = " + bl2);
            System.out.println("text = " + bl3);
            SequenceGroup sequenceGroup = new SequenceGroup(colourScheme, true, bl2, bl3, bl4, true);
            System.out.println("Sequence group " + sequenceGroup);
            this.af.ap.seqPanel.align.addGroup(sequenceGroup);
            int n = 0;
            while (nArray[n] != -1) {
                if (this.af.ap.seqPanel.align.sequences[nArray[n]] != null) {
                    if (this.af.ap.seqPanel.align.findGroup(nArray[n]) != null) {
                        this.af.ap.seqPanel.align.removeFromGroup(this.af.ap.seqPanel.align.findGroup(nArray[n]), this.af.ap.seqPanel.align.sequences[nArray[n]]);
                    }
                    sequenceGroup.addSequence(this.af.ap.seqPanel.align.sequences[nArray[n]]);
                }
                ++n;
            }
            System.out.println("Colourscheme is " + colourScheme);
            if (this.af.cons != null && colourScheme instanceof ResidueColourScheme) {
                System.out.println("Setting colour scheme " + colourScheme);
                ((ResidueColourScheme)sequenceGroup.colourScheme).cons = this.af.cons;
            }
            if (this.af.cons != null && colourScheme instanceof ClustalxColourScheme) {
                System.out.println("Setting colour scheme " + colourScheme);
                ((ClustalxColourScheme)sequenceGroup.colourScheme).cons = this.af.cons;
                System.out.println("Consensus is" + this.af.cons);
            }
            this.af.ap.seqPanel.align.displayText(sequenceGroup);
            this.af.ap.seqPanel.align.displayBoxes(sequenceGroup);
            this.af.ap.seqPanel.align.colourText(sequenceGroup);
            this.af.ap.seqPanel.align.setColourScheme(sequenceGroup);
            return;
        }
        catch (Exception exception) {
            System.out.println("Exception : " + exception);
            return;
        }
    }

    public int[] selectSeqs(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int[] nArray = new int[2000];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("*")) {
                int n2 = 0;
                while (n2 < this.af.ap.seqPanel.align.sequences.length) {
                    nArray[n2] = n2;
                    ++n2;
                }
                continue;
            }
            if (string2.indexOf("-") >= 0) {
                try {
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "-");
                    int n3 = Integer.valueOf(stringTokenizer2.nextToken());
                    int n4 = Integer.valueOf(stringTokenizer2.nextToken());
                    if (n4 <= n3) continue;
                    int n5 = n3;
                    while (n5 <= n4) {
                        nArray[n] = n5 - 1;
                        ++n;
                        ++n5;
                    }
                }
                catch (Exception exception) {
                    System.out.println("Exception : " + exception);
                }
                continue;
            }
            try {
                nArray[n] = Integer.valueOf(string2) - 1;
                System.out.println("Adding " + nArray[n] + " to group");
                ++n;
            }
            catch (Exception exception) {
                System.out.println("Exception : " + exception);
            }
        }
        nArray[n] = -1;
        return nArray;
    }
}

