/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.Serializable;
import org.armedbear.lisp.Binding;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.FunctionBinding;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.Symbol;

public final class Environment
extends LispObject
implements Serializable {
    Binding vars;
    FunctionBinding lastFunctionBinding;
    private Binding blocks;
    private Binding tags;
    public boolean inactive;
    public static final Primitive MAKE_ENVIRONMENT = new Primitive("make-environment", Lisp.PACKAGE_SYS, true, "&optional parent-environment"){

        @Override
        public LispObject execute() {
            return new Environment();
        }

        @Override
        public LispObject execute(LispObject arg) {
            if (arg == Lisp.NIL) {
                return new Environment();
            }
            return new Environment(Lisp.checkEnvironment(arg));
        }
    };
    public static final Primitive ENVIRONMENT_ADD_MACRO_DEFINITION = new Primitive("environment-add-macro-definition", Lisp.PACKAGE_SYS, true, "environment name expander"){

        @Override
        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            Environment env = Lisp.checkEnvironment(first);
            LispObject name = second;
            LispObject expander = third;
            env.addFunctionBinding(name, expander);
            return env;
        }
    };
    public static final Primitive ENVIRONMENT_ADD_FUNCTION_DEFINITION = new Primitive("environment-add-function-definition", Lisp.PACKAGE_SYS, true, "environment name lambda-expression"){

        @Override
        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            Lisp.checkEnvironment(first).addFunctionBinding(second, third);
            return first;
        }
    };
    public static final Primitive ENVIRONMENT_ADD_SYMBOL_BINDING = new Primitive("environment-add-symbol-binding", Lisp.PACKAGE_SYS, true, "environment symbol value"){

        @Override
        public LispObject execute(LispObject first, LispObject second, LispObject third) {
            Lisp.checkEnvironment(first).bind(Lisp.checkSymbol(second), third);
            return first;
        }
    };
    private static final Primitive EMPTY_ENVIRONMENT_P = new Primitive("empty-environment-p", Lisp.PACKAGE_SYS, true, "environment"){

        @Override
        public LispObject execute(LispObject arg) {
            return Lisp.checkEnvironment(arg).isEmpty() ? Lisp.T : Lisp.NIL;
        }
    };
    private static final Primitive ENVIRONMENT_VARS = new Primitive("environment-variables", Lisp.PACKAGE_SYS, true, "environment"){

        @Override
        public LispObject execute(LispObject arg) {
            Environment env = Lisp.checkEnvironment(arg);
            LispObject result = Lisp.NIL;
            Binding binding = env.vars;
            while (binding != null) {
                if (!binding.specialp) {
                    result = result.push(new Cons(binding.symbol, binding.value));
                }
                binding = binding.next;
            }
            return result.nreverse();
        }
    };
    private static final Primitive ENVIRONMENT_ALL_VARS = new Primitive("environment-all-variables", Lisp.PACKAGE_SYS, true, "environment"){

        @Override
        public LispObject execute(LispObject arg) {
            Environment env = Lisp.checkEnvironment(arg);
            LispObject result = Lisp.NIL;
            Binding binding = env.vars;
            while (binding != null) {
                LispObject symbolValue;
                result = binding.specialp ? ((symbolValue = ((Symbol)binding.symbol).symbolValueNoThrow()) != null ? result.push(new Cons(binding.symbol, symbolValue)) : result.push(binding.symbol)) : result.push(new Cons(binding.symbol, binding.value));
                binding = binding.next;
            }
            return result.nreverse();
        }
    };
    private static final Primitive ENVIRONMENT_ALL_FUNS = new Primitive("environment-all-functions", Lisp.PACKAGE_SYS, true, "environment"){

        @Override
        public LispObject execute(LispObject arg) {
            Environment env = Lisp.checkEnvironment(arg);
            LispObject result = Lisp.NIL;
            FunctionBinding binding = env.lastFunctionBinding;
            while (binding != null) {
                result = result.push(new Cons(binding.name, binding.value));
                binding = binding.next;
            }
            return result.nreverse();
        }
    };

    public Environment() {
    }

    public Environment(Environment parent) {
        if (parent != null) {
            this.vars = parent.vars;
            this.lastFunctionBinding = parent.lastFunctionBinding;
            this.blocks = parent.blocks;
            this.tags = parent.tags;
        }
    }

    public Environment(Environment parent, Symbol symbol, LispObject value) {
        this(parent);
        this.vars = new Binding(symbol, value, this.vars);
    }

    @Override
    public LispObject typeOf() {
        return Symbol.ENVIRONMENT;
    }

    @Override
    public LispObject classOf() {
        return BuiltInClass.ENVIRONMENT;
    }

    @Override
    public LispObject typep(LispObject type) {
        if (type == Symbol.ENVIRONMENT) {
            return Lisp.T;
        }
        if (type == BuiltInClass.ENVIRONMENT) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    public boolean isEmpty() {
        if (this.lastFunctionBinding != null) {
            return false;
        }
        if (this.vars != null) {
            Binding binding = this.vars;
            while (binding != null) {
                if (!binding.specialp) {
                    return false;
                }
                binding = binding.next;
            }
        }
        return true;
    }

    public void bind(Symbol symbol, LispObject value) {
        this.vars = new Binding(symbol, value, this.vars);
    }

    public void rebind(Symbol symbol, LispObject value) {
        Binding binding = this.getBinding(symbol);
        binding.value = value;
    }

    public LispObject lookup(LispObject symbol, Binding binding) {
        while (binding != null) {
            if (binding.symbol == symbol) {
                return binding.value;
            }
            binding = binding.next;
        }
        return null;
    }

    public LispObject lookup(LispObject symbol) {
        return this.lookup(symbol, this.vars);
    }

    public Binding getOuterMostBlock() {
        Binding binding;
        Binding result = binding = this.blocks;
        while (binding != null) {
            result = binding;
            binding = binding.next;
        }
        return result;
    }

    public Binding getBinding(LispObject symbol) {
        return this.getBinding(symbol, this.vars);
    }

    public Binding getBinding(LispObject symbol, Binding binding) {
        while (binding != null) {
            if (binding.symbol == symbol) {
                return binding;
            }
            binding = binding.next;
        }
        return null;
    }

    public void addFunctionBinding(LispObject name, LispObject value) {
        this.lastFunctionBinding = new FunctionBinding(name, value, this.lastFunctionBinding);
    }

    public LispObject lookupFunction(LispObject name) {
        FunctionBinding binding = this.lastFunctionBinding;
        if (name instanceof Symbol) {
            while (binding != null) {
                if (binding.name == name) {
                    return binding.value;
                }
                binding = binding.next;
            }
            return name.getSymbolFunction();
        }
        if (name instanceof Cons) {
            while (binding != null) {
                if (binding.name.equal(name)) {
                    return binding.value;
                }
                binding = binding.next;
            }
        }
        return null;
    }

    public void addBlock(LispObject symbol, LispObject block) {
        this.blocks = new Binding(symbol, this, block, this.blocks);
    }

    public LispObject lookupBlock(LispObject symbol) {
        Binding binding = this.blocks;
        while (binding != null) {
            if (binding.symbol == symbol) {
                return binding.value;
            }
            binding = binding.next;
        }
        return null;
    }

    public Binding getBlockBinding(LispObject block) {
        Binding binding = this.blocks;
        while (binding != null) {
            if (binding.symbol == block) {
                return binding;
            }
            binding = binding.next;
        }
        return null;
    }

    public void addTagBinding(LispObject tag, LispObject code) {
        this.tags = new Binding(tag, this, code, this.tags);
    }

    public Binding getTagBinding(LispObject tag) {
        Binding binding = this.tags;
        while (binding != null) {
            if (binding.symbol.eql(tag)) {
                return binding;
            }
            binding = binding.next;
        }
        return null;
    }

    public LispObject processDeclarations(LispObject body) {
        LispObject bodyAndDecls = Lisp.parseBody(body, false);
        for (LispObject specials = Lisp.parseSpecials(bodyAndDecls.NTH(1)); specials != Lisp.NIL; specials = specials.cdr()) {
            this.declareSpecial(Lisp.checkSymbol(specials.car()));
        }
        return bodyAndDecls.car();
    }

    public void declareSpecial(Symbol var) {
        this.vars = new Binding(var, null, this.vars);
        this.vars.specialp = true;
    }

    public boolean isDeclaredSpecial(Symbol var) {
        Binding binding = this.getBinding(var);
        return binding != null ? binding.specialp : LispThread.currentThread().getSpecialBinding(var) != null;
    }

    @Override
    public String printObject() {
        return this.unreadableString("ENVIRONMENT");
    }
}

