# Flashsystem Configuration Replication using Ansible

**Objective:**
Replication of system configuration from one Flashsystem to another Flashsystem

**Prerequisite:**
- IBM Storage Virtualize ansible collection version 2.2.0 or above must be installed

**Features:**
- Set System name
- Set up NTP server
- Set up Timezone
- Set up DNS server
- Create Ownership groups
- Create Usergroups
- Create Users

**Details about files:**

1. src_cluster_vars:
   This file stores source cluster credentials, defines settable_fields required to extract from source cluster for specified entity, and formats raw extracted data to generate replication_vars file in desired format which will be provided as an input to replicate_config_on_target_cluster.yml playbook.
   Fields to be set by user:
   cluster_ip: Cluster IP source system
   cluster_username: Username of source system
   cluster_password: Password of source system

2. extract_src_cluster_config.yml:
   This playbook takes src_cluster_vars file as an input and gathers cluster configuration and writes it onto replication_vars file in a format that can be consumed by replicate_config_on_target_cluster.yml playbook for replication.
   To run this playbook:
   ```
   ansible-playbook extract_src_cluster_config.yml
   ```

3. target_cluster_vars:
   This file stores destination cluster credentials, which can be encrypted.
   Fields to be set by user:
      cluster_ip: Cluster IP target system
      cluster_username: Username of target system
      cluster_password: Password of target system
      user_default_password: Default password to be set for newly created users
   >IMPORTANT: 
   user_default_password value should be according to Flashsystem password policy
   To encrypt cluster_vars file:
   ```
   ansible-vault encrypt target_cluster_vars
   ```
   This command will promt to set a password. Note the password entered at prompt, as it will be required while running playbooks
   To open/ edit this file later:
   ```
   ansible-vault edit target_cluster_vars
   ```

4. replicate_config_on_target_cluster.yml:
   Run this playbook after running extract_src_cluster_config.yml playbook. This playbook takes replication_vars file generated by extract_src_cluster_config.yml playbook as an input and configures target system accordingly.
   Note: If target_cluster_vars file has been encrypted use following command to run replicate_config_on_target_cluster.yml playbook- 
   ```
   ansible-playbook replicate_config_on_target_cluster.yml --ask-vault-pass
   ```
   Enter password used in previous step to encrypt target_cluster_vars file
   >Note: 
   This playbook sets default password for users created on target system, user will be asked to change this default password on next login.
   >IMPORTANT: 
   If superuser is also being replicated, use the default password for next login.
 
**Usage:**
1. Replicate from one system to another exactly:
- Set source cluster details in src_cluster_vars
- Run playbook extract_src_cluster_config.yml
- Set target cluster details in target_cluster_vars
- Run playbook replicate_config_on_target_cluster.yml

2. Replicate from one system to another with few modifications:
- Set source cluster details in src_cluster_vars
- Run playbook extract_src_cluster_config.yml
- Edit config fields to be modified in replication_vars file
- Set target cluster details in target_cluster_vars
- Run playbook replicate_config_on_target_cluster.yml

3. Set-up system by customising config:
- Set config fields in replication_vars file
- Set target cluster details in target_cluster_vars
- Run playbook replicate_config_on_target_cluster.yml

**Authors:** 
Ajinkya Nanavati (ananava1@in.ibm.com)
Devendra Mahajan (demahaj1@in.ibm.com)
Mohit Chitlange (mochitla@in.ibm.com)
Vrinda Dhakad (vrinda.dhakad@ibm.com)
