/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.fixedinput;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.fixedinput.FixedFileInputField;
import org.pentaho.di.trans.steps.fixedinput.FixedInputData;
import org.pentaho.di.trans.steps.fixedinput.FixedInputMeta;
import org.pentaho.di.trans.steps.fixedinput.Messages;

public class FixedInput
extends BaseStep
implements StepInterface {
    private FixedInputMeta meta;
    private FixedInputData data;

    public FixedInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] outputRowData;
        this.meta = (FixedInputMeta)smi;
        this.data = (FixedInputData)sdi;
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = new RowMeta();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
            this.data.convertRowMeta = this.data.outputRowMeta.clone();
            for (ValueMetaInterface valueMeta : this.data.convertRowMeta.getValueMetaList()) {
                valueMeta.setStorageType(1);
            }
            if (this.meta.isHeaderPresent()) {
                this.readOneRow(false);
            }
        }
        if ((outputRowData = this.readOneRow(true)) == null) {
            this.setOutputDone();
            return false;
        }
        this.putRow(this.data.outputRowMeta, outputRowData);
        if (this.checkFeedback(this.getLinesInput())) {
            this.logBasic(Messages.getString("FixedInput.Log.LineNumber", Long.toString(this.getLinesInput())));
        }
        return true;
    }

    private Object[] readOneRow(boolean doConversions) throws KettleException {
        try {
            if (this.meta.isRunningInParallel() && this.getLinesInput() >= this.data.rowsToRead) {
                return null;
            }
            Object[] outputRowData = RowDataUtil.allocateRowData((int)this.data.convertRowMeta.size());
            int outputIndex = 0;
            if (this.data.stopReading) {
                return null;
            }
            FixedFileInputField[] fieldDefinitions = this.meta.getFieldDefinition();
            for (int i = 0; i < fieldDefinitions.length; ++i) {
                int fieldWidth = fieldDefinitions[i].getWidth();
                this.data.endBuffer = this.data.startBuffer + fieldWidth;
                if (this.data.endBuffer > this.data.bufferSize) {
                    this.data.resizeByteBuffer();
                    this.data.readBufferFromFile();
                }
                if (this.data.endBuffer > this.data.bufferSize) {
                    if (0 == i && this.data.bufferSize <= 0) {
                        return null;
                    }
                    this.data.stopReading = true;
                    fieldWidth = this.data.bufferSize;
                }
                byte[] field = new byte[fieldWidth];
                System.arraycopy(this.data.byteBuffer, this.data.startBuffer, field, 0, fieldWidth);
                if (doConversions) {
                    if (this.meta.isLazyConversionActive()) {
                        outputRowData[outputIndex++] = field;
                    } else {
                        ValueMetaInterface sourceValueMeta = this.data.convertRowMeta.getValueMeta(outputIndex);
                        outputRowData[outputIndex++] = sourceValueMeta.convertBinaryStringToNativeType(field);
                    }
                } else {
                    outputRowData[outputIndex++] = null;
                }
                this.data.startBuffer = this.data.endBuffer;
            }
            if (this.meta.isLineFeedPresent()) {
                this.data.endBuffer += 2;
                if (this.data.endBuffer >= this.data.bufferSize) {
                    this.data.resizeByteBuffer();
                    this.data.readBufferFromFile();
                }
                if (this.data.byteBuffer[this.data.startBuffer] == 10 || this.data.byteBuffer[this.data.startBuffer] == 13) {
                    ++this.data.startBuffer;
                    if (this.data.byteBuffer[this.data.startBuffer] == 10 || this.data.byteBuffer[this.data.startBuffer] == 13) {
                        ++this.data.startBuffer;
                    }
                }
                this.data.endBuffer = this.data.startBuffer;
            }
            this.incrementLinesInput();
            return outputRowData;
        }
        catch (Exception e) {
            throw new KettleFileException("Exception reading line using NIO: " + e.toString(), (Throwable)e);
        }
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (FixedInputMeta)smi;
        this.data = (FixedInputData)sdi;
        if (super.init(smi, sdi)) {
            try {
                this.data.preferredBufferSize = Integer.parseInt(this.environmentSubstitute(this.meta.getBufferSize()));
                this.data.lineWidth = Integer.parseInt(this.environmentSubstitute(this.meta.getLineWidth()));
                this.data.filename = this.environmentSubstitute(this.meta.getFilename());
                if (Const.isEmpty((String)this.data.filename)) {
                    this.logError(Messages.getString("FixedInput.MissingFilename.Message"));
                    return false;
                }
                FileObject fileObject = KettleVFS.getFileObject((String)this.data.filename);
                try {
                    FileInputStream fileInputStream = new FileInputStream(fileObject.getName().getPathDecoded());
                    this.data.fc = fileInputStream.getChannel();
                    this.data.bb = ByteBuffer.allocateDirect(this.data.preferredBufferSize);
                }
                catch (IOException e) {
                    this.logError(e.toString());
                    return false;
                }
                if (this.meta.isAddResultFile()) {
                    ResultFile resultFile = new ResultFile(0, fileObject, this.getTransMeta().getName(), this.toString());
                    resultFile.setComment("File was read by a Fixed input step");
                    this.addResultFile(resultFile);
                }
                this.logBasic("Opened file with name [" + this.data.filename + "]");
                this.data.stopReading = false;
                if (this.meta.isRunningInParallel()) {
                    this.data.stepNumber = this.getUniqueStepNrAcrossSlaves();
                    this.data.totalNumberOfSteps = this.getUniqueStepCountAcrossSlaves();
                    this.data.fileSize = fileObject.getContent().getSize();
                }
                if (this.meta.isRunningInParallel()) {
                    int totalLineWidth = this.data.lineWidth + this.meta.getLineSeparatorLength();
                    long nrRows = this.data.fileSize / (long)totalLineWidth;
                    long rowsToSkip = Math.round((double)((long)this.data.stepNumber * nrRows) / (double)this.data.totalNumberOfSteps);
                    long nextRowsToSkip = Math.round((double)((long)(this.data.stepNumber + 1) * nrRows) / (double)this.data.totalNumberOfSteps);
                    this.data.rowsToRead = nextRowsToSkip - rowsToSkip;
                    long bytesToSkip = rowsToSkip * (long)totalLineWidth;
                    this.logBasic("Step #" + this.data.stepNumber + " is skipping " + bytesToSkip + " to position in file, then it's reading " + this.data.rowsToRead + " rows.");
                    this.data.fc.position(bytesToSkip);
                }
                return true;
            }
            catch (IOException e) {
                this.logError("Error opening file '" + this.meta.getFilename() + "' : " + e.toString());
                this.logError(Const.getStackTracker((Throwable)e));
            }
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        try {
            if (this.data.fc != null) {
                this.data.fc.close();
            }
        }
        catch (IOException e) {
            this.logError("Unable to close file channel for file '" + this.meta.getFilename() + "' : " + e.toString());
            this.logError(Const.getStackTracker((Throwable)e));
        }
        super.dispose(smi, sdi);
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

