/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import javax.annotation.Nullable;
import org.gradle.api.internal.provider.AbstractProviderWithValue;
import org.gradle.api.internal.provider.OrElseValueProducer;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.internal.Cast;

class OrElseFixedValueProvider<T>
extends AbstractProviderWithValue<T> {
    private final ProviderInternal<? extends T> provider;
    private final T fallbackValue;

    public OrElseFixedValueProvider(ProviderInternal<? extends T> provider, T fallbackValue) {
        this.provider = provider;
        this.fallbackValue = fallbackValue;
    }

    @Override
    public String toString() {
        return String.format("or(%s, fixed(%s))", this.provider, this.fallbackValue);
    }

    @Override
    @Nullable
    public Class<T> getType() {
        return (Class)Cast.uncheckedCast(this.provider.getType());
    }

    @Override
    public ValueSupplier.ValueProducer getProducer() {
        return new OrElseValueProducer(this.provider, null, ValueSupplier.ValueProducer.unknown());
    }

    @Override
    public ValueSupplier.ExecutionTimeValue<? extends T> calculateExecutionTimeValue() {
        ValueSupplier.ExecutionTimeValue<T> value = this.provider.calculateExecutionTimeValue();
        if (value.isMissing()) {
            return ValueSupplier.ExecutionTimeValue.fixedValue(this.fallbackValue);
        }
        if (value.hasFixedValue()) {
            return value;
        }
        return ValueSupplier.ExecutionTimeValue.changingValue(new OrElseFixedValueProvider<T>(value.getChangingValue(), this.fallbackValue));
    }

    @Override
    protected ValueSupplier.Value<? extends T> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
        ValueSupplier.Value<T> value = this.provider.calculateValue(consumer);
        if (value.isMissing()) {
            return ValueSupplier.Value.of(this.fallbackValue);
        }
        return value;
    }
}

