/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.visitor;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jd.core.v1.model.classfile.ClassFile;
import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.declaration.AnnotationDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.BaseFormalParameter;
import org.jd.core.v1.model.javasyntax.declaration.BodyDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ClassDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ConstructorDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.EnumDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.FormalParameter;
import org.jd.core.v1.model.javasyntax.declaration.InterfaceDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.LocalVariableDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.LocalVariableDeclarator;
import org.jd.core.v1.model.javasyntax.declaration.MethodDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.StaticInitializerDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.TypeDeclaration;
import org.jd.core.v1.model.javasyntax.expression.BaseExpression;
import org.jd.core.v1.model.javasyntax.expression.BinaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.CastExpression;
import org.jd.core.v1.model.javasyntax.expression.ConstructorInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.FieldReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.NewExpression;
import org.jd.core.v1.model.javasyntax.expression.NullExpression;
import org.jd.core.v1.model.javasyntax.expression.ObjectTypeReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.SuperConstructorInvocationExpression;
import org.jd.core.v1.model.javasyntax.statement.BaseStatement;
import org.jd.core.v1.model.javasyntax.statement.ExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.LocalVariableDeclarationStatement;
import org.jd.core.v1.model.javasyntax.statement.Statement;
import org.jd.core.v1.model.javasyntax.statement.Statements;
import org.jd.core.v1.model.javasyntax.statement.TypeDeclarationStatement;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.InnerObjectType;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileBodyDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileClassDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileConstructorDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileMemberDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileMethodDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileStaticInitializerDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileTypeDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileConstructorInvocationExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileLocalVariableReferenceExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileNewExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileSuperConstructorInvocationExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.AbstractLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.AbstractUpdateExpressionVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.SearchFirstLineNumberVisitor;
import org.jd.core.v1.util.DefaultList;

public class InitInnerClassVisitor
extends AbstractJavaSyntaxVisitor {
    protected UpdateFieldReferencesVisitor updateFieldReferencesVisitor = new UpdateFieldReferencesVisitor();
    protected DefaultList<String> syntheticInnerFieldNames = new DefaultList();
    protected ObjectType outerType;

    @Override
    public void visit(AnnotationDeclaration declaration) {
        this.safeAccept(declaration.getBodyDeclaration());
    }

    @Override
    public void visit(ClassDeclaration declaration) {
        this.safeAccept(declaration.getBodyDeclaration());
    }

    @Override
    public void visit(EnumDeclaration declaration) {
        this.safeAccept(declaration.getBodyDeclaration());
    }

    @Override
    public void visit(InterfaceDeclaration declaration) {
        this.safeAccept(declaration.getBodyDeclaration());
    }

    @Override
    public void visit(BodyDeclaration declaration) {
        ClassFileBodyDeclaration bodyDeclaration = (ClassFileBodyDeclaration)declaration;
        this.outerType = null;
        this.syntheticInnerFieldNames.clear();
        this.safeAcceptListDeclaration(bodyDeclaration.getMethodDeclarations());
        bodyDeclaration.setOuterType(this.outerType);
        if (!this.syntheticInnerFieldNames.isEmpty()) {
            bodyDeclaration.setSyntheticInnerFieldNames(new DefaultList<String>((Collection<String>)this.syntheticInnerFieldNames));
        }
        if (this.outerType != null || !this.syntheticInnerFieldNames.isEmpty()) {
            this.updateFieldReferencesVisitor.visit(bodyDeclaration);
        }
    }

    @Override
    public void visit(ConstructorDeclaration declaration) {
        BaseFormalParameter parameters;
        ClassFileConstructorDeclaration cfcd = (ClassFileConstructorDeclaration)declaration;
        ClassFile classFile = cfcd.getClassFile();
        ClassFile outerClassFile = classFile.getOuterClassFile();
        this.syntheticInnerFieldNames.clear();
        if (cfcd.getStatements().isList()) {
            Iterator iterator = cfcd.getStatements().iterator();
            while (iterator.hasNext()) {
                Statement statement = (Statement)iterator.next();
                if (statement.getClass() == ExpressionStatement.class) {
                    BinaryOperatorExpression boe;
                    Expression e;
                    Expression expression = ((ExpressionStatement)statement).getExpression();
                    Class<?> clazz = expression.getClass();
                    if (clazz == ClassFileSuperConstructorInvocationExpression.class) break;
                    if (clazz == ClassFileConstructorInvocationExpression.class) {
                        if (outerClassFile == null || (classFile.getAccessFlags() & 8) != 0) break;
                        this.outerType = (ObjectType)cfcd.getParameterTypes().getFirst();
                        break;
                    }
                    if (clazz == BinaryOperatorExpression.class && (e = (boe = (BinaryOperatorExpression)expression).getLeftExpression()).getClass() == FieldReferenceExpression.class) {
                        String name = ((FieldReferenceExpression)e).getName();
                        if (name.startsWith("this$")) {
                            this.outerType = (ObjectType)boe.getRightExpression().getType();
                        } else if (name.startsWith("val$")) {
                            this.syntheticInnerFieldNames.add(name);
                        }
                    }
                }
                iterator.remove();
            }
        }
        if ((parameters = cfcd.getFormalParameters()) != null) {
            if (parameters.isList()) {
                int count;
                DefaultList list = parameters.getList();
                if (this.outerType != null) {
                    list.remove(0);
                }
                if ((count = this.syntheticInnerFieldNames.size()) > 0) {
                    int size = list.size();
                    list.subList(size - count, size).clear();
                }
            } else if (this.outerType != null || !this.syntheticInnerFieldNames.isEmpty()) {
                cfcd.setFormalParameters(null);
            }
        }
        if (outerClassFile != null) {
            String internalTypeName;
            String outerTypeName = outerClassFile.getInternalTypeName();
            int min = (internalTypeName = cfcd.getClassFile().getInternalTypeName()).startsWith(outerTypeName + '$') ? outerTypeName.length() + 1 : internalTypeName.lastIndexOf(36) + 1;
            if (Character.isDigit(internalTypeName.charAt(min))) {
                int i = internalTypeName.length();
                boolean anonymousFlag = true;
                while (--i > min) {
                    if (Character.isDigit(internalTypeName.charAt(i))) continue;
                    anonymousFlag = false;
                    break;
                }
                if (anonymousFlag) {
                    cfcd.setFlags(cfcd.getFlags() | 0x1000);
                }
            }
        }
    }

    @Override
    public void visit(MethodDeclaration declaration) {
    }

    @Override
    public void visit(StaticInitializerDeclaration declaration) {
    }

    public static class UpdateNewExpressionVisitor
    extends AbstractJavaSyntaxVisitor {
        protected TypeMaker typeMaker;
        protected ClassFileBodyDeclaration bodyDeclaration;
        protected ClassFile classFile;
        protected HashMap<String, String> finalLocalVariableNameMap = new HashMap();
        protected DefaultList<ClassFileClassDeclaration> localClassDeclarations = new DefaultList();
        protected HashSet<NewExpression> newExpressions = new HashSet();
        protected int lineNumber;

        public UpdateNewExpressionVisitor(TypeMaker typeMaker) {
            this.typeMaker = typeMaker;
        }

        @Override
        public void visit(BodyDeclaration declaration) {
            this.bodyDeclaration = (ClassFileBodyDeclaration)declaration;
            this.safeAcceptListDeclaration(this.bodyDeclaration.getMethodDeclarations());
        }

        @Override
        public void visit(ConstructorDeclaration declaration) {
            this.classFile = ((ClassFileConstructorDeclaration)declaration).getClassFile();
            this.finalLocalVariableNameMap.clear();
            this.localClassDeclarations.clear();
            this.safeAccept(declaration.getStatements());
            if (!this.finalLocalVariableNameMap.isEmpty()) {
                UpdateParametersAndLocalVariablesVisitor visitor = new UpdateParametersAndLocalVariablesVisitor();
                declaration.getStatements().accept(visitor);
                if (declaration.getFormalParameters() != null) {
                    declaration.getFormalParameters().accept(visitor);
                }
            }
            if (!this.localClassDeclarations.isEmpty()) {
                this.localClassDeclarations.sort(new MemberDeclarationComparator());
                declaration.accept(new AddLocalClassDeclarationVisitor());
            }
        }

        @Override
        public void visit(MethodDeclaration declaration) {
            this.finalLocalVariableNameMap.clear();
            this.localClassDeclarations.clear();
            this.safeAccept(declaration.getStatements());
            if (!this.finalLocalVariableNameMap.isEmpty()) {
                UpdateParametersAndLocalVariablesVisitor visitor = new UpdateParametersAndLocalVariablesVisitor();
                declaration.getStatements().accept(visitor);
                if (declaration.getFormalParameters() != null) {
                    declaration.getFormalParameters().accept(visitor);
                }
            }
            if (!this.localClassDeclarations.isEmpty()) {
                this.localClassDeclarations.sort(new MemberDeclarationComparator());
                declaration.accept(new AddLocalClassDeclarationVisitor());
            }
        }

        @Override
        public void visit(StaticInitializerDeclaration declaration) {
            this.finalLocalVariableNameMap.clear();
            this.localClassDeclarations.clear();
            this.safeAccept(declaration.getStatements());
            if (!this.finalLocalVariableNameMap.isEmpty()) {
                declaration.getStatements().accept(new UpdateParametersAndLocalVariablesVisitor());
            }
            if (!this.localClassDeclarations.isEmpty()) {
                this.localClassDeclarations.sort(new MemberDeclarationComparator());
                declaration.accept(new AddLocalClassDeclarationVisitor());
            }
        }

        @Override
        public void visit(Statements list) {
            if (!list.isEmpty()) {
                ListIterator<TypeDeclarationStatement> iterator = list.listIterator();
                while (iterator.hasNext()) {
                    Statement s = (Statement)iterator.next();
                    s.accept(this);
                    if (this.lineNumber != 0 || this.localClassDeclarations.isEmpty()) continue;
                    iterator.previous();
                    for (TypeDeclaration typeDeclaration : this.localClassDeclarations) {
                        iterator.add(new TypeDeclarationStatement(typeDeclaration));
                    }
                    this.localClassDeclarations.clear();
                    iterator.next();
                }
            }
        }

        @Override
        public void visit(NewExpression expression) {
            if (!this.newExpressions.contains(expression)) {
                this.newExpressions.add(expression);
                ClassFileNewExpression ne = (ClassFileNewExpression)expression;
                ClassFileBodyDeclaration cfbd = null;
                if (ne.getBodyDeclaration() == null) {
                    ObjectType type = ne.getObjectType();
                    String internalName = type.getInternalName();
                    ClassFileTypeDeclaration typeDeclaration = this.bodyDeclaration.getInnerTypeDeclaration(internalName);
                    if (typeDeclaration == null) {
                        for (ClassFileBodyDeclaration bd = this.bodyDeclaration; bd != null; bd = bd.getOuterBodyDeclaration()) {
                            if (!bd.getInternalTypeName().equals(internalName)) continue;
                            cfbd = bd;
                            break;
                        }
                    } else if (typeDeclaration.getClass() == ClassFileClassDeclaration.class) {
                        ClassFileClassDeclaration cfcd = (ClassFileClassDeclaration)typeDeclaration;
                        cfbd = (ClassFileBodyDeclaration)cfcd.getBodyDeclaration();
                        if (type.getQualifiedName() == null && type.getName() != null) {
                            cfcd.setFlags(cfcd.getFlags() & 0xFFFFEFFF);
                            this.localClassDeclarations.add(cfcd);
                            this.bodyDeclaration.removeInnerType(internalName);
                            this.lineNumber = ne.getLineNumber();
                        }
                    }
                } else {
                    cfbd = (ClassFileBodyDeclaration)ne.getBodyDeclaration();
                }
                if (cfbd != null) {
                    BaseExpression parameters = ne.getParameters();
                    BaseType parameterTypes = ne.getParameterTypes();
                    if (parameters != null) {
                        DefaultList<String> syntheticInnerFieldNames = cfbd.getSyntheticInnerFieldNames();
                        if (parameters.isList()) {
                            DefaultList list = parameters.getList();
                            DefaultList types = parameterTypes.getList();
                            if (cfbd.getOuterType() != null) {
                                list.removeFirst();
                                types.removeFirst();
                            }
                            if (syntheticInnerFieldNames != null) {
                                int size = list.size();
                                int count = syntheticInnerFieldNames.size();
                                List lastParameters = list.subList(size - count, size);
                                Iterator parameterIterator = lastParameters.iterator();
                                Iterator syntheticInnerFieldNameIterator = syntheticInnerFieldNames.iterator();
                                while (parameterIterator.hasNext()) {
                                    Expression param = (Expression)parameterIterator.next();
                                    String syntheticInnerFieldName = (String)syntheticInnerFieldNameIterator.next();
                                    if (param.getClass() == CastExpression.class) {
                                        param = ((CastExpression)param).getExpression();
                                    }
                                    if (param.getClass() != ClassFileLocalVariableReferenceExpression.class) continue;
                                    AbstractLocalVariable lv = ((ClassFileLocalVariableReferenceExpression)param).getLocalVariable();
                                    String localVariableName = syntheticInnerFieldName.substring(4);
                                    this.finalLocalVariableNameMap.put(lv.getName(), localVariableName);
                                }
                                lastParameters.clear();
                                types.subList(size - count, size).clear();
                            }
                        } else if (cfbd.getOuterType() != null) {
                            ne.setParameters(null);
                            ne.setParameterTypes(null);
                        } else if (syntheticInnerFieldNames != null) {
                            Expression param = (Expression)parameters.getFirst();
                            if (param.getClass() == CastExpression.class) {
                                param = ((CastExpression)param).getExpression();
                            }
                            if (param.getClass() == ClassFileLocalVariableReferenceExpression.class) {
                                AbstractLocalVariable lv = ((ClassFileLocalVariableReferenceExpression)param).getLocalVariable();
                                String localVariableName = syntheticInnerFieldNames.getFirst().substring(4);
                                this.finalLocalVariableNameMap.put(lv.getName(), localVariableName);
                                ne.setParameters(null);
                                ne.setParameterTypes(null);
                            }
                        }
                        parameters = ne.getParameters();
                        if (parameters != null && parameters.size() > 0 && ((Expression)parameters.getLast()).getClass() == NullExpression.class && ((Type)(parameterTypes = ne.getParameterTypes()).getLast()).getName() == null) {
                            if (parameters.isList()) {
                                parameters.getList().removeLast();
                                parameterTypes.getList().removeLast();
                            } else {
                                ne.setParameters(null);
                                ne.setParameterTypes(null);
                            }
                        }
                    }
                }
            }
            this.safeAccept(expression.getParameters());
        }

        @Override
        public void visit(SuperConstructorInvocationExpression expression) {
            ClassFileSuperConstructorInvocationExpression scie = (ClassFileSuperConstructorInvocationExpression)expression;
            BaseExpression parameters = scie.getParameters();
            if (parameters != null && parameters.size() > 0) {
                TypeMaker.TypeTypes superTypeTypes;
                Type firstParameterType = ((Expression)parameters.getFirst()).getType();
                if (firstParameterType.isObject() && (this.classFile.getAccessFlags() & 8) == 0 && this.bodyDeclaration.getOuterType() != null && (superTypeTypes = this.typeMaker.makeTypeTypes(this.classFile.getSuperTypeName())) != null && superTypeTypes.thisType.getClass() == InnerObjectType.class && this.typeMaker.isRawTypeAssignable(((InnerObjectType)superTypeTypes.thisType).getOuterType(), (ObjectType)firstParameterType)) {
                    scie.setParameters(this.removeFirstItem(parameters));
                    scie.setParameterTypes(this.removeFirstItem(scie.getParameterTypes()));
                }
                expression.setParameters(this.removeLastSyntheticParameter(scie.getParameters(), scie.getParameterTypes()));
            }
        }

        @Override
        public void visit(ConstructorInvocationExpression expression) {
            ClassFileConstructorInvocationExpression cie = (ClassFileConstructorInvocationExpression)expression;
            BaseExpression parameters = cie.getParameters();
            if (parameters != null && parameters.size() > 0) {
                if (((Expression)parameters.getFirst()).getType().equals(this.bodyDeclaration.getOuterType())) {
                    cie.setParameters(this.removeFirstItem(parameters));
                    cie.setParameterTypes(this.removeFirstItem(cie.getParameterTypes()));
                }
                cie.setParameters(this.removeLastSyntheticParameter(cie.getParameters(), cie.getParameterTypes()));
            }
        }

        protected BaseExpression removeFirstItem(BaseExpression parameters) {
            if (parameters.isList()) {
                parameters.getList().removeFirst();
            } else {
                parameters = null;
            }
            return parameters;
        }

        protected BaseType removeFirstItem(BaseType types) {
            if (types.isList()) {
                types.getList().removeFirst();
            } else {
                types = null;
            }
            return types;
        }

        protected BaseExpression removeLastSyntheticParameter(BaseExpression parameters, BaseType parameterTypes) {
            if (parameters != null && parameters.size() > 0 && ((Expression)parameters.getLast()).getClass() == NullExpression.class && ((Type)parameterTypes.getLast()).getName() == null) {
                if (parameters.isList()) {
                    parameters.getList().removeLast();
                } else {
                    parameters = null;
                }
            }
            return parameters;
        }

        protected class MemberDeclarationComparator
        implements Comparator<ClassFileMemberDeclaration> {
            protected MemberDeclarationComparator() {
            }

            @Override
            public int compare(ClassFileMemberDeclaration md1, ClassFileMemberDeclaration md2) {
                return md1.getFirstLineNumber() - md2.getFirstLineNumber();
            }
        }

        protected class AddLocalClassDeclarationVisitor
        extends AbstractJavaSyntaxVisitor {
            protected SearchFirstLineNumberVisitor searchFirstLineNumberVisitor = new SearchFirstLineNumberVisitor();
            protected int lineNumber = 0;

            protected AddLocalClassDeclarationVisitor() {
            }

            @Override
            public void visit(ConstructorDeclaration declaration) {
                ClassFileConstructorDeclaration cfcd = (ClassFileConstructorDeclaration)declaration;
                cfcd.setStatements(this.addLocalClassDeclarations(cfcd.getStatements()));
            }

            @Override
            public void visit(MethodDeclaration declaration) {
                ClassFileMethodDeclaration cfmd = (ClassFileMethodDeclaration)declaration;
                cfmd.setStatements(this.addLocalClassDeclarations(cfmd.getStatements()));
            }

            @Override
            public void visit(StaticInitializerDeclaration declaration) {
                ClassFileStaticInitializerDeclaration cfsid = (ClassFileStaticInitializerDeclaration)declaration;
                cfsid.setStatements(this.addLocalClassDeclarations(cfsid.getStatements()));
            }

            protected BaseStatement addLocalClassDeclarations(BaseStatement statements) {
                if (!UpdateNewExpressionVisitor.this.localClassDeclarations.isEmpty()) {
                    if (statements.getClass() == Statements.class) {
                        statements.accept(this);
                    } else {
                        ClassFileClassDeclaration declaration = (ClassFileClassDeclaration)UpdateNewExpressionVisitor.this.localClassDeclarations.get(0);
                        this.searchFirstLineNumberVisitor.init();
                        statements.accept(this.searchFirstLineNumberVisitor);
                        if (this.searchFirstLineNumberVisitor.getLineNumber() != -1) {
                            this.lineNumber = this.searchFirstLineNumberVisitor.getLineNumber();
                        }
                        if (declaration.getFirstLineNumber() <= this.lineNumber) {
                            Statements list = new Statements();
                            Iterator declarationIterator = UpdateNewExpressionVisitor.this.localClassDeclarations.iterator();
                            list.add(new TypeDeclarationStatement(declaration));
                            declarationIterator.next();
                            declarationIterator.remove();
                            while (declarationIterator.hasNext() && (declaration = (ClassFileClassDeclaration)declarationIterator.next()).getFirstLineNumber() <= this.lineNumber) {
                                list.add(new TypeDeclarationStatement(declaration));
                                declarationIterator.remove();
                            }
                            if (statements.isList()) {
                                list.addAll(statements.getList());
                            } else {
                                list.add(statements.getFirst());
                            }
                            statements = list;
                        } else {
                            statements.accept(this);
                        }
                    }
                }
                return statements;
            }

            @Override
            public void visit(Statements list) {
                if (!UpdateNewExpressionVisitor.this.localClassDeclarations.isEmpty() && !list.isEmpty()) {
                    ListIterator<TypeDeclarationStatement> statementIterator = list.listIterator();
                    Iterator declarationIterator = UpdateNewExpressionVisitor.this.localClassDeclarations.iterator();
                    ClassFileClassDeclaration declaration = (ClassFileClassDeclaration)declarationIterator.next();
                    while (statementIterator.hasNext()) {
                        Statement statement = (Statement)statementIterator.next();
                        this.searchFirstLineNumberVisitor.init();
                        statement.accept(this.searchFirstLineNumberVisitor);
                        if (this.searchFirstLineNumberVisitor.getLineNumber() != -1) {
                            this.lineNumber = this.searchFirstLineNumberVisitor.getLineNumber();
                        }
                        while (declaration.getFirstLineNumber() <= this.lineNumber) {
                            statementIterator.previous();
                            statementIterator.add(new TypeDeclarationStatement(declaration));
                            statementIterator.next();
                            declarationIterator.remove();
                            if (!declarationIterator.hasNext()) {
                                return;
                            }
                            declaration = (ClassFileClassDeclaration)declarationIterator.next();
                        }
                    }
                }
            }
        }

        protected class UpdateParametersAndLocalVariablesVisitor
        extends AbstractJavaSyntaxVisitor {
            protected boolean fina1;

            protected UpdateParametersAndLocalVariablesVisitor() {
            }

            @Override
            public void visit(FormalParameter declaration) {
                if (UpdateNewExpressionVisitor.this.finalLocalVariableNameMap.containsKey(declaration.getName())) {
                    declaration.setFinal(true);
                    declaration.setName(UpdateNewExpressionVisitor.this.finalLocalVariableNameMap.get(declaration.getName()));
                }
            }

            @Override
            public void visit(LocalVariableDeclarationStatement statement) {
                this.fina1 = false;
                statement.getLocalVariableDeclarators().accept(this);
                statement.setFinal(this.fina1);
            }

            @Override
            public void visit(LocalVariableDeclaration declaration) {
                this.fina1 = false;
                declaration.getLocalVariableDeclarators().accept(this);
                declaration.setFinal(this.fina1);
            }

            @Override
            public void visit(LocalVariableDeclarator declarator) {
                if (UpdateNewExpressionVisitor.this.finalLocalVariableNameMap.containsKey(declarator.getName())) {
                    this.fina1 = true;
                    declarator.setName(UpdateNewExpressionVisitor.this.finalLocalVariableNameMap.get(declarator.getName()));
                }
            }
        }
    }

    protected class UpdateFieldReferencesVisitor
    extends AbstractUpdateExpressionVisitor {
        protected ClassFileBodyDeclaration bodyDeclaration;

        protected UpdateFieldReferencesVisitor() {
        }

        @Override
        public void visit(BodyDeclaration declaration) {
            this.bodyDeclaration = (ClassFileBodyDeclaration)declaration;
            this.safeAcceptListDeclaration(this.bodyDeclaration.getMethodDeclarations());
        }

        @Override
        public void visit(StaticInitializerDeclaration declaration) {
        }

        @Override
        public void visit(MethodDeclaration declaration) {
            this.safeAccept(declaration.getStatements());
        }

        @Override
        public void visit(NewExpression expression) {
            if (expression.getParameters() != null) {
                expression.setParameters(this.updateBaseExpression(expression.getParameters()));
                expression.getParameters().accept(this);
            }
            this.safeAccept(expression.getBodyDeclaration());
        }

        @Override
        public void visit(FieldReferenceExpression expression) {
            if (expression.getName().startsWith("this$")) {
                if (expression.getType().getDescriptor().equals(InitInnerClassVisitor.this.outerType.getDescriptor())) {
                    Expression exp = expression.getExpression() == null ? expression : expression.getExpression();
                    expression.setExpression(new ObjectTypeReferenceExpression(exp.getLineNumber(), InitInnerClassVisitor.this.outerType.createType(null)));
                    expression.setName("this");
                } else {
                    ObjectType objectType;
                    ClassFileBodyDeclaration cfbd;
                    String outerInternalTypeName;
                    ClassFileTypeDeclaration typeDeclaration = this.bodyDeclaration.getInnerTypeDeclaration(expression.getInternalTypeName());
                    if (typeDeclaration != null && typeDeclaration.getClass() == ClassFileClassDeclaration.class && typeDeclaration.getInternalTypeName().equals(expression.getInternalTypeName()) && (outerInternalTypeName = (cfbd = (ClassFileBodyDeclaration)typeDeclaration.getBodyDeclaration()).getOuterBodyDeclaration().getInternalTypeName()).equals((objectType = (ObjectType)expression.getType()).getInternalName())) {
                        Expression exp = expression.getExpression() == null ? expression : expression.getExpression();
                        expression.setExpression(new ObjectTypeReferenceExpression(exp.getLineNumber(), objectType.createType(null)));
                        expression.setName("this");
                    }
                }
            } else if (expression.getName().startsWith("val$")) {
                expression.setName(expression.getName().substring(4));
                expression.setExpression(null);
            } else {
                super.visit(expression);
            }
        }

        @Override
        protected Expression updateExpression(Expression expression) {
            ClassFileLocalVariableReferenceExpression cdlvre;
            if (expression.getClass() == ClassFileLocalVariableReferenceExpression.class && (cdlvre = (ClassFileLocalVariableReferenceExpression)expression).getName() != null && cdlvre.getName().startsWith("this$") && cdlvre.getType().getDescriptor().equals(InitInnerClassVisitor.this.outerType.getDescriptor())) {
                return new FieldReferenceExpression(InitInnerClassVisitor.this.outerType, new ObjectTypeReferenceExpression(cdlvre.getLineNumber(), InitInnerClassVisitor.this.outerType.createType(null)), InitInnerClassVisitor.this.outerType.getInternalName(), "this", InitInnerClassVisitor.this.outerType.getDescriptor());
            }
            return expression;
        }
    }
}

