#         'trust200902',
#         'noModificationTrust200902',
#         'noDerivativesTrust200902',
#         'pre5378Trust200902',
#         'trust200811',
#         'noModificationTrust200811',
#         'noDerivativesTrust200811',





boilerplate_tlp = {
    "2.0": {
        # From https://trustee.ietf.org/license-info/IETF-TLP-2.htm
        "draft": [
            """<t>
            This Internet-Draft is submitted in full conformance
            with the provisions of BCP 78 and BCP 79.
            </t>""",
        ],
        "n/a": [
            """<t>
            Copyright (c) {year} IETF Trust and the persons identified as
            the document authors.  All rights reserved. 
            </t>""",
            """<t>
            This document is subject to BCP 78 and the IETF Trust's Legal
            Provisions Relating to IETF Documents in effect on the date of
            publication of this document (http://trustee.ietf.org/license-info).
            Please review these documents carefully, as they describe your rights
            and restrictions with respect to this document.
            </t>""",
        ],
        "noModification": [
            """<t>
            This document may not be modified, and derivative works of it may
            not be created, except to format it for publication as an RFC or
            to translate it into languages other than English.
            </t>""",
        ],
        "noDerivatives": [
            """<t>
            This document may not be modified, and derivative works of it may
            not be created, and it may not be published except as an
            Internet-Draft.
            </t>""",
        ],
        "pre5378": [
            """<t>
            This document may contain material from IETF Documents or IETF
            Contributions published or made publicly available before November
            10, 2008. The person(s) controlling the copyright in some of this
            material may not have granted the IETF Trust the right to allow
            modifications of such material outside the IETF Standards Process.
            Without obtaining an adequate license from the person(s)
            controlling the copyright in such materials, this document may not
            be modified outside the IETF Standards Process, and derivative
            works of it may not be created outside the IETF Standards Process,
            except to format it for publication as an RFC or to translate it
            into languages other than English.
            </t>""",
        ],
    },
    "3.0": {
        # From https://trustee.ietf.org/license-info/IETF-TLP-3.htm
        "draft": [
            """<t>
            This Internet-Draft is submitted to IETF in full conformance with
            the provisions of BCP 78 and BCP 79.
            </t>""",
        ],
        "n/a": [
            """<t>
            Copyright (c) {year} IETF Trust and the persons identified as
            the document authors.  All rights reserved. 
            </t>""",
            """<t>
            This document is subject to BCP 78 and the IETF Trust's Legal
            Provisions Relating to IETF Documents
            (http://trustee.ietf.org/license-info) in effect on the date of
            publication of this document. Please review these documents carefully,
            as they describe your rights and restrictions with respect to this
            document.  Code Components extracted from this document must include
            Simplified BSD License text as described in Section 4.e of the Trust
            Legal Provisions and are provided without warranty as described in the
            BSD License.
            </t>""",
        ],
        "noModification": [
            """<t>
            This document may not be modified, and derivative works of it may
            not be created, except to format it for publication as an RFC or
            to translate it into languages other than English.
            </t>""",
        ],
        "noDerivatives": [
            """<t>
            This document may not be modified, and derivative works of it may
            not be created, and it may not be published except as an
            Internet-Draft.
            </t>""",
        ],
        "pre5378": [
            """<t>
            This document may contain material from IETF Documents or IETF
            Contributions published or made publicly available before November
            10, 2008. The person(s) controlling the copyright in some of this
            material may not have granted the IETF Trust the right to allow
            modifications of such material outside the IETF Standards Process.
            Without obtaining an adequate license from the person(s)
            controlling the copyright in such materials, this document may not
            be modified outside the IETF Standards Process, and derivative
            works of it may not be created outside the IETF Standards Process,
            except to format it for publication as an RFC or to translate it
            into languages other than English.
            </t>""",
        ],
    },
    "4.0": {
        # From https://trustee.ietf.org/license-info/IETF-TLP-4.htm
        "draft": [
            """<t>
            This Internet-Draft is submitted in full conformance with the
            provisions of BCP 78 and BCP 79.
            </t>""",
        ],
        "IETF": [
            """<t>
            Copyright (c) {year} IETF Trust and the persons identified as the document
            authors. All rights reserved.
            </t>""",
            """<t>
            This document is subject to BCP 78 and the IETF Trust's Legal
            Provisions Relating to IETF Documents
            (http://trustee.ietf.org/license-info) in effect on the date of
            publication of this document. Please review these documents carefully,
            as they describe your rights and restrictions with respect to this
            document. Code Components extracted from this document must include
            Simplified BSD License text as described in Section 4.e of the Trust
            Legal Provisions and are provided without warranty as described in the
            Simplified BSD License.
            </t>""",
        ],
        "alt": [
            """<t>
            Copyright (c) {year} IETF Trust and the persons identified as the
            document authors. All rights reserved.
            </t>""",
            """<t>
            This document is subject to BCP 78 and the IETF Trust's Legal
            Provisions Relating to IETF Documents
            (http://trustee.ietf.org/license-info) in effect on the date of
            publication of this document. Please review these documents
            carefully, as they describe your rights and restrictions with
            respect to this document.
            </t>""",
        ],
        "noModification": [
            """<t>
            This document may not be modified, and derivative works of it may
            not be created, except to format it for publication as an RFC or
            to translate it into languages other than English.
            </t>""",
        ],
        "noDerivatives": [
            """<t>
            This document may not be modified, and derivative works of it may
            not be created, and it may not be published except as an
            Internet-Draft.
            </t>""",
        ],
        "pre5378": [
            """<t>
            This document may contain material from IETF Documents or IETF
            Contributions published or made publicly available before November
            10, 2008. The person(s) controlling the copyright in some of this
            material may not have granted the IETF Trust the right to allow
            modifications of such material outside the IETF Standards Process.
            Without obtaining an adequate license from the person(s)
            controlling the copyright in such materials, this document may not
            be modified outside the IETF Standards Process, and derivative
            works of it may not be created outside the IETF Standards Process,
            except to format it for publication as an RFC or to translate it
            into languages other than English.
            </t>""",
        ],
    },
    "5.0": {
        # From https://trustee.ietf.org/license-info/IETF-TLP-5.htm
        "draft": [
            """<t>
            This Internet-Draft is submitted in full conformance with the
            provisions of BCP 78 and BCP 79.
            </t>""",
        ],
        "IETF": [
            """<t>
            Copyright (c) {year} IETF Trust and the persons identified as the
            document authors. All rights reserved.
            </t>""",
            """<t>
            This document is subject to BCP 78 and the IETF Trust's Legal
            Provisions Relating to IETF Documents
            (<eref target="{scheme}://trustee.ietf.org/license-info"/>) in effect on the date of
            publication of this document. Please review these documents
            carefully, as they describe your rights and restrictions with
            respect to this document. Code Components extracted from this
            document must include Revised BSD License text as described in
            Section 4.e of the Trust Legal Provisions and are provided without
            warranty as described in the Revised BSD License.
            </t>""",
        ],
        "alt": [
            """<t>
            Copyright (c) {year} IETF Trust and the persons identified as the
            document authors. All rights reserved.
            </t>""",
            """<t>
            This document is subject to BCP 78 and the IETF Trust's Legal
            Provisions Relating to IETF Documents
            (<eref target="{scheme}://trustee.ietf.org/license-info"/>) in effect on the date of
            publication of this document. Please review these documents
            carefully, as they describe your rights and restrictions with
            respect to this document.
            </t>""",
        ],
        "noModification": [
            """<t>
            This document may not be modified, and derivative works of it may
            not be created, except to format it for publication as an RFC or
            to translate it into languages other than English.
            </t>""",
        ],
        "noDerivatives": [
            """<t>
            This document may not be modified, and derivative works of it may
            not be created, and it may not be published except as an
            Internet-Draft.
            </t>""",
        ],
        "pre5378": [
            """<t>
            This document may contain material from IETF Documents or IETF
            Contributions published or made publicly available before November
            10, 2008. The person(s) controlling the copyright in some of this
            material may not have granted the IETF Trust the right to allow
            modifications of such material outside the IETF Standards Process.
            Without obtaining an adequate license from the person(s)
            controlling the copyright in such materials, this document may not
            be modified outside the IETF Standards Process, and derivative
            works of it may not be created outside the IETF Standards Process,
            except to format it for publication as an RFC or to translate it
            into languages other than English.
            </t>""",
        ],
    },
}
