/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.header;

import com.google.inject.Inject;
import com.google.inject.Provider;
import javax.servlet.http.HttpServletRequest;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.header.ConfigurationService;
import org.apache.guacamole.auth.header.user.AuthenticatedUser;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.net.auth.credentials.CredentialsInfo;
import org.apache.guacamole.net.auth.credentials.GuacamoleInvalidCredentialsException;

public class AuthenticationProviderService {
    @Inject
    private ConfigurationService confService;
    @Inject
    private Provider<AuthenticatedUser> authenticatedUserProvider;

    public AuthenticatedUser authenticateUser(Credentials credentials) throws GuacamoleException {
        String username;
        HttpServletRequest request = credentials.getRequest();
        if (request != null && (username = request.getHeader(this.confService.getHttpAuthHeader())) != null) {
            AuthenticatedUser authenticatedUser = (AuthenticatedUser)((Object)this.authenticatedUserProvider.get());
            authenticatedUser.init(username, credentials);
            return authenticatedUser;
        }
        throw new GuacamoleInvalidCredentialsException("Invalid login.", CredentialsInfo.USERNAME_PASSWORD);
    }
}

