/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.AllPermission;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import net.sourceforge.jnlp.config.InfrastructureFileDescriptor;
import net.sourceforge.jnlp.config.PathsAndFiles;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.SecurityUtil;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.logging.OutputController;

public final class KeyStores {
    public static final Map<Integer, String> keystoresPaths = new HashMap<Integer, String>();
    private static final String KEYSTORE_TYPE = "JKS";

    public static final KeyStore getKeyStore(Level level, Type type) {
        boolean create = level == Level.USER;
        return KeyStores.getKeyStore(level, type, create);
    }

    public static final KeyStore getKeyStore(Level level, Type type, boolean create) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AllPermission());
        }
        String location = KeyStores.getKeyStoreLocation(level, type).getFullPath();
        KeyStore ks = null;
        try {
            ks = KeyStores.createKeyStoreFromFile(new File(location), create);
            keystoresPaths.put(ks.hashCode(), location);
        }
        catch (Exception e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
        }
        return ks;
    }

    public static String getPathToKeystore(int k) {
        String s = keystoresPaths.get(k);
        if (s == null) {
            return "unknown keystore location";
        }
        return s;
    }

    public static final KeyStore[] getCertKeyStores() {
        ArrayList<KeyStore> result = new ArrayList<KeyStore>(10);
        KeyStore ks = KeyStores.getKeyStore(Level.SYSTEM, Type.JSSE_CERTS);
        if (ks != null) {
            result.add(ks);
        }
        if ((ks = KeyStores.getKeyStore(Level.SYSTEM, Type.CERTS)) != null) {
            result.add(ks);
        }
        if ((ks = KeyStores.getKeyStore(Level.USER, Type.JSSE_CERTS)) != null) {
            result.add(ks);
        }
        if ((ks = KeyStores.getKeyStore(Level.USER, Type.CERTS)) != null) {
            result.add(ks);
        }
        return result.toArray(new KeyStore[result.size()]);
    }

    public static final KeyStore[] getCAKeyStores() {
        ArrayList<KeyStore> result = new ArrayList<KeyStore>(10);
        KeyStore ks = KeyStores.getKeyStore(Level.SYSTEM, Type.JSSE_CA_CERTS);
        if (ks != null) {
            result.add(ks);
        }
        if ((ks = KeyStores.getKeyStore(Level.SYSTEM, Type.CA_CERTS)) != null) {
            result.add(ks);
        }
        if ((ks = KeyStores.getKeyStore(Level.USER, Type.JSSE_CA_CERTS)) != null) {
            result.add(ks);
        }
        if ((ks = KeyStores.getKeyStore(Level.USER, Type.CA_CERTS)) != null) {
            result.add(ks);
        }
        return result.toArray(new KeyStore[result.size()]);
    }

    public static KeyStore[] getClientKeyStores() {
        ArrayList<KeyStore> result = new ArrayList<KeyStore>();
        KeyStore ks = KeyStores.getKeyStore(Level.SYSTEM, Type.CLIENT_CERTS);
        if (ks != null) {
            result.add(ks);
        }
        if ((ks = KeyStores.getKeyStore(Level.USER, Type.CLIENT_CERTS)) != null) {
            result.add(ks);
        }
        return result.toArray(new KeyStore[result.size()]);
    }

    public static final InfrastructureFileDescriptor getKeyStoreLocation(Level level, Type type) {
        switch (level) {
            case SYSTEM: {
                switch (type) {
                    case JSSE_CA_CERTS: {
                        return PathsAndFiles.SYS_JSSECAC;
                    }
                    case CA_CERTS: {
                        return PathsAndFiles.SYS_CACERT;
                    }
                    case JSSE_CERTS: {
                        return PathsAndFiles.SYS_JSSECERT;
                    }
                    case CERTS: {
                        return PathsAndFiles.SYS_CERT;
                    }
                    case CLIENT_CERTS: {
                        return PathsAndFiles.SYS_CLIENTCERT;
                    }
                }
                break;
            }
            case USER: {
                switch (type) {
                    case JSSE_CA_CERTS: {
                        return PathsAndFiles.USER_JSSECAC;
                    }
                    case CA_CERTS: {
                        return PathsAndFiles.USER_CACERTS;
                    }
                    case JSSE_CERTS: {
                        return PathsAndFiles.USER_JSSECER;
                    }
                    case CERTS: {
                        return PathsAndFiles.USER_CERTS;
                    }
                    case CLIENT_CERTS: {
                        return PathsAndFiles.USER_CLIENTCERT;
                    }
                }
            }
        }
        throw new RuntimeException("Unspported");
    }

    public static final String toTranslatableString(Level level, Type type) {
        StringBuilder response = new StringBuilder();
        response.append("KS");
        if (level != null) {
            String levelString = level.toString();
            response.append(levelString.substring(0, 1).toUpperCase());
            response.append(levelString.substring(1).toLowerCase());
        }
        if (type != null) {
            String typeString = type.toString();
            StringTokenizer tokenizer = new StringTokenizer(typeString, "_");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                response.append(token.substring(0, 1).toUpperCase());
                response.append(token.substring(1).toLowerCase());
            }
        }
        return response.toString();
    }

    public static String toDisplayableString(Level level, Type type) {
        return Translator.R(KeyStores.toTranslatableString(level, type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final KeyStore createKeyStoreFromFile(File file, boolean createIfNotFound) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        KeyStore ks = null;
        try (FileInputStream fis = null;){
            if (createIfNotFound && !file.exists()) {
                File parent = file.getParentFile();
                if (!parent.isDirectory() && !parent.mkdirs()) {
                    throw new IOException("unable to create " + parent);
                }
                FileUtils.createRestrictedFile(file, true);
                ks = KeyStore.getInstance(KEYSTORE_TYPE);
                SecurityUtil.loadKeyStore(ks, null);
                SecurityUtil.storeKeyStore(ks, file);
            }
            if (file.exists()) {
                ks = KeyStore.getInstance(KEYSTORE_TYPE);
                SecurityUtil.loadKeyStore(ks, file);
            } else {
                ks = KeyStore.getInstance(KEYSTORE_TYPE);
                SecurityUtil.loadKeyStore(ks, null);
            }
        }
        return ks;
    }

    public static enum Type {
        CERTS,
        JSSE_CERTS,
        CA_CERTS,
        JSSE_CA_CERTS,
        CLIENT_CERTS;

    }

    public static enum Level {
        USER,
        SYSTEM;

    }
}

