/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.nlp.tokenizer;

import ai.grazie.nlp.langs.Language;
import ai.grazie.nlp.tokenizer.JsExportableTokenizer;
import ai.grazie.nlp.tokenizer.TokenizerJsExportableWrapper;
import ai.grazie.nlp.tokenizer.sentence.StandardSentenceTokenizer;
import ai.grazie.nlp.tokenizer.spacy.SpacyTokenizerFast;
import ai.grazie.nlp.tokenizer.word.StandardWordTokenizer;
import ai.grazie.nlp.tokenizer.word.WhitespaceWordTokenizer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lai/grazie/nlp/tokenizer/JSTokenizers;", "", "()V", "whitespace", "Lai/grazie/nlp/tokenizer/JsExportableTokenizer;", "getWhitespace", "()Lai/grazie/nlp/tokenizer/JsExportableTokenizer;", "words", "getWords", "sentence", "splitByNewLinesNumber", "", "language", "Lai/grazie/nlp/langs/Language;", "spacy", "nlp-tokenizer"})
public final class JSTokenizers {
    @NotNull
    public static final JSTokenizers INSTANCE = new JSTokenizers();
    @NotNull
    private static final JsExportableTokenizer words = new TokenizerJsExportableWrapper(StandardWordTokenizer.INSTANCE);
    @NotNull
    private static final JsExportableTokenizer whitespace = new TokenizerJsExportableWrapper(WhitespaceWordTokenizer.INSTANCE);

    private JSTokenizers() {
    }

    @NotNull
    public final JsExportableTokenizer sentence(int splitByNewLinesNumber, @NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        return new TokenizerJsExportableWrapper(new StandardSentenceTokenizer(splitByNewLinesNumber, language));
    }

    public static /* synthetic */ JsExportableTokenizer sentence$default(JSTokenizers jSTokenizers, int n, Language language, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 2;
        }
        if ((n2 & 2) != 0) {
            language = Language.UNKNOWN;
        }
        return jSTokenizers.sentence(n, language);
    }

    @NotNull
    public final JsExportableTokenizer spacy(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        return switch (WhenMappings.$EnumSwitchMapping$0[language.ordinal()]) {
            case 1 -> new TokenizerJsExportableWrapper(SpacyTokenizerFast.Companion.loadEnglish$default(SpacyTokenizerFast.Companion, false, null, false, 7, null));
            case 2 -> new TokenizerJsExportableWrapper(SpacyTokenizerFast.Companion.loadRussian$default(SpacyTokenizerFast.Companion, false, null, 3, null));
            case 3 -> new TokenizerJsExportableWrapper(SpacyTokenizerFast.Companion.loadGerman$default(SpacyTokenizerFast.Companion, false, null, false, 7, null));
            default -> throw new IllegalStateException(("Unsupported language " + language).toString());
        };
    }

    @NotNull
    public final JsExportableTokenizer getWords() {
        return words;
    }

    @NotNull
    public final JsExportableTokenizer getWhitespace() {
        return whitespace;
    }

    @Metadata(mv={1, 7, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Language.values().length];
            try {
                nArray[Language.ENGLISH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Language.RUSSIAN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Language.GERMAN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

