/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.tokens;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.tokens.ZenCodingToken;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateToken
extends ZenCodingToken {
    public static final String ATTRS = "ATTRS";
    public static final TemplateToken EMPTY_TEMPLATE_TOKEN = new TemplateToken("", Collections.emptyMap());
    @NotNull
    private final String myKey;
    private TemplateImpl myTemplate;
    @NotNull
    private final Map<String, String> myAttributes;
    private final boolean myForceSingleTag;
    private PsiFile myFile;

    public TemplateToken(@NotNull String key2) {
        if (key2 == null) {
            TemplateToken.$$$reportNull$$$0(0);
        }
        this(key2, Collections.emptyMap());
    }

    public TemplateToken(@NotNull String key2, @NotNull Map<String, String> attribute2value) {
        if (key2 == null) {
            TemplateToken.$$$reportNull$$$0(1);
        }
        if (attribute2value == null) {
            TemplateToken.$$$reportNull$$$0(2);
        }
        this(key2, attribute2value, false);
    }

    public TemplateToken(@NotNull String key2, @NotNull Map<String, String> attribute2value, boolean forceSingleTag) {
        if (key2 == null) {
            TemplateToken.$$$reportNull$$$0(3);
        }
        if (attribute2value == null) {
            TemplateToken.$$$reportNull$$$0(4);
        }
        this.myKey = key2;
        this.myAttributes = attribute2value;
        this.myForceSingleTag = forceSingleTag;
    }

    @NotNull
    public Map<String, String> getAttributes() {
        Map<String, String> map = this.myAttributes;
        if (map == null) {
            TemplateToken.$$$reportNull$$$0(5);
        }
        return map;
    }

    public PsiFile getFile() {
        return this.myFile;
    }

    public String getTemplateText() {
        return this.myFile.getText();
    }

    private void setFile(PsiFile file) {
        this.myFile = file;
    }

    public boolean isForceSingleTag() {
        return this.myForceSingleTag;
    }

    @Nullable
    public XmlTag getXmlTag() {
        return (XmlTag)PsiTreeUtil.findChildOfType((PsiElement)this.myFile, XmlTag.class);
    }

    public void setTemplateText(@NotNull String templateText, @NotNull PsiFile context) {
        PsiFile file;
        VirtualFile vFile;
        if (templateText == null) {
            TemplateToken.$$$reportNull$$$0(6);
        }
        if (context == null) {
            TemplateToken.$$$reportNull$$$0(7);
        }
        if ((vFile = (file = PsiFileFactory.getInstance((Project)context.getProject()).createFileFromText("dummy.html", context.getLanguage(), (CharSequence)templateText, false, true)).getVirtualFile()) != null) {
            UndoUtil.disableUndoFor((VirtualFile)vFile);
        }
        this.setFile(file);
    }

    @NotNull
    public String getKey() {
        String string2 = this.myKey;
        if (string2 == null) {
            TemplateToken.$$$reportNull$$$0(8);
        }
        return string2;
    }

    public void setTemplate(@NotNull TemplateImpl template, @NotNull CustomTemplateCallback callback) {
        if (template == null) {
            TemplateToken.$$$reportNull$$$0(9);
        }
        if (callback == null) {
            TemplateToken.$$$reportNull$$$0(10);
        }
        this.myTemplate = template;
        this.setTemplateText(TemplateToken.createTemplateText(template, callback, this.getAttributes()), callback.getFile());
    }

    private static boolean containsAttrsVar(@NotNull TemplateImpl template) {
        if (template == null) {
            TemplateToken.$$$reportNull$$$0(11);
        }
        for (int i = 0; i < template.getVariableCount(); ++i) {
            String varName = template.getVariableNameAt(i);
            if (!ATTRS.equals(varName)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static String createTemplateText(@NotNull TemplateImpl template, @NotNull CustomTemplateCallback callback, @NotNull Map<String, String> attributes) {
        PsiFile dummyFile;
        if (template == null) {
            TemplateToken.$$$reportNull$$$0(12);
        }
        if (callback == null) {
            TemplateToken.$$$reportNull$$$0(13);
        }
        if (attributes == null) {
            TemplateToken.$$$reportNull$$$0(14);
        }
        XmlTag dummyRootTag = null;
        String templateString = template.getString();
        if (!TemplateToken.containsAttrsVar(template) && (dummyRootTag = (XmlTag)PsiTreeUtil.findChildOfType((PsiElement)(dummyFile = PsiFileFactory.getInstance((Project)callback.getProject()).createFileFromText("dummy.html", callback.getFile().getLanguage(), (CharSequence)templateString, false, true)), XmlTag.class)) != null && !attributes.isEmpty()) {
            TemplateToken.addMissingAttributes(dummyRootTag, attributes);
        }
        String string2 = dummyRootTag != null ? dummyRootTag.getContainingFile().getText() : templateString;
        if (string2 == null) {
            TemplateToken.$$$reportNull$$$0(15);
        }
        return string2;
    }

    private static void addMissingAttributes(@NotNull XmlTag tag, @NotNull Map<String, String> attributes) {
        if (tag == null) {
            TemplateToken.$$$reportNull$$$0(16);
        }
        if (attributes == null) {
            TemplateToken.$$$reportNull$$$0(17);
        }
        for (Map.Entry<String, String> attribute : attributes.entrySet()) {
            XmlTag htmlTag;
            XmlAttribute newAttribute;
            if ("%default".equals(attribute.getKey()) || tag.getAttribute(attribute.getKey()) != null || (newAttribute = (XmlAttribute)ArrayUtil.getFirstElement((Object[])(htmlTag = XmlElementFactory.getInstance(tag.getProject()).createHTMLTagFromText("<dummy " + attribute.getKey() + "=\"\"/>")).getAttributes())) == null) continue;
            tag.add(newAttribute);
        }
    }

    @Nullable
    public TemplateImpl getTemplate() {
        return this.myTemplate;
    }

    @NotNull
    public String toString() {
        return "TEMPLATE";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 8, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute2value";
                break;
            }
            case 5: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/emmet/tokens/TemplateToken";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateText";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/emmet/tokens/TemplateToken";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemplateText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 8: 
            case 15: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setTemplateText";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setTemplate";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "containsAttrsVar";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createTemplateText";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addMissingAttributes";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5, 8, 15 -> new IllegalStateException(string2);
        };
    }
}

