/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.inspector.accessibilityAudit;

import com.intellij.internal.inspector.accessibilityAudit.Severity;
import com.intellij.internal.inspector.accessibilityAudit.UiInspectorAccessibilityInspection;
import com.intellij.internal.inspector.accessibilityAudit.UtilsKt;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/internal/inspector/accessibilityAudit/AccessibleNameNotEmptyForFocusableComponentsInspection;", "Lcom/intellij/internal/inspector/accessibilityAudit/UiInspectorAccessibilityInspection;", "<init>", "()V", "propertyName", "", "getPropertyName", "()Ljava/lang/String;", "severity", "Lcom/intellij/internal/inspector/accessibilityAudit/Severity;", "getSeverity", "()Lcom/intellij/internal/inspector/accessibilityAudit/Severity;", "passesInspection", "", "context", "Ljavax/accessibility/AccessibleContext;", "intellij.platform.ide.ui.inspector"})
@ApiStatus.Internal
@ApiStatus.Experimental
public final class AccessibleNameNotEmptyForFocusableComponentsInspection
implements UiInspectorAccessibilityInspection {
    @NotNull
    private final String propertyName;
    @NotNull
    private final Severity severity = Severity.WARNING;

    public AccessibleNameNotEmptyForFocusableComponentsInspection() {
        this.propertyName = "AccessibleName";
    }

    @Override
    @NotNull
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    @NotNull
    public Severity getSeverity() {
        return this.severity;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean passesInspection(@NotNull AccessibleContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!UtilsKt.isVisibleAndEnabled(context)) return true;
        if (!context.getAccessibleStateSet().contains(AccessibleState.FOCUSABLE)) return true;
        if (!UtilsKt.isInteractive(context)) return true;
        if (context.getAccessibleName() == null) return false;
        String string2 = context.getAccessibleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAccessibleName(...)");
        if (((CharSequence)string2).length() != 0) return true;
        return false;
    }
}

