/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.inspector.components;

import com.intellij.ide.DataManager;
import com.intellij.internal.inspector.components.DataContextDialog;
import com.intellij.openapi.actionSystem.CustomizedDataContext;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0003/01B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0014J\u0013\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0014\u00a2\u0006\u0002\u0010\u000fJ\n\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0014\u0010\u0015\u001a\u00020\u0016*\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0014\u0010\u0019\u001a\u00020\u0016*\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\f\u0010\u001c\u001a\u00020\u0016*\u00020\u0012H\u0002J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J4\u0010\u001f\u001a\u00020\u00142\b\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010!2\u0006\u0010#\u001a\u00020$2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010&H\u0002J\u0014\u0010'\u001a\u00020\u00142\n\u0010(\u001a\u0006\u0012\u0002\b\u00030)H\u0002J\u0018\u0010*\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u0014H\u0002J\u0010\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020!H\u0002J\u0010\u0010.\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020!H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u00062"}, d2={"Lcom/intellij/internal/inspector/components/DataContextDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "contextComponent", "Ljavax/swing/JComponent;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljavax/swing/JComponent;)V", "getContextComponent", "()Ljavax/swing/JComponent;", "getDimensionServiceKey", "", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "createCenterPanel", "buildTreeModel", "Ljavax/swing/table/DefaultTableModel;", "showDataRules", "", "appendHeader", "", "component", "Ljava/awt/Component;", "appendRow", "data", "Lcom/intellij/internal/inspector/components/DataContextDialog$ContextData;", "appendEmptyRow", "collectDataFrom", "", "equalData", "o1", "", "o2", "level", "", "visited", "", "isSpecialContextComponentOnlyKey", "key", "Lcom/intellij/openapi/actionSystem/DataKey;", "getKeyPresentation", "overridden", "getValuePresentation", "value", "getClassName", "MyTableCellRenderer", "ContextData", "Header", "intellij.platform.ide.ui.inspector"})
@SourceDebugExtension(value={"SMAP\nDataContextDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataContextDialog.kt\ncom/intellij/internal/inspector/components/DataContextDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,226:1\n1#2:227\n*E\n"})
public final class DataContextDialog
extends DialogWrapper {
    @NotNull
    private final JComponent contextComponent;

    public DataContextDialog(@Nullable Project project2, @NotNull JComponent contextComponent) {
        Intrinsics.checkNotNullParameter((Object)contextComponent, (String)"contextComponent");
        super(project2);
        this.contextComponent = contextComponent;
        this.init();
    }

    @NotNull
    public final JComponent getContextComponent() {
        return this.contextComponent;
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "UiInternal.DataContextDialog";
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getCancelAction()};
        return actionArray;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JBTable table = new JBTable();
        table.setDefaultRenderer(Object.class, (TableCellRenderer)((Object)new MyTableCellRenderer()));
        table.setModel((TableModel)this.buildTreeModel(false));
        TableSpeedSearch.installOn((JTable)((JTable)table));
        DialogPanel panel = BuilderKt.panel(arg_0 -> DataContextDialog.createCenterPanel$lambda$3(table, this, arg_0));
        Rectangle rectangle = ScreenUtil.getMainScreenBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getMainScreenBounds(...)");
        Rectangle screenBounds = rectangle;
        int width = (int)((double)screenBounds.width * 0.8);
        int height = (int)((double)screenBounds.height * 0.8);
        return (JComponent)panel.withPreferredSize(width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DefaultTableModel buildTreeModel(boolean showDataRules) {
        DefaultTableModel model2 = new DefaultTableModel(){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        model2.addColumn("Key");
        model2.addColumn("Value");
        model2.addColumn("Value type");
        for (Component component = (Component)this.contextComponent; component != null; component = (Component)component.getParent()) {
            List<ContextData> list2;
            Component c = component;
            AccessToken accessToken = showDataRules ? SlowOperations.knownIssue((String)"move collection to BGT") : AccessToken.EMPTY_ACCESS_TOKEN;
            Intrinsics.checkNotNull((Object)accessToken);
            AccessToken token = accessToken;
            AutoCloseable autoCloseable = (AutoCloseable)token;
            Throwable throwable = null;
            try {
                AccessToken it = (AccessToken)autoCloseable;
                boolean bl = false;
                list2 = this.collectDataFrom(c, showDataRules);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            List<ContextData> result2 = list2;
            if (!(!((Collection)result2).isEmpty())) continue;
            if (model2.getRowCount() > 0) {
                this.appendEmptyRow(model2);
            }
            this.appendHeader(model2, c);
            for (ContextData data2 : result2) {
                this.appendRow(model2, data2);
            }
        }
        return model2;
    }

    private final void appendHeader(DefaultTableModel $this$appendHeader, Component component) {
        Object[] objectArray = new Object[]{new Header(String.valueOf(component)), null, this.getClassName(component)};
        $this$appendHeader.addRow(objectArray);
    }

    private final void appendRow(DefaultTableModel $this$appendRow, ContextData data2) {
        Object[] objectArray = new String[]{this.getKeyPresentation(data2.getKey(), data2.getOverridden()), data2.getValueStr(), data2.getValueClass()};
        $this$appendRow.addRow(objectArray);
    }

    private final void appendEmptyRow(DefaultTableModel $this$appendEmptyRow) {
        Object[] objectArray = new String[]{"", "", ""};
        $this$appendEmptyRow.addRow(objectArray);
    }

    private final List<ContextData> collectDataFrom(Component component, boolean showDataRules) {
        DataContext dataContext;
        DataContext dataContext2;
        DataManager dataManager = DataManager.getInstance();
        DataContext it = dataManager.getDataContext(component);
        boolean bl = false;
        if (showDataRules) {
            dataContext2 = it;
        } else {
            Intrinsics.checkNotNull((Object)it);
            dataContext2 = Utils.getUiOnlyDataContext((DataContext)it);
        }
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"let(...)");
        DataContext context = dataContext2;
        DataContext it2 = dataManager.getDataContext((Component)component.getParent());
        boolean bl2 = false;
        if (showDataRules) {
            dataContext = it2;
        } else {
            Intrinsics.checkNotNull((Object)it2);
            dataContext = Utils.getUiOnlyDataContext((DataContext)it2);
        }
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"let(...)");
        DataContext parentContext = dataContext;
        List result2 = new ArrayList();
        for (DataKey key2 : DataKey.Companion.allKeys()) {
            Object parentData;
            boolean specialKey = this.isSpecialContextComponentOnlyKey(key2);
            if (specialKey && component != this.contextComponent) continue;
            Object data2 = context.getData(key2);
            Object object = parentData = specialKey ? null : parentContext.getData(key2);
            if (this.equalData(data2, parentData, 0, null)) continue;
            Collection collection = result2;
            String string2 = key2.getName();
            Object object2 = data2;
            if (object2 == null) {
                object2 = CustomizedDataContext.EXPLICIT_NULL;
            }
            Object object3 = object2;
            Intrinsics.checkNotNull((Object)object3);
            String string3 = this.getValuePresentation(object3);
            Object object4 = data2;
            if (object4 == null) {
                object4 = CustomizedDataContext.EXPLICIT_NULL;
            }
            object3 = object4;
            Intrinsics.checkNotNull((Object)object3);
            collection.add(new ContextData(string2, string3, this.getClassName(object3), parentData != null && !Intrinsics.areEqual((Object)key2, (Object)PlatformCoreDataKeys.BGT_DATA_PROVIDER)));
        }
        Comparator<Object> comparator2 = Comparator.comparing(arg_0 -> DataContextDialog.collectDataFrom$lambda$8(DataContextDialog::collectDataFrom$lambda$7, arg_0));
        Intrinsics.checkNotNullExpressionValue(comparator2, (String)"comparing(...)");
        CollectionsKt.sortWith((List)result2, comparator2);
        return result2;
    }

    private final boolean equalData(Object o1, Object o2, int level, Set<Object> visited) {
        boolean bl;
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        Class<?> c1 = o1.getClass();
        Class<?> c2 = o2.getClass();
        if (level > 10) {
            Set<Object> set = visited;
            @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u000e"}, d2={"com/intellij/internal/inspector/components/DataContextDialog$equalData$P", "", "o1", "o2", "<init>", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;)V", "getO1", "()Ljava/lang/Object;", "getO2", "equals", "", "other", "hashCode", "", "intellij.platform.ide.ui.inspector"})
            public final class P {
                private final Object o1;
                private final Object o2;
                final /* synthetic */ Object $o1;
                final /* synthetic */ Object $o2;

                public P(Object $o1, Object $o2, Object o1, Object o2) {
                    Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
                    Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
                    this.$o1 = $o1;
                    this.$o2 = $o2;
                    this.o1 = o1;
                    this.o2 = o2;
                }

                public final Object getO1() {
                    return this.o1;
                }

                public final Object getO2() {
                    return this.o2;
                }

                public boolean equals(Object other) {
                    return other instanceof P && this.$o1 == ((P)other).o1 && this.$o2 == ((P)other).o2;
                }

                public int hashCode() {
                    Object object = this.$o1;
                    Object object2 = this.$o2;
                    return (object != null ? object.hashCode() : 0) + (object2 != null ? object2.hashCode() : 0) * 31;
                }
            }
            bl = set != null ? set.contains(new P(o1, o2, o1, o2)) : false;
        } else if (Comparing.equal((Object)o1, (Object)o2)) {
            bl = true;
        } else if (o1 instanceof Object[] && o2 instanceof Object[]) {
            bl = this.equalData(ArraysKt.toList((Object[])((Object[])o1)), ArraysKt.toList((Object[])((Object[])o2)), level + 1, DataContextDialog.equalData$set(visited, o1, o2));
        } else if (o1 instanceof Reference && o2 instanceof Reference) {
            bl = Comparing.equal(((Reference)o1).get(), ((Reference)o2).get());
        } else if (o1 instanceof Collection && o2 instanceof Collection) {
            if (((Collection)o1).size() != ((Collection)o2).size()) {
                return false;
            }
            Iterator it1 = ((Collection)o1).iterator();
            Iterator it2 = ((Collection)o2).iterator();
            while (it1.hasNext()) {
                if (this.equalData(it1.next(), it2.next(), level + 1, DataContextDialog.equalData$set(visited, o1, o2))) continue;
                return false;
            }
            bl = true;
        } else if (!Intrinsics.areEqual(c1, c2)) {
            bl = false;
        } else if (o1 instanceof JBIterable && o2 instanceof JBIterable) {
            bl = this.equalData(((JBIterable)o1).toList(), ((JBIterable)o2).toList(), level + 1, DataContextDialog.equalData$set(visited, o1, o2));
        } else {
            for (Field field : ReflectionUtil.collectFields(c1)) {
                Object o22;
                if (Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                Object o11 = field.get(o1);
                if (this.equalData(o11, o22 = field.get(o2), level + 1, DataContextDialog.equalData$set(visited, o1, o2))) continue;
                return false;
            }
            bl = true;
        }
        return bl;
    }

    private final boolean isSpecialContextComponentOnlyKey(DataKey<?> key2) {
        return key2 == PlatformCoreDataKeys.CONTEXT_COMPONENT || key2 == PlatformCoreDataKeys.IS_MODAL_CONTEXT || key2 == PlatformDataKeys.MODALITY_STATE || key2 == PlatformDataKeys.SPEED_SEARCH_TEXT || key2 == PlatformDataKeys.SPEED_SEARCH_COMPONENT;
    }

    private final String getKeyPresentation(String key2, boolean overridden) {
        return overridden ? "*OVERRIDDEN* " + key2 : key2;
    }

    private final String getValuePresentation(Object value) {
        String string2;
        if (value instanceof Object[]) {
            String string3 = Arrays.toString((Object[])value);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        } else {
            string2 = value.toString();
        }
        return string2;
    }

    private final String getClassName(Object value) {
        Object object;
        Class<?> clazz = value.getClass();
        if (clazz.isAnonymousClass()) {
            object = clazz.getSuperclass().getSimpleName() + "$...";
        } else {
            String string2 = clazz.getSimpleName();
            object = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSimpleName(...)");
        }
        return object;
    }

    private static final Unit createCenterPanel$lambda$3$lambda$1$lambda$0(JBTable $table, DataContextDialog this$0, ActionEvent event, JBCheckBox component) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        $table.setModel((TableModel)this$0.buildTreeModel(component.isSelected()));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$3$lambda$1(JBTable $table, DataContextDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ButtonKt.actionListener((Cell)$this$row.checkBox("Show BGT Data"), (arg_0, arg_1) -> DataContextDialog.createCenterPanel$lambda$3$lambda$1$lambda$0($table, this$0, arg_0, arg_1));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$3$lambda$2(JBTable $table, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.scrollCell((JComponent)$table).align(Align.FILL).resizableColumn();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$3(JBTable $table, DataContextDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DataContextDialog.createCenterPanel$lambda$3$lambda$1($table, this$0, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DataContextDialog.createCenterPanel$lambda$3$lambda$2($table, arg_0), (int)1, null).resizableRow();
        return Unit.INSTANCE;
    }

    private static final String collectDataFrom$lambda$7(ContextData it) {
        return StringUtil.toUpperCase((String)it.getKey());
    }

    private static final String collectDataFrom$lambda$8(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Set<Object> equalData$set(Set<Object> $visited, Object $o1, Object $o2) {
        Set set;
        Set set2 = $visited;
        if (set2 == null) {
            set2 = new HashSet();
        }
        Set $this$equalData_u24set_u24lambda_u249 = set = set2;
        boolean bl = false;
        Object object = $o1;
        Intrinsics.checkNotNull((Object)object);
        Object object2 = $o2;
        Intrinsics.checkNotNull((Object)object2);
        $this$equalData_u24set_u24lambda_u249.add(new P($o1, $o2, object, object2));
        return set;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/internal/inspector/components/DataContextDialog$ContextData;", "", "key", "", "valueStr", "valueClass", "overridden", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "getKey", "()Ljava/lang/String;", "getValueStr", "getValueClass", "getOverridden", "()Z", "intellij.platform.ide.ui.inspector"})
    private static final class ContextData {
        @NotNull
        private final String key;
        @NotNull
        private final String valueStr;
        @NotNull
        private final String valueClass;
        private final boolean overridden;

        public ContextData(@NotNull String key2, @NotNull String valueStr, @NotNull String valueClass, boolean overridden) {
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            Intrinsics.checkNotNullParameter((Object)valueStr, (String)"valueStr");
            Intrinsics.checkNotNullParameter((Object)valueClass, (String)"valueClass");
            this.key = key2;
            this.valueStr = valueStr;
            this.valueClass = valueClass;
            this.overridden = overridden;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public final String getValueStr() {
            return this.valueStr;
        }

        @NotNull
        public final String getValueClass() {
            return this.valueClass;
        }

        public final boolean getOverridden() {
            return this.overridden;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/internal/inspector/components/DataContextDialog$Header;", "", "key", "", "<init>", "(Ljava/lang/String;)V", "getKey", "()Ljava/lang/String;", "toString", "intellij.platform.ide.ui.inspector"})
    private static final class Header {
        @NotNull
        private final String key;

        public Header(@NotNull String key2) {
            Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
            this.key = key2;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public String toString() {
            return this.key;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/internal/inspector/components/DataContextDialog$MyTableCellRenderer;", "Lcom/intellij/ui/ColoredTableCellRenderer;", "<init>", "()V", "customizeCellRenderer", "", "table", "Ljavax/swing/JTable;", "value", "", "selected", "", "hasFocus", "row", "", "column", "intellij.platform.ide.ui.inspector"})
    private static final class MyTableCellRenderer
    extends ColoredTableCellRenderer {
        protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
            boolean isHeader;
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            if (value != null) {
                this.append(value.toString());
            }
            if (isHeader = table.getModel().getValueAt(row, 0) instanceof Header) {
                this.setBackground(JBUI.CurrentTheme.Table.Selection.background((boolean)false));
            }
        }
    }
}

