/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.inspector.components;

import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

final class DimensionsComponent
extends JComponent {
    Component myComponent;
    int myWidth;
    int myHeight;
    Border myBorder;
    Insets myInsets;

    DimensionsComponent(@NotNull Component component) {
        if (component == null) {
            DimensionsComponent.$$$reportNull$$$0(0);
        }
        this.myComponent = component;
        this.setOpaque(true);
        this.setBackground((Color)JBColor.WHITE);
        this.setBorder(JBUI.Borders.customLine((Color)JBColor.border()));
        this.setFont((Font)JBUI.Fonts.label((float)9.0f));
        this.myWidth = this.myComponent.getWidth();
        this.myHeight = this.myComponent.getHeight();
        if (this.myComponent instanceof JComponent) {
            this.myBorder = ((JComponent)this.myComponent).getBorder();
            this.myInsets = ((JComponent)this.myComponent).getInsets();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        GraphicsConfig config = new GraphicsConfig(g).setAntialiasing(UISettings.getShadowInstance().getIdeAAType() != AntialiasingType.OFF);
        Rectangle bounds = this.getBounds();
        g2d.setColor(this.getBackground());
        Insets insets = this.getInsets();
        g2d.fillRect(insets.left, insets.top, bounds.width - insets.left - insets.right, bounds.height - insets.top - insets.bottom);
        String sizeString = String.format("%d x %d", this.myWidth, this.myHeight);
        FontMetrics fm = g2d.getFontMetrics();
        int sizeWidth = fm.stringWidth(sizeString);
        int fontHeight = fm.getHeight();
        int innerBoxWidthGap = JBUIScale.scale((int)20);
        int innerBoxHeightGap = JBUIScale.scale((int)5);
        int boxSize = JBUIScale.scale((int)15);
        int centerX = bounds.width / 2;
        int centerY = bounds.height / 2;
        int innerX = centerX - sizeWidth / 2 - innerBoxWidthGap;
        int innerY = centerY - fontHeight / 2 - innerBoxHeightGap;
        int innerWidth = sizeWidth + innerBoxWidthGap * 2;
        int innerHeight = fontHeight + innerBoxHeightGap * 2;
        g2d.setColor(this.getForeground());
        DimensionsComponent.drawCenteredString(g2d, fm, fontHeight, sizeString, centerX, centerY);
        g2d.setColor((Color)JBColor.GRAY);
        g2d.drawRect(innerX, innerY, innerWidth, innerHeight);
        Insets borderInsets = null;
        if (this.myBorder != null) {
            borderInsets = this.myBorder.getBorderInsets(this.myComponent);
        }
        UIUtil.drawDottedRectangle((Graphics)g2d, (int)(innerX - boxSize), (int)(innerY - boxSize), (int)(innerX + innerWidth + boxSize), (int)(innerY + innerHeight + boxSize));
        DimensionsComponent.drawInsets(g2d, fm, "border", borderInsets, boxSize, fontHeight, innerX, innerY, innerWidth, innerHeight);
        g2d.drawRect(innerX - boxSize * 2, innerY - boxSize * 2, innerWidth + boxSize * 4, innerHeight + boxSize * 4);
        DimensionsComponent.drawInsets(g2d, fm, "insets", this.myInsets, boxSize * 2, fontHeight, innerX, innerY, innerWidth, innerHeight);
        config.restore();
    }

    private static void drawInsets(Graphics2D g2d, FontMetrics fm, String name, Insets insets, int offset, int fontHeight, int innerX, int innerY, int innerWidth, int innerHeight) {
        g2d.setColor((Color)JBColor.BLACK);
        g2d.drawString(name, innerX - offset + JBUIScale.scale((int)5), innerY - offset + fontHeight);
        g2d.setColor((Color)JBColor.GRAY);
        int outerX = innerX - offset;
        int outerWidth = innerWidth + offset * 2;
        int outerY = innerY - offset;
        int outerHeight = innerHeight + offset * 2;
        String top = insets != null ? Integer.toString(insets.top) : "-";
        String bottom = insets != null ? Integer.toString(insets.bottom) : "-";
        String left = insets != null ? Integer.toString(insets.left) : "-";
        String right = insets != null ? Integer.toString(insets.right) : "-";
        int shift = JBUIScale.scale((int)7);
        DimensionsComponent.drawCenteredString(g2d, fm, fontHeight, top, outerX + outerWidth / 2, outerY + shift);
        DimensionsComponent.drawCenteredString(g2d, fm, fontHeight, bottom, outerX + outerWidth / 2, outerY + outerHeight - shift);
        DimensionsComponent.drawCenteredString(g2d, fm, fontHeight, left, outerX + shift, outerY + outerHeight / 2);
        DimensionsComponent.drawCenteredString(g2d, fm, fontHeight, right, outerX + outerWidth - shift, outerY + outerHeight / 2);
    }

    private static void drawCenteredString(Graphics2D g2d, FontMetrics fm, int fontHeight, String text2, int x, int y) {
        int width = fm.stringWidth(text2);
        UIUtil.drawCenteredString((Graphics2D)g2d, (Rectangle)new Rectangle(x - width / 2, y - fontHeight / 2, width, fontHeight), (String)text2);
    }

    @Override
    public Dimension getMinimumSize() {
        return JBUI.size((int)120);
    }

    @Override
    public Dimension getPreferredSize() {
        return JBUI.size((int)150);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/internal/inspector/components/DimensionsComponent", "<init>"));
    }
}

