/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.XmlDomBundle;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddDomElementQuickFix<T extends DomElement>
implements LocalQuickFix {
    protected final T myElement;
    @IntentionName
    protected final String myName;

    public AddDomElementQuickFix(@NotNull T element) {
        if (element == null) {
            AddDomElementQuickFix.$$$reportNull$$$0(0);
        }
        this.myElement = element.createStableCopy();
        this.myName = this.computeName();
    }

    @NotNull
    public String getName() {
        String string2 = this.myName;
        if (string2 == null) {
            AddDomElementQuickFix.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @IntentionName
    private String computeName() {
        String name = this.myElement.getXmlElementName();
        return XmlDomBundle.message(this.isTag() ? "dom.quickfix.add.element.name" : "dom.quickfix.add.attribute.name", name);
    }

    private boolean isTag() {
        return this.myElement.getXmlElement() instanceof XmlTag;
    }

    @NotNull
    public String getFamilyName() {
        String string2 = XmlDomBundle.message("dom.quickfix.add.element.family", new Object[0]);
        if (string2 == null) {
            AddDomElementQuickFix.$$$reportNull$$$0(2);
        }
        return string2;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        if (project2 == null) {
            AddDomElementQuickFix.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            AddDomElementQuickFix.$$$reportNull$$$0(4);
        }
        XmlElement element = this.myElement.ensureXmlElementExists();
        if (ApplicationManager.getApplication().isDispatchThread()) {
            XmlElement navigationElement = this.isTag() ? element : ((XmlAttribute)element).getValueElement();
            PsiNavigateUtil.navigate((PsiElement)navigationElement);
        }
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        XmlElement parent;
        DomElement element;
        if (target == null) {
            AddDomElementQuickFix.$$$reportNull$$$0(5);
        }
        if ((element = DomUtil.getDomElement(parent = (XmlElement)PsiTreeUtil.findSameElementInCopy((PsiElement)this.myElement.getParent().getXmlElement(), (PsiFile)target))) == null) {
            return null;
        }
        AbstractDomChildrenDescription description = this.myElement.getChildDescription();
        if (description == null) {
            return null;
        }
        List<? extends DomElement> values = description.getStableValues(element);
        return values.isEmpty() ? null : new AddDomElementQuickFix<DomElement>(values.get(0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/highlighting/AddDomElementQuickFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/highlighting/AddDomElementQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 2 -> new IllegalStateException(string2);
        };
    }
}

