/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.NameClass;
import com.thaiopensource.relaxng.impl.NameClassVisitor;
import com.thaiopensource.relaxng.impl.SimpleNameClass;
import com.thaiopensource.xml.util.Name;

class OverlapDetector
implements NameClassVisitor {
    private final NameClass nc1;
    private final NameClass nc2;
    private boolean overlaps = false;
    private static final String IMPOSSIBLE = "\u0000";

    private OverlapDetector(NameClass nameClass, NameClass nameClass2) {
        this.nc1 = nameClass;
        this.nc2 = nameClass2;
        nameClass.accept(this);
        nameClass2.accept(this);
    }

    private void probe(Name name) {
        if (this.nc1.contains(name) && this.nc2.contains(name)) {
            this.overlaps = true;
        }
    }

    public void visitChoice(NameClass nameClass, NameClass nameClass2) {
        nameClass.accept(this);
        nameClass2.accept(this);
    }

    public void visitNsName(String string2) {
        this.probe(new Name(string2, IMPOSSIBLE));
    }

    public void visitNsNameExcept(String string2, NameClass nameClass) {
        this.probe(new Name(string2, IMPOSSIBLE));
        nameClass.accept(this);
    }

    public void visitAnyName() {
        this.probe(new Name(IMPOSSIBLE, IMPOSSIBLE));
    }

    public void visitAnyNameExcept(NameClass nameClass) {
        this.probe(new Name(IMPOSSIBLE, IMPOSSIBLE));
        nameClass.accept(this);
    }

    public void visitName(Name name) {
        this.probe(name);
    }

    public void visitNull() {
    }

    public void visitError() {
    }

    static boolean overlap(NameClass nameClass, NameClass nameClass2) {
        if (nameClass2 instanceof SimpleNameClass) {
            SimpleNameClass simpleNameClass = (SimpleNameClass)nameClass2;
            return nameClass.contains(simpleNameClass.getName());
        }
        if (nameClass instanceof SimpleNameClass) {
            SimpleNameClass simpleNameClass = (SimpleNameClass)nameClass;
            return nameClass2.contains(simpleNameClass.getName());
        }
        return new OverlapDetector((NameClass)nameClass, (NameClass)nameClass2).overlaps;
    }
}

