/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.impl;

import com.thaiopensource.relaxng.impl.DataDerivType;
import com.thaiopensource.relaxng.impl.DataDerivTypeFunction;
import com.thaiopensource.relaxng.impl.Pattern;
import com.thaiopensource.relaxng.impl.PatternFunction;
import com.thaiopensource.relaxng.impl.StartAttributeDerivFunction;
import com.thaiopensource.relaxng.impl.StartTagOpenDerivFunction;
import com.thaiopensource.relaxng.impl.StartTagOpenRecoverDerivFunction;
import com.thaiopensource.relaxng.impl.ValidatorPatternBuilder;
import com.thaiopensource.xml.util.Name;
import java.util.Hashtable;
import org.relaxng.datatype.ValidationContext;

final class PatternMemo {
    private final Pattern pattern;
    private final ValidatorPatternBuilder builder;
    private final boolean notAllowed;
    private PatternMemo memoEndAttributes;
    private PatternMemo memoTextOnly;
    private PatternMemo memoEndTagDeriv;
    private PatternMemo memoMixedTextDeriv;
    private PatternMemo memoIgnoreMissingAttributes;
    private Hashtable startTagOpenDerivMap;
    private Hashtable startTagOpenRecoverDerivMap;
    private Hashtable startAttributeDerivMap;
    private DataDerivType memoDataDerivType;

    PatternMemo(Pattern pattern, ValidatorPatternBuilder validatorPatternBuilder) {
        this.pattern = pattern;
        this.builder = validatorPatternBuilder;
        this.notAllowed = pattern.isNotAllowed();
    }

    Pattern getPattern() {
        return this.pattern;
    }

    ValidatorPatternBuilder getPatternBuilder() {
        return this.builder;
    }

    boolean isNotAllowed() {
        return this.notAllowed;
    }

    PatternMemo endAttributes() {
        if (this.memoEndAttributes == null) {
            this.memoEndAttributes = this.applyForPatternMemo(this.builder.getEndAttributesFunction());
        }
        return this.memoEndAttributes;
    }

    PatternMemo endAttributes(PatternFunction patternFunction) {
        if (this.memoEndAttributes == null) {
            this.memoEndAttributes = this.applyForPatternMemo(patternFunction);
        }
        return this.memoEndAttributes;
    }

    PatternMemo ignoreMissingAttributes() {
        if (this.memoIgnoreMissingAttributes == null) {
            this.memoIgnoreMissingAttributes = this.applyForPatternMemo(this.builder.getIgnoreMissingAttributesFunction());
        }
        return this.memoIgnoreMissingAttributes;
    }

    PatternMemo ignoreMissingAttributes(PatternFunction patternFunction) {
        if (this.memoIgnoreMissingAttributes == null) {
            this.memoIgnoreMissingAttributes = this.applyForPatternMemo(patternFunction);
        }
        return this.memoIgnoreMissingAttributes;
    }

    PatternMemo textOnly() {
        if (this.memoTextOnly == null) {
            this.memoTextOnly = this.applyForPatternMemo(this.builder.getTextOnlyFunction());
        }
        return this.memoTextOnly;
    }

    PatternMemo textOnly(PatternFunction patternFunction) {
        if (this.memoTextOnly == null) {
            this.memoTextOnly = this.applyForPatternMemo(patternFunction);
        }
        return this.memoTextOnly;
    }

    PatternMemo endTagDeriv() {
        if (this.memoEndTagDeriv == null) {
            this.memoEndTagDeriv = this.applyForPatternMemo(this.builder.getEndTagDerivFunction());
        }
        return this.memoEndTagDeriv;
    }

    PatternMemo endTagDeriv(PatternFunction patternFunction) {
        if (this.memoEndTagDeriv == null) {
            this.memoEndTagDeriv = this.applyForPatternMemo(patternFunction);
        }
        return this.memoEndTagDeriv;
    }

    PatternMemo mixedTextDeriv() {
        if (this.memoMixedTextDeriv == null) {
            this.memoMixedTextDeriv = this.applyForPatternMemo(this.builder.getMixedTextDerivFunction());
        }
        return this.memoMixedTextDeriv;
    }

    PatternMemo mixedTextDeriv(PatternFunction patternFunction) {
        if (this.memoMixedTextDeriv == null) {
            this.memoMixedTextDeriv = this.applyForPatternMemo(patternFunction);
        }
        return this.memoMixedTextDeriv;
    }

    PatternMemo startTagOpenDeriv(Name name) {
        return this.startTagOpenDeriv(name, null);
    }

    PatternMemo startTagOpenDeriv(StartTagOpenDerivFunction startTagOpenDerivFunction) {
        return this.startTagOpenDeriv(startTagOpenDerivFunction.getName(), startTagOpenDerivFunction);
    }

    private PatternMemo startTagOpenDeriv(Name name, StartTagOpenDerivFunction startTagOpenDerivFunction) {
        PatternMemo patternMemo;
        if (this.startTagOpenDerivMap == null) {
            this.startTagOpenDerivMap = new Hashtable();
        } else {
            patternMemo = (PatternMemo)this.startTagOpenDerivMap.get(name);
            if (patternMemo != null) {
                return patternMemo;
            }
        }
        if (startTagOpenDerivFunction == null) {
            startTagOpenDerivFunction = new StartTagOpenDerivFunction(name, this.builder);
        }
        patternMemo = this.applyForPatternMemo(startTagOpenDerivFunction);
        this.startTagOpenDerivMap.put(name, patternMemo);
        return patternMemo;
    }

    PatternMemo startTagOpenRecoverDeriv(Name name) {
        return this.startTagOpenRecoverDeriv(name, null);
    }

    PatternMemo startTagOpenRecoverDeriv(StartTagOpenRecoverDerivFunction startTagOpenRecoverDerivFunction) {
        return this.startTagOpenRecoverDeriv(startTagOpenRecoverDerivFunction.getName(), startTagOpenRecoverDerivFunction);
    }

    private PatternMemo startTagOpenRecoverDeriv(Name name, StartTagOpenRecoverDerivFunction startTagOpenRecoverDerivFunction) {
        PatternMemo patternMemo;
        if (this.startTagOpenRecoverDerivMap == null) {
            this.startTagOpenRecoverDerivMap = new Hashtable();
        } else {
            patternMemo = (PatternMemo)this.startTagOpenRecoverDerivMap.get(name);
            if (patternMemo != null) {
                return patternMemo;
            }
        }
        if (startTagOpenRecoverDerivFunction == null) {
            startTagOpenRecoverDerivFunction = new StartTagOpenRecoverDerivFunction(name, this.builder);
        }
        patternMemo = this.applyForPatternMemo(startTagOpenRecoverDerivFunction);
        this.startTagOpenRecoverDerivMap.put(name, patternMemo);
        return patternMemo;
    }

    PatternMemo startAttributeDeriv(Name name) {
        return this.startAttributeDeriv(name, null);
    }

    PatternMemo startAttributeDeriv(StartAttributeDerivFunction startAttributeDerivFunction) {
        return this.startAttributeDeriv(startAttributeDerivFunction.getName(), startAttributeDerivFunction);
    }

    private PatternMemo startAttributeDeriv(Name name, StartAttributeDerivFunction startAttributeDerivFunction) {
        PatternMemo patternMemo;
        if (this.startAttributeDerivMap == null) {
            this.startAttributeDerivMap = new Hashtable();
        } else {
            patternMemo = (PatternMemo)this.startAttributeDerivMap.get(name);
            if (patternMemo != null) {
                return patternMemo;
            }
        }
        if (startAttributeDerivFunction == null) {
            startAttributeDerivFunction = new StartAttributeDerivFunction(name, this.builder);
        }
        patternMemo = this.applyForPatternMemo(startAttributeDerivFunction);
        this.startAttributeDerivMap.put(name, patternMemo);
        return patternMemo;
    }

    DataDerivType dataDerivType() {
        if (this.memoDataDerivType == null) {
            this.memoDataDerivType = DataDerivTypeFunction.dataDerivType(this.builder, this.pattern).copy();
        }
        return this.memoDataDerivType;
    }

    PatternMemo dataDeriv(String string2, ValidationContext validationContext) {
        return this.dataDerivType().dataDeriv(this.builder, this.pattern, string2, validationContext);
    }

    PatternMemo recoverAfter() {
        return this.applyForPatternMemo(this.builder.getRecoverAfterFunction());
    }

    private PatternMemo applyForPatternMemo(PatternFunction patternFunction) {
        return this.builder.getPatternMemo(this.pattern.applyForPattern(patternFunction));
    }
}

