/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.schematron;

import com.thaiopensource.util.Localizer;
import com.thaiopensource.util.PropertyId;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Option;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.validate.rng.CompactSchemaReader;
import com.thaiopensource.validate.rng.RngProperty;
import com.thaiopensource.validate.schematron.DraconianErrorListener;
import com.thaiopensource.validate.schematron.SchemaImpl;
import com.thaiopensource.validate.schematron.SchematronProperty;
import com.thaiopensource.validate.schematron.ValidatorImpl;
import com.thaiopensource.validate.schematron.XMLReaderImpl;
import com.thaiopensource.xml.sax.CountingErrorHandler;
import com.thaiopensource.xml.sax.DelegatingContentHandler;
import com.thaiopensource.xml.sax.DraconianErrorHandler;
import com.thaiopensource.xml.sax.ForkContentHandler;
import com.thaiopensource.xml.sax.XMLReaderCreator;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

class SchemaReaderImpl
implements SchemaReader {
    static final String SCHEMATRON_URI = "http://www.ascc.net/xml/schematron";
    private static final String LOCATION_URI = "http://www.thaiopensource.com/ns/location";
    private static final String ERROR_URI = "http://www.thaiopensource.com/ns/error";
    private final Localizer localizer = new Localizer(class$com$thaiopensource$validate$schematron$SchemaReaderImpl == null ? (class$com$thaiopensource$validate$schematron$SchemaReaderImpl = SchemaReaderImpl.class$("com.thaiopensource.validate.schematron.SchemaReaderImpl")) : class$com$thaiopensource$validate$schematron$SchemaReaderImpl);
    private final Class transformerFactoryClass;
    private final Templates schematron;
    private final Schema schematronSchema;
    private static final String SCHEMATRON_SCHEMA = "schematron.rnc";
    private static final String SCHEMATRON_STYLESHEET = "schematron.xsl";
    private static final PropertyId[] supportedPropertyIds = new PropertyId[]{ValidateProperty.ERROR_HANDLER, ValidateProperty.XML_READER_CREATOR, SchematronProperty.DIAGNOSE, SchematronProperty.PHASE};
    static /* synthetic */ Class class$com$thaiopensource$validate$schematron$SchemaReaderImpl;

    SchemaReaderImpl(TransformerFactory transformerFactory) throws TransformerConfigurationException, IncorrectSchemaException {
        this.transformerFactoryClass = transformerFactory.getClass();
        String string2 = SchemaReaderImpl.fullResourceName(SCHEMATRON_STYLESHEET);
        StreamSource streamSource = new StreamSource(SchemaReaderImpl.getResourceAsStream(string2));
        this.initTransformerFactory(transformerFactory);
        this.schematron = transformerFactory.newTemplates(streamSource);
        InputSource inputSource = new InputSource(SchemaReaderImpl.getResourceAsStream(SchemaReaderImpl.fullResourceName(SCHEMATRON_SCHEMA)));
        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder();
        ValidateProperty.ERROR_HANDLER.put(propertyMapBuilder, new DraconianErrorHandler());
        RngProperty.CHECK_ID_IDREF.add(propertyMapBuilder);
        try {
            this.schematronSchema = CompactSchemaReader.getInstance().createSchema(inputSource, propertyMapBuilder.toPropertyMap());
        }
        catch (SAXException sAXException) {
            throw new IncorrectSchemaException();
        }
        catch (IOException iOException) {
            throw new IncorrectSchemaException();
        }
    }

    public Option getOption(String string2) {
        return SchematronProperty.getOption(string2);
    }

    private void initTransformerFactory(TransformerFactory transformerFactory) {
        block5: {
            String string2 = transformerFactory.getClass().getName();
            try {
                if (string2.equals("com.icl.saxon.TransformerFactoryImpl")) {
                    transformerFactory.setAttribute("http://icl.com/saxon/feature/linenumbering", Boolean.TRUE);
                    break block5;
                }
                if (!string2.equals("org.apache.xalan.processor.TransformerFactoryImpl")) break block5;
                try {
                    transformerFactory.setAttribute("http://xml.apache.org/xalan/properties/source-location", Boolean.TRUE);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    transformerFactory.setAttribute("http://apache.org/xalan/features/source_location", Boolean.TRUE);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public Schema createSchema(InputSource inputSource, PropertyMap propertyMap) throws IOException, SAXException, IncorrectSchemaException {
        ErrorHandler errorHandler = ValidateProperty.ERROR_HANDLER.get(propertyMap);
        SAXErrorListener sAXErrorListener = new SAXErrorListener(errorHandler, inputSource.getSystemId());
        UserWrapErrorHandler userWrapErrorHandler = new UserWrapErrorHandler(errorHandler);
        UserWrapErrorHandler userWrapErrorHandler2 = new UserWrapErrorHandler(errorHandler);
        try {
            PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder(propertyMap);
            ValidateProperty.ERROR_HANDLER.put(propertyMapBuilder, userWrapErrorHandler);
            SAXSource sAXSource = this.createValidatingSource(inputSource, propertyMapBuilder.toPropertyMap(), userWrapErrorHandler);
            sAXSource = this.createTransformingSource(sAXSource, SchematronProperty.PHASE.get(propertyMap), propertyMap.contains(SchematronProperty.DIAGNOSE), inputSource.getSystemId(), userWrapErrorHandler2);
            TransformerFactory transformerFactory = (TransformerFactory)this.transformerFactoryClass.newInstance();
            this.initTransformerFactory(transformerFactory);
            transformerFactory.setErrorListener(sAXErrorListener);
            Templates templates = transformerFactory.newTemplates(sAXSource);
            return new SchemaImpl(templates, propertyMap, supportedPropertyIds);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw this.toSAXException(transformerConfigurationException, sAXErrorListener.getHadError() || userWrapErrorHandler.getHadErrorOrFatalError() || userWrapErrorHandler2.getHadErrorOrFatalError());
        }
        catch (InstantiationException instantiationException) {
            throw new SAXException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SAXException(illegalAccessException);
        }
    }

    private SAXSource createValidatingSource(InputSource inputSource, PropertyMap propertyMap, CountingErrorHandler countingErrorHandler) throws SAXException {
        Validator validator = this.schematronSchema.createValidator(propertyMap);
        XMLReaderCreator xMLReaderCreator = ValidateProperty.XML_READER_CREATOR.get(propertyMap);
        XMLReader xMLReader = xMLReaderCreator.createXMLReader();
        xMLReader.setErrorHandler(countingErrorHandler);
        return new SAXSource(new ValidateStage(xMLReader, validator, countingErrorHandler), inputSource);
    }

    private SAXSource createTransformingSource(SAXSource sAXSource, String string2, boolean bl, String string3, CountingErrorHandler countingErrorHandler) throws SAXException {
        try {
            Transformer transformer = this.schematron.newTransformer();
            transformer.setErrorListener(new DraconianErrorListener());
            if (string2 != null) {
                transformer.setParameter("phase", string2);
            }
            if (bl) {
                transformer.setParameter("diagnose", Boolean.TRUE);
            }
            return new SAXSource(new TransformStage(transformer, sAXSource, string3, countingErrorHandler, this.localizer), new InputSource(string3));
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new SAXException(transformerConfigurationException);
        }
    }

    private SAXException toSAXException(TransformerException transformerException, boolean bl) throws IOException, IncorrectSchemaException {
        return this.causeToSAXException(transformerException.getException(), bl);
    }

    private SAXException causeToSAXException(Throwable throwable, boolean bl) throws IOException, IncorrectSchemaException {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        if (throwable instanceof IncorrectSchemaException) {
            throw (IncorrectSchemaException)throwable;
        }
        if (throwable instanceof SAXException) {
            return this.causeToSAXException(((SAXException)throwable).getException(), bl);
        }
        if (throwable instanceof TransformerException) {
            return this.toSAXException((TransformerException)throwable, bl);
        }
        if (throwable instanceof UserException) {
            return SchemaReaderImpl.toSAXException((UserException)throwable);
        }
        if (bl) {
            throw new IncorrectSchemaException();
        }
        return new SAXException(this.localizer.message("unexpected_schema_creation_error"), throwable instanceof Exception ? (Exception)throwable : null);
    }

    private static SAXException toSAXException(UserException userException) throws IOException, IncorrectSchemaException {
        SAXException sAXException = userException.getException();
        Exception exception = sAXException.getException();
        if (exception instanceof IncorrectSchemaException) {
            throw (IncorrectSchemaException)exception;
        }
        if (exception instanceof IOException) {
            throw (IOException)exception;
        }
        return sAXException;
    }

    private static String fullResourceName(String string2) {
        String string3 = (class$com$thaiopensource$validate$schematron$SchemaReaderImpl == null ? (class$com$thaiopensource$validate$schematron$SchemaReaderImpl = SchemaReaderImpl.class$("com.thaiopensource.validate.schematron.SchemaReaderImpl")) : class$com$thaiopensource$validate$schematron$SchemaReaderImpl).getName();
        return string3.substring(0, string3.lastIndexOf(46)).replace('.', '/') + "/resources/" + string2;
    }

    private static InputStream getResourceAsStream(String string2) {
        ClassLoader classLoader = (class$com$thaiopensource$validate$schematron$SchemaReaderImpl == null ? (class$com$thaiopensource$validate$schematron$SchemaReaderImpl = SchemaReaderImpl.class$("com.thaiopensource.validate.schematron.SchemaReaderImpl")) : class$com$thaiopensource$validate$schematron$SchemaReaderImpl).getClassLoader();
        if (classLoader == null) {
            return ClassLoader.getSystemResourceAsStream(string2);
        }
        return classLoader.getResourceAsStream(string2);
    }

    static /* synthetic */ Class class$(String string2) {
        try {
            return Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class SAXErrorListener
    implements ErrorListener {
        private final ErrorHandler eh;
        private final String systemId;
        private boolean hadError = false;

        SAXErrorListener(ErrorHandler errorHandler, String string2) {
            this.eh = errorHandler;
            this.systemId = string2;
        }

        boolean getHadError() {
            return this.hadError;
        }

        public void warning(TransformerException transformerException) throws TransformerException {
            SAXParseException sAXParseException = this.transform(transformerException);
            try {
                this.eh.warning(sAXParseException);
            }
            catch (SAXException sAXException) {
                throw new TransformerException(new UserException(sAXException));
            }
        }

        public void error(TransformerException transformerException) throws TransformerException {
            this.hadError = true;
            SAXParseException sAXParseException = this.transform(transformerException);
            try {
                this.eh.error(sAXParseException);
            }
            catch (SAXException sAXException) {
                throw new TransformerException(new UserException(sAXException));
            }
        }

        public void fatalError(TransformerException transformerException) throws TransformerException {
            this.hadError = true;
            SAXParseException sAXParseException = this.transform(transformerException);
            try {
                this.eh.fatalError(sAXParseException);
            }
            catch (SAXException sAXException) {
                throw new TransformerException(new UserException(sAXException));
            }
        }

        SAXParseException transform(TransformerException transformerException) throws TransformerException {
            Throwable throwable = transformerException.getException();
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof SAXException || throwable instanceof IncorrectSchemaException || throwable instanceof IOException) {
                throw transformerException;
            }
            SourceLocator sourceLocator = transformerException.getLocator();
            if (sourceLocator == null) {
                return new SAXParseException(transformerException.getMessage(), null);
            }
            String string2 = sourceLocator.getSystemId();
            if (string2 == null) {
                string2 = this.systemId;
            }
            return new SAXParseException(transformerException.getMessage(), null, string2, sourceLocator.getLineNumber(), -1);
        }
    }

    static class TransformStage
    extends XMLReaderImpl {
        private ContentHandler contentHandler;
        private final Transformer transformer;
        private final SAXSource transformSource;
        private final String systemId;
        private final CountingErrorHandler ceh;
        private final Localizer localizer;

        TransformStage(Transformer transformer, SAXSource sAXSource, String string2, CountingErrorHandler countingErrorHandler, Localizer localizer) {
            this.transformer = transformer;
            this.transformSource = sAXSource;
            this.systemId = string2;
            this.ceh = countingErrorHandler;
            this.localizer = localizer;
        }

        public void parse(InputSource inputSource) throws IOException, SAXException {
            try {
                LocationFilter locationFilter = new LocationFilter(new ErrorFilter(this.contentHandler, this.ceh, this.localizer), this.systemId);
                this.transformer.transform(this.transformSource, new SAXResult(locationFilter));
                SAXException sAXException = locationFilter.getException();
                if (sAXException != null) {
                    throw sAXException;
                }
            }
            catch (TransformerException transformerException) {
                if (transformerException.getException() instanceof IOException) {
                    throw (IOException)transformerException.getException();
                }
                throw ValidatorImpl.toSAXException(transformerException);
            }
            if (this.ceh.getHadErrorOrFatalError()) {
                throw new SAXException(new IncorrectSchemaException());
            }
        }

        public ContentHandler getContentHandler() {
            return this.contentHandler;
        }

        public void setContentHandler(ContentHandler contentHandler) {
            this.contentHandler = contentHandler;
        }
    }

    static class LocationFilter
    extends DelegatingContentHandler
    implements Locator {
        private final String systemId;
        private int lineNumber = -1;
        private SAXException exception = null;

        LocationFilter(ContentHandler contentHandler, String string2) {
            super(contentHandler);
            this.systemId = string2;
        }

        SAXException getException() {
            return this.exception;
        }

        public void setDocumentLocator(Locator locator) {
        }

        public void startDocument() throws SAXException {
            this.getDelegate().setDocumentLocator(this);
            super.startDocument();
        }

        public void startElement(String string2, String string3, String string4, Attributes attributes) throws SAXException {
            String string5 = attributes.getValue(SchemaReaderImpl.LOCATION_URI, "line-number");
            if (string5 != null) {
                try {
                    this.lineNumber = Integer.parseInt(string5);
                }
                catch (NumberFormatException numberFormatException) {
                    this.lineNumber = -1;
                }
            } else {
                this.lineNumber = -1;
            }
            try {
                super.startElement(string2, string3, string4, attributes);
            }
            catch (SAXException sAXException) {
                this.exception = sAXException;
                this.setDelegate(null);
            }
            this.lineNumber = -1;
        }

        public String getPublicId() {
            return null;
        }

        public String getSystemId() {
            return this.systemId;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public int getColumnNumber() {
            return -1;
        }
    }

    static class ErrorFilter
    extends DelegatingContentHandler {
        private final ErrorHandler eh;
        private final Localizer localizer;
        private Locator locator;

        ErrorFilter(ContentHandler contentHandler, ErrorHandler errorHandler, Localizer localizer) {
            super(contentHandler);
            this.eh = errorHandler;
            this.localizer = localizer;
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
            super.setDocumentLocator(locator);
        }

        public void startElement(String string2, String string3, String string4, Attributes attributes) throws SAXException {
            if (string2.equals(SchemaReaderImpl.ERROR_URI) && string3.equals("error")) {
                this.eh.error(new SAXParseException(this.localizer.message(attributes.getValue("", "message"), attributes.getValue("", "arg")), this.locator));
            }
            super.startElement(string2, string3, string4, attributes);
        }
    }

    static class UserWrapErrorHandler
    extends CountingErrorHandler {
        UserWrapErrorHandler(ErrorHandler errorHandler) {
            super(errorHandler);
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            try {
                super.warning(sAXParseException);
            }
            catch (SAXException sAXException) {
                throw new SAXException(new UserException(sAXException));
            }
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            try {
                super.error(sAXParseException);
            }
            catch (SAXException sAXException) {
                throw new SAXException(new UserException(sAXException));
            }
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            try {
                super.fatalError(sAXParseException);
            }
            catch (SAXException sAXException) {
                throw new SAXException(new UserException(sAXException));
            }
        }
    }

    static class UserException
    extends Exception {
        private final SAXException exception;

        UserException(SAXException sAXException) {
            this.exception = sAXException;
        }

        SAXException getException() {
            return this.exception;
        }
    }

    static class ValidateStage
    extends XMLReaderImpl {
        private final ContentHandler validator;
        private ContentHandler contentHandler;
        private final XMLReader reader;
        private final CountingErrorHandler ceh;

        ValidateStage(XMLReader xMLReader, Validator validator, CountingErrorHandler countingErrorHandler) {
            this.reader = xMLReader;
            this.validator = validator.getContentHandler();
            this.ceh = countingErrorHandler;
        }

        public void parse(InputSource inputSource) throws SAXException, IOException {
            this.reader.parse(inputSource);
            if (this.ceh.getHadErrorOrFatalError()) {
                throw new SAXException(new IncorrectSchemaException());
            }
        }

        public void setContentHandler(ContentHandler contentHandler) {
            this.contentHandler = contentHandler;
            this.reader.setContentHandler(new ForkContentHandler(this.validator, this.contentHandler));
        }

        public ContentHandler getContentHandler() {
            return this.contentHandler;
        }
    }
}

