/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.inspection.RegExpReplacementUtil;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SingleCharAlternationInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            SingleCharAlternationInspection.$$$reportNull$$$0(0);
        }
        return new SingleCharAlternationVisitor(holder);
    }

    static String buildReplacementText(RegExpPattern pattern) {
        StringBuilder text2 = new StringBuilder("[");
        for (RegExpBranch branch : pattern.getBranches()) {
            block9: for (PsiElement child : branch.getChildren()) {
                int value;
                if (!(child instanceof RegExpChar)) {
                    return null;
                }
                RegExpChar ch = (RegExpChar)child;
                IElementType type = ch.getNode().getFirstChildNode().getElementType();
                if (type == RegExpTT.REDUNDANT_ESCAPE) {
                    value = ch.getValue();
                    if (value == 93) {
                        text2.append(ch.getUnescapedText());
                        continue;
                    }
                    if (value == 45 && text2.length() != 1) {
                        text2.append("\\-");
                        continue;
                    }
                    text2.append((char)value);
                    continue;
                }
                if (type == RegExpTT.ESC_CHARACTER) {
                    value = ch.getValue();
                    switch (value) {
                        case 36: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 46: 
                        case 63: 
                        case 123: 
                        case 124: {
                            text2.append((char)value);
                            break;
                        }
                        case 94: {
                            if (text2.length() == 1) {
                                text2.append(ch.getUnescapedText());
                                break;
                            }
                            text2.append((char)value);
                            break;
                        }
                        default: {
                            text2.append(ch.getUnescapedText());
                            break;
                        }
                    }
                    continue;
                }
                value = ch.getValue();
                switch (value) {
                    case 93: {
                        text2.append("\\]");
                        continue block9;
                    }
                    case 45: {
                        if (text2.length() != 1) {
                            text2.append("\\-");
                            continue block9;
                        }
                    }
                    default: {
                        text2.append(ch.getUnescapedText());
                    }
                }
            }
        }
        text2.append("]");
        return text2.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/regexp/inspection/SingleCharAlternationInspection", "buildVisitor"));
    }

    private static class SingleCharAlternationVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        SingleCharAlternationVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpPattern(RegExpPattern pattern) {
            Object[] branches = pattern.getBranches();
            if (branches.length < 2) {
                return;
            }
            if (!ContainerUtil.and((Object[])branches, SingleCharAlternationVisitor::isSingleChar)) {
                return;
            }
            String text2 = SingleCharAlternationInspection.buildReplacementText(pattern);
            this.myHolder.registerProblem((PsiElement)pattern, RegExpBundle.message("inspection.warning.single.character.alternation.in.regexp", new Object[0]), new LocalQuickFix[]{new SingleCharAlternationFix(text2)});
        }

        private static boolean isSingleChar(RegExpBranch branch) {
            RegExpAtom[] atoms = branch.getAtoms();
            return atoms.length == 1 && atoms[0] instanceof RegExpChar;
        }

        private static class SingleCharAlternationFix
        extends PsiUpdateModCommandQuickFix {
            private final String myText;

            SingleCharAlternationFix(String text2) {
                this.myText = text2;
            }

            @Nls
            @NotNull
            public String getName() {
                String string2 = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myText});
                if (string2 == null) {
                    SingleCharAlternationFix.$$$reportNull$$$0(0);
                }
                return string2;
            }

            @Nls
            @NotNull
            public String getFamilyName() {
                String string2 = RegExpBundle.message("inspection.quick.fix.replace.alternation.with.character.class", new Object[0]);
                if (string2 == null) {
                    SingleCharAlternationFix.$$$reportNull$$$0(1);
                }
                return string2;
            }

            protected void applyFix(@NotNull Project project2, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
                RegExpGroup group;
                if (project2 == null) {
                    SingleCharAlternationFix.$$$reportNull$$$0(2);
                }
                if (element == null) {
                    SingleCharAlternationFix.$$$reportNull$$$0(3);
                }
                if (updater == null) {
                    SingleCharAlternationFix.$$$reportNull$$$0(4);
                }
                if (!(element instanceof RegExpPattern)) {
                    return;
                }
                RegExpPattern pattern = (RegExpPattern)element;
                PsiElement parent = pattern.getParent();
                RegExpPattern victim = parent instanceof RegExpGroup && (group = (RegExpGroup)parent).getType() == RegExpGroup.Type.NON_CAPTURING ? parent : pattern;
                String replacementText = SingleCharAlternationInspection.buildReplacementText(pattern);
                if (replacementText == null) {
                    return;
                }
                RegExpReplacementUtil.replaceInContext(victim, replacementText);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 2, 3, 4 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/intellij/lang/regexp/inspection/SingleCharAlternationInspection$SingleCharAlternationVisitor$SingleCharAlternationFix";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "updater";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/intellij/lang/regexp/inspection/SingleCharAlternationInspection$SingleCharAlternationVisitor$SingleCharAlternationFix";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string2);
                    case 2, 3, 4 -> new IllegalArgumentException(string2);
                };
            }
        }
    }
}

