/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.CommitSession;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.commit.Committer;
import com.intellij.vcs.commit.CommitterResultHandler;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0011B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0013\u0010\r\u001a\u00020\u000e2\u000b\u0010\u000f\u001a\u00070\n\u00a2\u0006\u0002\b\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/vcs/commit/CustomCommitter;", "Lcom/intellij/vcs/commit/Committer;", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lcom/intellij/openapi/vcs/changes/CommitSession;", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "commitMessage", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/changes/CommitSession;Ljava/util/List;Ljava/lang/String;)V", "runCommit", "", "taskName", "Lorg/jetbrains/annotations/Nls;", "CustomCommitResultHandler", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nCustomCommitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomCommitter.kt\ncom/intellij/vcs/commit/CustomCommitter\n+ 2 progress.kt\ncom/intellij/openapi/progress/ProgressKt\n*L\n1#1,41:1\n24#2,6:42\n*S KotlinDebug\n*F\n+ 1 CustomCommitter.kt\ncom/intellij/vcs/commit/CustomCommitter\n*L\n24#1:42,6\n*E\n"})
public final class CustomCommitter
extends Committer {
    @NotNull
    private final CommitSession session;
    @NotNull
    private final List<Change> changes;

    public CustomCommitter(@NotNull Project project, @NotNull CommitSession session, @NotNull List<? extends Change> changes, @NotNull String commitMessage) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        Intrinsics.checkNotNullParameter((Object)commitMessage, (String)"commitMessage");
        super(project, commitMessage);
        this.session = session;
        this.changes = changes;
    }

    /*
     * WARNING - void declaration
     */
    public final void runCommit(@NotNull String taskName) {
        void title$iv;
        void project$iv;
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        this.addResultHandler(new CustomCommitResultHandler(this, taskName));
        String string = UIUtil.removeMnemonic((String)taskName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"removeMnemonic(...)");
        String string2 = string;
        Project project = this.getProject();
        boolean cancellable$iv = true;
        boolean $i$f$runModalTask = false;
        ProgressManager.getInstance().run((Task)new Task.Modal((Project)project$iv, (String)title$iv, cancellable$iv, this){
            final /* synthetic */ CustomCommitter this$0;
            {
                this.this$0 = customCommitter;
                super($project, $title, $cancellable);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                ProgressIndicator it = indicator;
                boolean bl = false;
                this.this$0.runCommitTask(false, (Function0<Unit>)((Function0)new Function0<Unit>(this.this$0){
                    final /* synthetic */ CustomCommitter this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final void invoke() {
                        CustomCommitter.access$getSession$p(this.this$0).execute((Collection)CustomCommitter.access$getChanges$p(this.this$0), this.this$0.getCommitMessage());
                    }
                }));
            }
        });
    }

    public static final /* synthetic */ List access$getChanges$p(CustomCommitter $this) {
        return $this.changes;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001c\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/vcs/commit/CustomCommitter$CustomCommitResultHandler;", "Lcom/intellij/vcs/commit/CommitterResultHandler;", "committer", "Lcom/intellij/vcs/commit/CustomCommitter;", "taskName", "", "Lorg/jetbrains/annotations/Nls;", "<init>", "(Lcom/intellij/vcs/commit/CustomCommitter;Ljava/lang/String;)V", "getCommitter", "()Lcom/intellij/vcs/commit/CustomCommitter;", "getTaskName", "()Ljava/lang/String;", "onCancel", "", "onFailure", "intellij.platform.vcs.impl"})
    private static final class CustomCommitResultHandler
    implements CommitterResultHandler {
        @NotNull
        private final CustomCommitter committer;
        @NotNull
        private final String taskName;

        public CustomCommitResultHandler(@NotNull CustomCommitter committer, @NotNull String taskName) {
            Intrinsics.checkNotNullParameter((Object)committer, (String)"committer");
            Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
            this.committer = committer;
            this.taskName = taskName;
        }

        @NotNull
        public final CustomCommitter getCommitter() {
            return this.committer;
        }

        @NotNull
        public final String getTaskName() {
            return this.taskName;
        }

        @Override
        public void onCancel() {
            this.committer.session.executionCanceled();
        }

        @Override
        public void onFailure() {
            VcsException vcsException = (VcsException)((Object)CollectionsKt.firstOrNull(this.committer.getCommitErrors()));
            if (vcsException == null) {
                return;
            }
            VcsException error = vcsException;
            Object[] objectArray = new Object[]{this.taskName, error.getLocalizedMessage()};
            Messages.showErrorDialog((String)VcsBundle.message((String)"error.executing.commit", (Object[])objectArray), (String)this.taskName);
        }
    }
}

