/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.AbstractBasicJavaSmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.BasicJavaAstTreeUtil;
import com.intellij.psi.impl.source.BasicJavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ParentAwareTokenSet;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingReturnExpressionFixer
implements Fixer {
    @Override
    public void apply(Editor editor, AbstractBasicJavaSmartEnterProcessor processor, @NotNull ASTNode astNode) throws IncorrectOperationException {
        ASTNode type;
        if (astNode == null) {
            MissingReturnExpressionFixer.$$$reportNull$$$0(0);
        }
        if (!BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_RETURN_STATEMENT)) {
            return;
        }
        if (!BasicJavaAstTreeUtil.hasErrorElements(astNode)) {
            return;
        }
        if (MissingReturnExpressionFixer.fixMethodCallWithoutTrailingSemicolon(astNode, editor, processor)) {
            return;
        }
        ASTNode returnValue = BasicJavaAstTreeUtil.getReturnValue(astNode);
        if (returnValue != null && MissingReturnExpressionFixer.lineNumber(editor, editor.getCaretModel().getOffset()) == MissingReturnExpressionFixer.lineNumber(editor, returnValue.getTextRange().getStartOffset())) {
            return;
        }
        ASTNode parent = BasicJavaAstTreeUtil.getParentOfType(astNode, ParentAwareTokenSet.create((IElementType[])new IElementType[]{BasicJavaElementType.BASIC_CLASS_INITIALIZER, BasicJavaElementType.BASIC_METHOD}));
        if (BasicJavaAstTreeUtil.is(parent, BasicJavaElementType.BASIC_METHOD) && (type = BasicJavaAstTreeUtil.findChildByType(parent, BasicJavaElementType.BASIC_TYPE)) != null && !type.getText().equals("void")) {
            int startOffset = astNode.getTextRange().getStartOffset();
            if (returnValue != null) {
                editor.getDocument().insertString(startOffset + "return".length(), (CharSequence)";");
            }
            processor.registerUnresolvedError(startOffset + "return".length());
        }
    }

    private static boolean fixMethodCallWithoutTrailingSemicolon(@Nullable ASTNode returnStatement, @NotNull Editor editor, @NotNull AbstractBasicJavaSmartEnterProcessor processor) {
        if (editor == null) {
            MissingReturnExpressionFixer.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            MissingReturnExpressionFixer.$$$reportNull$$$0(2);
        }
        if (returnStatement == null) {
            return false;
        }
        ASTNode lastChild = returnStatement.getLastChildNode();
        if (!BasicJavaAstTreeUtil.is(lastChild, TokenType.ERROR_ELEMENT)) {
            return false;
        }
        ASTNode prev = lastChild.getTreePrev();
        if (BasicJavaAstTreeUtil.isWhiteSpace(prev)) {
            prev = prev.getTreePrev();
        }
        if (!(prev instanceof PsiJavaToken)) {
            int offset = returnStatement.getTextRange().getEndOffset();
            PsiElement psiMethod = BasicJavaAstTreeUtil.getParentOfType(BasicJavaAstTreeUtil.toPsi(returnStatement), BasicJavaElementType.BASIC_METHOD, true, ParentAwareTokenSet.create((IElementType[])new IElementType[]{BasicJavaElementType.BASIC_LAMBDA_EXPRESSION}));
            ASTNode method = BasicJavaAstTreeUtil.toNode(psiMethod);
            ASTNode type = BasicJavaAstTreeUtil.findChildByType(method, BasicJavaElementType.BASIC_TYPE);
            if (method != null && type != null && type.getText().equals("void")) {
                offset = returnStatement.getTextRange().getStartOffset() + "return".length();
            }
            editor.getDocument().insertString(offset, (CharSequence)";");
            return true;
        }
        PsiJavaToken prevToken = (PsiJavaToken)prev;
        if (prevToken.getTokenType() == JavaTokenType.SEMICOLON) {
            return false;
        }
        int offset = returnStatement.getTextRange().getEndOffset();
        editor.getDocument().insertString(offset, (CharSequence)";");
        if (prevToken.getTokenType() == JavaTokenType.RETURN_KEYWORD) {
            ASTNode method = BasicJavaAstTreeUtil.getParentOfType(returnStatement, BasicJavaElementType.BASIC_METHOD);
            ASTNode type = BasicJavaAstTreeUtil.findChildByType(method, BasicJavaElementType.BASIC_TYPE);
            if (method != null && type != null && !type.getText().equals("void")) {
                editor.getCaretModel().moveToOffset(offset);
                processor.setSkipEnter(true);
            }
        }
        return true;
    }

    private static int lineNumber(Editor editor, int offset) {
        return editor.getDocument().getLineNumber(offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "astNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/smartEnter/MissingReturnExpressionFixer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fixMethodCallWithoutTrailingSemicolon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

