/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.core;

import java.awt.Component;
import java.awt.Container;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.description.Description;
import org.assertj.core.description.TextDescription;
import org.assertj.core.util.Strings;
import org.assertj.swing.core.ComponentFinder;
import org.assertj.swing.core.ComponentMatcher;
import org.assertj.swing.core.ResettableComponentMatcher;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.exception.ComponentLookupException;
import org.assertj.swing.timing.Condition;

public final class ComponentFoundCondition
extends Condition {
    private final ComponentFinder finder;
    private final ComponentMatcher matcher;
    private final Container root;
    private Component found;
    private final AtomicReference<ComponentLookupException> notFoundError = new AtomicReference();

    public ComponentFoundCondition(@Nonnull String description, @Nonnull ComponentFinder finder, @Nonnull ComponentMatcher matcher) {
        this(description, finder, matcher, null);
    }

    public ComponentFoundCondition(@Nonnull String description, @Nonnull ComponentFinder finder, @Nonnull ComponentMatcher matcher, @Nullable Container root) {
        this(new TextDescription(description, new Object[0]), finder, matcher, root);
    }

    public ComponentFoundCondition(@Nonnull Description description, @Nonnull ComponentFinder finder, @Nonnull ComponentMatcher matcher) {
        this(description, finder, matcher, null);
    }

    public ComponentFoundCondition(@Nonnull Description description, @Nonnull ComponentFinder finder, @Nonnull ComponentMatcher matcher, @Nullable Container root) {
        super(description);
        this.finder = finder;
        this.matcher = matcher;
        this.root = root;
    }

    @Override
    public boolean test() {
        boolean matchFound = false;
        try {
            this.found = this.finder.find(this.root, this.matcher);
            matchFound = true;
        }
        catch (ComponentLookupException e) {
            this.notFoundError.set(e);
        }
        this.resetMatcher(matchFound);
        if (matchFound) {
            this.notFoundError.set(null);
        }
        return matchFound;
    }

    private void resetMatcher(boolean matchFound) {
        if (!(this.matcher instanceof ResettableComponentMatcher)) {
            return;
        }
        ((ResettableComponentMatcher)this.matcher).reset(matchFound);
    }

    @Override
    @Nonnull
    protected String descriptionAddendum() {
        ComponentLookupException error = this.notFoundError.get();
        if (error == null) {
            return "";
        }
        return Strings.concat(System.lineSeparator(), error.getMessage());
    }

    @Nullable
    public Component found() {
        return this.found;
    }

    public Collection<Component> duplicatesFound() {
        ComponentLookupException error = this.notFoundError.get();
        if (error == null) {
            return Collections.emptyList();
        }
        return error.found();
    }
}

