/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.monitor;

import java.applet.Applet;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Sets;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.dependency.jsr305.concurrent.GuardedBy;
import org.assertj.swing.dependency.jsr305.concurrent.ThreadSafe;
import org.assertj.swing.edt.GuiActionRunner;
import org.assertj.swing.monitor.EventQueueMapping;
import org.assertj.swing.monitor.WindowEventQueueMapping;

@ThreadSafe
class Context {
    @GuardedBy(value="lock")
    private final WindowEventQueueMapping windowEventQueueMapping;
    @GuardedBy(value="lock")
    private final EventQueueMapping eventQueueMapping;
    private final Object lock = new Object();

    Context(@Nonnull Toolkit toolkit) {
        this(toolkit, new WindowEventQueueMapping(), new EventQueueMapping());
    }

    Context(@Nonnull Toolkit toolkit, @Nonnull WindowEventQueueMapping windowEventQueueMapping, @Nonnull EventQueueMapping eventQueueMapping) {
        this.windowEventQueueMapping = windowEventQueueMapping;
        this.eventQueueMapping = eventQueueMapping;
        this.windowEventQueueMapping.addQueueFor(toolkit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    Collection<Window> rootWindows() {
        LinkedHashSet<Window> rootWindows = Sets.newLinkedHashSet();
        Object object = this.lock;
        synchronized (object) {
            rootWindows.addAll(this.windowEventQueueMapping.windows());
        }
        rootWindows.addAll(Lists.newArrayList(Frame.getFrames()));
        rootWindows.addAll(Lists.newArrayList(Window.getOwnerlessWindows()));
        return rootWindows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    EventQueue storedQueueFor(@Nonnull Component c) {
        Object object = this.lock;
        synchronized (object) {
            return this.eventQueueMapping.storedQueueFor(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeContextFor(@Nonnull Component component) {
        Object object = this.lock;
        synchronized (object) {
            this.windowEventQueueMapping.removeMappingFor(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addContextFor(@Nonnull Component component) {
        Object object = this.lock;
        synchronized (object) {
            this.windowEventQueueMapping.addQueueFor(component);
            this.eventQueueMapping.addQueueFor(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @RunsInEDT
    EventQueue eventQueueFor(@Nonnull Component c) {
        Component component = Context.topParentOf(c);
        if (component == null) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            return this.eventQueueMapping.queueFor(component);
        }
    }

    @Nullable
    @RunsInEDT
    private static Component topParentOf(@Nonnull Component c) {
        return GuiActionRunner.execute(() -> {
            Component parent = c;
            while (!(parent instanceof Applet) && parent.getParent() != null) {
                parent = parent.getParent();
            }
            return parent;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    Collection<EventQueue> allEventQueues() {
        LinkedHashSet<EventQueue> eventQueues = Sets.newLinkedHashSet();
        Object object = this.lock;
        synchronized (object) {
            eventQueues.addAll(this.windowEventQueueMapping.eventQueues());
            eventQueues.addAll(this.eventQueueMapping.eventQueues());
        }
        return eventQueues;
    }
}

