/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.util;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.assertj.core.util.Objects;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;

public final class Strings {
    public static boolean isDefaultToString(@Nullable String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        int at = s.indexOf("@");
        if (at == -1) {
            return false;
        }
        String hash = s.substring(at + 1, s.length());
        try {
            Integer.parseInt(hash, 16);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean areEqualOrMatch(@Nullable String pattern, @Nullable String s) {
        if (Objects.areEqual(pattern, s)) {
            return true;
        }
        if (pattern != null && s != null) {
            try {
                return s.matches(pattern);
            }
            catch (PatternSyntaxException invalidRegex) {
                return s.contains(pattern);
            }
        }
        return false;
    }

    public static boolean match(@Nonnull Pattern p, @Nullable String s) {
        return Strings.match(p, (CharSequence)s);
    }

    public static boolean match(@Nonnull Pattern p, @Nullable CharSequence s) {
        Preconditions.checkNotNull(p);
        if (s == null) {
            return false;
        }
        return p.matcher(s).matches();
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    private Strings() {
    }
}

