/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator.structure;

import com.intellij.execution.Location;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.mac.touchbar.Touchbar;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenGoalLocation;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenConstants;
import org.jetbrains.idea.maven.model.MavenProfileKind;
import org.jetbrains.idea.maven.model.MavenRepositoryInfo;
import org.jetbrains.idea.maven.model.RepositoryKind;
import org.jetbrains.idea.maven.navigator.structure.BaseDependenciesNode;
import org.jetbrains.idea.maven.navigator.structure.DependenciesNode;
import org.jetbrains.idea.maven.navigator.structure.DependencyNode;
import org.jetbrains.idea.maven.navigator.structure.MavenGoalNode;
import org.jetbrains.idea.maven.navigator.structure.MavenProjectNode;
import org.jetbrains.idea.maven.navigator.structure.MavenProjectsStructure;
import org.jetbrains.idea.maven.navigator.structure.MavenSimpleNode;
import org.jetbrains.idea.maven.navigator.structure.ProfileNode;
import org.jetbrains.idea.maven.navigator.structure.ProjectNode;
import org.jetbrains.idea.maven.navigator.structure.RepositoryNode;
import org.jetbrains.idea.maven.navigator.structure.RunConfigurationNode;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenDataKeys;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;

public final class MavenProjectsNavigatorPanel
extends SimpleToolWindowPanel {
    private final Project myProject;
    private final SimpleTree myTree;
    private final Comparator<String> myGoalOrderComparator = new Comparator<String>(){
        private Map<String, Integer> standardGoalOrder;

        @Override
        public int compare(String o1, String o2) {
            return this.getStandardGoalOrder(o1) - this.getStandardGoalOrder(o2);
        }

        private int getStandardGoalOrder(String goal) {
            Integer order;
            if (this.standardGoalOrder == null) {
                this.standardGoalOrder = new HashMap<String, Integer>();
                int i2 = 0;
                for (String aGoal : MavenConstants.PHASES) {
                    this.standardGoalOrder.put(aGoal, i2++);
                }
            }
            return (order = this.standardGoalOrder.get(goal)) != null ? order.intValue() : this.standardGoalOrder.size();
        }
    };

    public MavenProjectsNavigatorPanel(Project project, SimpleTree tree) {
        super(true, true);
        this.myProject = project;
        this.myTree = tree;
        final ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar actionToolbar = actionManager.createActionToolbar("Maven Navigator Toolbar", (ActionGroup)((DefaultActionGroup)actionManager.getAction("Maven.NavigatorActionsToolbar")), true);
        actionToolbar.setTargetComponent((JComponent)tree);
        this.setToolbar(actionToolbar.getComponent());
        this.setContent(ScrollPaneFactory.createScrollPane((Component)this.myTree));
        this.setTransferHandler(new MyTransferHandler(project));
        this.myTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionGroup actionGroup;
                String id = 2.getMenuId(MavenProjectsStructure.getSelectedNodes(MavenProjectsNavigatorPanel.this.myTree, MavenSimpleNode.class));
                if (id != null && (actionGroup = (ActionGroup)actionManager.getAction(id)) != null) {
                    actionManager.createActionPopupMenu("Maven tool window", actionGroup).getComponent().show(comp, x, y);
                }
            }

            @Nullable
            private static String getMenuId(Collection<? extends MavenSimpleNode> nodes) {
                String id = null;
                for (MavenSimpleNode mavenSimpleNode : nodes) {
                    String menuId = mavenSimpleNode.getMenuId();
                    if (menuId == null) {
                        return null;
                    }
                    if (id == null) {
                        id = menuId;
                        continue;
                    }
                    if (id.equals(menuId)) continue;
                    return null;
                }
                return id;
            }
        });
        Touchbar.setActions((JComponent)((Object)this), (String)"Maven.Reimport");
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            MavenProjectsNavigatorPanel.$$$reportNull$$$0(0);
        }
        super.uiDataSnapshot(sink);
        sink.set(CommonDataKeys.PROJECT, (Object)this.myProject);
        sink.set(MavenDataKeys.MAVEN_PROJECTS_TREE, (Object)this.myTree);
        sink.set(PlatformCoreDataKeys.HELP_ID, (Object)"reference.toolWindows.mavenProjects");
        List<MavenSimpleNode> selectedNodes = MavenProjectsStructure.getSelectedNodes(this.myTree, MavenSimpleNode.class);
        sink.lazy(CommonDataKeys.VIRTUAL_FILE, () -> MavenProjectsNavigatorPanel.extractVirtualFile(selectedNodes));
        sink.lazy(CommonDataKeys.VIRTUAL_FILE_ARRAY, () -> MavenProjectsNavigatorPanel.extractVirtualFiles(selectedNodes));
        sink.lazy(Location.DATA_KEY, () -> this.extractLocation(selectedNodes));
        sink.lazy(CommonDataKeys.NAVIGATABLE_ARRAY, () -> MavenProjectsNavigatorPanel.extractNavigatables(selectedNodes));
        sink.lazy(MavenDataKeys.MAVEN_GOALS, () -> this.extractGoals(true, selectedNodes));
        sink.lazy(MavenDataKeys.RUN_CONFIGURATION, () -> MavenProjectsNavigatorPanel.extractRunSettings(selectedNodes));
        sink.lazy(MavenDataKeys.MAVEN_REPOSITORY, () -> MavenProjectsNavigatorPanel.extractRepositoryInfo(selectedNodes));
        sink.lazy(MavenDataKeys.MAVEN_PROFILES, () -> MavenProjectsNavigatorPanel.extractProfiles(selectedNodes));
        sink.lazy(MavenDataKeys.MAVEN_DEPENDENCIES, () -> MavenProjectsNavigatorPanel.extractDependencies(selectedNodes));
    }

    private static VirtualFile extractVirtualFile(@NotNull List<MavenSimpleNode> selectedNodes) {
        if (selectedNodes == null) {
            MavenProjectsNavigatorPanel.$$$reportNull$$$0(1);
        }
        for (MavenSimpleNode each : selectedNodes) {
            VirtualFile file = each.getVirtualFile();
            if (file == null || !file.isValid()) continue;
            return file;
        }
        MavenProjectNode projectNode = MavenProjectsNavigatorPanel.getContextProjectNode(selectedNodes);
        if (projectNode == null) {
            return null;
        }
        VirtualFile file = projectNode.getMavenProject().getFile();
        if (!file.isValid()) {
            return null;
        }
        return file;
    }

    private static VirtualFile @Nullable [] extractVirtualFiles(@NotNull List<MavenSimpleNode> selectedNodes) {
        if (selectedNodes == null) {
            MavenProjectsNavigatorPanel.$$$reportNull$$$0(2);
        }
        ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>();
        for (MavenSimpleNode each : selectedNodes) {
            VirtualFile file = each.getVirtualFile();
            if (file == null || !file.isValid()) continue;
            files2.add(file);
        }
        return files2.isEmpty() ? null : VfsUtilCore.toVirtualFileArray(files2);
    }

    private static Navigatable @Nullable [] extractNavigatables(@NotNull List<MavenSimpleNode> selectedNodes) {
        if (selectedNodes == null) {
            MavenProjectsNavigatorPanel.$$$reportNull$$$0(3);
        }
        ArrayList<Navigatable> navigatables = new ArrayList<Navigatable>();
        for (MavenSimpleNode each : selectedNodes) {
            Navigatable navigatable = each.getNavigatable();
            if (navigatable == null) continue;
            navigatables.add(navigatable);
        }
        return navigatables.isEmpty() ? null : navigatables.toArray(Navigatable.EMPTY_NAVIGATABLE_ARRAY);
    }

    @Nullable
    private Location<?> extractLocation(@NotNull List<MavenSimpleNode> selectedNodes) {
        VirtualFile file;
        if (selectedNodes == null) {
            MavenProjectsNavigatorPanel.$$$reportNull$$$0(4);
        }
        if ((file = MavenProjectsNavigatorPanel.extractVirtualFile(selectedNodes)) == null) {
            return null;
        }
        List<String> goals = this.extractGoals(false, selectedNodes);
        if (goals == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
        return psiFile == null ? null : new MavenGoalLocation(this.myProject, psiFile, goals);
    }

    @Nullable
    private static RunnerAndConfigurationSettings extractRunSettings(@NotNull List<MavenSimpleNode> selectedNodes) {
        MavenSimpleNode node;
        if (selectedNodes == null) {
            MavenProjectsNavigatorPanel.$$$reportNull$$$0(5);
        }
        MavenSimpleNode mavenSimpleNode = node = selectedNodes.isEmpty() ? null : selectedNodes.get(0);
        if (!(node instanceof RunConfigurationNode)) {
            return null;
        }
        return ((RunConfigurationNode)node).getSettings();
    }

    private List<String> extractGoals(boolean qualifiedGoals, @NotNull List<MavenSimpleNode> selectedNodes) {
        List<ProjectNode> projectNodes;
        ProjectNode projectNode;
        if (selectedNodes == null) {
            MavenProjectsNavigatorPanel.$$$reportNull$$$0(6);
        }
        ProjectNode projectNode2 = projectNode = (projectNodes = MavenProjectsNavigatorPanel.filterNodesByClass(selectedNodes, ProjectNode.class)).size() == 1 ? projectNodes.get(0) : null;
        if (projectNode != null) {
            MavenProject project = projectNode.getMavenProject();
            String goal = project.getDefaultGoal();
            if (!StringUtil.isEmptyOrSpaces((String)goal)) {
                return ContainerUtil.newArrayList((Iterable)StringUtil.tokenize((StringTokenizer)new StringTokenizer(goal)));
            }
        } else {
            List<MavenGoalNode> goalNodes = MavenProjectsNavigatorPanel.filterNodesByClass(selectedNodes, MavenGoalNode.class);
            if (MavenProjectsNavigatorPanel.getCommonProjectNode(goalNodes) == null) {
                return null;
            }
            ArrayList<String> goals = new ArrayList<String>();
            for (MavenGoalNode node : goalNodes) {
                goals.add(qualifiedGoals ? node.getGoal() : node.getName());
            }
            goals.sort(this.myGoalOrderComparator);
            return goals;
        }
        return null;
    }

    @Nullable
    private static MavenProjectNode getCommonProjectNode(Collection<? extends MavenSimpleNode> nodes) {
        MavenProjectNode parent = null;
        for (MavenSimpleNode mavenSimpleNode : nodes) {
            MavenProjectNode nextParent = mavenSimpleNode.findParentProjectNode();
            if (parent == null) {
                parent = nextParent;
                continue;
            }
            if (parent == nextParent) continue;
            return null;
        }
        return parent;
    }

    @Nullable
    private static MavenRepositoryInfo extractRepositoryInfo(@NotNull List<MavenSimpleNode> selectedNodes) {
        List<RepositoryNode> repositoryNodes;
        if (selectedNodes == null) {
            MavenProjectsNavigatorPanel.$$$reportNull$$$0(7);
        }
        if ((repositoryNodes = MavenProjectsNavigatorPanel.filterNodesByClass(selectedNodes, RepositoryNode.class)) == null || repositoryNodes.isEmpty()) {
            return null;
        }
        RepositoryNode repositoryNode = repositoryNodes.get(0);
        return new MavenRepositoryInfo(repositoryNode.getId(), repositoryNode.getUrl(), repositoryNode.isLocal() ? RepositoryKind.LOCAL : RepositoryKind.REMOTE);
    }

    private static Map<String, MavenProfileKind> extractProfiles(@NotNull List<MavenSimpleNode> selectedNodes) {
        if (selectedNodes == null) {
            MavenProjectsNavigatorPanel.$$$reportNull$$$0(8);
        }
        List<ProfileNode> profileNodes = MavenProjectsNavigatorPanel.filterNodesByClass(selectedNodes, ProfileNode.class);
        HashMap<String, MavenProfileKind> profiles2 = new HashMap<String, MavenProfileKind>();
        for (ProfileNode node : profileNodes) {
            profiles2.put(node.getProfileName(), node.getState());
        }
        return profiles2;
    }

    private static Set<MavenArtifact> extractDependencies(@NotNull List<MavenSimpleNode> selectedNodes) {
        if (selectedNodes == null) {
            MavenProjectsNavigatorPanel.$$$reportNull$$$0(9);
        }
        HashSet<MavenArtifact> result2 = new HashSet<MavenArtifact>();
        List<ProjectNode> projectNodes = MavenProjectsNavigatorPanel.filterNodesByClass(selectedNodes, ProjectNode.class);
        if (!projectNodes.isEmpty()) {
            for (ProjectNode each : projectNodes) {
                result2.addAll(each.getMavenProject().getDependencies());
            }
            return result2;
        }
        List<BaseDependenciesNode> baseDependenciesNodes = MavenProjectsNavigatorPanel.filterNodesByClass(selectedNodes, BaseDependenciesNode.class);
        for (BaseDependenciesNode each : baseDependenciesNodes) {
            if (each instanceof DependenciesNode) {
                result2.addAll(each.getMavenProject().getDependencies());
                continue;
            }
            result2.add(((DependencyNode)each).getArtifact());
        }
        return result2;
    }

    private static <T extends MavenSimpleNode> List<T> filterNodesByClass(@NotNull List<MavenSimpleNode> nodes, Class<T> aClass) {
        List filtered;
        if (nodes == null) {
            MavenProjectsNavigatorPanel.$$$reportNull$$$0(10);
        }
        return (filtered = ContainerUtil.filterIsInstance(nodes, aClass)).size() == nodes.size() ? filtered : Collections.emptyList();
    }

    @Nullable
    private static MavenProjectNode getContextProjectNode(@NotNull List<MavenSimpleNode> selectedNodes) {
        List<ProjectNode> projectNodes;
        ProjectNode projectNode;
        if (selectedNodes == null) {
            MavenProjectsNavigatorPanel.$$$reportNull$$$0(11);
        }
        ProjectNode projectNode2 = projectNode = (projectNodes = MavenProjectsNavigatorPanel.filterNodesByClass(selectedNodes, ProjectNode.class)).size() == 1 ? projectNodes.get(0) : null;
        if (projectNode != null) {
            return projectNode;
        }
        return MavenProjectsNavigatorPanel.getCommonProjectNode(selectedNodes);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedNodes";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/navigator/structure/MavenProjectsNavigatorPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "uiDataSnapshot";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "extractVirtualFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "extractVirtualFiles";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "extractNavigatables";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "extractLocation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "extractRunSettings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "extractGoals";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "extractRepositoryInfo";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "extractProfiles";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "extractDependencies";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "filterNodesByClass";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getContextProjectNode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class MyTransferHandler
    extends TransferHandler {
        private final Project myProject;

        private MyTransferHandler(Project project) {
            this.myProject = project;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (this.canImport(support)) {
                ArrayList<VirtualFile> pomFiles = new ArrayList<VirtualFile>();
                List fileList = FileCopyPasteUtil.getFileList((Transferable)support.getTransferable());
                if (fileList == null) {
                    return false;
                }
                MavenProjectsManager manager = MavenProjectsManager.getInstance(this.myProject);
                for (File file : fileList) {
                    VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
                    if (!file.isFile() || virtualFile == null || !MavenActionUtil.isMavenProjectFile(virtualFile) || manager.isManagedFile(virtualFile)) continue;
                    pomFiles.add(virtualFile);
                }
                if (pomFiles.isEmpty()) {
                    return false;
                }
                manager.addManagedFilesOrUnignore(pomFiles);
                return true;
            }
            return false;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return FileCopyPasteUtil.isFileListFlavorAvailable((DataFlavor[])support.getDataFlavors());
        }
    }
}

