/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.session;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.terminal.completion.spec.ShellCommandResult;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.execution.ParametersListUtil;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TerminalStarter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.TimeMark;
import kotlin.time.TimeSource;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalUtil;
import org.jetbrains.plugins.terminal.block.session.BlockTerminalSession;
import org.jetbrains.plugins.terminal.block.session.CommandFinishedEvent;
import org.jetbrains.plugins.terminal.block.session.GeneratorFinishedEvent;
import org.jetbrains.plugins.terminal.block.session.KeyBinding;
import org.jetbrains.plugins.terminal.block.session.ShellCommandExecutionManager;
import org.jetbrains.plugins.terminal.block.session.ShellCommandListener;
import org.jetbrains.plugins.terminal.block.session.ShellCommandManager;
import org.jetbrains.plugins.terminal.block.session.ShellCommandSentListener;
import org.jetbrains.plugins.terminal.block.util.ActionCoordinator;
import org.jetbrains.plugins.terminal.fus.TerminalUsageTriggerCollector;
import org.jetbrains.plugins.terminal.fus.TimeSpanType;
import org.jetbrains.plugins.terminal.util.ShellIntegration;
import org.jetbrains.plugins.terminal.util.ShellType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 A2\u00020\u0001:\u0003?@AB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001aH\u0002J\u0010\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020\u001aH\u0016J\u0010\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020\u0017H\u0016J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u0010)\u001a\u00020\u001aH\u0016J\b\u0010/\u001a\u00020$H\u0002J\u000e\u00100\u001a\b\u0018\u00010\u0015R\u00020\u0000H\u0002J\u001e\u00101\u001a\b\u0012\u0004\u0012\u0002H302\"\u0004\b\u0000\u00103*\b\u0012\u0004\u0012\u0002H30\u0014H\u0002J \u00104\u001a\u00020$2\u0006\u0010)\u001a\u00020\u001a2\u0006\u00105\u001a\u00020\u001c2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u00104\u001a\u00020$2\u0006\u00106\u001a\u0002072\u0006\u0010)\u001a\u00020\u001aH\u0002J\u0010\u00108\u001a\u00020$2\u0006\u00109\u001a\u00020\u0010H\u0016J\u0018\u00108\u001a\u00020$2\u0006\u00109\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010:\u001a\u00020$2\u0006\u0010;\u001a\u00020\u001aH\u0002J\u0010\u0010<\u001a\u00020$2\u0006\u0010=\u001a\u00020\u001aH\u0002J\u0010\u0010>\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\f\u0012\b\u0012\u00060\u0015R\u00020\u00000\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0018\u00010\u0015R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/ShellCommandExecutionManagerImpl;", "Lorg/jetbrains/plugins/terminal/block/session/ShellCommandExecutionManager;", "session", "Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;", "commandManager", "Lorg/jetbrains/plugins/terminal/block/session/ShellCommandManager;", "shellIntegration", "Lorg/jetbrains/plugins/terminal/util/ShellIntegration;", "terminal", "Lcom/jediterm/terminal/Terminal;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lorg/jetbrains/plugins/terminal/block/session/BlockTerminalSession;Lorg/jetbrains/plugins/terminal/block/session/ShellCommandManager;Lorg/jetbrains/plugins/terminal/util/ShellIntegration;Lcom/jediterm/terminal/Terminal;Lcom/intellij/openapi/Disposable;)V", "listeners", "Lcom/intellij/util/EventDispatcher;", "Lorg/jetbrains/plugins/terminal/block/session/ShellCommandSentListener;", "lock", "Lorg/jetbrains/plugins/terminal/block/session/ShellCommandExecutionManagerImpl$Lock;", "scheduledGenerators", "Ljava/util/Queue;", "Lorg/jetbrains/plugins/terminal/block/session/ShellCommandExecutionManagerImpl$Generator;", "scheduledKeyBindings", "Lorg/jetbrains/plugins/terminal/block/session/KeyBinding;", "runningGenerator", "scheduledCommands", "", "isInitialized", "", "isCommandRunning", "isCommandSent", "metricCommandSubmitToVisuallyStarted", "Lorg/jetbrains/plugins/terminal/block/util/ActionCoordinator;", "Lkotlin/time/TimeMark;", "metricCommandSubmitToActuallyStarted", "cancelGenerators", "", "registrar", "Lorg/jetbrains/plugins/terminal/block/session/ShellCommandExecutionManagerImpl$Lock$AfterLockActionRegistrar;", "incompatibleCondition", "sendCommandToExecute", "shellCommand", "sendKeyBinding", "keyBinding", "runGeneratorAsync", "Lkotlinx/coroutines/Deferred;", "Lcom/intellij/terminal/completion/spec/ShellCommandResult;", "processQueueIfReady", "pollNextGeneratorToRun", "drainToList", "", "T", "doSendCommandToExecute", "isGenerator", "starter", "Lcom/jediterm/terminal/TerminalStarter;", "addListener", "listener", "fireUserCommandSent", "userCommand", "fireGeneratorCommandSent", "generatorCommand", "createClearPromptShortcut", "Generator", "Lock", "Companion", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nShellCommandExecutionManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellCommandExecutionManagerImpl.kt\norg/jetbrains/plugins/terminal/block/session/ShellCommandExecutionManagerImpl\n+ 2 ShellCommandManager.kt\norg/jetbrains/plugins/terminal/block/session/ShellCommandManager$Companion\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,447:1\n215#2,2:448\n217#2:454\n215#2,2:455\n217#2:461\n62#3,4:450\n62#3,4:457\n14#3:466\n1863#4,2:462\n1863#4,2:464\n*S KotlinDebug\n*F\n+ 1 ShellCommandExecutionManagerImpl.kt\norg/jetbrains/plugins/terminal/block/session/ShellCommandExecutionManagerImpl\n*L\n313#1:448,2\n313#1:454\n318#1:455,2\n318#1:461\n313#1:450,4\n318#1:457,4\n392#1:466\n154#1:462,2\n231#1:464,2\n*E\n"})
public final class ShellCommandExecutionManagerImpl
implements ShellCommandExecutionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BlockTerminalSession session;
    @NotNull
    private final ShellIntegration shellIntegration;
    @NotNull
    private final Terminal terminal;
    @NotNull
    private final Disposable parentDisposable;
    @NotNull
    private final EventDispatcher<ShellCommandSentListener> listeners;
    @NotNull
    private final Lock lock;
    @NotNull
    private final Queue<Generator> scheduledGenerators;
    @NotNull
    private final Queue<KeyBinding> scheduledKeyBindings;
    @Nullable
    private Generator runningGenerator;
    @NotNull
    private final Queue<String> scheduledCommands;
    private boolean isInitialized;
    private boolean isCommandRunning;
    private boolean isCommandSent;
    @NotNull
    private final ActionCoordinator<String, TimeMark> metricCommandSubmitToVisuallyStarted;
    @NotNull
    private final ActionCoordinator<String, TimeMark> metricCommandSubmitToActuallyStarted;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final AtomicInteger NEXT_REQUEST_ID;
    @NotNull
    private static final String GENERATOR_COMMAND = "__jetbrains_intellij_run_generator";
    @NotNull
    private static final String SHORTCUT_CTRL_U = "\u0015";
    @NotNull
    private static final Map<Character, String> pwshCharsToEscape;

    public ShellCommandExecutionManagerImpl(@NotNull BlockTerminalSession session2, @NotNull ShellCommandManager commandManager, @NotNull ShellIntegration shellIntegration, @NotNull Terminal terminal, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)commandManager, (String)"commandManager");
        Intrinsics.checkNotNullParameter((Object)shellIntegration, (String)"shellIntegration");
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.session = session2;
        this.shellIntegration = shellIntegration;
        this.terminal = terminal;
        this.parentDisposable = parentDisposable;
        EventDispatcher eventDispatcher2 = EventDispatcher.create(ShellCommandSentListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher2, (String)"create(...)");
        this.listeners = eventDispatcher2;
        this.lock = new Lock();
        this.scheduledGenerators = new LinkedList();
        this.scheduledKeyBindings = new LinkedList();
        this.scheduledCommands = new LinkedList();
        this.metricCommandSubmitToVisuallyStarted = ShellCommandExecutionManagerImpl.Companion.createCommandMetric(this.shellIntegration.getShellType(), TimeSpanType.FROM_COMMAND_SUBMIT_TO_VISUALLY_STARTED);
        this.metricCommandSubmitToActuallyStarted = ShellCommandExecutionManagerImpl.Companion.createCommandMetric(this.shellIntegration.getShellType(), TimeSpanType.FROM_COMMAND_SUBMIT_TO_ACTUALLY_STARTED);
        commandManager.addListener(new ShellCommandListener(){

            @Override
            public void initialized() {
                lock.withLock((Function1<? super Lock.AfterLockActionRegistrar, Unit>)((Function1)arg_0 -> 1.initialized$lambda$0(this, arg_0)));
                this.processQueueIfReady();
            }

            @Override
            public void commandStarted(String command2) {
                Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
                metricCommandSubmitToActuallyStarted.finished(command2);
                lock.withLock((Function1<? super Lock.AfterLockActionRegistrar, Unit>)((Function1)arg_0 -> 1.commandStarted$lambda$1(this, arg_0)));
                this.processQueueIfReady();
            }

            @Override
            public void commandFinished(CommandFinishedEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                lock.withLock((Function1<? super Lock.AfterLockActionRegistrar, Unit>)((Function1)arg_0 -> 1.commandFinished$lambda$2(this, arg_0)));
                this.processQueueIfReady();
            }

            @Override
            public void generatorFinished(GeneratorFinishedEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                lock.withLock((Function1<? super Lock.AfterLockActionRegistrar, Unit>)((Function1)arg_0 -> 1.generatorFinished$lambda$4(this, event, arg_0)));
                this.processQueueIfReady();
            }

            private static final Unit initialized$lambda$0(ShellCommandExecutionManagerImpl this$0, Lock.AfterLockActionRegistrar it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this$0.isInitialized = true;
                return Unit.INSTANCE;
            }

            private static final Unit commandStarted$lambda$1(ShellCommandExecutionManagerImpl this$0, Lock.AfterLockActionRegistrar it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (this$0.isCommandRunning) {
                    LOG.warn("Received command_started event, but previous command wasn't finished");
                }
                this$0.isCommandRunning = true;
                return Unit.INSTANCE;
            }

            private static final Unit commandFinished$lambda$2(ShellCommandExecutionManagerImpl this$0, Lock.AfterLockActionRegistrar it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (!this$0.isCommandRunning) {
                    LOG.warn("Received command_finished event, but command wasn't started");
                }
                this$0.isCommandSent = false;
                this$0.isCommandRunning = false;
                return Unit.INSTANCE;
            }

            private static final Unit generatorFinished$lambda$4$lambda$3(GeneratorFinishedEvent $event, Generator $runningGeneratorLocal) {
                if ($event.getRequestId() == $runningGeneratorLocal.getRequestId()) {
                    ShellCommandResult result = ShellCommandResult.Companion.create($event.getOutput(), $event.getExitCode());
                    v0 = $runningGeneratorLocal.getDeferred().complete((Object)result);
                } else {
                    String msg = "Received generator_finished event (request_id=" + $event.getRequestId() + "), but " + $runningGeneratorLocal + " was expected";
                    LOG.warn(msg);
                    v0 = $runningGeneratorLocal.getDeferred().completeExceptionally((Throwable)new IllegalStateException(msg));
                }
                return Unit.INSTANCE;
            }

            private static final Unit generatorFinished$lambda$4(ShellCommandExecutionManagerImpl this$0, GeneratorFinishedEvent $event, Lock.AfterLockActionRegistrar registrar) {
                Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
                if (this$0.runningGenerator == null) {
                    LOG.warn("Received generator_finished event (request_id=" + $event.getRequestId() + "), but no running generator");
                } else {
                    Generator generator2 = this$0.runningGenerator;
                    Intrinsics.checkNotNull((Object)generator2);
                    Generator runningGeneratorLocal = generator2;
                    this$0.runningGenerator = null;
                    registrar.afterLock((Function0<Unit>)((Function0)() -> 1.generatorFinished$lambda$4$lambda$3($event, runningGeneratorLocal)));
                }
                return Unit.INSTANCE;
            }
        }, this.parentDisposable);
    }

    private final void cancelGenerators(Lock.AfterLockActionRegistrar registrar, String incompatibleCondition) {
        block1: {
            Generator generator2 = this.runningGenerator;
            if (generator2 != null) {
                Generator runningGenerator = generator2;
                boolean bl = false;
                registrar.afterLock((Function0<Unit>)((Function0)() -> ShellCommandExecutionManagerImpl.cancelGenerators$lambda$1$lambda$0(runningGenerator, incompatibleCondition)));
            }
            this.runningGenerator = null;
            List list = UtilKt.nullize(this.drainToList(this.scheduledGenerators));
            if (list == null) break block1;
            List cancelledGenerators = list;
            boolean bl = false;
            LOG.warn("Unexpected scheduled generators " + cancelledGenerators + ", but " + incompatibleCondition);
            registrar.afterLock((Function0<Unit>)((Function0)() -> ShellCommandExecutionManagerImpl.cancelGenerators$lambda$4$lambda$3(cancelledGenerators, incompatibleCondition)));
        }
    }

    @Override
    public void sendCommandToExecute(@NotNull String shellCommand) {
        Intrinsics.checkNotNullParameter((Object)shellCommand, (String)"shellCommand");
        this.metricCommandSubmitToVisuallyStarted.started(shellCommand, (TimeMark)TimeSource.Monotonic.ValueTimeMark.box-impl((long)TimeSource.Monotonic.INSTANCE.markNow-z9LOYto()));
        this.metricCommandSubmitToActuallyStarted.started(shellCommand, (TimeMark)TimeSource.Monotonic.ValueTimeMark.box-impl((long)TimeSource.Monotonic.INSTANCE.markNow-z9LOYto()));
        this.lock.withLock((Function1<? super Lock.AfterLockActionRegistrar, Unit>)((Function1)arg_0 -> ShellCommandExecutionManagerImpl.sendCommandToExecute$lambda$5(this, shellCommand, arg_0)));
        this.processQueueIfReady();
    }

    @Override
    public void sendKeyBinding(@NotNull KeyBinding keyBinding) {
        Intrinsics.checkNotNullParameter((Object)keyBinding, (String)"keyBinding");
        this.lock.withLock((Function1<? super Lock.AfterLockActionRegistrar, Unit>)((Function1)arg_0 -> ShellCommandExecutionManagerImpl.sendKeyBinding$lambda$6(this, keyBinding, arg_0)));
        this.processQueueIfReady();
    }

    @Override
    @NotNull
    public Deferred<ShellCommandResult> runGeneratorAsync(@NotNull String shellCommand) {
        Intrinsics.checkNotNullParameter((Object)shellCommand, (String)"shellCommand");
        Generator generator2 = new Generator(shellCommand);
        this.lock.withLock((Function1<? super Lock.AfterLockActionRegistrar, Unit>)((Function1)arg_0 -> ShellCommandExecutionManagerImpl.runGeneratorAsync$lambda$7(this, generator2, arg_0)));
        this.processQueueIfReady();
        return (Deferred)generator2.getDeferred();
    }

    private final void processQueueIfReady() {
        this.lock.withLock((Function1<? super Lock.AfterLockActionRegistrar, Unit>)((Function1)arg_0 -> ShellCommandExecutionManagerImpl.processQueueIfReady$lambda$11(this, arg_0)));
    }

    private final Generator pollNextGeneratorToRun() {
        Generator generator2 = null;
        while ((generator2 = this.scheduledGenerators.poll()) != null && !generator2.getDeferred().isActive()) {
        }
        return generator2;
    }

    private final <T> List<T> drainToList(Queue<T> $this$drainToList) {
        ArrayList<T> arrayList;
        ArrayList<T> it = arrayList = new ArrayList<T>($this$drainToList.size());
        boolean bl = false;
        while (!((Collection)$this$drainToList).isEmpty()) {
            T t = $this$drainToList.poll();
            Intrinsics.checkNotNull(t);
            it.add(t);
        }
        return arrayList;
    }

    private final void doSendCommandToExecute(String shellCommand, boolean isGenerator, Lock.AfterLockActionRegistrar registrar) {
        this.session.getTerminalStarterFuture$intellij_terminal().thenAccept(arg_0 -> ShellCommandExecutionManagerImpl.doSendCommandToExecute$lambda$15(arg_0 -> ShellCommandExecutionManagerImpl.doSendCommandToExecute$lambda$14(this, shellCommand, registrar, isGenerator, arg_0), arg_0));
    }

    /*
     * Unable to fully structure code
     */
    private final void doSendCommandToExecute(TerminalStarter starter, String shellCommand) {
        adjustedCommand = shellCommand;
        v0 = this.terminal.getCodeForKey(10, 0);
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getCodeForKey(...)");
        var5_4 = v0;
        v1 = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"UTF_8");
        var6_5 = v1;
        enterCode = new String(var5_4, var6_5);
        if (!this.session.getModel().isBracketedPasteMode()) ** GOTO lbl-1000
        if (StringsKt.contains$default((CharSequence)adjustedCommand, (CharSequence)"\n", (boolean)false, (int)2, null)) ** GOTO lbl-1000
        v2 = adjustedCommand;
        v3 = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"lineSeparator(...)");
        if (StringsKt.contains$default((CharSequence)v2, (CharSequence)v3, (boolean)false, (int)2, null)) lbl-1000:
        // 2 sources

        {
            adjustedCommand = org.jetbrains.plugins.terminal.block.session.ShellCommandExecutionManagerImpl$Companion.access$bracketed(ShellCommandExecutionManagerImpl.Companion, adjustedCommand);
        } else lbl-1000:
        // 2 sources

        {
            adjustedCommand = StringsKt.replace$default((String)adjustedCommand, (String)"\n", (String)enterCode, (boolean)false, (int)4, null);
        }
        clearPrompt = this.createClearPromptShortcut(this.terminal);
        TerminalUtil.sendCommandToExecute(clearPrompt + adjustedCommand, starter);
    }

    @Override
    public void addListener(@NotNull ShellCommandSentListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.addListener((EventListener)listener2, this.parentDisposable);
    }

    @Override
    public void addListener(@NotNull ShellCommandSentListener listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.listeners.addListener((EventListener)listener2, parentDisposable);
    }

    private final void fireUserCommandSent(String userCommand) {
        ((ShellCommandSentListener)this.listeners.getMulticaster()).userCommandSent(userCommand);
        ShellCommandManager.Companion $this$iv = ShellCommandManager.Companion;
        Throwable e$iv = null;
        boolean $i$f$debug$intellij_terminal = false;
        Logger $this$debug$iv$iv = $this$iv.getLOG$intellij_terminal();
        boolean $i$f$debug = false;
        if ($this$debug$iv$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv$iv;
            boolean bl = false;
            logger.debug("User command sent: " + userCommand, e$iv);
        }
    }

    private final void fireGeneratorCommandSent(String generatorCommand) {
        ((ShellCommandSentListener)this.listeners.getMulticaster()).generatorCommandSent(generatorCommand);
        ShellCommandManager.Companion $this$iv = ShellCommandManager.Companion;
        Throwable e$iv = null;
        boolean $i$f$debug$intellij_terminal = false;
        Logger $this$debug$iv$iv = $this$iv.getLOG$intellij_terminal();
        boolean $i$f$debug = false;
        if ($this$debug$iv$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv$iv;
            boolean bl = false;
            logger.debug("Generator command sent: " + generatorCommand, e$iv);
        }
    }

    private final String createClearPromptShortcut(Terminal terminal) {
        String string;
        if (WhenMappings.$EnumSwitchMapping$0[this.shellIntegration.getShellType().ordinal()] == 1) {
            if (SystemInfo.isUnix) {
                string = SHORTCUT_CTRL_U;
            } else {
                byte[] byArray = terminal.getCodeForKey(36, 2);
                Intrinsics.checkNotNull((Object)byArray);
                string = new String(byArray, Charsets.UTF_8);
            }
        } else {
            string = SHORTCUT_CTRL_U;
        }
        return string;
    }

    private static final Unit cancelGenerators$lambda$1$lambda$0(Generator $runningGenerator, String $incompatibleCondition) {
        String msg = "Unexpectedly running " + $runningGenerator + ", but " + $incompatibleCondition;
        LOG.warn(msg);
        $runningGenerator.getDeferred().completeExceptionally((Throwable)new IllegalStateException(msg));
        return Unit.INSTANCE;
    }

    private static final Unit cancelGenerators$lambda$4$lambda$3(List $cancelledGenerators, String $incompatibleCondition) {
        Iterable $this$forEach$iv = $cancelledGenerators;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Generator it = (Generator)element$iv;
            boolean bl = false;
            it.getDeferred().cancel(new CancellationException("Unexpectedly scheduled generator, but " + $incompatibleCondition));
        }
        return Unit.INSTANCE;
    }

    private static final Unit sendCommandToExecute$lambda$5(ShellCommandExecutionManagerImpl this$0, String $shellCommand, Lock.AfterLockActionRegistrar it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.isCommandSent || this$0.isCommandRunning) {
            LOG.info("Command '" + $shellCommand + "' is postponed until currently running command is finished");
        }
        if (!this$0.isInitialized) {
            LOG.info("Command '" + $shellCommand + "' is postponed until `initialized` event is received");
        }
        this$0.scheduledCommands.offer($shellCommand);
        return Unit.INSTANCE;
    }

    private static final Unit sendKeyBinding$lambda$6(ShellCommandExecutionManagerImpl this$0, KeyBinding $keyBinding, Lock.AfterLockActionRegistrar it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.scheduledKeyBindings.offer($keyBinding);
        return Unit.INSTANCE;
    }

    private static final Unit runGeneratorAsync$lambda$7(ShellCommandExecutionManagerImpl this$0, Generator $generator, Lock.AfterLockActionRegistrar it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.scheduledGenerators.offer($generator);
        return Unit.INSTANCE;
    }

    private static final Unit processQueueIfReady$lambda$11(ShellCommandExecutionManagerImpl this$0, Lock.AfterLockActionRegistrar registrar) {
        block7: {
            String string;
            Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
            if (!this$0.isInitialized) {
                this$0.cancelGenerators(registrar, "not initialized yet");
                return Unit.INSTANCE;
            }
            if (this$0.isCommandSent || this$0.isCommandRunning) {
                this$0.cancelGenerators(registrar, "command is running");
                return Unit.INSTANCE;
            }
            if (this$0.runningGenerator != null) {
                return Unit.INSTANCE;
            }
            List<KeyBinding> keyBindings = this$0.drainToList(this$0.scheduledKeyBindings);
            if (!((Collection)keyBindings).isEmpty()) {
                Iterable $this$forEach$iv = keyBindings;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KeyBinding keyBinding = (KeyBinding)element$iv;
                    boolean bl = false;
                    this$0.session.getTerminalOutputStream$intellij_terminal().sendBytes(keyBinding.getBytes(), false);
                }
                if (this$0.shellIntegration.getShellType() == ShellType.BASH) {
                    Object element$iv;
                    String clearPrompt = this$0.createClearPromptShortcut(this$0.terminal);
                    byte[] byArray = this$0.terminal.getCodeForKey(10, 0);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getCodeForKey(...)");
                    Object object = byArray;
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                    element$iv = charset;
                    String enterCode = new String((byte[])object, (Charset)element$iv);
                    this$0.session.getTerminalOutputStream$intellij_terminal().sendString(clearPrompt + enterCode, false);
                }
            }
            if ((string = this$0.scheduledCommands.poll()) != null) {
                String command2 = string;
                boolean bl = false;
                this$0.cancelGenerators(registrar, "user command is ready to execute");
                this$0.isCommandSent = true;
                this$0.doSendCommandToExecute(command2, false, registrar);
                return Unit.INSTANCE;
            }
            Generator generator2 = this$0.pollNextGeneratorToRun();
            if (generator2 == null) break block7;
            Generator it = generator2;
            boolean bl = false;
            this$0.runningGenerator = it;
            this$0.doSendCommandToExecute(it.shellCommand(), true, registrar);
        }
        return Unit.INSTANCE;
    }

    private static final Unit doSendCommandToExecute$lambda$14$lambda$13(boolean $isGenerator, ShellCommandExecutionManagerImpl this$0, String $shellCommand) {
        if ($isGenerator) {
            this$0.fireGeneratorCommandSent($shellCommand);
        } else {
            this$0.metricCommandSubmitToVisuallyStarted.finished($shellCommand);
            this$0.fireUserCommandSent($shellCommand);
        }
        return Unit.INSTANCE;
    }

    private static final Unit doSendCommandToExecute$lambda$14(ShellCommandExecutionManagerImpl this$0, String $shellCommand, Lock.AfterLockActionRegistrar $registrar, boolean $isGenerator, TerminalStarter starter) {
        if (starter == null) {
            return Unit.INSTANCE;
        }
        this$0.doSendCommandToExecute(starter, $shellCommand);
        $registrar.afterLock((Function0<Unit>)((Function0)() -> ShellCommandExecutionManagerImpl.doSendCommandToExecute$lambda$14$lambda$13($isGenerator, this$0, $shellCommand)));
        return Unit.INSTANCE;
    }

    private static final void doSendCommandToExecute$lambda$15(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ShellCommandExecutionManagerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        NEXT_REQUEST_ID = new AtomicInteger(0);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Character.valueOf('`'), (Object)"``"), TuplesKt.to((Object)Character.valueOf('\"'), (Object)"`\""), TuplesKt.to((Object)Character.valueOf('\u0000'), (Object)"`0"), TuplesKt.to((Object)Character.valueOf('\u0007'), (Object)"`a"), TuplesKt.to((Object)Character.valueOf('\b'), (Object)"`b"), TuplesKt.to((Object)Character.valueOf('\f'), (Object)"`f"), TuplesKt.to((Object)Character.valueOf('\n'), (Object)"`n"), TuplesKt.to((Object)Character.valueOf('\r'), (Object)"`r"), TuplesKt.to((Object)Character.valueOf('\t'), (Object)"`t"), TuplesKt.to((Object)Character.valueOf('\u000b'), (Object)"'v"), TuplesKt.to((Object)Character.valueOf('$'), (Object)"`$")};
        pwshCharsToEscape = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tJ\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0002J$\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\t0\fX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000e\u0010\u0003\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/ShellCommandExecutionManagerImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "NEXT_REQUEST_ID", "Ljava/util/concurrent/atomic/AtomicInteger;", "GENERATOR_COMMAND", "", "SHORTCUT_CTRL_U", "pwshCharsToEscape", "", "", "getPwshCharsToEscape$annotations", "escapePowerShellParameter", "parameter", "bracketed", "command", "createCommandMetric", "Lorg/jetbrains/plugins/terminal/block/util/ActionCoordinator;", "Lkotlin/time/TimeMark;", "shellType", "Lorg/jetbrains/plugins/terminal/util/ShellType;", "type", "Lorg/jetbrains/plugins/terminal/fus/TimeSpanType;", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nShellCommandExecutionManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellCommandExecutionManagerImpl.kt\norg/jetbrains/plugins/terminal/block/session/ShellCommandExecutionManagerImpl$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,447:1\n24#2:448\n*S KotlinDebug\n*F\n+ 1 ShellCommandExecutionManagerImpl.kt\norg/jetbrains/plugins/terminal/block/session/ShellCommandExecutionManagerImpl$Companion\n*L\n442#1:448\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void getPwshCharsToEscape$annotations() {
        }

        @NotNull
        public final String escapePowerShellParameter(@NotNull String parameter) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
            int n = parameter.length();
            StringBuilder $this$escapePowerShellParameter_u24lambda_u240 = stringBuilder = new StringBuilder(n);
            boolean bl = false;
            int n2 = parameter.length();
            for (int i = 0; i < n2; ++i) {
                char ch = parameter.charAt(i);
                Object object = (String)pwshCharsToEscape.get(Character.valueOf(ch));
                if (object == null) {
                    object = Character.valueOf(ch);
                }
                $this$escapePowerShellParameter_u24lambda_u240.append(object);
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final String bracketed(String command2) {
            return "\u001b[200~" + command2 + "\u001b[201~";
        }

        private final ActionCoordinator<String, TimeMark> createCommandMetric(ShellType shellType, TimeSpanType type) {
            return new ActionCoordinator<String, TimeMark>(0, (arg_0, arg_1) -> Companion.createCommandMetric$lambda$1(shellType, type, arg_0, arg_1), (arg_0, arg_1) -> Companion.createCommandMetric$lambda$2(shellType, type, arg_0, arg_1), Companion::createCommandMetric$lambda$3, 1, null);
        }

        private static final Unit createCommandMetric$lambda$1(ShellType $shellType, TimeSpanType $type, String command2, TimeMark startTime) {
            Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
            Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
            TerminalUsageTriggerCollector.logBlockTerminalTimeSpanFinished-Wn2Vu4Y$intellij_terminal(null, $shellType, $type, startTime.elapsedNow-UwyO8pc());
            return Unit.INSTANCE;
        }

        private static final Unit createCommandMetric$lambda$2(ShellType $shellType, TimeSpanType $type, String command2, TimeMark startTime) {
            Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
            Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
            TerminalUsageTriggerCollector.logBlockTerminalTimeSpanFinished-Wn2Vu4Y$intellij_terminal(null, $shellType, $type, Duration.Companion.getINFINITE-UwyO8pc());
            return Unit.INSTANCE;
        }

        private static final Unit createCommandMetric$lambda$3(String command2) {
            Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
            Companion $this$thisLogger$iv = Companion;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(Companion.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Mismatched command " + command2);
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ String access$bracketed(Companion $this, String command2) {
            return $this.bracketed(command2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/ShellCommandExecutionManagerImpl$Generator;", "", "shellCommand", "", "<init>", "(Lorg/jetbrains/plugins/terminal/block/session/ShellCommandExecutionManagerImpl;Ljava/lang/String;)V", "requestId", "", "getRequestId", "()I", "deferred", "Lkotlinx/coroutines/CompletableDeferred;", "Lcom/intellij/terminal/completion/spec/ShellCommandResult;", "getDeferred", "()Lkotlinx/coroutines/CompletableDeferred;", "toString", "intellij.terminal"})
    private final class Generator {
        @NotNull
        private final String shellCommand;
        private final int requestId;
        @NotNull
        private final CompletableDeferred<ShellCommandResult> deferred;

        public Generator(String shellCommand) {
            Intrinsics.checkNotNullParameter((Object)shellCommand, (String)"shellCommand");
            this.shellCommand = shellCommand;
            this.requestId = NEXT_REQUEST_ID.incrementAndGet();
            this.deferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        }

        public final int getRequestId() {
            return this.requestId;
        }

        @NotNull
        public final CompletableDeferred<ShellCommandResult> getDeferred() {
            return this.deferred;
        }

        @NotNull
        public final String shellCommand() {
            String string = WhenMappings.$EnumSwitchMapping$0[ShellCommandExecutionManagerImpl.this.shellIntegration.getShellType().ordinal()] == 1 ? StringUtil.wrapWithDoubleQuote((String)Companion.escapePowerShellParameter(this.shellCommand)) : ParametersListUtil.escape((CharSequence)this.shellCommand);
            Intrinsics.checkNotNull((Object)string);
            String escapedCommand = string;
            return "__jetbrains_intellij_run_generator " + this.requestId + " " + escapedCommand;
        }

        @NotNull
        public String toString() {
            return "Generator(command=" + this.shellCommand + ", requestId=" + this.requestId + ")";
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ShellType.values().length];
                try {
                    nArray[ShellType.POWERSHELL.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\bR\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/ShellCommandExecutionManagerImpl$Lock;", "", "<init>", "()V", "lock", "withLock", "", "block", "Lkotlin/Function1;", "Lorg/jetbrains/plugins/terminal/block/session/ShellCommandExecutionManagerImpl$Lock$AfterLockActionRegistrar;", "AfterLockActionRegistrar", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nShellCommandExecutionManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellCommandExecutionManagerImpl.kt\norg/jetbrains/plugins/terminal/block/session/ShellCommandExecutionManagerImpl$Lock\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,447:1\n1863#2,2:448\n*S KotlinDebug\n*F\n+ 1 ShellCommandExecutionManagerImpl.kt\norg/jetbrains/plugins/terminal/block/session/ShellCommandExecutionManagerImpl$Lock\n*L\n382#1:448,2\n*E\n"})
    private static final class Lock {
        @NotNull
        private final Object lock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void withLock(@NotNull Function1<? super AfterLockActionRegistrar, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            List afterLockBlocks = new ArrayList();
            try {
                Object object = this.lock;
                synchronized (object) {
                    boolean $i$a$-synchronized-ShellCommandExecutionManagerImpl$Lock$withLock$22 = false;
                    block.invoke((Object)new AfterLockActionRegistrar(afterLockBlocks){
                        final /* synthetic */ List<Function0<Unit>> $afterLockBlocks;
                        {
                            this.$afterLockBlocks = $afterLockBlocks;
                        }

                        public void afterLock(Function0<Unit> block) {
                            Intrinsics.checkNotNullParameter(block, (String)"block");
                            this.$afterLockBlocks.add(block);
                        }
                    });
                    Unit $i$a$-synchronized-ShellCommandExecutionManagerImpl$Lock$withLock$22 = Unit.INSTANCE;
                }
            }
            finally {
                Iterable $this$forEach$iv = afterLockBlocks;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Function0 it = (Function0)element$iv;
                    boolean bl = false;
                    it.invoke();
                }
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/ShellCommandExecutionManagerImpl$Lock$AfterLockActionRegistrar;", "", "afterLock", "", "block", "Lkotlin/Function0;", "intellij.terminal"})
        public static interface AfterLockActionRegistrar {
            public void afterLock(@NotNull Function0<Unit> var1);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ShellType.values().length];
            try {
                nArray[ShellType.POWERSHELL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

